<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerPagesSaleCreditCardDetails
 *
 * @property ModelSaleCreditCardDetails $model_sale_credit_card_details
 */
class ControllerPagesSaleCreditCardDetails extends AController
{
    public $error = [];

    public function main()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        redirect(
            $this->html->getSecureURL(
                'sale/credit_card_details/details',
                '&order_id='.$this->request->get['order_id']
            )
        );
    }

    public function details()
    {
        $this->data = [];
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('sale/order');
        $this->loadLanguage('offline_credit_card_processing/offline_credit_card_processing');
        $this->loadModel('sale/credit_card_details');
        $this->loadModel('sale/order');

        $title = $this->language->get('offline_credit_card_processing_tabname');
        $this->document->setTitle($title);

        if (isset($this->request->get['order_id'])) {
            $order_id = $this->request->get['order_id'];
        } else {
            $order_id = 0;
        }

        $order_info = $this->model_sale_order->getOrder($order_id);
        if (empty($order_info)) {
            $this->session->data['error'] = $this->language->get('error_order_load');
            redirect($this->html->getSecureURL('sale/order'));
        }

        $this->document->initBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('index/home'),
                'text'      => $this->language->get('text_home'),
                'separator' => false,
            ]
        );

        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('sale/order'),
                'text'      => $this->language->get('heading_title'),
                'separator' => ' :: ',
            ]
        );
        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL(
                    'sale/order/details',
                    '&order_id='.$this->request->get['order_id']
                ),
                'text'      => $this->language->get('heading_title').' #'.$order_info['order_id'],
                'separator' => ' :: ',
            ]
        );
        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL(
                    'sale/credit_card_details/details',
                    '&order_id='.$this->request->get['order_id']
                ),
                'text'      => $title,
                'separator' => ' :: ',
                'current'   => true,
            ]
        );

        if (isset($this->session->data['success'])) {
            $this->data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $this->data['success'] = '';
        }

        $this->data['order_id'] = $this->request->get['order_id'];
        $this->data['invoice'] = $this->html->getSecureURL(
            'sale/invoice',
            '&order_id='.(int) $this->request->get['order_id']
        );
        $this->data['back'] = $this->html->getSecureURL(
            'sale/order/update',
            '&order_id='.(int) $this->request->get['order_id']
        );
        $this->data['delete'] = $this->html->getSecureURL(
            'sale/credit_card_details/delete',
            '&order_id='.$this->request->get['order_id']
        );
        $this->data['form_title'] = $title;

        $cc_details = $this->model_sale_credit_card_details->getCardCarddetails($this->data['order_id']);

        $encryption = new AEncryption(
            AEncryption::getHash(
                $this->config->get('offline_credit_card_processing_encryption_key')
            )
        );
        $cc_details_arr = unserialize($encryption->decrypt($cc_details['card_data']));

        if ($cc_details_arr === false) {
            $cc_details_arr = ['no_info' => ''];
        }

        $this->view->assign('cc_detail', $cc_details_arr);
        $this->view->assign('help_url', $this->gen_help_url('order_payment'));
        $this->_initTabs('payment_details');
        $this->addChild('pages/sale/order_summary', 'summary_form', 'pages/sale/order_summary.tpl');

        $this->view->batchAssign($this->data);
        $this->processTemplate('pages/sales/credit_card_details.tpl');
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    protected function _initTabs($active)
    {
        $this->data['active'] = $active;
        //load tabs controller
        $tabs_obj = $this->dispatch('pages/sale/order_tabs', [$this->data]);
        $this->data['order_tabs'] = $tabs_obj->dispatchGetOutput();
    }

    public function delete()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('offline_credit_card_processing/offline_credit_card_processing');
        $order_id = $this->request->get['order_id'];
        if (isset($order_id) && $this->_validateForm()) {
            $this->model_sale_credit_card_details->removeCardCarddetails($order_id);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->extensions->hk_ProcessData($this, __FUNCTION__);
            redirect($this->html->getSecureURL('sale/credit_card_details/details', '&order_id='.$order_id));
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    protected function _validateForm()
    {
        if (!$this->user->hasPermission('modify', 'sale/credit_card_details')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        $this->extensions->hk_ValidateData($this);
        return (!$this->error);
    }

}