<?php

/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelExtensionIpCapture extends Model {

    public function save($data) {
        $sql = 'INSERT INTO '.$this->db->table("ip_capture").' SET `customer_id`="'.$data['customer_id'].'", `firstname`="'.$data['firstname'].'",`lastname`="'.$data['lastname'].'",
               `company`="'.$data['company'].'",`email`="'.$data['email'].'",`zone`="'.$data['zone'].'",`country`="'.$data['country'].'",`blocked`="'.$data['blocked'].'",`ip`="'.$data['ip'].'",`date_added`=NOW()';
        $this->db->query($sql);
    }

    public function updateCustIp($data) {
        $sql = 'UPDATE '.$this->db->table("customers").' SET `ip`="'.$data['ip'].'" WHERE `customer_id`='.$data['customer_id'];
        $this->db->query($sql);
    }

    /**
     * @return mixed
     */
    public function getUserIP() {
        // Get real visitor IP behind CloudFlare network
        if (isset($_SERVER["HTTP_CF_CONNECTING_IP"])) {
            $_SERVER['REMOTE_ADDR'] = $_SERVER["HTTP_CF_CONNECTING_IP"];
            $_SERVER['HTTP_CLIENT_IP'] = $_SERVER["HTTP_CF_CONNECTING_IP"];
        }
        $client  = @$_SERVER['HTTP_CLIENT_IP'];
        $forward = @$_SERVER['HTTP_X_FORWARDED_FOR'];
        $remote  = $_SERVER['REMOTE_ADDR'];

        if(filter_var($client, FILTER_VALIDATE_IP))
        {
            $ip = $client;
        }
        elseif(filter_var($forward, FILTER_VALIDATE_IP))
        {
            $ip = $forward;
        }
        else
        {
            $ip = $remote;
        }

        return $ip;
    }

    /**
     * @param $ip
     * @return array
     */
    public function getLocationByIp($ip) {
        $ip_data = @json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip=" . $ip));
        $location['country'] = $ip_data->geoplugin_countryName;
        $location['zone'] = $ip_data->geoplugin_regionName;
        $location['iso_code_2'] = $ip_data->geoplugin_countryCode;
        return $location;
    }

    /**
     * @param $ip
     * @return mixed
     * @throws AException
     */
    public function isBlocked($ip) {
        $sql = "SELECT `blocked` FROM ".$this->db->table("ip_capture")." WHERE `ip`='".$this->db->escape($ip)."'";
        $query = $this->db->query($sql);
        return $query->row['blocked'];
    }

    /**
     * @param $customer_id
     * @param $address_id
     * @return array|false
     * @throws AException
     */
    public function getAddress($customer_id,$address_id)
    {
        $address_query = $this->db->query(
            "SELECT DISTINCT *
             FROM ".$this->db->table("addresses")."
             WHERE address_id = '".(int) $address_id."' 
                AND customer_id = '".(int) $customer_id."'"
        );

        if ($address_query->num_rows) {
            return $this->_build_address_data($address_query->row);
        } else {
            return false;
        }
    }

    /**
     * @param array $address_row
     *
     * @return array
     * @throws AException
     */
    protected function _build_address_data($address_row)
    {
        $addr_row = $this->dcrypt->decrypt_data($address_row, 'addresses');

        $this->load->model('localisation/country');
        $this->load->model('localisation/zone');
        $country_row = $this->model_localisation_country->getCountry($addr_row['country_id']);

        if ($country_row) {
            $country = $country_row['name'];
            $iso_code_2 = $country_row['iso_code_2'];
            $iso_code_3 = $country_row['iso_code_3'];
            $address_format = $country_row['address_format'];
        } else {
            $country = '';
            $iso_code_2 = '';
            $iso_code_3 = '';
            $address_format = '';
        }

        $zone_row = $this->model_localisation_zone->getZone($addr_row['zone_id']);

        if ($zone_row) {
            $zone = $zone_row['name'];
            $code = $zone_row['code'];
        } else {
            $zone = '';
            $code = '';
        }

        return [
            'address_id'     => $addr_row['address_id'],
            'firstname'      => $addr_row['firstname'],
            'lastname'       => $addr_row['lastname'],
            'company'        => $addr_row['company'],
            'address_1'      => $addr_row['address_1'],
            'address_2'      => $addr_row['address_2'],
            'postcode'       => $addr_row['postcode'],
            'city'           => $addr_row['city'],
            'zone_id'        => $addr_row['zone_id'],
            'zone'           => $zone,
            'zone_code'      => $code,
            'country_id'     => $addr_row['country_id'],
            'country'        => $country,
            'iso_code_2'     => $iso_code_2,
            'iso_code_3'     => $iso_code_3,
            'address_format' => $address_format,
        ];
    }

}