<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}
$rm = new AResourceManager();
$rm->setType('image');

$language_id = $this->language->getLanguageID();
$data = [];
$data['resource_code'] = '<i class="fa fa-map-pin"></i>&nbsp;';
$data['name'] = [$language_id => 'Menu Icon IP Capture'];
$data['title'] = [$language_id => ''];
$data['description'] = [$language_id => ''];
$resource_id = $rm->addResource($data);

$menu = new AMenu ( "admin" );

$menu->insertMenuItem ( [
        "item_id"         => "ip_capture",
        "parent_id"       => "reports",
        "item_text"       => "IP Capture",
        "item_url"        => "",
        "item_icon_rl_id" => $resource_id,
        "sort_order"      => "20",
        "item_type"       => "core",
    ]
);

$menu->insertMenuItem ( [
        "item_id"         => "ip_capture_account_register",
        "parent_id"       => "ip_capture",
        "item_text"       => "IP Capture Account Register",
        "item_url"        => "extension/ip_capture",
        "item_icon_rl_id" => $resource_id,
        "item_type"       => "core",
    ]
);

$menu->insertMenuItem ( [
        "item_id"         => "ip_capture_contact_us",
        "parent_id"       => "ip_capture",
        "item_text"       => "IP Capture Contact US",
        "item_url"        => "extension/ip_capture_contact_us",
        "item_icon_rl_id" => $resource_id,
        "item_type"       => "core",
    ]
);

$sql = "CREATE TABLE IF NOT EXISTS ".$this->db->table("ip_capture") ."(
  `ip_capture_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` INT(11),
  `firstname` VARCHAR(64) NOT NULL,
  `lastname` VARCHAR(64) NOT NULL,
  `company` VARCHAR(64) NOT NULL,
  `email` VARCHAR(128) NOT NULL,
  `zone` VARCHAR(128) NOT NULL,
  `country` VARCHAR(128) NOT NULL,
  `ip` VARCHAR(32),
  `blocked` CHAR(1) NOT NULL DEFAULT '0', 
  `note` text,
  `date_added` timestamp,
  PRIMARY KEY (`ip_capture_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql);


$sql = "CREATE TABLE IF NOT EXISTS ".$this->db->table("ip_capture_contact_us") ."(
  `ip_capture_contact_us_id` int(11) NOT NULL AUTO_INCREMENT,
  `firstname` VARCHAR(64) NOT NULL,
  `lastname` VARCHAR(64) NOT NULL,
  `company` VARCHAR(64) NOT NULL,
  `email` VARCHAR(128) NOT NULL,
  `zone` VARCHAR(128) NOT NULL,
  `country` VARCHAR(128) NOT NULL,
  `ip` VARCHAR(32),
  `blocked` CHAR(1) NOT NULL DEFAULT '0', 
  `note` text,
  `date_added` timestamp,
  PRIMARY KEY (`ip_capture_contact_us_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql);


$exist = "SELECT COUNT(*) as exist FROM ".$this->db->table("customer_groups")." WHERE `name`='IP Blocked'";

$query = $this->db->query($exist);

if ($query->row['exist']==='0') {
    $this->db->query("INSERT INTO ".$this->db->table("customer_groups")." SET `name`='IP Blocked', `tax_exempt`=0");
}