<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( ! defined( 'DIR_CORE' ) ) {
	header( 'Location: static_pages/' );
}

class ExtensionIpCapture extends Extension {

	public $data = [];
	public $error = [];

    public function __construct() {
        $this->registry = Registry::getInstance();
    }

	private function _is_enabled() {
      	return $this->baseObject->config->get('ip_capture_status');
	}

    public function verifyhcaptcha() {
        $that =& $this->baseObject;
        if ($that->config->get('hcaptcha_integration_status')) {
            $that->load->model('extension/hcaptcha_integration_license_info');
            $license_key = $that->config->get('hcaptcha_integration_license_code');
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('hcaptcha_integration_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_hcaptcha_integration_license_info->getStoreId();
                    $license_key = $that->model_extension_hcaptcha_integration_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_hcaptcha_integration_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'hcaptcha_integration');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_hcaptcha_integration_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                return false;
            }
        }
    }

    /** Admin Section */
    public function onControllerPagesSaleCustomer_UpdateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method==='update') {
            $that->load->model('sale/customer');
            $that->load->language('ip_capture/ip_capture');
            $customer_id = $that->request->get['customer_id'];
            $customer_info = $that->model_sale_customer->getCustomer($customer_id);
            $that->data['fields']['ip'] = null;
            $form = $that->view->getData('form');
            $form['fields']['details']['ip'] = $that->html->buildElement(
                [
                    'type'    => 'input',
                    'name'    => 'ip',
                    'value'   => $customer_info['ip'],
                    'attr'    => 'disabled'
                ]
            );
            $that->view->assign('entry_ip',$that->language->get('entry_ip'));
            $that->view->assign('form', $form);
        }
    }

    public function onControllerResponsesListingGridCustomer_UpdateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method==='update') {
            $that->load->model('extension/ip_capture');
            switch ($that->request->post['oper']) {
                case 'del':
                    $ids = explode(',', $that->request->post['id']);
                    if (!empty($ids)) {
                        foreach ($ids as $id) {
                            $that->model_extension_ip_capture->deleteIPInfo($id);
                        }
                    }
                    break;
            }
        }
    }

    /** End Of Admin Section */

    /** Storefront Section */
    public function onModelAccountCustomer_ValidateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method[0]==='validateRegistrationData') {
            $that->load->model('extension/ip_capture');
            $that->load->model('localisation/zone');
            $that->load->model('localisation/country');
            $post = $that->request->post;
            $zones = $that->model_localisation_zone->getZone($post['zone_id']);
            $post['zone_code'] = $zones['code'];
            $countries = $that->model_localisation_country->getCountry($post['country_id']);
            $post['iso_code_2'] = $countries['iso_code_2'];

            if ($that->config->get('fedex_integration_status')) {
                $that->load->model('extension/fedex_integration');
                $address_validation = $that->model_extension_fedex_integration->validateAddress($post);
                $validate = $address_validation['output']['resolvedAddresses'][0]['classification'];
                if ($validate === 'UNKNOWN') {
                    $ip = $that->model_extension_ip_capture->getUserIP();
                    $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);
                    $data['customer_id'] = 0;
                    $data['firstname'] = $post['firstname'];
                    $data['lastname'] = $post['lastname'];
                    $data['company'] = $post['company'];
                    $data['email'] = $post['email'];
                    $data['zone'] = $ipdat['zone'];
                    $data['country'] = $ipdat['country'];
                    $data['blocked'] = '1';
                    $data['ip'] = $ip;
                    $that->model_extension_ip_capture->save($data);
                    $that->session->data['blocked'] = '1';
                    redirect($that->html->getSEOURL('error/restricted'));
               } else {
                    $that->session->data['blocked'] = '0';
                }
            } elseif ($that->config->get('ups_integration_status')) {
                $that->load->model('extension/ups_integration');
                $address_validation = $that->model_extension_ups_integration->validateAddress($post);
                $validate = $address_validation['XAVResponse']['AddressClassification']['Code'];
                if ($validate === '0') {
                    $ip = $that->model_extension_ip_capture->getUserIP();
                    $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);
                    $data['customer_id'] = 0;
                    $data['firstname'] = $post['firstname'];
                    $data['lastname'] = $post['lastname'];
                    $data['company'] = $post['company'];
                    $data['email'] = $post['email'];
                    $data['zone'] = $ipdat['zone'];
                    $data['country'] = $ipdat['country'];
                    $data['blocked'] = '1';
                    $data['ip'] = $ip;
                    $that->model_extension_ip_capture->save($data);
                    $that->session->data['blocked'] = '1';
                    redirect($that->html->getSEOURL('error/restricted'));
                } else {
                    $that->session->data['blocked'] = '0';
                }
            }
            if ($this->verifyhcaptcha()) {
                unset($that->error['captcha']);

                if (!isset($that->request->post['h-captcha-response'])) {
                    $that->error['captcha'] = $that->language->get('error_captcha');
                }

                if (!$that->session->data['account_register_hcaptcha']) {
                    $hcaptcha = file_get_contents('https://hcaptcha.com/siteverify?secret=' . urlencode($that->config->get('hcaptcha_integration_secret_key')) . '&response=' .
                        $that->request->post['h-captcha-response'] . '&remoteip=' . $that->request->server['REMOTE_ADDR']);

                    $hcaptcha = json_decode($hcaptcha, true);

                    if ($hcaptcha['success']) {
                        $that->session->data['account_register_hcaptcha'] = true;
                    } else {
                        $that->error['captcha'] = $that->language->get('error_captcha');
                    }
                }
            }
        }
    }

    public function onControllerPagesAccountCreate_UpdateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
            $that->load->model('extension/ip_capture');
            $that->load->model('extension/ip_capture_contact_us');
            $ip = $that->model_extension_ip_capture->getUserIP();
            $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);

            $allowed_countries = unserialize($that->config->get('ip_capture_altcha_allowed_countries'));
            if (!in_array($ipdat['iso_code_2'], $allowed_countries)) {
                redirect($that->html->getSEOURL('error/restricted'));
            } else {
                $blocked = $that->model_extension_ip_capture->isBlocked($ip);
                $contact_us_blocked = $that->model_extension_ip_capture_contact_us->isBlocked($ip);
                if ($blocked || $contact_us_blocked) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            }
            if ($that->request->is_POST()) {
                $blocked = $that->session->data['blocked'];
                if ($blocked === '0') {
                    $that->load->model('account/customer');
                    $that->load->model('account/address');
                    $that->load->model('extension/ip_capture');
                    if ($that->data['customer_id']) {
                        $customer_id = $that->data['customer_id'];
                        $customer_info = $that->model_account_customer->getCustomer($customer_id);
                        $address_id = $customer_info['address_id'];
                        $address_info = $that->model_extension_ip_capture->getAddress($customer_id,$address_id);
                        $ip = $that->model_extension_ip_capture->getUserIP();
                        $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);
                        $data['customer_id'] = $customer_id;
                        $data['firstname'] = $customer_info['firstname'];
                        $data['lastname'] = $customer_info['lastname'];
                        $data['company'] = $address_info['company'];
                        $data['email'] = $customer_info['email'];
                        $data['zone'] = $ipdat['zone'];
                        $data['country'] = $ipdat['country'];
                        $data['ip'] = $ip;
                        $data['blocked'] = '0';
                        //$data['source'] = 'Register Account Page';
                        $that->model_extension_ip_capture->updateCustIp($data);
                        $that->model_extension_ip_capture->save($data);
                    }
                }
            }

            $form = $that->view->getData('form');
            $that->load->model('extension/ip_capture');
            $ip = $that->model_extension_ip_capture->getUserIP();
            $form['fields']['general']['ip'] = $that->html->buildElement(
                [
                    'type' => 'hidden',
                    'name' => 'ip',
                    'value' => $ip,
                ]
            );
            $that->view->assign('form', $form);
        }
    }

    public function onControllerPagesIndexHome_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method ==='main' && !IS_ADMIN) {
            $that->load->model('extension/ip_capture');
            $that->load->model('extension/ip_capture_contact_us');
            $ip = $that->model_extension_ip_capture->getUserIP();
            $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);

            if ($that->config->get('ip_capture_block_entirely')) {
                $allowed_countries = unserialize($that->config->get('ip_capture_altcha_allowed_countries'));
                if (!in_array($ipdat['iso_code_2'], $allowed_countries)) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            } else {
                $blocked = $that->model_extension_ip_capture->isBlocked($ip);
                $contact_us_blocked = $that->model_extension_ip_capture_contact_us->isBlocked($ip);
                if ($blocked || $contact_us_blocked) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            }
        }
    }

    public function onControllerPagesAccountLogin_UpdateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main' && !IS_ADMIN) {
            $that->load->model('extension/ip_capture');
            $that->load->model('extension/ip_capture_contact_us');
            $ip = $that->model_extension_ip_capture->getUserIP();
            $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);

            $allowed_countries = unserialize($that->config->get('ip_capture_altcha_allowed_countries'));
            if (!in_array($ipdat['iso_code_2'], $allowed_countries)) {
                redirect($that->html->getSEOURL('error/restricted'));
            } else {
                $blocked = $that->model_extension_ip_capture->isBlocked($ip);
                $contact_us_blocked = $that->model_extension_ip_capture_contact_us->isBlocked($ip);
                if ($blocked || $contact_us_blocked) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            }
        }
    }

    public function onControllerPagesAccountInvoice_InitData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
            $that->load->model('extension/ip_capture');
            $that->load->model('extension/ip_capture_contact_us');
            $ip = $that->model_extension_ip_capture->getUserIP();
            $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);

            if ($that->config->get('ip_capture_block_entirely')) {
                $allowed_countries = unserialize($that->config->get('ip_capture_altcha_allowed_countries'));
                if (!in_array($ipdat['iso_code_2'], $allowed_countries)) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            } else {
                $blocked = $that->model_extension_ip_capture->isBlocked($ip);
                $contact_us_blocked = $that->model_extension_ip_capture_contact_us->isBlocked($ip);
                if ($blocked || $contact_us_blocked) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            }
        }
    }

    public function onControllerPagesCheckoutCart_UpdateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
            $that->load->model('extension/ip_capture');
            $that->load->model('extension/ip_capture_contact_us');
            $ip = $that->model_extension_ip_capture->getUserIP();
            $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);

            if ($that->config->get('ip_capture_block_entirely')) {
                $allowed_countries = unserialize($that->config->get('ip_capture_altcha_allowed_countries'));
                if (!in_array($ipdat['iso_code_2'], $allowed_countries)) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            } else {
                $blocked = $that->model_extension_ip_capture->isBlocked($ip);
                $contact_us_blocked = $that->model_extension_ip_capture_contact_us->isBlocked($ip);
                if ($blocked || $contact_us_blocked) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            }
        }
    }

    public function onControllerPagesCheckoutShipping_UpdateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
            $that->load->model('extension/ip_capture');
            $that->load->model('extension/ip_capture_contact_us');
            $ip = $that->model_extension_ip_capture->getUserIP();
            $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);

            if ($that->config->get('ip_capture_block_entirely')) {
                $allowed_countries = unserialize($that->config->get('ip_capture_altcha_allowed_countries'));
                if (!in_array($ipdat['iso_code_2'], $allowed_countries)) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            } else {
                $blocked = $that->model_extension_ip_capture->isBlocked($ip);
                $contact_us_blocked = $that->model_extension_ip_capture_contact_us->isBlocked($ip);
                if ($blocked || $contact_us_blocked) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            }
        }
    }

    public function onControllerPagesCheckoutGuestStep1_UpdateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
            $that->load->model('extension/ip_capture');
            $that->load->model('extension/ip_capture_contact_us');
            $ip = $that->model_extension_ip_capture->getUserIP();
            $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);

            if ($that->config->get('ip_capture_block_entirely')) {
                $allowed_countries = unserialize($that->config->get('ip_capture_altcha_allowed_countries'));
                if (!in_array($ipdat['iso_code_2'], $allowed_countries)) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            } else {
                $blocked = $that->model_extension_ip_capture->isBlocked($ip);
                $contact_us_blocked = $that->model_extension_ip_capture_contact_us->isBlocked($ip);
                if ($blocked || $contact_us_blocked) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            }
        }
    }

    public function onControllerPagesContentContent_UpdateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
            $that->load->model('extension/ip_capture');
            $that->load->model('extension/ip_capture_contact_us');
            $ip = $that->model_extension_ip_capture->getUserIP();
            $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);

            if ($that->config->get('ip_capture_block_entirely')) {
                $allowed_countries = unserialize($that->config->get('ip_capture_altcha_allowed_countries'));
                if (!in_array($ipdat['iso_code_2'], $allowed_countries)) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            } else {
                $blocked = $that->model_extension_ip_capture->isBlocked($ip);
                $contact_us_blocked = $that->model_extension_ip_capture_contact_us->isBlocked($ip);
                if ($blocked || $contact_us_blocked) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            }
        }
    }

    public function onControllerPagesContentContact_UpdateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
            $that->load->model('extension/ip_capture');
            $that->load->model('extension/ip_capture_contact_us');
            $ip = $that->model_extension_ip_capture->getUserIP();
            $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);

            $allowed_countries = unserialize($that->config->get('ip_capture_altcha_allowed_countries'));
            if (!in_array($ipdat['iso_code_2'], $allowed_countries)) {
                redirect($that->html->getSEOURL('error/restricted'));
            } else {
                $blocked = $that->model_extension_ip_capture->isBlocked($ip);
                $contact_us_blocked = $that->model_extension_ip_capture_contact_us->isBlocked($ip);
                if ($blocked || $contact_us_blocked) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            }
        }
    }

    public function onControllerPagesContentSitemap_UpdateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
            $that->load->model('extension/ip_capture');
            $that->load->model('extension/ip_capture_contact_us');
            $ip = $that->model_extension_ip_capture->getUserIP();
            $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);

            if ($that->config->get('ip_capture_block_entirely')) {
                $allowed_countries = unserialize($that->config->get('ip_capture_altcha_allowed_countries'));
                if (!in_array($ipdat['iso_code_2'], $allowed_countries)) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            } else {
                $blocked = $that->model_extension_ip_capture->isBlocked($ip);
                $contact_us_blocked = $that->model_extension_ip_capture_contact_us->isBlocked($ip);
                if ($blocked || $contact_us_blocked) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            }
        }
    }

    public function onControllerPagesContentContact_ValidateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        $that->load->model('extension/ip_capture_contact_us');
        $ip = $that->model_extension_ip_capture_contact_us->getUserIP();
        $ipdat = $that->model_extension_ip_capture_contact_us->getLocationByIp($ip);

        if ($that->config->get('ip_capture_block_entirely')) {
            $allowed_countries = unserialize($that->config->get('ip_capture_altcha_allowed_countries'));
            if (!in_array($ipdat['iso_code_2'], $allowed_countries)) {
                redirect($that->html->getSEOURL('error/restricted'));
            }
        } else {
            $post = $that->request->post;
            $result = $this->checkSpam($that, $post);

            if ($result['classification'] === 'BAD') {
                $datas['customer_id'] = 0;
                $datas['firstname'] = $post['first_name'];
                $datas['lastname'] = $post['last_name'];
                $datas['company'] = $post['company'];
                $datas['email'] = $post['email'];
                $datas['zone'] = $ipdat['zone'];
                $datas['country'] = $ipdat['country'];
                $datas['blocked'] = '1';
                $datas['ip'] = $ip;
                $that->model_extension_ip_capture_contact_us->save($datas);
                $contact_us_blocked = $that->model_extension_ip_capture_contact_us->isBlocked($ip);
                if ($contact_us_blocked) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            }
        }

        //spammaster
        //if ($result['threat']) {
        //    $datas['customer_id'] = 0;
        //    $datas['firstname'] = $post['first_name'];
        //    $datas['lastname'] = $post['last_name'];
        //    $datas['company'] = $post['company'];
        //    $datas['email'] = $post['email'];
        //    $datas['zone'] = $ipdat['zone'];
        //    $datas['country'] = $ipdat['country'];
        //    $datas['blocked'] = '1';
        //    $datas['ip'] = $ip;
        //    $that->model_extension_ip_capture_contact_us->save($datas);
        //    $contact_us_blocked = $that->model_extension_ip_capture_contact_us->isBlocked($ip);
        //    if ($contact_us_blocked) {
        //        redirect($that->html->getSEOURL('error/restricted'));
        //    }
        //}
        //return $result;
    }
    public function onControllerPagesContentContact_ProcessData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'sf_contact_us_mail') {
            $that->load->model('extension/ip_capture_contact_us');
            $post_data = $that->request->post;
            $ip = $that->model_extension_ip_capture_contact_us->getUserIP();
            $ipdat = $that->model_extension_ip_capture_contact_us->getLocationByIp($ip);
            //$data['customer_id'] = 0;
            $data['firstname'] = $post_data['first_name'];
            $data['lastname'] = $post_data['last_name'];
            $data['company'] = $post_data['company'];
            $data['email'] = $post_data['email'];
            $data['zone'] = $ipdat['zone'];
            $data['country'] = $ipdat['country'];
            $data['ip'] = $ip;
            //$data['source'] = 'Contact Us Page';
            $that->model_extension_ip_capture_contact_us->save($data);
        }
    }

    public function onControllerPagesProductProduct_UpdateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
            $that->load->model('extension/ip_capture');
            $that->load->model('extension/ip_capture_contact_us');
            $ip = $that->model_extension_ip_capture->getUserIP();

            $ip = $that->model_extension_ip_capture->getUserIP();
            $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);

            if ($that->config->get('ip_capture_block_entirely')) {
                $allowed_countries = unserialize($that->config->get('ip_capture_altcha_allowed_countries'));
                if (!in_array($ipdat['iso_code_2'], $allowed_countries)) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            } else {
                $blocked = $that->model_extension_ip_capture->isBlocked($ip);
                $contact_us_blocked = $that->model_extension_ip_capture_contact_us->isBlocked($ip);
                if ($blocked || $contact_us_blocked) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            }
        }
    }

    public function onControllerPagesProductCategory_UpdateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
            $that->load->model('extension/ip_capture');
            $that->load->model('extension/ip_capture_contact_us');
            $ip = $that->model_extension_ip_capture->getUserIP();
            $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);

            if ($that->config->get('ip_capture_block_entirely')) {
                $allowed_countries = unserialize($that->config->get('ip_capture_altcha_allowed_countries'));
                if (!in_array($ipdat['iso_code_2'], $allowed_countries)) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            } else {
                $blocked = $that->model_extension_ip_capture->isBlocked($ip);
                $contact_us_blocked = $that->model_extension_ip_capture_contact_us->isBlocked($ip);
                if ($blocked || $contact_us_blocked) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            }
        }
    }

    public function onControllerPagesProductCollection_UpdateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
            $that->load->model('extension/ip_capture');
            $that->load->model('extension/ip_capture_contact_us');
            $ip = $that->model_extension_ip_capture->getUserIP();
            $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);

            if ($that->config->get('ip_capture_block_entirely')) {
                $allowed_countries = unserialize($that->config->get('ip_capture_altcha_allowed_countries'));
                if (!in_array($ipdat['iso_code_2'], $allowed_countries)) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            } else {
                $blocked = $that->model_extension_ip_capture->isBlocked($ip);
                $contact_us_blocked = $that->model_extension_ip_capture_contact_us->isBlocked($ip);
                if ($blocked || $contact_us_blocked) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            }
        }
    }

    public function onControllerPagesProductManufacturer_UpdateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
            $that->load->model('extension/ip_capture');
            $ip = $that->model_extension_ip_capture->getUserIP();
            $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);

            if ($that->config->get('ip_capture_block_entirely')) {
                $allowed_countries = unserialize($that->config->get('ip_capture_altcha_allowed_countries'));
                if (!in_array($ipdat['iso_code_2'], $allowed_countries)) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            } else {
                $blocked = $that->model_extension_ip_capture->isBlocked($ip);
                $contact_us_blocked = $that->model_extension_ip_capture_contact_us->isBlocked($ip);
                if ($blocked || $contact_us_blocked) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            }
        }
    }

    public function onControllerPagesProductSearch_UpdateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
            $that->load->model('extension/ip_capture');
            $that->load->model('extension/ip_capture_contact_us');
            $ip = $that->model_extension_ip_capture->getUserIP();
            $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);

            if ($that->config->get('ip_capture_block_entirely')) {
                $allowed_countries = unserialize($that->config->get('ip_capture_altcha_allowed_countries'));
                if (!in_array($ipdat['iso_code_2'], $allowed_countries)) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            } else {
                $blocked = $that->model_extension_ip_capture->isBlocked($ip);
                $contact_us_blocked = $that->model_extension_ip_capture_contact_us->isBlocked($ip);
                if ($blocked || $contact_us_blocked) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            }
        }
    }

    public function onControllerPagesProductSpecial_UpdateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
            $that->load->model('extension/ip_capture');
            $that->load->model('extension/ip_capture_contact_us');
            $ip = $that->model_extension_ip_capture->getUserIP();
            $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);

            if ($that->config->get('ip_capture_block_entirely')) {
                $allowed_countries = unserialize($that->config->get('ip_capture_altcha_allowed_countries'));
                if (!in_array($ipdat['iso_code_2'], $allowed_countries)) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            } else {
                $blocked = $that->model_extension_ip_capture->isBlocked($ip);
                $contact_us_blocked = $that->model_extension_ip_capture_contact_us->isBlocked($ip);
                if ($blocked || $contact_us_blocked) {
                    redirect($that->html->getSEOURL('error/restricted'));
                }
            }
        }
    }
    
    private function checkSpam($that,$post) {
        $that->load->model('extension/ip_capture_contact_us');
        $ip = $that->model_extension_ip_capture_contact_us->getUserIP();
        $emailProviders = explode("@",$post['email']);

        $allowedCountries = unserialize($that->config->get('ip_capture_altcha_allowed_countries'));
        $blockedCountries = unserialize($that->config->get('ip_capture_altcha_blocked_countries'));

        $data = [
            //"email" => "@".$emailProviders[1],
            //"ipAddress" => "auto",
            "email" => $post["email"],
            "ipAddress" => $ip,
            "expectedCountries" => $allowedCountries,
            "blockedCountries" => $blockedCountries,
            "fields" => [
                "name" => $post['first_name']
            ]
            //"text" => addslashes($post['enquiry'])
        ];

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://us.altcha.org/api/v1/classify?apiKey='.$that->config->get('ip_capture_altcha_api_key'),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array(
                'Referer: '.$that->config->get('config_ssl_url'),
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        return json_decode($response,true);
    }
    /** End Of Storefront Section */
} ?>