<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelExtensionIpCaptureContactUs extends Model {

    /**
     * @param array $data
     *
     * @return array|int
     * @throws AException
     */
    public function getTotalIpCapture($data = []) {
        return $this->getIpCapture($data, 'total_only');
    }

    /**
     * @param $data
     * @param $mode
     * @return int|mixed
     * @throws AException
     */
    public function getIpCapture($data = [], $mode = 'default') {
        if ($mode == 'total_only') {
            $sql = "SELECT COUNT(*) as total ";
        } else {
            $sql = "SELECT *";
        }
        
        $sql .= " FROM ".$this->db->table("ip_capture_contact_us");

        $implode = [];
        $filter = (isset($data['filter']) ? $data['filter'] : []);

        if (isset($filter['name']) && has_value($filter['name'])) {
            $implode[] = "CONCAT(firstname, ' ', lastname) 
                LIKE '%".$this->db->escape($filter['name'], true) ."%' ";
        }

        if (isset($filter['company']) && has_value($filter['company'])) {
            $implode[] = "company LIKE '%".$this->db->escape($filter['company'], true )."%' ";
        }

        if (isset($filter['email']) && has_value($filter['email'])) {
            $implode[] = "email LIKE '%".$this->db->escape($filter['email'], true )."%' ";
        }

        if (isset($filter['zone']) && has_value($filter['zone'])) {
            $implode[] = "zone LIKE '%".$this->db->escape($filter['zone'], true )."%' ";
        }

        if (isset($filter['country']) && has_value($filter['country'])) {
            $implode[] = "country LIKE '%".$this->db->escape($filter['coutry'], true )."%' ";
        }

        if (isset($filter['ip']) && has_value($filter['ip'])) {
            $implode[] = "ip LIKE '%".$this->db->escape($filter['ip'], true )."%' ";
        }

        if (isset($filter['blocked']) && has_value($filter['blocked'])) {
            if (strtolower($filter['blocked'])==='yes') {
                $blocked = '1';
            } else {
                $blocked = '0';
            }
            $implode[] = "blocked='".$blocked."'";
        }

        if ($implode) {
            $sql .= " WHERE ".implode(" AND ", $implode);
        }

        //If for total, we done building the query
        if ($mode == 'total_only' && !$this->dcrypt->active) {
            $query = $this->db->query($sql);
            return $query->row['total'];
        }

        $sort_data = [
            'ip_capture_contact_us_id' => 'ip_capture_contact_us_id',
            'name'           => 'firstname',
            'company'        => 'company',
            'email'          => 'email',
            'ip'             => 'ip',
            'blocked'        => 'blocked',
            'zone'           => 'zone',
            'country'        => 'country',
            'note'           => 'note',
            'date_added'     => 'date_added',
        ];

        //Total calculation for encrypted mode
        // NOTE: Performance slowdown might be noticed or larger search results
        if ($mode != 'total_only') {
            $sql .= " ORDER BY ".($sort_data[$data['sort']] ? $sort_data[$data['sort']] : 'firstname');
            if (isset($data['order']) && (strtoupper($data['order']) == 'DESC')) {
                $sql .= " DESC";
            } else {
                $sql .= " ASC";
            }

            if (isset($data['start']) || isset($data['limit'])) {
                if ($data['start'] < 0) {
                    $data['start'] = 0;
                }
                if ($data['limit'] < 1) {
                    $data['limit'] = 20;
                }
                $sql .= " LIMIT ".(int) $data['start'].",".(int) $data['limit'];
            }
        }

        $query = $this->db->query($sql);
        $result_rows = $query->rows;

        if ($mode == 'total_only') {
            //we get here only if in data encryption mode
            return count($result_rows);
        }

        return $result_rows;
    }

    public function getIpCaptureInfo($id) {
        $query = $this->db->query("SELECT * FROM ".$this->db->table("ip_capture_contact_us")."  WHERE ip_capture_contact_us_id=".(int)$id);
        return $query->row;
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getCompanies() {
        $sql = "SELECT DISTINCT company FROM ".$this->db->table("ip_capture_contact_us");
        $query = $this->db->query($sql);
        return $query->rows;
    }
    
    public function getNote($ip_capture_contact_us_id) {
        $query = $this->db->query("SELECT note FROM ".$this->db->table("ip_capture_contact_us")." 
                         WHERE ip_capture_contact_us_id=".(int)$ip_capture_contact_us_id);
        return $query->row;
    }

    /**
     * @param $ip_capture_id
     * @param $note
     * @return bool|stdClass|void
     * @throws AException
     */
    public function updateNote($ip_capture_contact_us_id,$note) {
        return $this->db->query('UPDATE '.$this->db->table("ip_capture_contact_us").' SET note="'.$note.'" WHERE ip_capture_contact_us_id = "' . (int)$ip_capture_contact_us_id . '"');
    }

    public function updateBlocked($ip_capture_contact_us_id,$blocked) {
        return $this->db->query('UPDATE '.$this->db->table("ip_capture_contact_us").' SET blocked="'.$blocked.'" WHERE ip_capture_contact_us_id = "' . (int)$ip_capture_contact_us_id . '"');
    }

    public function deleteIPCaptureContactUs($ip_capture_contact_us_id) {
        $this->db->query("DELETE FROM ".$this->db->table("ip_capture_contact_us")." WHERE `ip_capture_contact_us_id`=".(int)$ip_capture_contact_us_id);
    }
}