<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * ControllerPagesExtensionIpCapture
 * @property ModelExtensionIpcapture $model_extension_ip_capture
 */

class ControllerPagesExtensionIpCapture extends AController {
    public $error = [];

    public function main()  {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->load->language('sale/customer');
        $this->load->language('ip_capture/ip_capture');

        $this->document->setTitle($this->language->get('ip_capture_heading_title'));

        $this->document->initBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('index/home'),
                'text'      => $this->language->get('text_home'),
                'separator' => false,
            ]
        );
        $this->document->addBreadcrumb(
            [
                'href'    => $this->html->getSecureURL('extension/ip_capture'),
                'text'    => $this->language->get('ip_capture_heading_title'),
                'current' => true,
            ]
        );

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/ip_capture.css'),
                'rel' => 'stylesheet',
            ]
        );

        //set store selector
        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());

        if (isset($this->session->data['error'])) {
            $this->data['error_warning'] = $this->session->data['error'];
            unset($this->session->data['error']);
        } elseif (isset($this->error['warning'])) {
            $this->data['error_warning'] = $this->error['warning'];
        } else {
            $this->data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $this->data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $this->data['success'] = '';
        }

        $grid_settings = [
            //id of grid
            'table_id'     => 'ip_capture_grid',
            // url to load data from
            'url'          => $this->html->getSecureURL('listing_grid/ip_capture'),
            'editurl'      => $this->html->getSecureURL('listing_grid/ip_capture/update'),
            'update_field' => '',
            'sortname'     => 'date_added',
            'sortorder'    => 'desc',
            // actions
            'actions'      => [
                'view'          => [
                    'text' => $this->language->get('text_view'),
                    'href' => $this->html->getSecureURL('extension/ip_capture/redirectCustomer', '&ip_capture_id=%ID%'),
                ],
                'edit'          => [
                    'text' => $this->language->get('text_edit'),
                    'href' => $this->html->getSecureURL('extension/ip_capture/edit', '&ip_capture_id=%ID%'),
                ],
                'delete'   => [
                    'text' => $this->language->get('button_delete'),
                ],
            ],
        ];

        $grid_settings['colNames'] = [
            $this->language->get('column_id'),
            $this->language->get('column_name'),
            $this->language->get('column_company'),
            $this->language->get('column_customer_group'),
            $this->language->get('column_email'),
            $this->language->get('column_zone'),
            $this->language->get('column_country'),
            $this->language->get('column_ip'),
            $this->language->get('column_blocked'),
            $this->language->get('column_note'),
            $this->language->get('column_date_added'),
        ];
        $grid_settings['colModel'] = [
            [
                'name'  => 'customer_id',
                'index' => 'customer_id',
                'width' => 40,
                'align' => 'center',
                'search' => false,
            ],
            [
                'name'  => 'name',
                'index' => 'name',
                'width' => 120,
                'align' => 'center',
            ],
            [
                'name'  => 'company',
                'index' => 'company',
                'width' => 160,
                'align' => 'center',
            ],
            [
                'name'  => 'customer_group',
                'index' => 'customer_group',
                'width' => 160,
                'align' => 'center',
            ],
            [
                'name'  => 'email',
                'index' => 'email',
                'width' => 200,
                'align' => 'center',
            ],
            [
                'name'  => 'zone',
                'index' => 'zone',
                'width' => 180,
                'align' => 'center',
            ],
            [
                'name'  => 'country',
                'index' => 'country',
                'width' => 180,
                'align' => 'center',
            ],
            [
                'name'  => 'ip',
                'index' => 'ip',
                'width' => 180,
                'align' => 'center',
            ],
            [
                'name'   => 'blocked',
                'index'  => 'blocked',
                'width'  => 100,
                'align'  => 'center'
            ],
            [
                'name'   => 'note',
                'index'  => 'note',
                'width'  => 160,
                'align'  => 'center'
            ],
            [
                'name'   => 'date_added',
                'index'  => 'date_added',
                'width'  => 120,
                'align'  => 'center',
                'search' => false,
            ],
        ];

        $this->load->model('extension/ip_capture');

        $companies_result = $this->model_extension_ip_capture->getCompanies();
        $companies = ['' => $this->language->get('text_select_company'),];
        foreach ($companies_result as $company) {
            if ($company['company']==='') {
                continue;
            }
            $companies[$company['company']] = $company['company'];
        }

        $form = new AForm();
        $form->setForm(
            [
                'form_name' => 'ip_capture_grid_search',
            ]
        );

        /**
        //get search filter from cookie if required
        $search_params = [];
        if ($this->request->get['saved_list']) {
            $grid_search_form = json_decode(html_entity_decode($this->request->cookie['grid_search_form']));
            if ($grid_search_form->table_id == $grid_settings['table_id']) {
                parse_str($grid_search_form->params, $search_params);
            }
        }

        $grid_search_form = [];
        $grid_search_form['id'] = 'ip_capture_grid_search';
        $grid_search_form['form_open'] = $form->getFieldHtml(
            [
                'type'   => 'form',
                'name'   => 'ip_capture_grid_search',
                'action' => '',
            ]
        );
        $grid_search_form['submit'] = $form->getFieldHtml(
            [
                'type'  => 'button',
                'name'  => 'submit',
                'text'  => $this->language->get('button_go'),
                'style' => 'button1',
            ]
        );
        $grid_search_form['reset'] = $form->getFieldHtml(
            [
                'type'  => 'button',
                'name'  => 'reset',
                'text'  => $this->language->get('button_reset'),
                'style' => 'button2',
            ]
        );

        $grid_search_form['fields']['company'] = $form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'company',
                'options' => $companies,
                'style' => 'chosen'
            ]
        );
        **/

       // $grid_settings['search_form'] = true;
        //$grid_settings['multiselect'] = "false";
        //$grid_settings['multiaction'] = "false";
        $grid_settings['multiaction_options']['delete'] = $this->language->get('text_delete_selected');

        $grid = $this->dispatch('common/listing_grid', [$grid_settings]);
        $this->view->assign('listing_grid', $grid->dispatchGetOutput());
        //$this->view->assign('search_form', $grid_search_form);

        //$this->view->assign('help_url', $this->gen_help_url('customer_listing'));

        $this->view->batchAssign($this->data);
        $this->processTemplate('pages/extension/ip_capture_list.tpl');

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    public function redirectCustomer() {
        $this->load->model('extension/ip_capture');
        $ip_capture_id = (int)$this->request->get['ip_capture_id'];
        $customer_id = $this->model_extension_ip_capture->getCustomerId($ip_capture_id);
        redirect($this->html->getSecureURL('sale/customer/update', '&customer_id='.$customer_id));
    }

    public function edit() {
        $this->loadModel('extension/ip_capture');
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadLanguage('ip_capture/ip_capture');
        $this->document->setTitle($this->language->get('text_edit'));
        $this->data['heading_title'] = $this->language->get('text_edit');
        $ip_capture_id = (int)$this->request->get['ip_capture_id'];
        // saving
        if ($this->request->is_POST() && $this->_validateEditForm() && $ip_capture_id) {
            $ip_capture_id = (int)$this->request->get['ip_capture_id'];
            $this->loadModel('extension/ip_capture');
            $this->model_extension_ip_capture->updateBlocked($ip_capture_id, $this->request->post['blocked']);
            $this->model_extension_ip_capture->updateNote($ip_capture_id, $this->request->post['note']);
            $customer_id = $this->model_extension_ip_capture->getCustomerId($ip_capture_id);
            $this->model_extension_ip_capture->updateCustomerGroup($customer_id, $this->request->post['customer_group_id']);
            $this->session->data ['success'] = $this->language->get('text_ip_capture_success');
            redirect($this->html->getSecureURL('extension/ip_capture', '&ip_capture_id=' . $ip_capture_id));
        }
        $this->data['error'] = $this->error;
        $info = $this->model_extension_ip_capture->getIpCaptureInfo($ip_capture_id);
        foreach ($info as $k => $v) {
            $this->data[$k] = $v;
        }
        $this->_getForm();
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    private function _getForm() {
        $this->load->language('ip_capture/ip_capture');
        $this->load->model('sale/customer_group');
        if (isset ($this->session->data['warning'])) {
            $this->data ['error_warning'] = $this->session->data['warning'];
            $this->session->data['warning'] = '';
        } else {
            $this->data ['error_warning'] = '';
        }
        $this->view->assign('success', $this->session->data['success']);

        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        $this->document->initBreadcrumb(array('href' => $this->html->getSecureURL('index/home'),
            'text' => $this->language->get('text_home'),
            'separator' => FALSE));

        $this->document->addBreadcrumb(array('href' => $this->html->getSecureURL('extension/ip_capture'),
            'text' => $this->language->get('ip_capture_name'),
            'separator' => ' :: '));

        $this->data ['cancel'] = $this->html->getSecureURL('extension/ip_capture');

        $this->data ['action'] = $this->html->getSecureURL('extension/ip_capture/edit', '&ip_capture_id=' . $this->request->get ['ip_capture_id']);
        $this->data ['form_title'] = $this->language->get('text_edit') . ' ' . $this->data['title'];
        $this->data ['update'] = $this->html->getSecureURL('listing_grid/ip_capture/update_field', '&ip_capture_id=' . $this->request->get ['ip_capture_id']);
        $form = new AForm ('HS');

        $this->document->addBreadcrumb(
            array('href' => $this->data['action'],
                'text' => $this->data ['form_title'],
                'separator' => ' :: ',
                'current' => true
            ));

        $form->setForm(array('form_name' => 'ipCaptureFrm', 'update' => $this->data ['update']));

        $this->data['form']['form_open'] = $form->getFieldHtml(
            array('type' => 'form',
                'name' => 'ipCaptureFrm',
                'attr' => 'data-confirm-exit="true" class="aform form-horizontal"',
                'action' => $this->data ['action']));

        $this->data['form']['submit'] = $form->getFieldHtml(
            array('type' => 'button',
                'name' => 'submit',
                'text' => $this->language->get('button_save')));

        $this->data['form']['cancel'] = $form->getFieldHtml(
            array('type' => 'button',
                'name' => 'cancel',
                'text' => $this->language->get('button_cancel')));

        $this->data['form']['fields']['name'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'name',
            'value' => $this->data['firstname'].' '.$this->data['lastname'],
            'attr'  => 'disabled'
        ));
        $this->data['form']['text']['name'] = $this->language->get('entry_name');

        $this->data['form']['fields']['company'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'company',
            'value' => $this->data['company'],
            'attr'  => 'disabled'
        ));
        $this->data['form']['text']['company'] = $this->language->get('entry_company');

        $customer_groups = $this->model_sale_customer_group->getCustomerGroups();
        $cust_groups = [];
        foreach ($customer_groups as $cust_group) {
            $cust_groups[$cust_group['customer_group_id']] = $cust_group['name'];
        }

        $this->data['form']['fields']['customer_group_id'] = $form->getFieldHtml(array(
            'type' => 'selectbox',
            'name' => 'customer_group_id',
            'options' => $cust_groups,
            'value' => $this->data['customer_group_id']
        ));
        $this->data['form']['text']['customer_group_id'] = $this->language->get('entry_customer_group_id');

        $this->data['form']['fields']['zone'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'zone',
            'value' => $this->data['zone'],
            'attr'  => 'disabled'
        ));
        $this->data['form']['text']['zone'] = $this->language->get('entry_zone');

        $this->data['form']['fields']['country'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'country',
            'value' => $this->data['country'],
            'attr'  => 'disabled'
        ));
        $this->data['form']['text']['country'] = $this->language->get('entry_country');

        $this->data['form']['fields']['blocked'] = $form->getFieldHtml(array(
            'type' => 'selectbox',
            'name' => 'blocked',
            'options' => [
                '0' => $this->language->get('text_no'),
                '1' => $this->language->get('text_yes')
            ],
            'value' => $this->data['blocked']
        ));
        $this->data['form']['text']['blocked'] = $this->language->get('entry_blocked');

        $this->data['form']['fields']['note'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'note',
            'value' => $this->data['note']
        ));
        $this->data['form']['text']['note'] = $this->language->get('entry_note');

        $this->data['customer_id'] = $this->request->get['customer_id'] ? $this->request->get['customer_id'] : '0';

        $this->view->batchAssign($this->language->getASet());
        $this->view->batchAssign($this->data);
        $this->view->assign('form_language_switch', $this->html->getContentLanguageSwitcher());
        $this->view->assign('language_code', $this->session->data['language']);
        $this->processTemplate('pages/extension/ip_capture_form.tpl');
    }

    private function _validateEditForm() {
        if (!$this->user->canModify('extension/ip_capture')) {
            $this->session->data['warning'] = $this->error ['warning'] = $this->language->get('error_permission');
        }

        $this->extensions->hk_ValidateData($this);
        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }

}