<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

$this->db->query("Create table if not exists `".DB_PREFIX."info_banner_tmp` ( `id` int(2) , `title` VARCHAR(100) )ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;");

$rm = new AResourceManager();
$rm->setType('image');

$language_id = $this->language->getLanguageID();
$data = [];
$data['resource_code'] = '<i class="fa fa-file-o"></i>&nbsp;';
$data['name'] = [$language_id => 'Menu Icon Info Banner'];
$data['title'] = [$language_id => ''];
$data['description'] = [$language_id => ''];
$resource_id = $rm->addResource($data);

$this->db->query('DELETE FROM '.$this->db->table('info_banner_tmp'));

$sql='Insert into '.$this->db->table('info_banner_tmp').' ( `id`, `title` ) value ( "'.$resource_id.'" , "'."info_banner_resource_id".'");';

$this->db->query($sql);

$menu = new AMenu ( "admin" );

$menu->insertMenuItem ( [
        "item_id"         => "info_banner",
        "parent_id"       =>"",
        "item_text"       => "Info Banner",
        "item_url"        => "extension/info_banner",
        "item_icon_rl_id" => $resource_id,
        "item_type"       =>"core",
        "sort_order"      =>"27"
    ]
);

$sql1="CREATE TABLE IF NOT EXISTS " . $this->db->table('info_banner') . " (
`info_banner_id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
`status` CHAR(1),
`sticky` CHAR(1),
`bg_color` CHAR(7),
`color` CHAR(7),
`close_button` CHAR(1),
`sort_order` INT(2),
`opacity` CHAR(3),
`hide_banner` CHAR(1),
`start_date` timestamp NULL DEFAULT NULL,
`end_date` timestamp NULL DEFAULT NULL,
`layouts` TEXT,
`customer_groups` TEXT,
`custom_css` TEXT,
`store_id` int(11),
`date_added` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
`date_modified` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00'
)ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql1);

$sql2="CREATE TABLE IF NOT EXISTS " . $this->db->table('info_banner_description') . " (
`id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
`info_banner_id` INT(11),
`title` VARCHAR(256) COMMENT 'translatable',
`content` TEXT COMMENT 'translatable',
`language_id` int(11) NOT NULL
)ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql2);

$sql3="CREATE TABLE IF NOT EXISTS " . $this->db->table('info_banner_to_layouts') . " (
`id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
`info_banner_id` INT(11),
`layout` INT(11),
`layout_name` VARCHAR(256)
)ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql3);

$sql4="CREATE TABLE IF NOT EXISTS " . $this->db->table('info_banner_to_customer_groups') . " (
`id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
`info_banner_id` INT(11),
`customer_group_id` INT(11),
`customer_group_name` VARCHAR(256)
)ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql4);

$sql5 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("info_banner_updater_notification") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL,
  `cart_version` VARCHAR(10),
  `extension_version` VARCHAR(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql5);

$sql6 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("info_banner_license_info") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `public_key` TEXT NOT NULL,
  `license_data` TEXT NOT NULL,
  `license_key` TEXT NOT NULL,
  `store_id` int(11) NOT NULL,
  `last_check` int(11),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql6);

if (!file_exists(DIR_SYSTEM.'lib/license.php')) {
    /**
     *  Function to Copy folders and files
     * @param $src
     * @param $dst
     * @return array
     */
    function custom_copy($src, $dst) {
        $error = [];
        // open the source directory
        $dir = opendir($src);
        if (!is_dir($dst)) {
            @mkdir($dst);
        }
        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    // Recursively calling custom copy function
                    // for sub directory
                    custom_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    if (!copy($src . '/' . $file, $dst . '/' . $file)) {
                        $error['error_copy'][] = "Failed to copy $file";
                    }
                }
            }
        }
        if (sizeof($error)>0) {
            $log=new ALog(DIR_SYSTEM.'logs/error.txt');
            $log->write(var_export($error,true));
        }
        closedir($dir);
        return $error;
    }

    $copy = custom_copy(DIR_EXT . 'info_banner' . DIR_EXT_CORE . 'lib/license', DIR_SYSTEM.'lib');
}
