<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ModelExtensionInfoBanner
 * @property ModelCatalogCategory $model_catalog_category
 * @property ModelCatalogProduct $model_catalog_product
 * @property ModelCatalogManufacturer $model_catalog_manufacturer
 * @property ModelSaleCustomerGroup $model_sale_customer_group
 */

class ModelExtensionInfoBanner extends Model {

    /**
     * @param $data
     * @return int
     * @throws AException
     */
    public function addInfoBanner($data) {
        $this->load->model('sale/customer_group');
        $store_id = $this->getStoreId();
        $language_id = (int) $this->language->getContentLanguageID();
        if (isset($data['start_date'])) {
            $data['start_date'] = "DATE('".$data['start_date']."')";
        } else {
            $data['start_date'] = "NULL";
        }

        if (isset($data['end_date'])) {
            $data['end_date'] = "DATE('".$data['end_date']."')";
        } else {
            $data['end_date'] = "NULL";
        }

        $sql = "INSERT INTO " . $this->db->table('info_banner') . " SET
        `status` ='" . $data['status'] . "',
        `sticky` ='" . $data['sticky'] . "',
        `hide_banner` ='" . $data['hide_banner'] . "',
        `bg_color` ='" . $data['bg_color'] . "',
        `color` ='" . $data['color'] . "',
        `close_button` ='" . $data['close_button'] . "',
        `start_date` = ".$data['start_date'].",
        `end_date` = ".$data['end_date'].",
        `opacity` ='" . $data['opacity'] . "',
        `sort_order` ='" . $data['sort_order'] . "',
        `layouts` ='" . serialize($data['layouts']) . "',
        `customer_groups` ='".serialize($data['customer_groups'])."',
        `custom_css` ='".$data['custom_css']."',
        `store_id`=" . $store_id.",
        `date_added`=NOW(),
        `date_modified`=NOW()";
        $this->db->query($sql);
        $info_banner_id = $this->db->getLastId();

        // if new product
        if (!is_int(key($data['info_banner_description']))) {
            $update = [];
            foreach ($data['info_banner_description'] as $field => $value) {
                $update[$language_id][$field] = $value;
            }
            $this->language->replaceDescriptions(
                'info_banner_description',
                ['info_banner_id' => (int) $info_banner_id],
                $update
            );
        }

        foreach ($data['layouts'] as $layout) {
            $query_layout_name = $this->db->query("SELECT `template_id`,`layout_name` FROM ".$this->db->table("layouts")." WHERE `layout_id`=".$layout);
            $layout_name = $query_layout_name->row;
            $layoutName = $this->addDetails($layout_name['layout_name']);
            $sql1 = "INSERT INTO " . $this->db->table('info_banner_to_layouts') . " SET
                    `info_banner_id` ='" . $info_banner_id . "',
                    `layout` ='" . $layout . "',
                      `layout_name`='".$layout_name['template_id'].' - '.$layoutName."'";
            $this->db->query($sql1);
        }

        foreach ($data['customer_groups'] as $groups) {
            $group_info = $this->model_sale_customer_group->getCustomerGroup($groups);
            $sql1 = "INSERT INTO " . $this->db->table('info_banner_to_customer_groups') . " SET
                    `info_banner_id` ='" . $info_banner_id . "',
                    `customer_group_id` ='" . $groups . "',
                    `customer_group_name`='".$group_info['name']."'";
            $this->db->query($sql1);
        }

        return $info_banner_id;
    }

    /**
     * @param $info_banner_id
     * @return mixed
     * @throws AException
     */
    public function getInfoBanner($info_banner_id) {
        $store_id = $this->getStoreId();
        $sql = "SELECT * FROM " . $this->db->table('info_banner'). " WHERE `info_banner_id`=".$info_banner_id." AND `store_id`=".$store_id;
        $result = $this->db->query($sql);
        return $result->row;
    }

    /**
     * @param $info_banner_id
     * @param $language_id
     * @return array|mixed
     * @throws AException
     */
    public function getInfoBannerDescription($info_banner_id,$language_id = 0) {
        $sql = "SELECT * FROM " . $this->db->table('info_banner_description'). " WHERE `info_banner_id`=".$info_banner_id;
        $query = $this->db->query($sql);
        foreach ($query->rows as $result) {
            $info_banner_description[$result['language_id']] = [
                'title'             => $result['title'],
                'content'           => $result['content']
            ];
        }

        return $language_id ? $info_banner_description[$language_id] : $info_banner_description;
    }

    /**
     * @param array $data
     *
     * @return array|null
     */
    public function getTotalInfoBanner($data = [])  {
        return $this->getAllInfoBanner($data, 'total_only');
    }

    /**
     * @param $filter
     * @param string $mode
     * @return array
     */
    public function getAllInfoBanner($data, $mode = '') {
        $store_id = $this->getStoreId();

        if ($data || $mode == 'total_only') {
            if ($mode == 'total_only') {
                $sql = "SELECT COUNT(*) as total ";
            } else {
                $sql =  "SELECT * ";
            }

            $sql.=" FROM ".$this->db->table("info_banner")." info 
                   LEFT JOIN ".$this->db->table("info_banner_description")." info_desc ON info_desc.info_banner_id=info.info_banner_id" ;

            $sql .= ' WHERE 1=1 AND info.store_id='.$store_id.' And info_desc.language_id='.$this->session->data['content_language_id'];

            $filter = (isset($data['filter']) ? $data['filter'] : array());

            if (isset($filter['title']) && $filter['title'] != '') {
                $sql .= " AND info_desc.title LIKE '%" . $filter['title'] . "%'";
            }

            if ($mode == 'total_only') {
                $query = $this->db->query($sql);
                return $query->row['total'];
            }

            $sort_data = [
                'id'      => 'info.info_banner_id',
                'title'   => 'info_desc.title',
                'status'  => 'info.status',
                'start_date' => 'info.start_date',
                'end_date' => 'info.end_date'
            ];

            if (isset($data['sort']) && in_array($data['sort'], array_keys($sort_data))) {
                $sql .= " ORDER BY ".$sort_data[$data['sort']];
            } else {
                $sql .= " ORDER BY info.info_banner_id";
            }

            if (isset($data['order']) && ($data['order'] == 'DESC')) {
                $sql .= " DESC";
            } else {
                $sql .= " ASC";
            }

            if (isset($filter['start']) || isset($filter['limit'])) {
                if ($filter['start'] < 0) {
                    $filter['start'] = 0;
                }
                if ($filter['limit'] < 1) {
                    $filter['limit'] = 20;
                }
                $sql .= $mode != 'total_only' ? " LIMIT " . (int)$filter['start'] . "," . (int)$filter['limit'] : '';
            }

            $result = $this->db->query($sql);
            $rows = $result->rows;
        } else {
            $sql = "SELECT * FROM ".$this->db->table("info_banner")." info 
                   LEFT JOIN ".$this->db->table("info_banner_description")." info_desc ON info_desc.info_banner_id=info.info_banner_id" ;

            $sql .= ' WHERE 1=1 AND info.store_id='.$store_id.' And info_desc.language_id='.$this->session->data['content_language_id'];
            $result = $this->db->query($sql);
            $rows = $result->rows;

        }

        return $rows;
    }

    /**
     * @param $info_banner_id
     * @return mixed
     */
    public function getLayoutName($info_banner_id) {
        $sql = "SELECT group_concat(`layout_name` ORDER BY `layout_name` ASC SEPARATOR '<br> ') as layouts FROM ".$this->db->table("info_banner_to_layouts")." WHERE info_banner_id=".$info_banner_id;
        $query = $this->db->query($sql);
        return $query->row['layouts'];
    }

    /**
     * @param $info_banner_id
     * @return mixed
     */
    public function getCustomerGroups($info_banner_id) {
        $sql = "SELECT group_concat(`customer_group_name` ORDER BY `customer_group_name` ASC SEPARATOR '<br> ') as customer_groups FROM ".$this->db->table("info_banner_to_customer_groups")." WHERE info_banner_id=".$info_banner_id;
        $query = $this->db->query($sql);
        return $query->row['customer_groups'];
    }

    /**
     * @param $info_banner_id
     * @param $data
     * @return void
     * @throws AException
     */
    public function updateInfoBanner($info_banner_id,$data) {
        $store_id = $this->getStoreId();
        $language_id = (int) $this->language->getContentLanguageID();
        $this->load->model('sale/customer_group');

        if (isset($data['start_date']) && !$data['start_date']) {
            $data['start_date'] = 'NULL';
        }
        if (isset($data['end_date']) && !$data['end_date']) {
            $data['end_date'] = 'NULL';
        }

        $fields = [
            'status',
            'sticky',
            'hide_banner',
            'bg_color',
            'color',
            'close_button',
            'opacity',
            'sort_order',
            'layouts',
            'start_date',
            'end_date',
            'customer_groups',
            'custom_css',
            'date_modified'
        ];

        $update=[];
        foreach ($fields as $f) {
            if (isset($data[$f])) {
                if ($f==='layouts') {
                    $update[] = "$f = '" . serialize($data[$f]) . "'";
                    $this->db->query("DELETE FROM " . $this->db->table('info_banner_to_layouts') . " WHERE `info_banner_id`=" . $info_banner_id);
                    foreach ($data[$f] as $layout) {
                        $query_layout_name = $this->db->query("SELECT `template_id`,`layout_name` FROM " . $this->db->table("layouts") . " WHERE `layout_id`=" . $layout);
                        $layout_name = $query_layout_name->row;
                        $layoutName = $this->addDetails($layout_name['layout_name']);
                        $sql1 = "INSERT INTO " . $this->db->table('info_banner_to_layouts') . " SET
                           `info_banner_id` ='" . $info_banner_id . "',
                           `layout` ='" . $layout . "',
                          `layout_name`='" . $layout_name['template_id'] . ' - ' . $layoutName . "'";
                        $this->db->query($sql1);
                    }
                } elseif ($f==='customer_groups') {
                    $update[] = "$f = '" . serialize($data[$f]) . "'";
                    $this->db->query("DELETE FROM " . $this->db->table('info_banner_to_customer_groups') . " WHERE `info_banner_id`=" . $info_banner_id);
                    foreach ($data[$f] as $groups) {
                        $group_info = $this->model_sale_customer_group->getCustomerGroup($groups);
                        $sql1 = "INSERT INTO " . $this->db->table('info_banner_to_customer_groups') . " SET
                                 `info_banner_id` ='" . $info_banner_id . "',
                                 `customer_group_id` ='" . $groups . "',
                                 `customer_group_name`='".$group_info['name']."'";
                        $this->db->query($sql1);
                    }
                } elseif ($f==='start_date' || $f==='end_date') {
                    if ($data[$f]==='NULL') {
                        $update[] = "$f = NULL ";
                    } else {
                        $update[] = "$f = '" . $data[$f] . "'";
                    }
                } else {
                    $update[] = "$f = '" . $data[$f] . "'";
                }
            }
        }

        if (!empty($update)) {
             $this->db->query("UPDATE " .$this->db->table('info_banner') ." SET " . implode(',', $update) . " WHERE info_banner_id = '" . (int)$info_banner_id . "' AND `store_id`='".$store_id."'");
        }

        if ($data['info_banner_description']) {
            foreach ($data['info_banner_description'] as $field => $value) {
                $desc_fields = [
                    'title',
                    'content',
                ];
                $update_desc = [];
                foreach ($desc_fields as $desc) {
                    if ($desc === $field) {
                        $update_desc[$desc] = $value;
                    }
                }

                if (!empty($update_desc)) {
                    $this->language->replaceDescriptions(
                        'info_banner_description',
                        ['info_banner_id' => (int) $info_banner_id],
                        [$language_id => $update_desc]
                    );
                }
            }
        }

    }

    /**
     * @param $info_banner_id
     * @return void
     * @throws AException
     */
    public function deleteInfoBanner($info_banner_id) {
        $store_id = $this->getStoreId();
        $sql="DELETE FROM " .$this->db->table('info_banner') ." WHERE info_banner_id=".$info_banner_id. " AND `store_id`=".$store_id;
        $this->db->query("DELETE FROM ".$this->db->table('info_banner_description')." WHERE `info_banner_id`=".$info_banner_id);
        $this->db->query("DELETE FROM ".$this->db->table('info_banner_to_layouts')." WHERE `info_banner_id`=".$info_banner_id);
        $this->db->query("DELETE FROM ".$this->db->table('info_banner_to_customer_groups')." WHERE `info_banner_id`=".$info_banner_id);
        $this->db->query($sql);
    }

    /**
     * @param $layout_name
     * @return string
     */
    public function addDetails($layout_name) {
        $layoutName = '';
        switch ($layout_name) {
            case 'Checkout Pages':
                $layoutName = 'Checkout Pages (All pages for checkout process)';
                break;
            case 'Cart Page':
                $layoutName = 'Cart Page (Basket or Shopping cart page)';
                break;
            case 'Product Listing Page':
                $layoutName = 'Product Listing Page (Categories Pages)';
                break;
            case 'Default Page Layout':
                $layoutName = 'Default Page Layout (All others pages)';
                break;
            default:
                $layoutName = $layout_name;
                break;
        }
        return $layoutName;
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getInfoBannerList() {
        $sql = "SELECT ib.info_banner_id,ibd.title FROM ".$this->db->table("info_banner")." ib LEFT JOIN ".$this->db->table("info_banner_description")." ibd ON ibd.info_banner_id = ib.info_banner_id";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    /**
     * @param int $product_id
     *
     * @return array
     * @throws AException
     */
    public function getInfoBannerRelated($promo_manager_id) {
        $query = $this->db->query(
            "SELECT `info_banner_id`
            FROM ".$this->db->table("promo_manager_info_banner_related")." 
            WHERE `promo_manager_id` = '".(int) $promo_manager_id."'"
        );

        return $query->row['info_banner_id'];
    }

    /**
     * @return int
     */
    public function getStoreId() {
        $store_id = (int)$this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int)$this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int)$this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
}