<?php

/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelSaleIncompleteOrder extends Model {

    public function cancelOrder() {
        if ((int) $this->config->get('incomplete_order_expiration_days') || $this->config->get('incomplete_order_expiration_days') === '0' ) {
            $query = $this->db->query(
                "SELECT order_id
                    FROM ".$this->db->table("orders")."
                    WHERE date_modified < '"
                .date(
                    'Y-m-d',
                    strtotime('-'.(int) $this->config->get('incomplete_order_expiration_days').' days')
                )."' AND order_status_id = '0'"
            );
            foreach ($query->rows as $result) {
                $this->_cancel_order($result['order_id']);
            }
        }
    }

    protected function _cancel_order($order_id) {
        $order_id = (int) $order_id;
        if (!$order_id) {
            return false;
        }
        $this->db->query("UPDATE `".$this->db->table("orders")."` SET `order_status_id` = '7' WHERE order_id = '".$order_id."'");
    }

}