<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

$sql = "CREATE TABLE IF NOT EXISTS ".$this->db->table('incomplete_order_history')." (
    `order_id` int(11) NOT NULL,
	`emailed` tinyint(1) NOT NULL DEFAULT '1',
	`date_added` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
	PRIMARY KEY (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin";

$this->db->query($sql);

$sql1 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("incomplete_order_license_info") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `public_key` TEXT NOT NULL,
  `license_data` TEXT NOT NULL,
  `license_key` TEXT NOT NULL,
  `store_id` int(11) NOT NULL,
  `last_check` int(11),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql1);

$sql3 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("incomplete_order_updater_notification") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL,
  `cart_version` VARCHAR(10),
  `extension_version` VARCHAR(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql3);

if (file_exists(DIR_EXT.'email_editor')) {
    $sql1 = "SELECT `store_id` FROM " . $this->db->table("stores");
    $query1 = $this->db->query($sql1);
    $results1 = $query1->rows;
    foreach ($results1 as $result) {
        $store_id = $result["store_id"];
        $query_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='incomplete_order'");
        $exist = $query_exist->row['total'];
        if ($exist === '0') {
            $incomplete_order_subject = 'Your feedback would be greatly appreciated';

            $incomplete_order_content = 'Dear {{customer_name}},<br>We noticed that during a visit to our store you placed the following item(s) in your shopping cart and proceeded through checkout, but did not complete the transaction.<br><br>';
            $incomplete_order_content .= 'Order Date: {{order_date}}<br><br>';
            $incomplete_order_content .= ' Shopping Cart Contents:<br>{{products}}<br><br>';
            $incomplete_order_content .= 'We are always interested in knowing what happened and if there was a reason that you decided not to purchase at this time. If you could be so kind as to let us know if you had any issues or concerns, we would appreciate it. We are asking for feedback from you and others as to how we can help make your experience at {{store_name}} better. Simply reply to this e-mail with your issue, concern or comment.<br><br>Again, thank you for your time and consideration in helping us improve the {{store_name}} website.<br>Sincerely, {{store_url}}';

            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
                              SET `section` = 'incomplete_order', 
                              `sender_name`='',`sender_email`='',`subject`='" . $this->db->escape($incomplete_order_subject) . "', 
                              `default_subject`='" . $this->db->escape($incomplete_order_subject) . "',
                              `content` = '" . $this->db->escape($incomplete_order_content) . "', 
                              `default_content` = '" . $this->db->escape($incomplete_order_content) . "',
                              `allowed_placeholders`='customer_name, order_date, products, store_name, store_url',
                              `email_signature_id` = 0,
                              `notify_admin`=0, `store_id`='" . $store_id . "'
                              ON DUPLICATE KEY UPDATE  
                              `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_incomplete_order_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {{customer_name}}, {{order_date}}, {{products}}, {{store_name}}, {{store_url}}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_incomplete_order_subject','Incomplete Order Email Subject:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_incomplete_order_content','Incomplete Order Email Content:',now(),now())");
        }
    }
}

// add new menu item
$menu = new AMenu ("admin");
$menu->insertMenuItem(
    [
        "item_id"    => "incomplete_order",
        "parent_id"  => "sale",
        "item_text"  => "incomplete_order_name",
        "item_url"   => "sale/incomplete_order",
        "item_type"  => "extension",
        "sort_order" => "",
    ]
);


if (!file_exists(DIR_SYSTEM.'lib/license.php')) {
    /**
     *  Function to Copy folders and files
     * @param $src
     * @param $dst
     * @return array
     */
    function custom_copy($src, $dst) {
        $error = array();
        // open the source directory
        $dir = opendir($src);
        if (!is_dir($dst)) {
            @mkdir($dst);
        }
        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    // Recursively calling custom copy function
                    // for sub directory
                    custom_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    if (!copy($src . '/' . $file, $dst . '/' . $file)) {
                        $error['error_copy'][] = "Failed to copy $file";
                    }
                }
            }
        }
        if (sizeof($error)>0) {
            $log=new ALog(DIR_SYSTEM.'logs/error.txt');
            $log->write(var_export($error,true));
        }
        closedir($dir);
        return $error;
    }

    $copy = custom_copy(DIR_EXT . 'incomplete_order' . DIR_EXT_CORE . 'lib', DIR_SYSTEM.'lib');
}
