<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerPagesSaleIncompleteOrder
 * @property ModelSaleIncompleteOrder $model_sale_incomplete_order
 * @property ModelExtensionEmailTemplates $model_extension_email_templates
 */
class ControllerPagesSaleIncompleteOrder extends AController {
    public $error = [];
    public $placeholders = [];

    public function verify() {
        if ( $this->config->get( 'incomplete_order_status' ) === '1' ) {
            $this->load->model('extension/incomplete_order_license_info');
            $license_key = $this->config->get('incomplete_order_license_code');
            $shared_secret = 'incomplete_order';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('incomplete_order_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_incomplete_order_license_info->getStoreId();
                    $license_key = $this->model_extension_incomplete_order_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_incomplete_order_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_incomplete_order_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyEmailEditor() {
        if ( $this->config->get( 'email_editor_status' ) === '1' ) {
            $this->load->model('extension/email_editor_license_info');
            $license_key = $this->config->get('email_editor_license_code');
            $shared_secret = 'email_editor';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('email_editor_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_email_editor_license_info->getStoreId();
                    $license_key = $this->model_extension_email_editor_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_email_editor_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_email_editor_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }
    public function main() {
        $this->loadLanguage('incomplete_order/incomplete_order');
        $this->document->setTitle($this->language->get('incomplete_order_name'));
        $this->load->model('sale/incomplete_order');
        $this->getList();
    }

    private function getList() {
        $post = $this->request->is_POST() ? $this->request->post : $this->request->get;
        $yes_no = [
            0 => $this->language->get('text_no'),
            1 => $this->language->get('text_yes'),
        ];

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'o.order_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }
        if (isset($this->request->get['limit'])) {
            $limit = $this->request->get['limit'];
        } else {
            $limit = $this->config->get('config_admin_limit');
        }

        // search form
        $form = new AForm();
        $form->setForm(
            [
                'form_name' => 'orders_grid_search',
            ]
        );

        $grid_search_form = [];
        $grid_search_form['id'] = 'orders_grid_search';
        $grid_search_form['form_open'] = $form->getFieldHtml(
            [
                'type'   => 'form',
                'name'   => 'orders_grid_search',
                'action' => $this->html->getSecureURL('sale/incomplete_order'),
            ]
        );
        $grid_search_form['submit'] = $form->getFieldHtml(
            [
                'type'  => 'button',
                'name'  => 'submit',
                'text'  => $this->language->get('button_go'),
                'style' => 'button1',
            ]
        );
        $grid_search_form['reset'] = $form->getFieldHtml(
            [
                'type'  => 'button',
                'name'  => 'reset',
                'text'  => $this->language->get('button_reset'),
                'style' => 'button2',
            ]
        );

        $grid_search_form['fields']['order_id'] = $form->getFieldHtml(
            [
                'type'        => 'input',
                'name'        => 'filter_order_id',
                'value'       => $post['filter_order_id'],
                'placeholder' => $this->language->get('search_order_placeholder'),
            ]
        );

        $grid_search_form['fields']['name'] = $form->getFieldHtml(
            [
                'type'        => 'input',
                'name'        => 'filter_name',
                'value'       => $post['filter_name'],
                'placeholder' => $this->language->get('search_name_placeholder'),
            ]
        );

        $companies_result = $this->model_sale_incomplete_order->getCompanies();
        $companies = [
            '' => $this->language->get('text_select_company'),
            'empty' => $this->language->get('text_blank'),
        ];
        foreach ($companies_result as $company) {
            if ($company['company']==='') {
                continue;
            }
            $companies[$company['company']] = $company['company'];
        }

        $grid_search_form['fields']['company'] = $form->getFieldHtml(
            [
                'type'        => 'selectbox',
                'name'        => 'filter_company',
                'value'       => $post['filter_company'],
                'options'     => $companies,
                'style'       => 'chosen'
            ]
        );

        $account_status = [
            'FALSE' => $this->language->get('text_select_account_status'),
            '0' => $this->language->get('text_guest'),
            '1' => $this->language->get('text_registered')
        ];

        $grid_search_form['fields']['account_status'] = $form->getFieldHtml(
            [
                'type'        => 'selectbox',
                'name'        => 'filter_account_status',
                'options'     => $account_status,
                'value'       => $post['filter_account_status'],
            ]
        );

        $grid_search_form['fields']['date_added'] = $form->getFieldHtml(
            [
                'type'        => 'date',
                'name'        => 'filter_date_added',
                'value'       => $post['filter_date_added'],
                'placeholder' => $this->language->get('search_date_added_placeholder'),
            ]
        );

        $grid_search_form['fields']['total'] = $form->getFieldHtml(
            [
                'type'        => 'input',
                'name'        => 'filter_total',
                'value'       => $post['filter_total'],
                'placeholder' => $this->language->get('search_total_placeholder'),
            ]
        );

        $grid_search_form['fields']['emailed'] = $form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'filter_emailed',
                'value'   => (isset($post['filter_emailed']) ? $post['filter_emailed'] : 'FALSE'),
                'options' => array_merge([
                    'FALSE' => $this->language->get('incomplete_order_text_show_all')],
                    $yes_no
                ),
            ]
        );

        $this->view->assign('search_form', $grid_search_form);

        $this->view->assign(
            'btn_auto_email', $this->html->buildElement(
            [
                'type' => 'button',
                'name' => 'auto_email',
                'text' => $this->language->get('incomplete_order_button_email_auto'),
            ]
        )
        );
        $this->view->assign('email_auto', $this->html->getSecureURL('sale/incomplete_order/email_auto'));

        $this->view->assign(
            'btn_email_selected', $this->html->buildElement(
            [
                'type' => 'button',
                'name' => 'email_selected',
                'text' => $this->language->get('incomplete_order_button_email_selected'),
            ]
        )
        );

        $form = new AForm();
        $form->setForm(
            [
                'form_name' => 'orderFRM',
            ]
        );

        $gridform = [];
        $gridform['id'] = 'orderFRM';
        $gridform['form_open'] = $form->getFieldHtml(
            [
                'type'   => 'form',
                'name'   => 'orderFRM',
                'action' => $this->html->getSecureURL('sale/incomplete_order/email_selected'),
            ]
        );

        $this->view->assign('gridform', $gridform);

        $ranges = $this->getDateRanges();
        $options = [];
        foreach ($ranges as $k => $range) {
            $options[$k] = $range['name'];
        }

        $this->view->assign(
            'email_date_range_selectbox', $this->html->buildElement(
            [
                'type'    => 'selectbox',
                'name'    => 'email_date_range',
                'options' => $options,
            ]
        )
        );
        $url = '';

        if (isset($post['filter_order_id'])) {
            $url .= '&filter_order_id='.$post['filter_order_id'];
        }
        if (isset($post['filter_name'])) {
            $url .= '&filter_name='.$post['filter_name'];
        }
        if (isset($post['filter_company'])) {
            $url .= '&filter_company='.$post['filter_company'];
        }
        if (isset($post['filter_account_status'])) {
            $url .= '&filter_account_status='.$post['filter_account_status'];
        }
        if (isset($post['filter_date_added'])) {
            $url .= '&filter_date_added='.$post['filter_date_added'];
        }
        if (isset($post['filter_total'])) {
            $url .= '&filter_total='.$post['filter_total'];
        }
        if (isset($post['filter_emailed'])) {
            $url .= '&filter_emailed='.$post['filter_emailed'];
        }

        $url .= '&page='.$page;
        $url .= '&sort='.$sort;
        $url .= '&order='.$order;

        $this->document->resetBreadcrumbs();
        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('common/home'),
                'text'      => $this->language->get('text_home'),
                'separator' => false,
            ]
        );

        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('sale/incomplete_order', $url),
                'text'      => $this->language->get('incomplete_order_name'),
                'separator' => ' :: ',
                'current'   => true,
            ]
        );

        $modelData = [
            'filter_order_id'   => $post['filter_order_id'],
            'filter_name'       => $post['filter_name'],
            'filter_company'       => $post['filter_company'],
            'filter_account_status'       => $post['filter_account_status'],
            'filter_date_added' => $post['filter_date_added']
                ? dateDisplay2ISO(
                    $post['filter_date_added'],
                    $this->language->get('date_format_short')
                )
                : null,
            'filter_total'      => $post['filter_total'],
            'filter_emailed'    => $post['filter_emailed'] != 'FALSE' ? $post['filter_emailed'] : null,
            'sort'              => $sort,
            'order'             => $order,
            'start'             => ($page - 1) * $limit,
            'limit'             => $limit,
        ];

        if ($post['dryrun'] == 1 && isset($post['email_date_range'])) {
            $this->session->data['dryrun'] = $this->language->get('text_dryrun');
            $ranges = $this->getDateRanges();
            $range = $ranges[$post['email_date_range']]['mysql'];
            if ($range) {
                $modelData['filter_date_range'] = $range;
            }
        }

        $order_total = $this->model_sale_incomplete_order->getTotalOrders($modelData);

        $results = $this->model_sale_incomplete_order->getOrders($modelData);
        $orders_list = [];

        foreach ($results as $result) {
            $action = [];

            $action[] = [
                'text' => $this->language->get('text_edit'),
                'href' => $this->html->getSecureURL('sale/order/details', '&order_id='.$result['order_id'].$url),
            ];

            $orders_list[] = [
                'order_id'   => $result['order_id'],
                'name'       => $result['name'],
                'company'    => $result['company'] !== '' ? $result['company'] : '-',
                'account_status' => $result['customer_id'] === '0' ? $this->language->get('text_guest') : $this->language->get('text_registered'),
                'date_added' => dateISO2Display($result['date_added'], $this->language->get('date_format_short')),
                'total'      => $this->currency->format($result['total'], $result['currency'], $result['value']),
                'emailed'    => ($result['emailed']
                    ? $this->language->get('text_yes_on').dateISO2Display(
                        $result['emailed_date'],
                        $this->language->get('date_format_short')
                    )
                    : $this->language->get('text_no')),
                'selected'   => isset($this->request->post['selected'])
                                    && in_array($result['order_id'], $this->request->post['selected']),
                'action'     => $action,
            ];
        }
        $this->view->assign('heading_title', $this->document->getTitle());

        $this->view->assign('orders', $orders_list);
        $this->view->assign('sort', $sort);

        $this->view->assign('incomplete_order_name', $this->language->get('incomplete_order_name'));

        $this->view->assign('text_no_results', $this->language->get('text_no_results'));
        $this->view->assign('text_instructions', $this->language->get('text_instructions'));

        $this->view->assign('entry_date_range', $this->language->get('entry_date_range'));

        $this->view->assign('column_order', $this->language->get('column_order'));
        $this->view->assign('column_name', $this->language->get('column_name'));
        $this->view->assign('column_date_added', $this->language->get('column_date_added'));
        $this->view->assign('column_total', $this->language->get('column_total'));
        $this->view->assign('column_emailed', $this->language->get('column_emailed'));
        $this->view->assign('column_action', $this->language->get('column_action'));

        $this->view->assign('button_filter', $this->language->get('button_filter'));

        $this->view->assign('token', $this->session->data['token']);

        if (isset($this->error['warning'])) {
            $this->view->assign('error_warning', $this->error['warning']);
        } else {
            $this->view->assign('error_warning', '');
        }

        if (isset($this->session->data['success'])) {
            $this->view->assign('success', $this->session->data['success']);

            unset($this->session->data['success']);
        } else {
            $this->view->assign('success', '');
        }

        if (isset($this->session->data['error'])) {
            $this->view->assign('error_warning', $this->session->data['error']);
            unset($this->session->data['error']);
        } else {
            $this->view->assign('error', '');
        }

        if (isset($this->session->data['dryrun'])) {
            $this->view->assign('info', $this->session->data['dryrun']);
            unset($this->session->data['dryrun']);
        } else {
            $this->view->assign('dryrun', '');
        }

        $url = '';

        if (isset($post['filter_order_id'])) {
            $url .= '&filter_order_id='.$post['filter_order_id'];
        }

        if (isset($post['filter_name'])) {
            $url .= '&filter_name='.$post['filter_name'];
        }

        if (isset($post['filter_company'])) {
            $url .= '&filter_company='.$post['filter_company'];
        }

        if (isset($post['filter_account_status'])) {
            $url .= '&filter_account_status='.$post['filter_account_status'];
        }

        if (isset($post['filter_date_added'])) {
            $url .= '&filter_date_added='.$post['filter_date_added'];
        }

        if (isset($post['filter_total'])) {
            $url .= '&filter_total='.$post['filter_total'];
        }

        if (isset($post['filter_emailed'])) {
            $url .= '&filter_emailed='.$post['filter_emailed'];
        }

        if ($order == 'ASC') {
            $url .= '&order='.'DESC';
        } else {
            $url .= '&order='.'ASC';
        }

        $url .= '&page='.$page;
        $url .= '&limit='.$limit;

        $this->view->assign('sort_order', $this->html->getSecureURL('sale/incomplete_order', '&sort=o.order_id'.$url));
        $this->view->assign('sort_name', $this->html->getSecureURL('sale/incomplete_order', '&sort=name'.$url));

        $this->view->assign('sort_company', $this->html->getSecureURL('sale/incomplete_order', '&sort=company'.$url));
        $this->view->assign('sort_account_status', $this->html->getSecureURL('sale/incomplete_order', '&sort=account_status'.$url));

        $this->view->assign(
            'sort_date_added', $this->html->getSecureURL('sale/incomplete_order', '&sort=o.date_added'.$url)
        );
        $this->view->assign('sort_total', $this->html->getSecureURL('sale/incomplete_order', '&sort=o.total'.$url));
        $this->view->assign('sort_emailed', $this->html->getSecureURL('sale/incomplete_order', '&sort=emailed'.$url));

        $url = '';

        if (isset($post['filter_order_id'])) {
            $url .= '&filter_order_id='.$post['filter_order_id'];
        }

        if (isset($post['filter_name'])) {
            $url .= '&filter_name='.$post['filter_name'];
        }

        if (isset($post['filter_company'])) {
            $url .= '&filter_company='.$post['filter_company'];
        }

        if (isset($post['filter_account_status'])) {
            $url .= '&filter_account_status='.$post['filter_account_status'];
        }

        if (isset($post['filter_date_added'])) {
            $url .= '&filter_date_added='.$post['filter_date_added'];
        }

        if (isset($post['filter_total'])) {
            $url .= '&filter_total='.$post['filter_total'];
        }

        if (isset($post['filter_emailed'])) {
            $url .= '&filter_emailed='.$post['filter_emailed'];
        }

        $url .= '&sort='.$sort;
        $url .= '&order='.$order;
        $url .= '&limit='.$limit;

        if ($order_total) {
            $this->view->assign(
                'pagination', HtmlElementFactory::create(
                [
                    'type'       => 'Pagination',
                    'name'       => 'pagination',
                    'text'       => $this->language->get('text_pagination'),
                    'text_limit' => '',
                    'total'      => $order_total,
                    'page'       => $page,
                    'limit'      => $limit,
                    'url'        => $this->html->getSecureURL('sale/incomplete_order'.$url, '&page={page}', '&encode'),
                    'style'      => 'pagination  form-inline',
                ]
            )
            );
        }

        $this->view->assign('email_selected_url',$this->html->getSecureURL('sale/incomplete_order/email_selected'));
        $this->view->assign('cancel_selected_url',$this->html->getSecureURL('sale/incomplete_order/cancel_selected'));
        $this->view->assign('incomplete_order_button_cancel_selected',$this->language->get('incomplete_order_button_cancel_selected'));
        $this->view->assign('reset_url',$this->html->getSecureURL('sale/incomplete_order'));
        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());
        $this->view->assign('license_status', $this->verify());
        $this->view->assign('sort_columns_note', $this->language->get('sort_columns_note'));

        if ($this->verifyEmailEditor()) {
            $this->load->model('extension/email_templates');
            $this->view->assign('email_editor_status', $this->verifyEmailEditor());
            $this->view->assign('text_edit_email_template',$this->language->get('text_edit_email_template'));
            $email_template_id = $this->model_extension_email_templates->getEmailTemplateId('incomplete_order');
            $this->view->assign('email_template_url', $this->html->getSecureURL('extension/email_templates/edit','&id='.$email_template_id['email_template_id']));
        }
        $this->view->assign('text_unauthorized', $this->language->get('text_incomplete_order_unauthorized'));
        $this->processTemplate('pages/sale/incomplete_order_list.tpl');
    }

    public function email_selected() {
        $this->loadLanguage('incomplete_order/incomplete_order');
        $this->document->setTitle($this->language->get('incomplete_order_name'));
        $this->load->model('sale/incomplete_order');

        if (isset($this->request->post['selected']) && ($this->_validateModify())) {
            foreach ($this->request->post['selected'] as $order_id) {
                $result = $this->_sendEmail($order_id);

                if (isset($result['error'])) {
                    if (isset($this->session->data['error'])) {
                        $this->session->data['error'] .= $result['error']."<br />";
                    } else {
                        $this->session->data['error'] = $result['error']."<br />";
                    }
                }

                if (isset($result['success'])) {
                    if (isset($this->session->data['success'])) {
                        $this->session->data['success'] .= $result['success']."<br />";
                    } else {
                        $this->session->data['success'] = $result['success']."<br />";
                    }
                }
            }

            $url = '';

            if (isset($post['filter_order_id'])) {
                $url .= '&filter_order_id='.$post['filter_order_id'];
            }

            if (isset($post['filter_name'])) {
                $url .= '&filter_name='.$post['filter_name'];
            }

            if (isset($post['filter_company'])) {
                $url .= '&filter_company='.$post['filter_company'];
            }

            if (isset($post['filter_account_status'])) {
                $url .= '&filter_account_status='.$post['filter_account_status'];
            }

            if (isset($post['filter_date_added'])) {
                $url .= '&filter_date_added='.$post['filter_date_added'];
            }

            if (isset($post['filter_total'])) {
                $url .= '&filter_total='.$post['filter_total'];
            }

            if (isset($post['filter_emailed'])) {
                $url .= '&filter_emailed='.$post['filter_emailed'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page='.$this->request->get['page'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort='.$this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order='.$this->request->get['order'];
            }

            redirect($this->html->getSecureURL('sale/incomplete_order', $url));
        }

        $this->getList();
    }

    public function cancel_selected() {
        $this->loadLanguage('incomplete_order/incomplete_order');
        $this->document->setTitle($this->language->get('incomplete_order_name'));
        $this->load->model('sale/incomplete_order');

        if (isset($this->request->post['selected']) && ($this->_validateModify())) {
            foreach ($this->request->post['selected'] as $order_id) {
                $result = $this->model_sale_incomplete_order->cancelSingleOrder($order_id);

                if (isset($result['error'])) {
                    if (isset($this->session->data['error'])) {
                        $this->session->data['error'] .= $result['error']."<br />";
                    } else {
                        $this->session->data['error'] = $result['error']."<br />";
                    }
                }

                if (isset($result['success'])) {
                    if (isset($this->session->data['success'])) {
                        $this->session->data['success'] .= $result['success']."<br />";
                    } else {
                        $this->session->data['success'] = $result['success']."<br />";
                    }
                }
            }

            $url = '';

            if (isset($post['filter_order_id'])) {
                $url .= '&filter_order_id='.$post['filter_order_id'];
            }

            if (isset($post['filter_name'])) {
                $url .= '&filter_name='.$post['filter_name'];
            }

            if (isset($post['filter_company'])) {
                $url .= '&filter_company='.$post['filter_company'];
            }

            if (isset($post['filter_account_status'])) {
                $url .= '&filter_account_status='.$post['filter_account_status'];
            }

            if (isset($post['filter_date_added'])) {
                $url .= '&filter_date_added='.$post['filter_date_added'];
            }

            if (isset($post['filter_total'])) {
                $url .= '&filter_total='.$post['filter_total'];
            }

            if (isset($post['filter_emailed'])) {
                $url .= '&filter_emailed='.$post['filter_emailed'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page='.$this->request->get['page'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort='.$this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order='.$this->request->get['order'];
            }

            redirect($this->html->getSecureURL('sale/incomplete_order', $url));
        }

        $this->getList();
    }

    public function email_auto() {
        $this->loadLanguage('incomplete_order/incomplete_order');

        $this->document->setTitle($this->language->get('incomplete_order_name'));

        $this->load->model('sale/incomplete_order');

        if ($this->_validateModify()) {
            $date_range = $this->request->post['email_date_range'];
            $ranges = $this->getDateRanges();

            if (!isset($ranges[$date_range])) {
                $this->session->data['error'] = $this->language->get('error_date_range');
            } else {
                $range = $ranges[$date_range];

                $data = [
                    'filter_date_range' => $range['mysql'],
                    'filter_emailed'    => 0,
                    'start'             => 0,
                    'sort'              => 'o.order_id',
                    'order'             => 'DESC', // choose most recent order first
                    'limit'             => 0,
                ];

                $orders = $this->model_sale_incomplete_order->getOrders($data);
                foreach ($orders as $order) {
                    $result = $this->_sendEmail($order['order_id'], $this->request->post['dryrun']);
                    if (isset($result['error'])) {
                        if (isset($this->session->data['error'])) {
                            $this->session->data['error'] .= $result['error']."<br />";
                        } else {
                            $this->session->data['error'] = $result['error']."<br />";
                        }
                    }

                    if (isset($result['success'])) {
                        if (isset($this->session->data['success'])) {
                            $this->session->data['success'] .= $result['success']."<br />";
                        } else {
                            $this->session->data['success'] = $result['success']."<br />";
                        }
                    }
                }

                if ($this->request->post['dryrun'] && isset($this->session->data['temporary_incomplete_order_ids'])) {
                    foreach ($this->session->data['temporary_incomplete_order_ids'] as $temp_order_id) {
                        $this->model_sale_incomplete_order->removeHistory($temp_order_id);
                    }
                    unset($this->session->data['temporary_incomplete_order_ids']);
                }

                if ($this->request->post['dryrun']) {
                    $this->session->data['dryrun'] = $this->language->get('text_dryrun');
                }

                if (!isset($this->session->data['error']) && !isset($this->session->data['success'])) {
                    $this->session->data['error'] = $this->language->get('error_no_matching_orders');
                }
            }

            $url = '';

            if (isset($this->request->get['filter_order_id'])) {
                $url .= '&filter_order_id='.$this->request->get['filter_order_id'];
            }

            if (isset($this->request->get['filter_name'])) {
                $url .= '&filter_name='.$this->request->get['filter_name'];
            }

            if (isset($this->request->get['filter_company'])) {
                $url .= '&filter_company='.$this->request->get['filter_company'];
            }

            if (isset($this->request->get['filter_account_status'])) {
                $url .= '&filter_account_status='.$this->request->get['filter_account_status'];
            }

            if (isset($this->request->get['filter_date_added'])) {
                $url .= '&filter_date_added='.$this->request->get['filter_date_added'];
            }

            if (isset($this->request->get['filter_total'])) {
                $url .= '&filter_total='.$this->request->get['filter_total'];
            }

            if (isset($this->request->get['filter_emailed'])) {
                $url .= '&filter_emailed='.$this->request->get['filter_emailed'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page='.$this->request->get['page'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort='.$this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order='.$this->request->get['order'];
            }
            if (!$this->request->post['dryrun']) {
                redirect($this->html->getSecureURL('sale/incomplete_order', $url));
            }
        }

        $this->getList();
    }

    protected function getDateRanges() {
        $ranges = [
            'lastweek'  => [
                'mysql' => '7 DAY',
                'name'  => $this->language->get('entry_last_week'),
            ],
            'lastmonth' => [
                'mysql' => '1 MONTH',
                'name'  => $this->language->get('entry_last_month'),
            ],
            'lastyear'  => [
                'mysql' => '1 YEAR',
                'name'  => $this->language->get('entry_last_year'),
            ],
        ];

        return $ranges;
    }

    protected function _validateModify() {
        if (!$this->user->hasPermission('modify', 'sale/incomplete_order')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        $this->extensions->hk_ValidateData($this);
        return (!$this->error);
    }

    protected function _sendEmail($order_id, $testing = false) {
        $this->load->model('sale/incomplete_order');
        $order_info = $this->model_sale_incomplete_order->getOrder($order_id);

        if ($order_info) {
            // check if email has already been sent
            $result = $this->model_sale_incomplete_order->getHistory($order_id);

            if ($result) {
                return ['error' => sprintf($this->language->get('error_email_already_sent'), $order_id)];
            }

            // update history
            $this->model_sale_incomplete_order->addHistory($order_id, $testing);

            if (!$testing) {
                // prepare data
                $product_data = [];

                $products = $this->model_sale_incomplete_order->getOrderProducts($order_id);

                foreach ($products as $product) {
                    $option_data = [];

                    $options = $this->model_sale_incomplete_order->getOrderOptions(
                        $order_id,
                        $product['order_product_id']
                    );

                    foreach ($options as $option) {
                        $option_data[] = [
                            'name'  => $option['name'],
                            'value' => $option['value'],
                        ];
                    }

                    $product_data[] = [
                        'name'     => $product['name'],
                        'model'    => $product['model'],
                        'option'   => $option_data,
                        'quantity' => $product['quantity'],
                    ];
                }

                if ($this->verifyEmailEditor()) {
                    $details = $this->model_sale_incomplete_order->getDetails('incomplete_order');

                    $sender_name=$details['sender_name'] ? $details['sender_name']:$this->config->get('store_name');
                    $sender_email=$details['sender_email'] ? $details['sender_email']:$this->config->get('store_main_email');
                    $content = html_entity_decode($details['content']);
                    preg_match("^\[(.*?)\]^",html_entity_decode($content),$fields);
                    $signature=html_entity_decode($details['signature']);

                    $this->data['mail_template_data']['customer_name'] = $order_info['firstname'] . ' ' . $order_info['lastname'];
                    $this->data['mail_template_data']['store_name'] = $this->config->get('store_name');
                    $this->data['mail_template_data']['order_date'] = dateISO2Display(
                        $order_info['date_added'],
                        $this->language->get('date_format_short').' '.$this->language->get('time_format')
                    );
                    $this->data['mail_template_data']['store_url'] = '<a href="'.$order_info['store_url'].'" target="_BLANK">'.$this->config->get('store_name').'</a>';

                    $product_message = '';

                    foreach ($product_data as $product) {
                        $product_message .= $product['quantity']
                            . ' x '
                            . html_entity_decode($product['name'])
                            . ' (' . html_entity_decode($product['model']) . ')'
                            . "<b2>";

                        foreach ($product['option'] as $option) {
                            $product_message .= chr(9) . '-' . html_entity_decode($option['name'] . ' ' . $option['value']) . "<br>";
                        }
                    }

                    $this->data['mail_template_data']['products'] = $product_message;

                    $mustache = new Mustache_Engine(['escape' => function ($value) {
                        return $value;
                    }]);

                    $arAllowedPlaceholders = explode(',', $details['allowed_placeholders']);

                    foreach ($arAllowedPlaceholders as &$placeholder) {
                        $placeholder = trim($placeholder);
                    }

                    foreach ( $this->data['mail_template_data'] as $key => $val) {
                        if (in_array($key, $arAllowedPlaceholders, true)) {
                            $this->placeholders[$key] = $val;
                        }
                    }

                    $subject = $mustache->render($details['subject'], $this->placeholders);
                    $content = $mustache->render($content, $this->placeholders);
                    $content = html_entity_decode($content);

                    $notify_admin = $details['notify_admin'];
                    $logos = $this->dispatch('pages/extension/email_logo',[]);
                    $logo = $logos->dispatchGetOutput();

                    $this->data['mail_template_data']['logo']=html_entity_decode($logo);
                    $this->data['mail_template_data']['signature']=$signature;
                    $this->data['mail_template_data']['content']=$content;
                    $this->data['mail_template'] = DIR_EXT.'incomplete_order'.DIR_EXT_CORE.'lib/incomplete_order.tpl';

                    $view = new AView($this->registry, 0);
                    $view->batchAssign($this->data['mail_template_data']);
                    $html_body = $view->fetch($this->data['mail_template']);
                    $config_mail_logo = $this->config->get('config_mail_logo');
                    $config_mail_logo = !$config_mail_logo ? $this->config->get('config_logo') : $config_mail_logo;
                    $this->_send_email($order_info['email'],
                        [
                            'subject'          => $subject,
                            'sender_email'     => $sender_email,
                            'sender_name'      => $sender_name,
                            'html_body'        => $html_body,
                            'config_mail_logo' => $config_mail_logo,
                            'notify_admin'     => $notify_admin
                        ]
                    );
                } else {
                    // load customer's language
                    $this->load->model('localisation/language');
                    $language_info = $this->model_localisation_language->getLanguage($order_info['language_id']);

                    $language = new ALanguageManager($this->registry);
                    $language->language_details = $language_info;
                    $language->load($language_info['filename']);
                    $language->load('incomplete_order/incomplete_order');

                    $subject = $language->get('email_subject');
                    $message = vsprintf(
                        $language->get('email_header'),[
                        $order_info['firstname'] . ' ' . $order_info['lastname'],
                        dateISO2Display(
                            $order_info['date_added'],
                            $this->language->get('date_format_short').' '.$this->language->get('time_format')
                        )
                            ]
                    );

                    foreach ($product_data as $product) {
                        $message .= $product['quantity']
                            . 'x '
                            . html_entity_decode($product['name'])
                            . ' (' . html_entity_decode($product['model']) . ')'
                            . "\n";

                        foreach ($product['option'] as $option) {
                            $message .= chr(9) . '-' . html_entity_decode($option['name'] . ' ' . $option['value']) . "\n";
                        }
                    }

                    $message .= "\n";
                    $message .= sprintf(
                        $language->get('email_footer'), $order_info['store_name'], $order_info['store_name'],
                        $order_info['store_name'], $order_info['store_url']
                    );
                    $message = str_replace('\n', "\n", $message);

                    $mail = new AMail($this->config);

                    $mail->setTo($order_info['email']);
                    $mail->setFrom($this->config->get('store_main_email'));
                    $mail->setSender($order_info['store_name']);
                    $mail->setSubject($subject);
                    $mail->setText($message);
                    $mail->send();
                }
            }

            return ['success' => sprintf($this->language->get('success_emailed'), $order_id)];
        }
        return ['error' => $this->language->get('text_no_results')];
    }

    protected function _send_email($email, $data) {
        $mail = new AMail($this->config);
        $mail->setTo($email);
        $mail->setFrom($data['sender_email']);
        $mail->setSender($data['sender_name']);
        $mail->setSubject($data['subject']);
        $mail->setText(html_entity_decode($data['txt_body'], ENT_QUOTES, 'UTF-8'));

        if (is_file(DIR_RESOURCE.$data['config_mail_logo'])) {
            $mail->addAttachment(DIR_RESOURCE.$data['config_mail_logo'],
                md5(pathinfo($data['config_mail_logo'], PATHINFO_FILENAME))
                .'.'.pathinfo($data['config_mail_logo'], PATHINFO_EXTENSION));
        }
        $mail->setHtml($data['html_body']);
        $mail->send();

        if ($data['notify_admin']==='1') {
            $mail = new AMail($this->config);
            if ($data['sender_email']) {
                $email_address = $data['sender_email'];
            } else {
                $email_address = $this->config->get('store_main_email');
            }
            $mail->setTo($email_address);
            $mail->setFrom($data['sender_email']);
            $mail->setSender($data['sender_name']);
            $mail->setSubject('(Copy) '.$data['subject']);
            $mail->setText(html_entity_decode($data['txt_body'], ENT_QUOTES, 'UTF-8'));

            if (is_file(DIR_RESOURCE.$data['config_mail_logo'])) {
                $mail->addAttachment(DIR_RESOURCE.$data['config_mail_logo'],
                    md5(pathinfo($data['config_mail_logo'], PATHINFO_FILENAME))
                    .'.'.pathinfo($data['config_mail_logo'], PATHINFO_EXTENSION));
            }
            $mail->setHtml($data['html_body']);
            $mail->send();
        }
    }

    protected function dispatch($dispatch_rt, $args = ['']) {
        return new ADispatcher($dispatch_rt, $args);
    }

}
