<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}


require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

$mc_server_url = "https://abantecartplus.com/clientarea/plugin/license_manager/validate/";
$diy_server_url = "https://wehearyou2.com/clientarea/plugin/license_manager/validate/";
$shared_secret = "hcaptcha_integration";

$public_key = "";
$path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";

if ($this->config->get('hcaptcha_integration_license_code')) {
    $license_key = $this->config->get('hcaptcha_integration_license_code');
    $license = new License($path_to_phpseclib);
    $license_manager = $license->getManager();
    if (stripos($license_key, 'mc-') !== false) {
        $server_url = $mc_server_url;
    } else {
        $server_url = $diy_server_url;
    }
    $license_manager->setLicenseServerUrl($server_url);
    $license_manager->setKeys($license_key, "", $shared_secret);
    $public_key = $license_manager->requestKey();
    $this->load->model('extension/hcaptcha_integration_license_info');

    $store_id = (int)$this->config->get('config_store_id');

    $license_manager->setKeys($license_key, $public_key, $shared_secret);
    $custom_data = ['version' => '1.3.4.1'];
    $license_data = $license_manager->requestData($custom_data);
    if (!is_null($license_data)) {
        $ttl = 1209600;
        $validate = $license_manager->validate($license_data, $ttl);

        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
            $data['public_key'] = $public_key;
            $data['license_data'] = $license_data;
            $data['license_key'] = $license_key;
            $data['store_id'] = $store_id;
            $data['last_check'] = time();
            $this->load->model('extension/hcaptcha_integration_license_info');
            $this->model_extension_hcaptcha_integration_license_info->saveLicenseData($data);
        }
    }
}