<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

$sql = 'CREATE TABLE IF NOT EXISTS ' . $this->db->table('email_editor_templates') . ' (
`email_template_id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
`section` VARCHAR(256) NOT NULL,
`sender_name` VARCHAR(32) NOT NULL,
`sender_email` VARCHAR(32) NOT NULL,
`subject` BLOB NOT NULL,
`default_subject` BLOB NOT NULL,
`content` BLOB NOT NULL,
`default_content` BLOB NOT NULL,
`allowed_placeholders` text COLLATE utf8_unicode_ci NOT NULL,
`email_signature_id` INT(11),
`notify_admin` INT(1) DEFAULT 0,
`store_id` INT(11)
)ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci';

$this->db->query($sql);

$sql1 = 'CREATE TABLE IF NOT EXISTS ' . $this->db->table('email_editor_signatures') . ' (
`email_signature_id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
`title` VARCHAR(256) NOT NULL,
`content` BLOB NOT NULL,
`store_id` INT(11)
)ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci';

$this->db->query($sql1);

$sql5 = "SELECT `store_id` FROM " . $this->db->table("stores");
$query5 = $this->db->query($sql5);
$results5 = $query5->rows;

foreach ($results5 as $result) {
    $store_id = $result["store_id"];

    $account_create_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_create' AND `store_id`='.$store_id'");

    if ($account_create_exist->row['total'] === '0') {
        $account_create_subject = '{{store_name}} - Thank you for registering';

        $account_create_content = 'Welcome and thank you for registering at {{store_name}}!<br><br>';
        $account_create_content .= 'Your account has now been created and you can access it by visiting our website or at the following URL: <br><br> {{login_url}} <br><br>';
        $account_create_content .= '<br>Upon logging in, you will be able to access other services including reviewing past orders, printing invoices and editing your account information.<br><br>';
        $account_create_content .= 'Thank you,';
        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
SET `section` = 'account_create', 
`sender_name`='',`sender_email`='',`subject`='" . $this->db->escape($account_create_subject) . "', 
`default_subject`='" . $this->db->escape($account_create_subject) . "',
`content` = '" . $this->db->escape($account_create_content) . "', 
`default_content` = '" . $this->db->escape($account_create_content) . "',
`allowed_placeholders`='store_name, login_url',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE  
`section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $account_activated_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_activated' AND `store_id`='.$store_id'");
    if ($account_activated_exist->row['total'] === '0') {
        $account_activated_subject = '{{store_name}} - Your Account has been activated!';
        $account_activated_content = 'Welcome and thank you for registering at {{store_name}}!<br><br>';
        $account_activated_content .= 'Your account has now been created and you can access it by visiting our website or at the following URL: <br><br> {{login_url}} <br><br>';
        $account_activated_content .= '<br>Upon logging in, you will be able to access other services including reviewing past orders, printing invoices and editing your account information.<br><br>';
        $account_activated_content .= 'Thank you,';
        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
SET `section` = 'account_activated', 
`sender_name`='',`sender_email`='',`subject`='" . $this->db->escape($account_activated_subject) . "', 
`default_subject`='" . $this->db->escape($account_activated_subject) . "',
`content` = '" . $this->db->escape($account_activated_content) . "', 
`default_content` = '" . $this->db->escape($account_activated_content) . "',
`allowed_placeholders`='store_name, login_url',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE  
`section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $account_approval_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_approval' AND `store_id`='.$store_id'");
    if ($account_approval_exist->row['total'] === '0') {
        $account_approval_subject = '{{store_name}} - Thank you for registering';
        $account_approval_content = 'Welcome and thank you for registering at {{store_name}}!<br><br>';
        $account_approval_content .= 'Your account must be approved before you can login. Once approved you can log in by using your email address and password by visiting our website or at the following URL: <br><br> {{login_url}} <br><br>';
        $account_approval_content .= 'Thank you,';
        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
SET `section` = 'account_approval', 
`sender_name`='',`sender_email`='',`subject`='" . $this->db->escape($account_approval_subject) . "', 
`default_subject`='" . $this->db->escape($account_approval_subject) . "',
`content` = '" . $this->db->escape($account_approval_content) . "', 
`default_content` = '" . $this->db->escape($account_approval_content) . "',
`allowed_placeholders`='store_name, login_url',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $account_activation_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_activation' AND `store_id`='.$store_id'");
    if ($account_activation_exist->row['total'] === '0') {
        $account_activation_subject = '{{store_name}} - Thank you for registering';
        $account_activation_content = 'Welcome and thank you for registering at {{store_name}}!<br><br>';
        $account_activation_content .= 'Before we can activate your account one last step must be taken to complete your registration.<br><br>
    You must complete this last step to become a registered member. Please click the following link to activate your account <br><br> {{activate_url}} <br><br>';
        $account_activation_content .= 'Thank you,<br>{{store_name}}';
        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`sender_name`='',`sender_email`='',`section` = 'account_activation', 
`subject`='" . $this->db->escape($account_activation_subject) . "', 
`default_subject`='" . $this->db->escape($account_activation_subject) . "' , 
`content` = '" . $this->db->escape($account_activation_content) . "', 
`default_content` = '" . $this->db->escape($account_activation_content) . "',
`allowed_placeholders`='store_name, activate_url',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $account_reset_password_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_reset_password' AND `store_id`='.$store_id'");
    if ($account_reset_password_exist->row['total'] === '0') {
        $account_reset_password_subject = '{{store_name}} - Password reset';
        $account_reset_password_content = 'A password reset was requested from {{store_name}}.<br><br>';
        $account_reset_password_content .= 'To reset your password click link below:<br><br>{{reset_password}}';
        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`section` = 'account_reset_password', 
`sender_name`='',`sender_email`='',`subject`='" . $this->db->escape($account_reset_password_subject) . "', 
`default_subject`='" . $this->db->escape($account_reset_password_subject) . "' ,
`content` = '" . $this->db->escape($account_reset_password_content) . "', 
`default_content` = '" . $this->db->escape($account_reset_password_content) . "',
`allowed_placeholders`='store_name, reset_password',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $account_reset_password_success_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_reset_password_success' AND `store_id`='.$store_id'");
    if ($account_reset_password_success_exist->row['total'] === '0') {
        $account_reset_password_success_subject = '{{store_name}} - Password reset';
        $account_reset_password_success_content = 'Your password was successfully reset on {{store_name}}.';
        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`section` = 'account_reset_password_success', 
`sender_name`='',`sender_email`='',`subject`='" . $this->db->escape($account_reset_password_success_subject) . "', 
`default_subject`='" . $this->db->escape($account_reset_password_success_subject) . "' , 
`content` = '" . $this->db->escape($account_reset_password_success_content) . "', 
`default_content` = '" . $this->db->escape($account_reset_password_success_content) . "',
`allowed_placeholders`='store_name',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $account_loginname_reminder_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_loginname_reminder' AND `store_id`='.$store_id'");
    if ($account_loginname_reminder_exist->row['total'] === '0') {
        $account_loginname_reminder_subject = '{{store_name}} - Login name reminder';
        $account_loginname_reminder_content = 'Login name reminder was requested from {{store_name}}.<br><br>';
        $account_loginname_reminder_content .= 'Your login name is: <br><br>{{loginname}}';
        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET `section` = 'account_loginname_reminder', 
`sender_name`='',`sender_email`='',`subject`='" . $this->db->escape($account_loginname_reminder_subject) . "',
 `default_subject`='" . $this->db->escape($account_loginname_reminder_subject) . "' , 
 `content` = '" . $this->db->escape($account_loginname_reminder_content) . "',
 `default_content` = '" . $this->db->escape($account_loginname_reminder_content) . "',
 `allowed_placeholders`='store_name, loginname',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
 ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $order_status_update_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='order_status_update' AND `store_id`='.$store_id'");
    if ($order_status_update_exist->row['total'] === '0') {
        $order_status_update_subject = '{{store_name}} - Order Update {{order_id}}';
        $order_status_update_content = 'Order ID: {{order_id}}<br>';
        $order_status_update_content .= 'Date Ordered: {{order_date}} <br><br>';
        $order_status_update_content .= 'Company: {{company}} <br><br>';
        $order_status_update_content .= 'Name: {{firstname}} {{lastname}} <br><br>';
        $order_status_update_content .= 'Date Ordered: {{order_date}} <br><br>';
        $order_status_update_content .= 'Your order has been updated to the following status:<br><br>';
        $order_status_update_content .= '{{order_status}}<br><br>';
        $order_status_update_content .= 'To view your order click on the link below:<br><br>{{invoice_url}}<br><br>';
        if (file_exists(DIR_EXT . 'delivery_scheduler') && $this->config->get('delivery_scheduler_status') === '1') {
            $order_status_update_content .= '[The comments or special delivery instruction for your order are:]<br><br>{{order_comment}}<br><br>';
        } else {
            $order_status_update_content .= '[The comments for your order are:]<br><br>{{order_comment}}<br><br>';
        }
        $order_status_update_content .= 'Please reply to this email if you have any questions.';
        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`section` = 'order_status_update', 
`sender_name`='',`sender_email`='',`subject`='" . $this->db->escape($order_status_update_subject) . "', 
`default_subject`='" . $this->db->escape($order_status_update_subject) . "' , 
`content` = '" . $this->db->escape($order_status_update_content) . "', 
`default_content` = '" . $this->db->escape($order_status_update_content) . "',
`allowed_placeholders`='order_id, order_date, order_status, invoice_url, order_comment, company, firstname, lastname',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $order_confirmation_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='order_confirmation' AND `store_id`='.$store_id'");
    if ($order_confirmation_exist->row['total'] === '0') {
        $order_confirmation_subject = '{{store_name}} - Order {{order_id}}';
        $order_confirmation_content = 'Thank you for your interest in {{store_name}} products.<br><br>Your order has been received and will be processed after payment is confirmed.<br><br>';

        if (file_exists(DIR_EXT . 'delivery_scheduler') && $this->config->get('delivery_scheduler_status') === '1') {
            $order_confirmation_content .= '{{order_details}}<br><br>[The comments or special delivery instructions for your order are:]<br><br>{{order_comment}}<br><br>[To view your order click on the link below:]<br><br>{{invoice_url}}<br><br>Please reply to this email if you have any questions.';
        } else {
            $order_confirmation_content .= '{{order_details}}<br><br>[The comments for your order are:]<br><br>{{order_comment}}<br><br>[To view your order click on the link below:]<br><br>{{invoice_url}}<br><br>Please reply to this email if you have any questions.';
        }

        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`section` = 'order_confirmation', 
`sender_name`='',`sender_email`='',`subject`='" . $this->db->escape($order_confirmation_subject) . "', 
`default_subject`='" . $this->db->escape($order_confirmation_subject) . "' , 
`content` = '" . $this->db->escape($order_confirmation_content) . "', 
`default_content` = '" . $this->db->escape($order_confirmation_content) . "',
`allowed_placeholders`='store_name, order_id, invoice_url, order_details, order_comment',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $customer_transaction_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='customer_transaction' AND `store_id`='.$store_id'");
    if ($customer_transaction_exist->row['total'] === '0') {
        $customer_transaction_subject = 'New transaction has been posted to your {{store_name}} account';
        $customer_transaction_content = 'New transaction has been posted to your {{store_name}} account in the amount of {{amount}}. For more details, login to {{store_name}} account<br><br>';
        $customer_transaction_content .= '{{transaction_url}}<br><br>{{comment}}';
        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`section` = 'customer_transaction', 
`sender_name`='',`sender_email`='',`subject`='" . $this->db->escape($customer_transaction_subject) . "', 
`default_subject`='" . $this->db->escape($customer_transaction_subject) . "' , 
`content` = '" . $this->db->escape($customer_transaction_content) . "', 
`default_content` = '" . $this->db->escape($customer_transaction_content) . "',
`allowed_placeholders`='store_name, amount, transaction_url, comment',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $shipping_info_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='shipping_info' AND `store_id`='.$store_id'");
    if ($shipping_info_exist->row['total'] === '0') {
        $shipper_info_content = 'Company: {{company}} <br>Name: {{firstname}} {{lastname}}<br>Your order has been shipped via: {{shipper_name}}.<br>The tracking number is: {{tracking_number}}.<br> You can track it via {{tracking_url}}.';
        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`section` = 'shipping_info', 
`sender_name`='',`sender_email`='',`subject`='', 
`default_subject`='' , 
`content` = '" . $this->db->escape($shipper_info_content) . "', 
`default_content` = '" . $this->db->escape($shipper_info_content) . "',
`allowed_placeholders`=' company, firstname, lastname, shipper_name, tracking_number, tracking_url',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $usps_shipping_info_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='usps_shipping_info' AND `store_id`='.$store_id'");
    if ($usps_shipping_info_exist->row['total'] === '0') {
        $usps_shipper_info_content = 'Company: {{company}} <br>Name: {{firstname}} {{lastname}}<br>Your order has been shipped via: USPS.<br>The tracking number is: {{tracking_number}}.<br> You can track it via {{tracking_url}}.<br><br>
                                  Want to know when your package will arrive?  Take more control of your delivery with USPS <a href="https://www.usps.com/manage/informed-delivery.htm" target="_blank">here</a>.';

        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`section` = 'usps_shipping_info', 
`sender_name`='',`sender_email`='',`subject`='', 
`default_subject`='' , 
`content` = '" . $this->db->escape($usps_shipper_info_content) . "', 
`default_content` = '" . $this->db->escape($usps_shipper_info_content) . "',
`allowed_placeholders`=' company, firstname, lastname, tracking_number, tracking_url',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $ups_shipping_info_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='ups_shipping_info' AND `store_id`='.$store_id'");
    if ($ups_shipping_info_exist->row['total'] === '0') {
        $ups_shipper_info_content = 'Company: {{company}} <br>Name: {{firstname}} {{lastname}}<br>Your order has been shipped via: UPS.<br>The tracking number is: {{tracking_number}}.<br> You can track it via {{tracking_url}}.<br><br>
                                  Want to know when your package will arrive?  Take more control of your delivery with UPS <a href="https://www.ups.com/us/en/track/ups-my-choice.page" target="_blank">here</a>.';

        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`section` = 'ups_shipping_info', 
`sender_name`='',`sender_email`='',`subject`='', 
`default_subject`='' , 
`content` = '" . $this->db->escape($ups_shipper_info_content) . "', 
`default_content` = '" . $this->db->escape($ups_shipper_info_content) . "',
`allowed_placeholders`=' company, firstname, lastname, tracking_number, tracking_url',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $fedex_shipping_info_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='fedex_shipping_info' AND `store_id`='.$store_id'");
    if ($fedex_shipping_info_exist->row['total'] === '0') {
        $fedex_shipper_info_content = 'Company: {{company}} <br>Name: {{firstname}} {{lastname}}<br>Your order has been shipped via: FedEx.<br>The tracking number is: {{tracking_number}}.<br> You can track it via {{tracking_url}}.<br><br>
                                  Want to know when your package will arrive?  Take more control of your delivery with FedEx <a href="https://www.fedex.com/en-us/delivery-manager.html" target="_blank">here</a>.';

        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`section` = 'fedex_shipping_info', 
`sender_name`='',`sender_email`='',`subject`='', 
`default_subject`='' , 
`content` = '" . $this->db->escape($fedex_shipper_info_content) . "', 
`default_content` = '" . $this->db->escape($fedex_shipper_info_content) . "',
`allowed_placeholders`=' company, firstname, lastname, tracking_number, tracking_url',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $auspost_shipping_info_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='auspost_shipping_info' AND `store_id`='.$store_id'");
    if ($auspost_shipping_info_exist->row['total'] === '0') {
        $auspost_shipper_info_content = 'Company: {{company}} <br>Name: {{firstname}} {{lastname}}<br>Your order has been shipped via: Australia Post.<br>The tracking number is: {{tracking_number}}.<br> You can track it via {{tracking_url}}.<br><br>
                                  Want to know when your package will arrive?  Take more control of your delivery with Australia Post <a href="https://auspost.com.au/using-our-tracking-service" target="_blank">here</a>.';

        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`section` = 'auspost_shipping_info', 
`sender_name`='',`sender_email`='',`subject`='', 
`default_subject`='' , 
`content` = '" . $this->db->escape($auspost_shipper_info_content) . "', 
`default_content` = '" . $this->db->escape($auspost_shipper_info_content) . "',
`allowed_placeholders`=' company, firstname, lastname, tracking_number, tracking_url',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $canpost_shipping_info_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='canpost_shipping_info' AND `store_id`='.$store_id'");
    if ($canpost_shipping_info_exist->row['total'] === '0') {
        $canpost_shipper_info_content = 'Company: {{company}} <br>Name: {{firstname}} {{lastname}}<br>Your order has been shipped via: Canada Post.<br>The tracking number is: {{tracking_number}}.<br> You can track it via {{tracking_url}}.<br><br>
                                  Want to know when your package will arrive?  Take more control of your delivery with Canada Post <a href="https://www.canadapost-postescanada.ca/cpc/en/personal/receiving/automatic-tracking.page" target="_blank">here</a>.';

        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`section` = 'canpost_shipping_info', 
`sender_name`='',`sender_email`='',`subject`='', 
`default_subject`='' , 
`content` = '" . $this->db->escape($canpost_shipper_info_content) . "', 
`default_content` = '" . $this->db->escape($canpost_shipper_info_content) . "',
`allowed_placeholders`=' company, firstname, lastname, tracking_number, tracking_url',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $parcelforce_shipping_info_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='parcelforce_shipping_info' AND `store_id`='.$store_id'");
    if ($parcelforce_shipping_info_exist->row['total'] === '0') {
        $parcelforce_shipper_info_content = 'Company: {{company}} <br>Name: {{firstname}} {{lastname}}<br>Your order has been shipped via: Parcel Force.<br>The tracking number is: {{tracking_number}}.<br> You can track it via {{tracking_url}}.<br><br>
                                  Want to know when your package will arrive?  Take more control of your delivery with Parcel Force <a href="https://www.parcelforce.com/track-trace" target="_blank">here</a>.';

        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`section` = 'parcelforce_shipping_info', 
`sender_name`='',`sender_email`='',`subject`='', 
`default_subject`='' , 
`content` = '" . $this->db->escape($parcelforce_shipper_info_content) . "', 
`default_content` = '" . $this->db->escape($parcelforce_shipper_info_content) . "',
`allowed_placeholders`=' company, firstname, lastname, tracking_number, tracking_url',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $royalmail_shipping_info_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='royalmail_shipping_info' AND `store_id`='.$store_id'");
    if ($royalmail_shipping_info_exist->row['total'] === '0') {
        $royalmail_shipper_info_content = 'Company: {{company}} <br>Name: {{firstname}} {{lastname}}<br>Your order has been shipped via: Royal Mail.<br>The tracking number is: {{tracking_number}}.<br> You can track it via {{tracking_url}}.<br><br>
                                  Want to know when your package will arrive?  Take more control of your delivery with Royal Mail <a href="https://www.royalmail.com/track-your-item#/" target="_blank">here</a>.';

        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`section` = 'royalmail_shipping_info', 
`sender_name`='',`sender_email`='',`subject`='', 
`default_subject`='' , 
`content` = '" . $this->db->escape($royalmail_shipper_info_content) . "', 
`default_content` = '" . $this->db->escape($royalmail_shipper_info_content) . "',
`allowed_placeholders`=' company, firstname, lastname, tracking_number, tracking_url',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $purolator_shipping_info_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='purolator_shipping_info' AND `store_id`='.$store_id'");
    if ($purolator_shipping_info_exist->row['total'] === '0') {
        $purolator_shipper_info_content = 'Company: {{company}} <br>Name: {{firstname}} {{lastname}}<br>Your order has been shipped via: Purolator.<br>The tracking number is: {{tracking_number}}.<br> You can track it via {{tracking_url}}.<br><br>
                                  Want to know when your package will arrive?  Take more control of your delivery with Purolator <a href="https://www.purolator.com/en/subscribe-purolator-your-way-sms-notifications#input-form" target="_blank">here</a>.';

        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`section` = 'purolator_shipping_info', 
`sender_name`='',`sender_email`='',`subject`='', 
`default_subject`='' , 
`content` = '" . $this->db->escape($purolator_shipper_info_content) . "', 
`default_content` = '" . $this->db->escape($purolator_shipper_info_content) . "',
`allowed_placeholders`=' company, firstname, lastname, tracking_number, tracking_url',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $rl_shipping_info_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='rl_shipping_info' AND `store_id`='.$store_id'");
    if ($rl_shipping_info_exist->row['total'] === '0') {
        $rl_shipper_info_content = 'Company: {{company}} <br>Name: {{firstname}} {{lastname}}<br>Your order has been shipped via: RL Carriers.<br>The tracking number is: {{tracking_number}}.<br> You can track it via {{tracking_url}}.<br><br>
                                  Want to know when your package will arrive?  Take more control of your delivery with RL Carriers <a href="https://www.rlcarriers.com/freight/shipping-technology/delivery-notifications" target="_blank">here</a>.';

        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`section` = 'rl_shipping_info', 
`sender_name`='',`sender_email`='',`subject`='', 
`default_subject`='' , 
`content` = '" . $this->db->escape($rl_shipper_info_content) . "', 
`default_content` = '" . $this->db->escape($rl_shipper_info_content) . "',
`allowed_placeholders`=' company, firstname, lastname, tracking_number, tracking_url',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $local_shipping_info_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='local_shipping_info' AND `store_id`='.$store_id'");
    if ($local_shipping_info_exist->row['total'] === '0') {
        $local_delivery_info_content = 'Company: {{company}} <br>Name: {{firstname}} {{lastname}}<br>Your order will be delivered on {{delivery_date}} via {{shipper_name}}.<br>';

        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`section` = 'local_shipping_info', 
`sender_name`='',`sender_email`='',`subject`='', 
`default_subject`='' , 
`content` = '" . $this->db->escape($local_delivery_info_content) . "', 
`default_content` = '" . $this->db->escape($local_delivery_info_content) . "',
`allowed_placeholders`=' company, firstname, lastname,delivery_date, shipper_name',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $this->db->query("Create table if not exists " . $this->db->table('email_editor_tmp') . " ( `id` int(2) , `title` VARCHAR(100) )ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;");

    $store_pickup_info_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='store_pickup_info' AND `store_id`='.$store_id'");
    if ($store_pickup_info_exist->row['total'] === '0') {
        $store_pickup_info_content = 'Company: {{company}} <br>Name: {{firstname}} {{lastname}}<br>Your package will be available for pickup at {{available_date}}.<br>';

        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`section` = 'store_pickup_info', 
`sender_name`='',`sender_email`='',`subject`='', 
`default_subject`='' , 
`content` = '" . $this->db->escape($store_pickup_info_content) . "', 
`default_content` = '" . $this->db->escape($store_pickup_info_content) . "',
`allowed_placeholders`=' company, firstname, lastname, available_date',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    $account_approved_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_approved' AND `store_id`='.$store_id'");
    if ($account_approved_exist->row['total'] === '0') {
        $account_approved_subject = 'Welcome, {{store_name}} ';
        $account_approved_content = 'Welcome and thank you for registering at {{store_name}}<br><br>';
        $account_approved_content .= 'Your account has now been created and you can log in by using your email address and password by visiting our website or at the following URL:<br/>
            <a href="{{login_url}}">{{login_url}}</a><br/><br/>
            Once you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.';
        $account_approved_content .= 'Thank you.<br/>{{store_name}}';
        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
`sender_name`='',`sender_email`='',`section` = 'account_approved', 
`subject`='" . $this->db->escape($account_approved_subject) . "', 
`default_subject`='" . $this->db->escape($account_approved_subject) . "' , 
`content` = '" . $this->db->escape($account_approved_content) . "', 
`default_content` = '" . $this->db->escape($account_approved_content) . "',
`allowed_placeholders`='store_name, login_url',
`email_signature_id` = 0,
`notify_admin`=0, `store_id`='" . $store_id . "'
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
    }

    if (file_exists(DIR_EXT . 'customer_group_auto_assigned') && $this->config->get('customer_group_auto_assigned_status')) {
        $sql2 = 'CREATE TABLE IF NOT EXISTS ' . $this->db->table('email_editor_customer_group') . ' (
                 `email_editor_customer_group_id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
                 `email_template_id` int(11),
                 `customer_group_id` int(11),
                 `section_name` VARCHAR(256)
                 )ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci';

        $this->db->query($sql2);
        $store_id = $result["store_id"];
        $query_customer_groups = $this->db->query("SELECT * FROM " . $this->db->table("customer_groups"));
        $customer_groups = $query_customer_groups->rows;
        foreach ($customer_groups as $cust_group) {
            $search = [" ", "'",];
            $replace = "_";
            $section = str_replace($search, $replace, strtolower($cust_group['name']));
            $account_activated_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='" . $section . "_account_create' AND `store_id`='.$store_id'");
            if ($account_activated_exist->row['total'] === '0') {
                $account_activated = $this->db->query("SELECT * FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_create'");
                $account_activated_info = $account_activated->row;
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_templates') . "  
                                  SET `section` = '" . $section . "_account_create', 
                                  `sender_name`='" . $account_activated_info['sender_name'] . "',`sender_email`='" . $account_activated_info['sender_email'] . "',`subject`='" . $account_activated_info['subject'] . "', 
                                  `default_subject`='" . $account_activated_info['default_subject'] . "',
                                  `content` = '" . $account_activated_info['content'] . "', 
                                  `default_content` = '" . $account_activated_info['default_content'] . "',
                                  `allowed_placeholders`='store_name, login_url',
                                   `email_signature_id` = '" . $account_activated_info['email_signature_id'] . "',
                                  `notify_admin`='" . $account_activated_info['notify_admin'] . "', `store_id`='" . $store_id . "'
                                  ON DUPLICATE KEY UPDATE  
                                  `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
                $account_create_email_id = $this->db->getLastId();
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=" . $account_create_email_id . ",`customer_group_id`=" . $cust_group['customer_group_id'] . ",`section_name`='" . $section . "'");
            } else {
                $this->db->query('UPDATE ' . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='store_name, login_url'" . " WHERE `section` = '" . $section . "_account_create'");
            }

            $account_approval_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='" . $section . "_account_approval' AND `store_id`='.$store_id'");
            if ($account_approval_exist->row['total'] === '0') {
                $account_approval = $this->db->query("SELECT * FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_approval'");
                $account_approval_info = $account_approval->row;
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_templates') . "  
                                  SET `section` = '" . $section . "_account_approval', 
                                  `sender_name`='" . $account_approval_info['sender_name'] . "',`sender_email`='" . $account_approval_info['sender_email'] . "',`subject`='" . $account_approval_info['subject'] . "', 
                                  `default_subject`='" . $account_approval_info['default_subject'] . "',
                                  `content` = '" . $account_approval_info['content'] . "', 
                                  `default_content` = '" . $account_approval_info['default_content'] . "',
                                  `allowed_placeholders`='store_name, login_url',
                                  `email_signature_id` = '" . $account_approval_info['email_signature_id'] . "',
                                  `notify_admin`='" . $account_approval_info['notify_admin'] . "', `store_id`='" . $store_id . "'
                                  ON DUPLICATE KEY UPDATE  
                                  `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
                $account_approval_email_id = $this->db->getLastId();
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=" . $account_approval_email_id . ",`customer_group_id`=" . $cust_group['customer_group_id'] . ",`section_name`='" . $section . "'");
            } else {
                $this->db->query('UPDATE ' . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='store_name, login_url'" . " WHERE `section` = '" . $section . "_account_approval'");
            }

            $account_activation_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='" . $section . "_account_activation' AND `store_id`='.$store_id'");
            if ($account_activation_exist->row['total'] === '0') {
                $account_activation = $this->db->query("SELECT * FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_activation'");
                $account_activation_info = $account_activation->row;
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_templates') . "  
                                  SET `section` = '" . $section . "_account_activation', 
                                  `sender_name`='" . $account_activation_info['sender_name'] . "',`sender_email`='" . $account_activation_info['sender_email'] . "',`subject`='" . $account_activation_info['subject'] . "', 
                                  `default_subject`='" . $account_activation_info['default_subject'] . "',
                                  `content` = '" . $account_activation_info['content'] . "', 
                                  `default_content` = '" . $account_activation_info['default_content'] . "',
                                  `allowed_placeholders`='store_name, activate_url',
                                  `email_signature_id` = '" . $account_activation_info['email_signature_id'] . "',
                                  `notify_admin`='" . $account_activation_info['notify_admin'] . "', `store_id`='" . $store_id . "'
                                  ON DUPLICATE KEY UPDATE  
                                  `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
                $account_activation_email_id = $this->db->getLastId();
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=" . $account_activation_email_id . ",`customer_group_id`=" . $cust_group['customer_group_id'] . ",`section_name`='" . $section . "'");
            } else {
                $this->db->query('UPDATE ' . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='store_name, activate_url'" . " WHERE `section` = '" . $section . "_account_activation'");
            }

            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_create_info'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_create_subject'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_create_content'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_activation_info'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_activation_subject'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_activation_content'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_approval_info'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_approval_subject'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_approval_content'");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_create_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {{store_name}}, {{login_url}}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_create_subject','Account Create Email Subject:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_create_content','Account Create Email Content:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_activation_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {{store_name}}, {{activate_url}}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_activation_subject','Account Activation Email Subject:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_activation_content','Account Activation Email Content:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_approval_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {{store_name}}, {{login_url}}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_approval_subject','Account Needs Approval Email Subject:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_approval_content','Account Needs Approval Email Content:',now(),now())");
        }
        $query_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='expired_tax_exempt_certificate'");
        $exist = $query_exist->row['total'];
        if ($exist === '0') {
            $expired_tax_exempt_certificate_subject = 'Your Tax Exempt Certificate Is Expired';

            $expired_tax_exempt_certificate_content = 'Dear {{customer_name}},<br>We noticed that your tax exempt certificate has expired or is about to expire on: {{expired_at}}. You can update it by uploading the current tax exempt certificate via your edit account {{edit_account_url}}.<br>';
            $expired_tax_exempt_certificate_content .= 'If you want us to upload the certificate for you simply reply to this e-mail and provide us your name along with the updated tax exempt certificate file.<br><br>';
            $expired_tax_exempt_certificate_content .= 'Sincerely, {{store_url}}';

            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
                              SET `section` = 'expired_tax_exempt_certificate', 
                              `sender_name`='',`sender_email`='',`subject`='" . $this->db->escape($expired_tax_exempt_certificate_subject) . "', 
                              `default_subject`='" . $this->db->escape($expired_tax_exempt_certificate_subject) . "',
                              `content` = '" . $this->db->escape($expired_tax_exempt_certificate_content) . "', 
                              `default_content` = '" . $this->db->escape($expired_tax_exempt_certificate_content) . "',
                              `allowed_placeholders`='customer_name, expired_at, edit_account_url, store_url',
                              `email_signature_id` = 0,
                              `notify_admin`=0, `store_id`='" . $store_id . "'
                              ON DUPLICATE KEY UPDATE  
                              `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_expired_tax_exempt_certificate_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {{customer_name}}, {{expired_at}}, {{edit_account_url}}, {{store_url}}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_expired_tax_exempt_certificate_subject','Expired Tax Exempt Email Subject:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_expired_tax_exempt_certificate_content','Expired Tax Exempt Email Content:',now(),now())");
        }
    }
}


if (file_exists(DIR_EXT.'incomplete_order')) {
    $sql1 = "SELECT `store_id` FROM " . $this->db->table("stores");
    $query1 = $this->db->query($sql1);
    $results1 = $query1->rows;
    foreach ($results1 as $result) {
        $store_id = $result["store_id"];
        $query_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='incomplete_order'");
        $exist = $query_exist->row['total'];
        if ($exist === '0') {
            $incomplete_order_subject = 'Your feedback would be greatly appreciated';

            $incomplete_order_content = 'Dear {{customer_name}},<br>We noticed that during a visit to our store you placed the following item(s) in your shopping cart and proceeded through checkout, but did not complete the transaction.<br><br>';
            $incomplete_order_content .= 'Order Date: {{order_date}}<br><br>';
            $incomplete_order_content .= ' Shopping Cart Contents:<br>{{products}}<br><br>';
            $incomplete_order_content .= 'We are always interested in knowing what happened and if there was a reason that you decided not to purchase at this time. If you could be so kind as to let us know if you had any issues or concerns, we would appreciate it. We are asking for feedback from you and others as to how we can help make your experience at {{store_name}} better. Simply reply to this e-mail with your issue, concern or comment.<br><br>Again, thank you for your time and consideration in helping us improve the {{store_name}} website.<br>Sincerely, {{store_url}}';

            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
                              SET `section` = 'incomplete_order', 
                              `sender_name`='',`sender_email`='',`subject`='" . $this->db->escape($incomplete_order_subject) . "', 
                              `default_subject`='" . $this->db->escape($incomplete_order_subject) . "',
                              `content` = '" . $this->db->escape($incomplete_order_content) . "', 
                              `default_content` = '" . $this->db->escape($incomplete_order_content) . "',
                              `allowed_placeholders`='customer_name, order_date, products, store_name, store_url',
                              `email_signature_id` = 0,
                              `notify_admin`=0, `store_id`='" . $store_id . "'
                              ON DUPLICATE KEY UPDATE  
                              `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_incomplete_order_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {{customer_name}}, {{products}}, {{store_name}}, {{store_url}}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_incomplete_order_subject','Incomplete Order Email Subject:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_incomplete_order_content','Incomplete Order Email Content:',now(),now())");
        }
    }
}

if (file_exists(DIR_EXT . 'return_authorization')) {
    $query_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='return_authorization'");
    $exist = $query_exist->row['total'];
    if ($exist === '0') {
        $return_authorization_subject = '{{return_status_subject}} ';
        $return_authorization_content = 'Order ID: {{order_id}}<br>';
        $return_authorization_content .= 'Order Date {{order_date}}<br>';
        $return_authorization_content .= 'Return Code: {{return_code}}<br>';
        $return_authorization_content .= 'Return Request Status: {{return_status}} <br>';
        $return_authorization_content .= 'Return Requested Date: {{request_date}} <br>';
        $return_authorization_content .= 'Return Request URL: {{return_url}}<br><br>';
        $return_authorization_content .= 'Comment:<br> {{comment}}<br><br>';
        $return_authorization_content .= 'If reporting damage please keep all original packaging until claim is completed.';

        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
                         `sender_name`='',`sender_email`='',`section` = 'return_authorization', 
                         `subject`='" . $this->db->escape($return_authorization_subject) . "', 
                         `default_subject`='" . $this->db->escape($return_authorization_subject) . "' , 
                         `content` = '" . $this->db->escape($return_authorization_content) . "', 
                         `default_content` = '" . $this->db->escape($return_authorization_content) . "',
                         `allowed_placeholders`='return_status_subject, order_id, order_date, return_code, return_status, request_date, return_url, comment',
                         `email_signature_id` = 0,
                         `notify_admin`=0, `store_id`='0'
                         ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_return_authorization_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {{return_status_subject}}, {{order_id}}, {{order_date}}, {{return_code}}, {{return_status}}, {{request_date}}, {{return_url}}, {{comment}}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_return_authorization_subject','Return Authorization Email Subject:',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_return_authorization_content','Return Authorization Email Content:',now(),now())");
    }
}

$this->db->query("Create table if not exists " . $this->db->table('email_editor_tmp') . " ( `id` int(2) , `title` VARCHAR(100) )ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;");

$rm = new AResourceManager();
$rm->setType('image');

$language_id = $this->language->getLanguageID();
$data = [];
$data['resource_code'] = '<i class="fa fa-envelope"></i>&nbsp;';
$data['name'] = [$language_id => 'Menu Icon Email Editor'];
$data['title'] = [$language_id => ''];
$data['description'] = [$language_id => ''];
$resource_id = $rm->addResource($data);

$this->db->query("DELETE FROM " . $this->db->table('email_editor_tmp'));

$sql = 'Insert into ' . $this->db->table('email_editor_tmp') . ' ( `id`, `title` ) value ( "' . $resource_id . '" , "' . "email_templates" . '");';

$this->db->query($sql);

$sql1 = "CREATE TABLE IF NOT EXISTS " . $this->db->table("email_editor_updater_notification") . "(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL,
  `cart_version` VARCHAR(10),
  `extension_version` VARCHAR(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql1);

$sql2 = "CREATE TABLE IF NOT EXISTS " . $this->db->table("email_editor_license_info") . "(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `public_key` TEXT NOT NULL,
  `license_data` TEXT NOT NULL,
  `license_key` TEXT NOT NULL,
  `store_id` int(11) NOT NULL,
  `last_check` int(11),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql2);

$menu = new AMenu ("admin");
$menu->insertMenuItem(array("item_id" => "email_editor",
        "parent_id" => "",
        "item_text" => "Email Editor",
        "item_url" => "",
        "item_type" => "core",
        "sort_order" => "10",
        "item_icon_rl_id" => $resource_id
    )
);

$menu->insertMenuItem(array("item_id" => "email_editor_templates",
        "parent_id" => "email_editor",
        "item_text" => "Email Editor Templates",
        "item_url" => "extension/email_templates",
        "item_type" => "core",
        "sort_order" => "10",
        "item_icon_rl_id" => $resource_id
    )
);

$menu->insertMenuItem(array("item_id" => "email_editor_signatures",
        "parent_id" => "email_editor",
        "item_text" => "Email Editor Signature",
        "item_url" => "extension/email_signatures",
        "item_type" => "core",
        "sort_order" => "11",
        "item_icon_rl_id" => $resource_id
    )
);

$menu->deleteMenuItem("shipper_tracking_url");

$this->db->query("DELETE FROM " . $this->db->table('order_data_types') . " WHERE `name`='tracking'");

$this->db->query("INSERT INTO " . $this->db->table('order_data_types') . " (`language_id`, `name`) VALUES ('1', 'tracking')");

$this->db->query("DROP TABLE IF EXISTS " . $this->db->table('shipper_tracking_url'));

$sql4 = 'CREATE TABLE IF NOT EXISTS ' . $this->db->table('shipper_tracking_url') . ' (
`shipper_tracking_url_id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
`shipper_name` VARCHAR(256) NOT NULL,
`tracking_url` VARCHAR(256) NOT NULL
)ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci';

$this->db->query($sql4);

$this->db->query("INSERT INTO " . $this->db->table('shipper_tracking_url') . " (`shipper_name`,`tracking_url`) VALUES 
('Australia Post','https://auspost.com.au/mypost/track/#/details/{tracking_number}'),
('Canada Post','https://www.canadapost.ca/trackweb/en#/details/{tracking_number}'),
('FedEx','https://www.fedex.com/apps/fedextrack/?action=track&trackingnumber={tracking_number}'),
('Purolator','https://www.purolator.com/en/shipping/tracker?pins={tracking_number}'),
('Parcel Force','https://www.parcelforce.com/track-trace?trackNumber={tracking_number}'),
('Royal Mail','http://www.royalmail.com/portal/rm/track?trackNumber={tracking_number}'),
('UPS','https://wwwapps.ups.com/tracking/tracking.cgi?tracknum={tracking_number}'),
('USPS','https://tools.usps.com/go/TrackConfirmAction?tLabels={tracking_number}'),
('R+L Carriers','https://m.rlcarriers.com/ShipmentTracing/?rstn={tracking_number}'),
('Store Pickup',''),
('Local Delivery','')");

if (!file_exists(DIR_SYSTEM . 'lib/license.php')) {
    /**
     *  Function to Copy folders and files
     * @param $src
     * @param $dst
     * @return array
     */
    function custom_copy($src, $dst)
    {
        $error = [];
        // open the source directory
        $dir = opendir($src);
        if (!is_dir($dst)) {
            @mkdir($dst);
        }
        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    // Recursively calling custom copy function
                    // for sub directory
                    custom_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    if (!copy($src . '/' . $file, $dst . '/' . $file)) {
                        $error['error_copy'][] = "Failed to copy $file";
                    }
                }
            }
        }
        if (sizeof($error) > 0) {
            $log = new ALog(DIR_SYSTEM . 'logs/error.txt');
            $log->write(var_export($error, true));
        }
        closedir($dir);
        return $error;
    }

    $copy = custom_copy(DIR_EXT . 'email_editor' . DIR_EXT_CORE . 'lib/license', DIR_SYSTEM . 'lib');
}