<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}
class ModelExtensionEmailTemplates extends Model {

    public function getTemplates() {
        $store_id = $this->getStoreId();
        $sql = "SELECT * FROM " . $this->db->table('email_editor_templates')." WHERE `store_id`=".$store_id;
        $result = $this->db->query($sql);
        return $result->rows;
    }

    /**
     * @param $filter
     * @param string $mode
     * @return array
     */
    public function getAllTemplates($filter, $mode = '') {
        $store_id = $this->getStoreId();
        if ($mode == 'total_only') {
            $sql = "SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates')." WHERE `store_id`=".$store_id;
        } else {
            $sql = "SELECT * FROM " . $this->db->table('email_editor_templates'). " WHERE `store_id`=".$store_id." ORDER BY email_template_id ASC";
        }

        if (isset($filter['start']) || isset($filter['limit'])) {
            if ($filter['start'] < 0) {
                $filter['start'] = 0;
            }
            if ($filter['limit'] < 1) {
                $filter['limit'] = 20;
            }
            $sql .= $mode != 'total_only' ? " LIMIT " . (int)$filter['start'] . "," . (int)$filter['limit'] : '';
        }
        $result = $this->db->query($sql);
        $output = [];
        if ($mode == 'total_only') {
            $output = $result->row['total'];
        } else {
            foreach ($result->rows as $row) {
                if ($row['section']) {
                    $output[] = $row;
                } else {
                    $output[] = $this->getTemplate($row['email_template_id']);
                }
            }
        }
        return $output;
    }

    /**
     * @param $template_id
     * @param null $reset
     * @return mixed
     */
    public function getTemplate($template_id,$reset=Null) {
        $store_id = $this->getStoreId();
        $template_id = (int)$template_id;

        if ($reset===true) {
            $reset="UPDATE " . $this->db->table('email_editor_templates') . " SET subject=default_subject,content=default_content WHERE email_template_id=" . (int)$template_id." AND `store_id`=".$store_id;
            $this->db->query($reset);
        }

        $sql = "SELECT * FROM " . $this->db->table('email_editor_templates'). " WHERE email_template_id=" . (int)$template_id." AND `store_id`=".$store_id;
        $result = $this->db->query($sql);
        return $result->row;
    }

    public function updateTemplate($template_id,$data) {
        $store_id = $this->getStoreId();
        $fields=[
            'sender_name',
            'sender_email',
            'subject',
            'content',
            'allowed_placeholders',
            'email_signature_id',
            'notify_admin'
        ];

        $update=[];
        foreach ($fields as $f) {
            if (isset($data['email_signature']) && $f==='email_signature_id') {
                $update[] = "$f = '" . $this->db->escape($data['email_signature']) . "'";
            } elseif (isset($data[$f])) {
                $update[] = "$f = '" . $this->db->escape($data[$f]) . "'";
            }
        }

        if (!empty($update)) {
            return $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . " SET " . implode(',', $update) . " WHERE email_template_id = '" . (int)$template_id . "' AND `store_id`=".$store_id);
        }
    }

    public function getEmailTemplateId($section) {
        $store_id = $this->getStoreId();
        $query = $this->db->query("SELECT `email_template_id`,`email_signature_id` FROM ".$this->db->table('email_editor_templates')." WHERE `section`='".$section."' AND `store_id`=".$store_id);
        return $query->row;
    }

    public function updateEmailTemplateSection($data) {
        $store_id = $this->getStoreId();
        $query_existing_section_name = $this->db->query("SELECT `section_name` FROM ".$this->db->table('email_editor_customer_group')." WHERE `customer_group_id`=".$data['customer_group_id']);
        $existing_section_name = $query_existing_section_name->row['section_name'];
        $this->db->query("UPDATE ".$this->db->table('email_editor_templates')." SET `section`=REPLACE(`section`,'".$existing_section_name."','".$data['section_name']."') WHERE `store_id`=".$store_id);
        $this->db->query("UPDATE ".$this->db->table('email_editor_customer_group')." SET `section_name`='".$data['section_name']."' WHERE `customer_group_id`=".$data['customer_group_id']);

        $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $existing_section_name . "_account_create_info'");
        $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $existing_section_name . "_account_create_subject'");
        $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $existing_section_name . "_account_create_content'");
        $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $existing_section_name . "_account_activation_info'");
        $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $existing_section_name . "_account_activation_subject'");
        $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $existing_section_name . "_account_activation_content'");
        $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $existing_section_name . "_account_approval_info'");
        $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $existing_section_name . "_account_approval_subject'");
        $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $existing_section_name . "_account_approval_content'");

         $search = [" ","'",];
        $replace = "_";
        $new_section_name = str_replace($search,$replace,strtolower($data['section_name']));

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $new_section_name . "_account_create_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {login_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $new_section_name . "_account_create_subject','Account Create Email Subject:',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $new_section_name . "_account_create_content','Account Create Email Content:',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $new_section_name . "_account_activation_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {activate_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $new_section_name . "_account_activation_subject','Account Activation Email Subject:',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $new_section_name . "_account_activation_content','Account Activation Email Content:',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $new_section_name . "_account_approval_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {login_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $new_section_name . "_account_approval_subject','Account Needs Approval Email Subject:',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $new_section_name . "_account_approval_content','Account Needs Approval Email Content:',now(),now())");
        $this->cache->remove('localization');
    }

    public function copyEmailTemplate($store_id) {
        $email_templates = $this->db->query("SELECT * FROM " . $this->db->table("email_editor_templates") . " WHERE `store_id`=0");
        $templates = $email_templates->rows;
        foreach ($templates as $template){
            $this->db->query("INSERT INTO " . $this->db->table('email_editor_templates') . "  (`sender_name`, `sender_email`, `section`, `subject`, `default_subject`, `content`, `default_content`,`email_signature_id`,`notify_admin`,`store_id`)
                             VALUES ('".$template['sender_name']."','".$template['sender_email']."','".$template['section']."','".$template['subject']."','".$template['default_subject']."','".$template['content']."', 
                             '".$template['default_content']."','".$template['email_signature_id']."','".$template['notify_admin']."','".$store_id."')");
        }
    }

    public function deleteEmailTemplateByStoreId($store_id) {
        $this->db->query("DELETE FROM " . $this->db->table("email_editor_templates") . " WHERE `store_id`=".$store_id);
    }

    public function createEmailTemplate($data) {
        $store_id = $this->getStoreId();
        $search = [" ","'",];
        $replace = "_";
        $section = str_replace($search,$replace,strtolower($data['name']));

        $account_activated_exist = $this->db->query("SELECT COUNT(*) as total FROM ".$this->db->table('email_editor_templates')." WHERE `section`='".$section."_account_create'");
        if ($account_activated_exist->row['total']==='0') {
            $account_activated = $this->db->query("SELECT * FROM ".$this->db->table('email_editor_templates')." WHERE `section`='account_create'");
            $account_activated_info = $account_activated->row;
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
                          SET `section` = '".$section."_account_create', 
                          `sender_name`='".$account_activated_info['sender_name']."',`sender_email`='".$account_activated_info['sender_email']."',`subject`='".$account_activated_info['subject']."', 
                          `default_subject`='".$account_activated_info['default_subject']."',
                          `content` = '".$account_activated_info['content']."', 
                          `default_content` = '".$account_activated_info['default_content']."',
                          `allowed_placeholders` = '".$account_activated_info['allowed_placeholders']."',
                          `email_signature_id` = '".$account_activated_info['email_signature_id']."',
                          `notify_admin`='".$account_activated_info['notify_admin']."',`store_id`='".$store_id."'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
            $account_activated_email_id = $this->db->getLastId();
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=".$account_activated_email_id.",`customer_group_id`=".$data['customer_group_id'].",`section_name`='".$section."'");
        }

        $account_approval_exist = $this->db->query("SELECT COUNT(*) as total FROM ".$this->db->table('email_editor_templates')." WHERE `section`='".$section."_account_approval'");
        if ($account_approval_exist->row['total']==='0') {
            $account_approval = $this->db->query("SELECT * FROM ".$this->db->table('email_editor_templates')." WHERE `section`='account_approval'");
            $account_approval_info = $account_approval->row;
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
                          SET `section` = '".$section."_account_approval', 
                          `sender_name`='".$account_approval_info['sender_name']."',`sender_email`='".$account_approval_info['sender_email']."',`subject`='".$account_approval_info['subject']."', 
                          `default_subject`='".$account_approval_info['default_subject']."',
                          `content` = '".$account_approval_info['content']."', 
                          `default_content` = '".$account_approval_info['default_content']."',
                          `allowed_placeholders` = '".$account_approval_info['allowed_placeholders']."',
                          `email_signature_id` = '".$account_approval_info['email_signature_id']."',
                          `notify_admin`='".$account_approval_info['notify_admin']."',`store_id`='".$store_id."'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
            $account_approval_email_id = $this->db->getLastId();

            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=".$account_approval_email_id.",`customer_group_id`=".$data['customer_group_id'].",`section_name`='".$section."'");
        }
        $account_activation_exist = $this->db->query("SELECT COUNT(*) as total FROM ".$this->db->table('email_editor_templates')." WHERE `section`='".$section."_account_activation'");
        if ($account_activation_exist->row['total']==='0') {

            $account_activation = $this->db->query("SELECT * FROM ".$this->db->table('email_editor_templates')." WHERE `section`='account_activation'");
            $account_activation_info = $account_activation->row;
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
                          SET `section` = '".$section."_account_activation', 
                          `sender_name`='".$account_activation_info['sender_name']."',`sender_email`='".$account_activation_info['sender_email']."',`subject`='".$account_activation_info['subject']."', 
                          `default_subject`='".$account_activation_info['default_subject']."',
                          `content` = '".$account_activation_info['content']."', 
                          `default_content` = '".$account_activation_info['default_content']."',
                          `allowed_placeholders` = '".$account_activation_info['allowed_placeholders']."',
                          `email_signature_id` = '".$account_activation_info['email_signature_id']."',
                          `notify_admin`='".$account_activation_info['notify_admin']."',`store_id`='".$store_id."'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
            $account_activation_email_id = $this->db->getLastId();

            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=".$account_activation_email_id.",`customer_group_id`=".$data['customer_group_id'].",`section_name`='".$section."'");
        }

        $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_create_info'");
        $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_create_subject'");
        $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_create_content'");
        $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_activation_info'");
        $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_activation_subject'");
        $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_activation_content'");
        $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_approval_info'");
        $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_approval_subject'");
        $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_approval_content'");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_create_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {login_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_create_subject','Account Create Email Subject:',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_create_content','Account Create Email Content:',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_activation_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {activate_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_activation_subject','Account Activation Email Subject:',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_activation_content','Account Activation Email Content:',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_approval_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {login_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_approval_subject','Account Needs Approval Email Subject:',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_approval_content','Account Needs Approval Email Content:',now(),now())");
        $this->cache->remove('localization');
    }

    public function getStoreId() {
        $store_id = (int)$this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int)$this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int)$this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
}