<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}
/**
 * Class ControllerResponsesListingGridEmailTemplatesList
 * @property ModelExtensionEmailTemplates $model_extension_email_templates
 */

class ControllerResponsesListingGridEmailTemplatesList extends AController {
    public $error = [];
    public $data = [];

    public function main() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('email_editor/email_editor');
        $this->loadModel('extension/email_templates');

        //Prepare filter config
        $filter_params = ['section'];
        $filter_grid = new AFilter(['method' => 'post',
            'grid_filter_params' => $filter_params,
            'additional_filter_string' => '']);


        $total = $this->model_extension_email_templates->getAllTemplates($filter_grid->getFilterData(),'total_only');
        $response = new stdClass();
        $response->page = $filter_grid->getParam('page');
        $response->total = $filter_grid->calcTotalPages($total);
        $response->records = $total;
        $response->userdata = new stdClass();
        $response->userdata->classes = [];
        $results = $this->model_extension_email_templates->getAllTemplates($filter_grid->getFilterData());
        $product_ids = [];
        foreach($results as $result){
            $product_ids[] = (int)$result['email_editor_id'];
        }

        $i = 0;
        foreach ($results as $result) {
            $response->rows[$i]['id'] = $result['email_template_id'];
            $response->rows[$i]['cell'] = [
                $result['email_template_id'],
                $result['section'],
            ];
            $i++;
        }

        $this->data['response'] = $response;
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
        $this->load->library('json');
        $this->response->setOutput(AJson::encode($this->data['response']));
    }

    /**
     * update only one field
     *
     * @return void
     */
    public function update_field() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        if (!$this->user->canModify('listing_grid/email_templates_list')) {
            $error = new AError('');
            return $error->toJSONResponse('NO_PERMISSIONS_402',
                [ 'error_text' => sprintf($this->language->get('error_permission_modify'), 'listing_grid/email_templates_list'),
                    'reset_value' => true
                ]);
        }

        $this->loadLanguage('extension/email_templates');
        if ($this->request->is_POST()) {
            $this->loadModel('extension/email_templates');
            foreach ($this->request->post as $field => $value) {
                $err = $this->_validateField($field, $value);
                if (!empty($err)) {
                    $error = new AError('');
                    return $error->toJSONResponse('VALIDATION_ERROR_406', ['error_text' => $err]);
                }
                if (is_array($value)) {
                    foreach ($value as $id => $val) {
                        $tmp[$field] = (int)$val;
                        $this->model_extension_email_templates->updateTemplate($id, $tmp);
                    }
                } else {
                    if ((int)$this->request->get['id']) {
                        $this->model_extension_email_templates->updateTemplate($this->request->get['id'], [$field => $value]);
                    }
                }
            }
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    private function _validateField($field, $value) {
        $this->data['error'] = '';
        switch ($field) {
            case 'subject' :
                if (empty($value)) {
                    $this->data['error'] = $this->language->get('error_subject');
                }
                break;
            case 'content' :
                if (empty($value)) {
                    $this->data['error'] = $this->language->get('error_content');
                }
                break;
        }
        $this->extensions->hk_ValidateData($this, [__FUNCTION__, $field, $value]);
        return $this->data['error'];
    }

}