<?php

/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerResponsesExtensionTracking
 * @property ModelExtensionTracking $model_extension_tracking
 * @property ModelExtensionEmailOrder $model_extension_email_order
 */

class ControllerResponsesExtensionTracking extends AController {
    public $data = [];
    public $placeholders = [];

	/**
	 * @throws AException
	 */
    public function addTracking() {
        $json = [];

        if (has_value($this->request->get['order_id'])) {
            $order = $this->request->get['order_id'];
			$trshipperid = $this->request->post['shipperId'];
            $trcode = $this->request->post['trackcode'] ? $this->request->post['trackcode'] : '';
            $trurl = $this->request->post['url'] ? $this->request->post['url']: '';
            $trdeliveryDate = $this->request->post['deliveryDate'] ? $this->request->post['deliveryDate'] : '';
            $additional = $this->request->post['additional'] ? $this->request->post['additional'] : '';
            $orderStatus = $this->request->post['orderStatus'] ? $this->request->post['orderStatus'] : '';
            $shipper = $this->request->post['name'];
            $specificTemplate = $this->request->post['spcTemplate'];

            $orderdata = $trshipperid.'|'.$trcode.'|'.$trurl.'|'.$trdeliveryDate.'|'.$additional."|".$orderStatus;

            if ($order > 0) {
                $this->loadModel('sale/order');
                $order_info = $this->model_sale_order->getOrder($order);

                $this->loadModel('extension/tracking');
	            $this->loadModel('extension/email_order');
                $this->loadLanguage('email_editor/email_editor');
                $this->model_extension_tracking->processUpdateOrderData($order, $orderdata);
	            $trcname = $this->model_extension_tracking->getShipperNameById($trshipperid);
                $this->data['mail_template_data']['company'] = $order_info['shipping_company'];
                $this->data['mail_template_data']['firstname'] = $order_info['shipping_firstname'];
                $this->data['mail_template_data']['lastname'] = $order_info['shipping_lastname'];

                if ($trcname!=='Store Pickup' && $trcname!=='Local Delivery') {
                    if ($specificTemplate === '1') {
                        $details = $this->model_extension_tracking->getSpecificTemplate($shipper);
                    } else {
                        $details = $this->model_extension_tracking->getCommentTemplate();
                    }
                    $this->data['mail_template_data']['shipper_name'] = $trcname;
                    $this->data['mail_template_data']['tracking_number'] = $trcode;
                    $this->data['mail_template_data']['tracking_url'] = "<a href='" . $trurl . "' target='_BLANK'>" . $trurl . "</a>";
                } else {
					if ($trcname==='Store Pickup') {
		                $details = $this->model_extension_tracking->getStorePickupTemplate();
					} else {
		                 $details = $this->model_extension_tracking->getLocalCommentTemplate();
					}

                    $this->data['mail_template_data']['shipper_name'] = $trcname;
                    $this->data['mail_template_data']['available_date'] = $trdeliveryDate.'.'.$additional;
                    $this->data['mail_template_data']['delivery_date'] = $trdeliveryDate.'.'.$additional;
                }

                $mustache = new Mustache_Engine(['escape' => function ($value) {
                    return $value;
                }]);

                $arAllowedPlaceholders = explode(',', $details['allowed_placeholders']);

                foreach ($arAllowedPlaceholders as &$placeholder) {
                    $placeholder = trim($placeholder);
                }

                foreach ( $this->data['mail_template_data'] as $key => $val) {
                    if (in_array($key, $arAllowedPlaceholders, true)) {
                        $this->placeholders[$key] = $val;
                    }
                }

                $comment = $mustache->render(html_entity_decode($details['content']), $this->placeholders);
                $comment = html_entity_decode($comment);

                $notifydata = [];
                $notifydata['comment'] = $comment;
                if ($this->config->get('email_editor_notify_customer')) {
                    $notifydata['notify'] = '1';
                } else {
                    $notifydata['notify'] = '0';
                }
                if ($this->config->get('email_editor_append_comments')) {
                    $notifydata['append'] = '1';
                }

                if ($trcname==='Store Pickup' || $trcname==='Local Delivery') {
                    $status['order_status_id'] = $orderStatus;
	                $notifydata['order_status_id'] = $orderStatus;
                } else {
	                $status['order_status_id'] = '3';
	                $notifydata['order_status_id'] = '3';
                }
				$this->model_sale_order->editOrder($order,$status);
                $this->model_extension_email_order->addOrderHistory($order, $notifydata);
            } else {
                // no data
                $this->session->data['error'] = $this->language->get('error_empty_data');
            }
        } else {
            // no order_id
            $this->session->data['error'] = $this->language->get('error_no_order_id');
        }

        $json['href'] = $this->html->getSecureURL('sale/order/details', '&order_id=' . (int) $this->request->get['order_id']);

        $this->load->library('json');
        $this->response->setOutput(AJson::encode($json));
    }

    public function getTrackingUrl() {
        $json = [];
        $this->load->model('extension/tracking');
        $code = $this->request->post['code'];
        $shipperId = $this->request->post['id'];
        $url = $this->model_extension_tracking->getTrackingUrlById($shipperId);
        $json['url'] = str_replace('{tracking_number}',$code,$url);
        $this->load->library('json');
        $this->response->setOutput(AJson::encode($json));
    }
}
