<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ModelSaleCustomerPreferences
 */
class ModelSaleCustomerPreferences extends Model {

    private $show_in = ['shipping', 'checkout_confirm','fast_checkout', 'invoice','confirmation_email'];

    /**
     * @param $customer_group_id
     * @param $language_id
     * @param $show_in
     * @return array
     * @throws AException
     */
    public function getPreferencesForGroup($customer_group_id, $language_id, $show_in = '') {

        if ( $show_in != '' && !in_array($show_in, $this->show_in) ) {
            return [];
        }

        $language_id = (int) $language_id;
        $language_id = $language_id ? : $this->config->get('storefront_language_id');

        $where = "gad.language_id = " . (int) $language_id . "
				AND cag.visible_by_customer = 1
				AND cag.status = 1";

        if ( $show_in != '' ) {
            $where .= " AND cag.show_" . $show_in . " = 1";
        }

        $where .= " AND cag.customer_group_id = " . (int) $customer_group_id;

        $sql = "SELECT  cag.customer_preferences_id,
                        cag.customer_group_id,
                        cag.editable_by_customer,
                        cag.visible_by_customer,
                        gad.name,
                        gad.error_text,
                        ga.element_type,
                        ga.sort_order,
                        ga.required,
                        ga.regexp_pattern,
                        ga.settings
                FROM ".$this->db->table('customer_preferences_to_groups')." cag
                INNER JOIN ".$this->db->table('customer_preferences_descriptions')." gad
                    ON cag.customer_preferences_id = gad.customer_preferences_id 
                        AND gad.language_id = ".(int) $language_id."
                INNER JOIN ".$this->db->table('customer_preferences')." ga 
                    ON cag.customer_preferences_id = ga.customer_preferences_id
               WHERE " . $where . "
                ORDER BY ga.sort_order ASC";

        $results = $this->db->query($sql);
        $output = (array) $results->rows;
        foreach ($output as &$row) {
            $row['values'] = $this->getPreferencesValues($row['customer_preferences_id'], $language_id);
            $row['selected_values'] = [];
            $row['settings'] = $row['settings'] ? unserialize($row['settings']) : [];
        }
        unset($row);
        return $output;
    }

    /**
     * @param int $customer_preferences_id
     * @param int $language_id
     *
     * @return array
     * @throws AException
     */
    private function getPreferencesValues($customer_preferences_id, $language_id = 0) {
        $customer_preferences_id = (int) $customer_preferences_id;
        if (!$customer_preferences_id) {
            return [];
        }
        $language_id = (int) $language_id;
        if (!$language_id) {
            $language_id = $this->language->getLanguageID();
        }

        $sql = "SELECT gav.customer_preferences_value_id,
                        gav.sort_order,
                        gav.default,
                        gavd.value
                FROM ".$this->db->table('customer_preferences_values_to_groups')." gav
                INNER JOIN ".$this->db->table('customer_preferences_value_descriptions_to_groups')." gavd
                    ON (gav.customer_preferences_value_id = gavd.customer_preferences_value_id
                        AND gavd.language_id = ".(int) $language_id.")
                WHERE gav.customer_preferences_id = ".$customer_preferences_id."
                ORDER BY gav.sort_order ASC";
        $results = $this->db->query($sql);
        return (array) $results->rows;
    }

    /**
     * @param int $customer_id
     * @param array $data
     *
     * @return bool
     * @throws AException
     */
    public function addPreferencesToCustomer($customer_id, $data = []) {
        if (!is_array($data) || !(int) $customer_id) {
            return false;
        }
        $this->db->query(
            "DELETE FROM " . $this->db->table('customer_preferences_values') . "
                 WHERE customer_id = '" . (int)$customer_id . "' 
                    AND  customer_preferences_id = '" . $data['customer_preferences_id'] . "';"
        );

        $this->db->query(
            "INSERT INTO " . $this->db->table('customer_preferences_values') . "
                        (customer_id, customer_preferences_id, customer_preferences_value)
                    VALUES (" . (int)$customer_id . ", " . (int)$data['customer_preferences_id'] . ", '" . addslashes($this->db->escape($data['value'])) . "');"
        );
        return true;
    }

    /**
     * @param int $customer_group_id
     *
     * @return array
     * @throws AException
     */
    public function getCustomerVisiblePreferences($customer_group_id) {
        $customer_group_id = (int) $customer_group_id;
        if (!$customer_group_id) {
            return [];
        }
        $customer_id = (int) $this->session->data['customer_id'];
        $language_id = $this->language->getLanguageID();
        $sql = "SELECT *, catg.customer_preferences_id
                FROM ".$this->db->table('customer_preferences_to_groups')." catg
                LEFT JOIN  ".$this->db->table('customer_preferences_descriptions')." cad
                    ON catg.customer_preferences_id = cad.customer_preferences_id 
                        AND cad.language_id = '".$language_id."'
                LEFT JOIN ".$this->db->table('customer_preferences')." ca 
                    ON ca.customer_preferences_id = catg.customer_preferences_id
                WHERE catg.visible_by_customer = 1 
                    AND catg.status = 1
                    AND catg.customer_group_id = ".(int) $customer_group_id."
                ORDER BY  ca.sort_order";
        $result = $this->db->query($sql);
         $attributes = [];
        foreach ($result->rows as $row) {
            $sql = "SELECT customer_preferences_value_id, customer_preferences_value
                      FROM ".$this->db->table('customer_preferences_values')."
                      WHERE customer_preferences_id = ".(int) $row['customer_preferences_id']."
                            AND customer_id=".(int) $customer_id;
            $selected_values = $this->db->query($sql);
            $row['selected_values'] = $selected_values->rows;

            $sql = "SELECT *
                    FROM ".$this->db->table('customer_preferences_values_to_groups')." cavtg
                    LEFT JOIN ".$this->db->table('customer_preferences_value_descriptions_to_groups')." cavdtg
                        ON cavdtg.customer_preferences_value_id = cavtg.customer_preferences_value_id 
                            AND language_id = '".$language_id."'
                    WHERE cavtg.customer_preferences_id = ".(int) $row['customer_preferences_id']."
                        AND cavtg.customer_group_id = ".$customer_group_id."
                    ORDER BY cavtg.sort_order";
            $all_values = $this->db->query($sql);
            $row['values'] = $all_values->rows;

            $attributes[] = $row;
        }

        return $attributes;
    }

    /**
     * @param int $customer_id
     *
     * @return array
     * @throws AException
     */
    public function getVisiblePreferences($customer_id) {
        $customer_id = (int) $customer_id;
        if (!$customer_id) {
            return [];
        }
        $results = $this->db->query(
            "SELECT cag.customer_preferences_id
            FROM ".$this->db->table('customer_preferences_to_groups')." cag
            INNER JOIN ".$this->db->table('customers')." c
                ON cag.customer_group_id = c.customer_group_id
            WHERE c.customer_id = ".(int) $customer_id." 
                AND cag.visible_by_customer = 1
                AND cag.status = 1 "
        );
        return $results->rows;
    }

    /**
     * @param int $customer_group_id
     * @param array $data
     *
     * @return array
     * @throws AException
     */
    public function validatePreferencesForEdit($customer_group_id, $data) {
        $errors = [];
        $check = $this->getCustomerVisiblePreferences($customer_group_id);

        $fm = new AFile();

        foreach ($check as $check_attr) {
            $attribute_id = $check_attr['customer_preferences_id'];
            if (empty($data[$attribute_id]) && $check_attr['required'] == 1
                && $check_attr['editable_by_customer'] == 1) {
                //if value is empty
                if (($check_attr['element_type'] == 'U' && !$this->request->files['attributes']['name'][$attribute_id])
                    || $check_attr['element_type'] != 'U'
                ) {
                    $errors[$attribute_id] = $this->language->get('error_required');
                }
            } else {
                if (!empty($data[$attribute_id]) && $check_attr['regexp_pattern']
                    && !preg_match($check_attr['regexp_pattern'], $data[$attribute_id])) {
                    $errors[$attribute_id] = $check_attr['error_text'];
                }
            }
            //check uploaded file
            if ($this->request->files['attributes']['name'][$attribute_id] && $check_attr['element_type'] == 'U'
                && $check_attr['editable_by_customer'] == 1) {
                if (is_serialized($check_attr['settings'])) {
                    $check_attr['settings'] = unserialize($check_attr['settings']);
                }
                $name = $this->request->files['attributes']['name'][$attribute_id];
                $file_path_info = $fm->getUploadFilePath($check_attr['settings']['directory'], $name);
                $file_data = [
                    'name'     => $file_path_info['name'],
                    'path'     => $file_path_info['path'],
                    'type'     => $this->request->files['attributes']['type'][$attribute_id],
                    'tmp_name' => $this->request->files['attributes']['tmp_name'][$attribute_id],
                    'error'    => $this->request->files['attributes']['error'][$attribute_id],
                    'size'     => $this->request->files['attributes']['size'][$attribute_id],
                ];
                $errors[$attribute_id] = implode(
                    '<br>',
                    $fm->validateFileOption($check_attr['settings'], $file_data)
                );
            }

            //if checkbox is not required and was unchecked - set value to emptiness
            if (!$errors[$attribute_id]
                && !isset($data[$attribute_id])
                && $check_attr['element_type'] == 'C'
            ) {
                $this->request->post['attributes'][$attribute_id] = '';
            }
        }
        return $errors;
    }

    /**
     * @param int $customer_group_id
     * @param int $language_id
     * @param array $data
     *
     * @return array
     * @throws AException
     */
    public function validatePreferencesForCreate($customer_group_id, $language_id, $data, $showIn = '') {
        $customer_group_id = (int) $customer_group_id;
        $language_id = (int) $language_id;
        $data = (array) $data;
        $errors = [];
        $check = $this->getPreferencesForGroup($customer_group_id, $language_id,$showIn);
        $fm = new AFile();
        foreach ($check as $check_attr) {
            $attribute_id = $check_attr['customer_preferences_id'];
            if (empty($data[$attribute_id]) && $check_attr['required'] == 1) {
                if (
                    ($check_attr['element_type'] == 'U' && !$this->request->files['attributes']['name'][$attribute_id])
                    || $check_attr['element_type'] != 'U'
                ) {
                    $errors['attribute_'.$attribute_id] = $this->language->get('error_required');
                }
            } else {
                if (!empty($data[$attribute_id]) && $check_attr['regexp_pattern']
                    && !preg_match($check_attr['regexp_pattern'], $data[$attribute_id])) {
                    $errors['attribute_'.$attribute_id] = $check_attr['error_text'];
                }
            }
            //check uploaded files
            if ($this->request->files['attributes']['name'][$attribute_id] && $check_attr['element_type'] == 'U') {
                $name = $this->request->files['attributes']['name'][$attribute_id];
                $file_path_info = $fm->getUploadFilePath($check_attr['settings']['directory'], $name);
                $file_data = [
                    'name'     => $file_path_info['name'],
                    'path'     => $file_path_info['path'],
                    'type'     => $this->request->files['attributes']['type'][$attribute_id],
                    'tmp_name' => $this->request->files['attributes']['tmp_name'][$attribute_id],
                    'error'    => $this->request->files['attributes']['error'][$attribute_id],
                    'size'     => $this->request->files['attributes']['size'][$attribute_id],
                ];
                $file_errors = $fm->validateFileOption($check_attr['settings'], $file_data);
                if ($file_errors) {
                    $errors['attribute_'.$attribute_id] = implode('<br>', $file_errors);
                }
            }

            //if checkbox is not required and was unchecked - set value to emptiness
            if (!$errors['attribute_'.$attribute_id]
                && !isset($data[$attribute_id])
                && $check_attr['element_type'] == 'C'
            ) {
                $this->request->post['attributes'][$attribute_id] = '';
            }
        }
        return $errors;
    }

    /**
     * @param int $attribute_id
     *
     * @return array
     * @throws AException
     */
    public function getPreferencesInfo($attribute_id) {
        $language_id = $this->config->get('storefront_language_id');
        $sql = "SELECT cag.customer_group_id,
                    cag.editable_by_customer,
                    cag.visible_by_customer,
                    cag.status,
                    gad.name,
                    gad.error_text,
                    ga.customer_preferences_id,
                    ga.element_type,
                    ga.sort_order,
                    ga.settings,
                    ga.required
            FROM ".$this->db->table('customer_preferences_to_groups')." cag
            INNER JOIN ".$this->db->table('customer_preferences_descriptions')." gad 
                ON cag.customer_preferences_id = gad.customer_preferences_id 
                    AND language_id = ".(int) $language_id."
            INNER JOIN ".$this->db->table('customer_preferences')." ga 
                ON cag.customer_preferences_id = ga.customer_preferences_id
            WHERE ga.customer_preferences_id = ".(int) $attribute_id." 
                AND cag.status = 1";
        $results = $this->db->query($sql);
        if (has_value($results->row['settings'])) {
            $results->row['settings'] = unserialize($results->row['settings']);
        }
        $results->row['values'] = $this->getPreferencesValues($results->row['attribute_id'], $language_id);
        return $results->row;
    }

    /**
     * @param int $customer_id
     *
     * @return array
     * @throws AException
     */
    public function getCustomerPreferences($customer_id) {
        $language_id = $this->config->get('storefront_language_id');
        $results = $this->db->query(
            "SELECT
                ca.customer_preferences_id,
                cag.customer_group_id,
                cag.editable_by_customer,
                cag.visible_by_customer,
                cag.status,
                gad.name,
                gad.error_text,
                ga.attribute_id,
                ga.element_type,
                ga.sort_order,
                ga.required
            FROM ".$this->db->table('customer_preferences_to_groups')." cag
            INNER JOIN ".$this->db->table('customer_preferences_descriptions')." gad 
                ON cag.customer_preferences_id = gad.customer_preferences_id
            INNER JOIN ".$this->db->table('customer_preferences_to_customers')." ca 
                ON cag.customer_preferences_id = ca.customer_preferences_id
            WHERE cag.customer_group_id = (
                                SELECT customer_group_id 
                                FROM ".$this->db->table('customers')." 
                                WHERE customer_id='".(int) $customer_id."' LIMIT 0,1)
                AND language_id = ".(int) $language_id."
                AND ga.status = 1"
        );

        $results->row['values'] = $this->getPreferencesValues($results->row['customer_preferences_id'], $language_id);
        return $results->row;
    }

    /**
     * @param int $customer_id
     *
     * @return array
     * @throws AException
     */
    public function getCustomerPreferencesIds($customer_id)
    {
        $res = $this->db->query(
            "SELECT customer_preferences_id
            FROM ".$this->db->table('customer_preferences')."
            WHERE customer_id = ".(int) $customer_id
        );
        return array_column($res->rows, 'customer_preferences_id');
    }

    /**
     * @param int $customer_group_id
     *
     * @return array
     * @throws AException
     */
    public function getCustomerEditablePreferencesIds($customer_group_id) {
        $res = $this->db->query(
            "SELECT ca.customer_preferences_id
            FROM ".$this->db->table('customer_preferences_to_groups')." cag
            LEFT JOIN ".$this->db->table('customer_preferences')." ca 
                ON ca.customer_preferences_id = cag.customer_preferences_id
            WHERE cag.customer_group_id = '".(int) $customer_group_id."'
                AND cag.editable_by_customer = 1"
        );

        return array_column($res->rows, 'customer_preferences_id');
    }

    /**
     * @param int $customer_id
     * @param array $data
     *
     * @return bool
     * @throws AException
     */
    public function addAttributesToCustomer($customer_id, $data = []) {
        if (!is_array($data) || !(int) $customer_id) {
            return false;
        }
        foreach ($data as $attr_id => $val) {
            if (!is_array($val)) {
                $val = (array) $val;
            }
            $this->db->query(
                "DELETE FROM ".$this->db->table('customer_preferences_values')."
                 WHERE customer_id = '".(int) $customer_id."' 
                    AND  customer_attribute_id = ".(int) $attr_id.";"
            );

            foreach ($val as $attr_val) {
                $this->db->query(
                    "INSERT INTO ".$this->db->table('customer_preferences_values')."
                        (customer_id, customer_attribute_id, customer_attribute_value)
                    VALUES (".(int) $customer_id.", ".(int) $attr_id.", '".addslashes($this->db->escape($attr_val))."');"
                );
            }
        }
        return true;
    }

    /**
     * @param int $customer_id
     * @param array $data
     *
     * @return null
     * @throws AException
     */
    public function updateCustomerPreferencesValues($customer_id, $data) {
        if (!has_value($data)) {
            return false;
        }

        $ids = $this->getCustomerEditablePreferencesIds($this->customer->getCustomerGroupId());
        foreach ($data as $key => $item) {
            //protect from editing wrong customer
            if (in_array($key, $ids)) {
                $this->db->query(
                    "DELETE FROM ".$this->db->table('customer_preferences_values')."
                    WHERE customer_preferences_id = ".(int) $key."
                        AND customer_id = ".(int) $customer_id
                );
                if (!is_array($item)) {
                    $item = [$item];
                }
                foreach ($item as $val) {
                    $this->db->query(
                        "INSERT INTO ".$this->db->table('customer_preferences_values')."
                        SET customer_id = ".(int) $customer_id.",
                            customer_preferences_id = ".(int) $key.",
                            customer_preferences_value = '".addslashes($this->db->escape($val))."'"
                    );
                }
            }
        }
        return true;
    }

    /**
     * @param $customer_id
     * @param $show_in
     * @return void
     * @throws AException
     */
    public function getPreferencesByCustId($customer_id,$show_in='') {
        $language_id = $this->language->getLanguageID();
        if ($customer_id) {
            $customer_group_id = $this->customer->getCustomerGroupId();
            $query = $this->db->query("SELECT cpd.name as name, REPLACE(cpv.customer_preferences_value, CHAR(92),'') as value, cptg.show_admin_invoice FROM " . $this->db->table("customer_preferences_descriptions") . " cpd 
                                  LEFT JOIN " . $this->db->table("customer_preferences_values") . " cpv ON cpv.customer_preferences_id = cpd.customer_preferences_id 
                                  LEFT JOIN " . $this->db->table("customer_preferences_to_groups") . " cptg ON cptg.customer_preferences_id = cpd.customer_preferences_id
                                  LEFT JOIN " . $this->db->table("customer_preferences") . " cp ON cp.customer_preferences_id = cpd.customer_preferences_id 
                                  WHERE cpv.customer_id='" . $customer_id . "' AND cpd.language_id='" . $language_id . "' AND cptg.show_" . $show_in . " = '1' AND cptg.customer_group_id='" . $customer_group_id . "' ORDER BY cp.sort_order ASC");
            return $query->rows;
        }
    }

    /**
     * @param $order_id
     * @param $customer_id
     * @param $data
     * @return void
     * @throws AException
     */
    public function saveOrderPreferences($order_id,$customer_id,$data) {
        foreach ($data as $info) {
            $sql = "INSERT INTO " . $this->db->table("customer_preferences_order") . " SET `order_id`='" . $order_id . "',`customer_id`='" . $customer_id . "',
                    `preferences_name`='" . $info['name'] . "',`preferences_value`='".addslashes($this->db->escape($info['value']))."',`show_admin_invoice`='".$info['show_admin_invoice']."'";
            $this->db->query($sql);
        }
    }

    /**
     * @param $order_id
     * @param $customer_id
     * @return mixed
     * @throws AException
     */
    public function getOrderPreferences($order_id,$customer_id) {
        $query = $this->db->query("SELECT * FROM ". $this->db->table("customer_preferences_order") . " WHERE `order_id`='".$order_id."' AND `customer_id`='".$customer_id."' ORDER BY  `customer_preferences_order_id` ASC");
        return $query->rows;
    }

}