<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

if (!class_exists('ExtensionCustomerPreferences')) {
    include('core/customer_preferences.php');
}

$controllers = [
    'storefront' => [''],
    'admin'      => [
        'pages/extension/customer_preferences_updater',
        'pages/sale/customer_preferences',
        'responses/sale/admin_invoice',
        'responses/sale/customer_preferences_response',
    ],
];

$models = [
    'storefront' => [
        'sale/customer_preferences',
    'extension/customer_preferences_license_info',
        ],
    'admin'      => [
        'sale/customer_preferences',
        'extension/customer_preferences_license_info',
        'extension/customer_preferences_updater',
        ],
];

$languages = [
    'storefront' => [
        'account/customer_attributes',
    ],
    'admin'      => [
        'customer_attributes/customer_attributes',
        'sale/customer_preferences',
    ],
];

$templates = [
    'storefront' => [
        'pages/account/fc_preferences_fields.tpl',
        'pages/account/fc_invoice_preferences_fields.tpl',
        'pages/account/invoice_preferences_fields.tpl',
        'pages/account/preferences_edit.tpl',
        'pages/account/order_preferences_fields.tpl',
        'pages/account/shipping_preferences_fields.tpl',
        'responses/checkout/preferences.tpl',
    ],
    'admin'      => [
        'pages/sale/preferences_form.tpl',
        'pages/sale/order_details_customer_preferences_fields.tpl',
        'pages/blocks/tabs.tpl',
        'responses/sale/preferences_values.tpl',
        'responses/sale/preferences_value_row.tpl',
        'responses/sale/file_upload_settings.tpl',
        'responses/sale/admin_invoice.tpl',
        'responses/sale/sale_invoice_customer_preferences_fields.tpl',
        'responses/sale/global_preferences_customer_preferences_subform.tpl',
        'pages/extension/extension_summary_button.tpl',
        'pages/extension/extensions.post.tpl',
        'pages/extension/extensions_edit.post.tpl',
        'pages/extension/customer_preferences_updater.tpl',
        'pages/extension/customer_preferences_manual.tpl',
    ],
];