<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

$exist = $this->db->query("SELECT * FROM ".$this->db->table('global_attributes_types')." WHERE `type_key`='customer_preferences'");
$result = $exist->row;

if (sizeof($result)===0) {
    $this->db->query(
        "INSERT INTO " . $this->db->table('global_attributes_types') . "
     (type_key, controller, sort_order, status)
        VALUES ('customer_preferences', 'responses/sale/customer_preferences_response/getCustomerPreferencesSubform', 2, 1)");
    $attribute_type_id = $this->db->getLastId();
    $this->language->replaceDescriptions(
        'global_attributes_type_descriptions',
        [
            'attribute_type_id' => (int)$attribute_type_id
        ],
        [
            (int)$this->language->getDefaultLanguageID() => [
                'type_name' => 'Customer Preferences'
            ]
        ]
    );
}

$this->cache->remove('*');

$sql1 ="CREATE TABLE IF NOT EXISTS ".$this->db->table("customer_preferences_order"). "(
`customer_preferences_order_id` int(11) NOT NULL AUTO_INCREMENT,
    `order_id` int(11) NOT NULL,
    `customer_id` int(11) NOT NULL,
    `show_admin_invoice` smallint(1),
    `preferences_name` varchar(255) NOT NULL,
    `preferences_value` varchar(255) NOT NULL,
    PRIMARY KEY (`customer_preferences_order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;";
$this->db->query($sql1);

$sql2 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("customer_preferences_license_info") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `public_key` TEXT NOT NULL,
  `license_data` TEXT NOT NULL,
  `license_key` TEXT NOT NULL,
  `store_id` int(11) NOT NULL,
  `last_check` int(11),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";
$this->db->query($sql2);

$sql3 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("customer_preferences_updater_notification") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL,
  `cart_version` VARCHAR(10),
  `extension_version` VARCHAR(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";
$this->db->query($sql3);

$sql4 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("customer_preferences")." (
`customer_preferences_id` int(11) NOT NULL AUTO_INCREMENT,
    `global_attribute_id` int(11) NOT NULL,
    `regexp_pattern` varchar(255) COLLATE utf8_bin DEFAULT NULL,
    `element_type` char(1) COLLATE utf8_bin NOT NULL DEFAULT 'I',
    `sort_order` int(3) NOT NULL DEFAULT '0',
    `required` smallint(1) NOT NULL DEFAULT '0',
    `settings` text COLLATE utf8_bin NOT NULL,
    PRIMARY KEY (`customer_preferences_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";
$this->db->query($sql4);

$sql5 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("customer_preferences_descriptions")." (
`customer_preferences_id` int(11) NOT NULL,
    `language_id` int(11) NOT NULL,
    `name` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
    `error_text` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";
$this->db->query($sql5);

$sql6="CREATE TABLE IF NOT EXISTS ".$this->db->table("customer_preferences_to_groups")." (
    `customer_preferences_id` int(11) NOT NULL,
    `customer_group_id` int(11) NOT NULL,
    `editable_by_customer` smallint(1) NOT NULL DEFAULT '1',
    `visible_by_customer` smallint(1) NOT NULL DEFAULT '1',
    `show_shipping` smallint(1) NOT NULL DEFAULT '1',
    `show_checkout_confirm` smallint(1) NOT NULL DEFAULT '1',
    `show_fast_checkout` smallint(1) NOT NULL DEFAULT '1',
    `show_admin_invoice` smallint(1) NOT NULL DEFAULT '1',
    `show_invoice` smallint(1) NOT NULL DEFAULT '1',
    `show_confirmation_email` smallint(1) NOT NULL DEFAULT '1',
    `status` smallint(1) NOT NULL DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";
$this->db->query($sql6);

$sql7= "CREATE TABLE IF NOT EXISTS ".$this->db->table("customer_preferences_values_to_groups")." (
`customer_preferences_value_id` int(11) NOT NULL AUTO_INCREMENT,
    `customer_preferences_id` int(11) NOT NULL,
    `customer_preferences_value` varchar(255) NOT NULL,
    `customer_group_id` int(11) NOT NULL,
    `sort_order` int(11) NOT NULL DEFAULT '0',
    `default` smallint DEFAULT 0,
    PRIMARY KEY (`customer_preferences_value_id`,`customer_preferences_id`,`customer_group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";
$this->db->query($sql7);

$sql8 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("customer_preferences_value_descriptions_to_groups"). "(
`customer_preferences_value_id` int(11) NOT NULL,
    `customer_preferences_id` int(11) NOT NULL,
    `customer_group_id` int(11) NOT NULL,
    `language_id` int(11) NOT NULL,
    `value` text COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
    PRIMARY KEY (`customer_preferences_value_id`,`customer_preferences_id`,`language_id`,`customer_group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";
$this->db->query($sql8);

$sql9 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("customer_preferences_values")." (
`customer_preferences_value_id` int(11) NOT NULL AUTO_INCREMENT,
    `customer_id` int(11) NOT NULL,
    `customer_preferences_id` int(11) NOT NULL,
    `customer_preferences_value` varchar(255) NOT NULL,
    PRIMARY KEY (`customer_preferences_value_id`,`customer_id`,`customer_preferences_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql9);

if (!file_exists(DIR_SYSTEM.'lib/license.php')) {
    /**
     *  Function to Copy folders and files
     * @param $src
     * @param $dst
     * @return array
     */
    function custom_copy($src, $dst) {
        $error = [];
        // open the source directory
        $dir = opendir($src);
        if (!is_dir($dst)) {
            @mkdir($dst);
        }
        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    // Recursively calling custom copy function
                    // for sub directory
                    custom_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    if (!copy($src . '/' . $file, $dst . '/' . $file)) {
                        $error['error_copy'][] = "Failed to copy $file";
                    }
                }
            }
        }
        if (sizeof($error)>0) {
            $log=new ALog(DIR_SYSTEM.'logs/error.txt');
            $log->write(var_export($error,true));
        }
        closedir($dir);
        return $error;
    }

    $copy = custom_copy(DIR_EXT . 'customer_preferences' . DIR_EXT_CORE . 'lib', DIR_SYSTEM.'lib');
}
