<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}


require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";
require_once DIR_EXT. "customer_preferences" . DIR_EXT_CORE ."updater.php";

/**
 * ExtensionCustomerPreferences
 */
class ExtensionCustomerPreferences extends Extension {

    public $errors = [];
    public $error = [];
    public $data = [];
    protected $registry;
    private $mc_server_url = "https://abantecartplus.com/clientarea/plugin/license_manager/validate/";
    private $diy_server_url = "https://wehearyou2.com/clientarea/plugin/license_manager/validate/";
    private $shared_secret = "customer_preferences";
    public function __construct() {
        $this->registry = Registry::getInstance();
    }

    private function _is_enabled() {
        return $this->baseObject->config->get('customer_preferences_status') && $this->verify();
    }

    /** Extension Sections */

    public function verify() {
        $that =& $this->baseObject;
        $that->load->model('extension/customer_preferences_license_info');
        $license_key = $that->config->get('customer_preferences_license_code');
        if ($license_key) {
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('customer_preferences_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $that->model_extension_customer_preferences_license_info->getStoreId();
                $license_key = $that->model_extension_customer_preferences_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_customer_preferences_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $that->model_extension_customer_preferences_license_info->getLicensedStoreStatus();
                if ($validate['status']==='expired') {
                    $public_key = "";
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }

                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $current_version = $that->model_extension_customer_preferences_license_info->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_data, $ttl);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/customer_preferences_license_info');
                            $that->model_extension_customer_preferences_license_info->saveLicenseData($data);
                        } elseif ($validate['status'] === 'valid' && $store_status == 1) {
                            return true;
                        } else {
                            return false;
                        }
                    }
                } else {
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyAutoAssigned() {
        $that =& $this->baseObject;
        if ( $that->config->get( 'customer_group_auto_assigned_status' ) ) {
            $that->load->model('extension/customer_group_auto_assigned_license_info');
            $license_key = $that->config->get('customer_group_auto_assigned_license_code');
            $shared_secret = 'customer_group_auto_assigned';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('customer_group_auto_assigned_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_customer_group_auto_assigned_license_info->getStoreId();
                    $license_key = $that->model_extension_customer_group_auto_assigned_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_customer_group_auto_assigned_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_customer_group_auto_assigned_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }


    public function onControllerPagesIndexLogin_InitData() {
        $that =& $this->baseObject;
        if ($that->request->is_POST()) {
            $logged_in = $that->session->data['LAST_ACTIVITY'];
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('customer_preferences_license_info') . "'");
            if ($exist->num_rows === 1) {
                if (isset($logged_in)) {
                    $that->load->model('extension/customer_preferences_license_info');
                    $store_id = $that->model_extension_customer_preferences_license_info->getStoreId();

                    $license_info = $that->model_extension_customer_preferences_license_info->getLicenseData($store_id);
                    $last_check = $license_info['last_check'];
                    $daily_check = 86400;
                    if (time() > $daily_check + $last_check) {
                        $public_key = "";
                        $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                        $license_key = $that->model_extension_customer_preferences_license_info->getLicenseCode($store_id);
                        $license = new License($path_to_phpseclib);
                        $license_manager = $license->getManager();
                        if (stripos($license_key,'mc-')!==false) {
                            $server_url = $this->mc_server_url;
                        } else {
                            $server_url = $this->diy_server_url;
                        }

                        $license_manager->setLicenseServerUrl($server_url);
                        $license_manager->setKeys($license_key, "", $this->shared_secret);
                        $public_key = $license_manager->requestKey();
                        $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                        $that->load->model('extension/customer_preferences_updater');
                        $current_version = $that->model_extension_customer_preferences_updater->getCurrentVersion();
                        $custom_data = ['version' => $current_version];
                        $license_data = $license_manager->requestData($custom_data);
                        if (!is_null($license_data)) {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $ttl = 1209600;
                            $validate = $license_manager->validate($license_data, $ttl);
                            if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                                $data['public_key'] = $public_key;
                                $data['license_data'] = $license_data;
                                $data['store_id'] = $store_id;
                                $data['last_check'] = time();
                                $that->load->model('extension/customer_preferences_license_info');
                                $that->model_extension_customer_preferences_license_info->saveLicenseData($data);
                            }
                        }
                    }
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensions_InitData() {
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'edit' ) {
            $extension = $that->request->get['extension'];
            if ( $extension === 'customer_preferences' ) {
                if ( $that->request->is_POST()) {
                    $public_key = "";
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license_key = trim($that->request->post['customer_preferences_license_code']);
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }
                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $that->load->model('extension/customer_preferences_license_info');

                    $store_id = (int) $that->config->get('config_store_id');
                    if (has_value($that->request->get_or_post('store_id'))) {
                        $store_id = (int) $that->request->get_or_post('store_id');
                    } else {
                        if ($that->session->data['current_store_id']) {
                            $store_id = (int) $that->session->data['current_store_id'];
                        }
                    }

                    $installed_store_id = $that->model_extension_customer_preferences_license_info->getInstalledLicense($license_key);

                    if ($installed_store_id!=='' && !is_null($installed_store_id)) {
                        $that->model_extension_customer_preferences_license_info->deleteLicenseInfo($installed_store_id);
                    }
                    $existing_license_key = $that->model_extension_customer_preferences_license_info->getLicenseCode($store_id);
                    $data['multi']=false;
                    $split_existing_license_key = explode('-',$existing_license_key);
                    $split_license_key = explode('-',$license_key);
                    if ($existing_license_key && $split_existing_license_key[0] !== $split_license_key[0]) {
                        $data['multi']=true;
                    }

                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $that->load->model('extension/customer_preferences_updater');
                    $current_version = $that->model_extension_customer_preferences_updater->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_data, $ttl);

                        $that->load->model('setting/setting');
                        $that->load->model('extension/customer_preferences_license_info');
                        $data['customer_preferences_licensed_store_id_'.$store_id] = 1;

                        $that->model_setting_setting->editSetting('customer_preferences', $data);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            if (file_exists(DIR_EXT.'customer_preferences/core/helpers.php')) {
                                unlink(DIR_EXT.'customer_preferences/core/helpers.php');
                            }
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['license_key'] = $license_key;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/customer_preferences_license_info');
                            $that->model_extension_customer_preferences_license_info->saveLicenseData($data);
                        }
                    } else {
                        $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                    }
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensions_UpdateData() {
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'edit' ) {
            $extension = $that->request->get['extension'];
            $that->load->language('customer_preferences/customer_preferences');
            if ( $extension === 'customer_preferences' ) {
                $latestVersion = $this->getVersion();
                $that->loadLanguage('extension/extensions');
                if (!is_null($latestVersion) && $latestVersion!=='') {
                    $info = sprintf(
                        $that->language->get('text_update_customer_preferences_available'),
                        $latestVersion,
                        $that->html->getSecureURL('extension/customer_preferences_updater','&version='.str_replace('.', '-', $latestVersion))
                    );
                    $that->view->assign('info',$info);
                } else {
                    $that->view->assign('info','');
                }
                $view = new AView($this->registry, 0);
                $data['manual_url'] = 'https://why2central.net/v1/customer-preferences';
                $data['manual_title'] = $that->language->get('customer_preferences_name').' Manual';
                $view->batchAssign($data);
                $that->view->addHookVar('extension_toolbar_buttons', $view->fetch('pages/extension/customer_preferences_manual.tpl'));
                $that->load->model('extension/customer_preferences_license_info');
                $license_key = $that->config->get('customer_preferences_license_code');
                if ($license_key) {
                    $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('customer_preferences_license_info') . "'");
                    if ($exist->num_rows === 1) {
                        $store_id = $that->model_extension_customer_preferences_license_info->getStoreId();
                        $license_key = $that->model_extension_customer_preferences_license_info->getLicenseCode($store_id);
                        $license_info = $that->model_extension_customer_preferences_license_info->getLicenseData($store_id);
                        $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                        $license = new License($path_to_phpseclib);
                        $license_manager = $license->getManager();
                        $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_info['license_data'], $ttl);
                        $message = '';
                        if ($validate['status']==='expired') {
                            $message = $that->language->get('customer_preferences_license_expired');
                        }
                        $that->view->assign('message',$message);
                    }
                }
                $that->processTemplate();
            }
        }
    }

    public function onControllerResponsesListingGridExtension_InitData() {
        if ($this->baseObject_method != 'update') {
            return false;
        }
        $that =& $this->baseObject;
        if ($that->request->get['id'] != 'customer_preferences') {
            return false;
        }
        if (isset($that->request->post['customer_preferences_license_code'])) {
            $that->request->post['customer_preferences_license_code'] = trim($that->request->post['customer_preferences_license_code']);
        }
    }

    public function onControllerResponsesListingGridExtension_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $store_id = (int)$that->config->get('current_store_id');
            if ($that->request->get_or_post('store_id')) {
                $store_id = $that->request->get_or_post('store_id');
            }
            $that->load->language('customer_preferences/customer_preferences');
            $response = json_decode(json_encode($that->data['response']), true);
            $extension_rows = $response['rows'];
            $ext_name = $that->language->get('customer_preferences_name');
            foreach ($extension_rows as $k => $extensions) {
                if ($extensions['id'] === 'customer_preferences_' . $store_id) {
                    $cells = $extensions['cell'];
                    foreach ($cells as $key => $cell) {
                        if ($cell===$ext_name || strpos($cell,'<p class="alert-info">'.$ext_name)!==false) {
                            $latestVersion = $this->getVersion();
                            if (!is_null($latestVersion) && $latestVersion !== '') {
                                $update_now_url = $that->html->getSecureURL('extension/customer_preferences_updater', '&version=' . str_replace('.', '-', $latestVersion));
                                $cells[$key] = '<p class="alert-info">'
                                    .$ext_name.' (WHY2)'
                                    . '<br>'
                                    . sprintf(
                                        $that->language->get('text_update_customer_preferences_available'),
                                        $latestVersion,
                                        $update_now_url
                                    )
                                    . '</p>';
                                $that->data['response']->rows[$k]['cell'][$key] = $cells[$key];
                            } else {
                                $that->data['response']->rows[$k]['cell'][$key] = $ext_name;
                            }
                        }
                    }
                }
            }
        } elseif ($this->baseObject_method==='update') {
            if ($that->request->post['customer_preferences_license_code']) {
                $public_key = "";
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";

                $license_key = trim($that->request->post['customer_preferences_license_code']);
                if (stripos($license_key,'mc-')!==false) {
                    $server_url = $this->mc_server_url;
                } else {
                    $server_url = $this->diy_server_url;
                }
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setLicenseServerUrl($server_url);
                $license_manager->setKeys($license_key, "", $this->shared_secret);
                $public_key = $license_manager->requestKey();

                $store_id = (int) $that->config->get('config_store_id');
                if ($that->request->get_or_post('store_id')) {
                    $store_id = $that->request->get_or_post('store_id');
                }

                $that->load->model('extension/customer_preferences_license_info');

                $installed_store_id = $that->model_extension_customer_preferences_license_info->getInstalledLicense($license_key);

                if ($installed_store_id!=='' && !is_null($installed_store_id)) {
                    $that->model_extension_customer_preferences_license_info->deleteLicenseInfo($installed_store_id);
                }

                $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                $that->load->model('extension/customer_preferences_updater');
                $current_version = $that->model_extension_customer_preferences_updater->getCurrentVersion();
                $custom_data = ['version' => $current_version];
                $license_data = $license_manager->requestData($custom_data);
                if (!is_null($license_data)) {
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_data, $ttl);

                    $that->load->model('setting/setting');
                    $that->load->model('extension/customer_preferences_license_info');

                    if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $data['license_key'] = $license_key;
                        $data['store_id'] = $store_id;
                        $data['last_check'] = time();
                        $that->load->model('extension/customer_preferences_license_info');
                        $that->model_extension_customer_preferences_license_info->saveLicenseData($data);
                    }
                } else {
                    $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensionSummary_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $extension = $that->request->get['extension'];
            if ($extension==='customer_preferences') {
                $that->load->language('customer_preferences/customer_preferences');
                $extension_info = $that->extensions->getExtensionInfo($extension);
                $support_expiration_int =  strtotime($extension_info['support_expiration']);
                if ($extension_info['support_expiration'] && $support_expiration_int !== 0) {
                    if ($support_expiration_int < time()) {
                        if ($that->data['text_support_expiration']) {
                            $that->view->assign('text_support_expired', $that->language->get('text_support_by_why2'));
                        } else {
                            $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                        }
                    } else {
                        $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                    }
                } else {
                    $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                }
                $that->view->assign('get_support_button', '');
                $data['get_diy_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'diy_support',
                        'target' => "_new",
                        'href'   => 'https://wehearyou2.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_diy_support_by_why2'),
                    ]
                );
                $data['get_mc_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'mc_support',
                        'target' => "_new",
                        'href'   => 'https://abantecartplus.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_mc_support_by_why2'),
                    ]
                );
                $view = new AView(Registry::getInstance(), 0);
                $view->batchAssign($data);
                $that->view->addHookVar('extension_summary_item', $view->fetch('pages/extension/extension_summary_buttons.tpl'));
                $that->view->batchAssign($this->data);
                $that->processTemplate();
            }
        }
    }

    public function onControllerCommonHead_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (IS_ADMIN) {
                $latestVersion = $this->getVersion();
                if ($latestVersion) {
                    $that->load->language('customer_preferences/customer_preferences');
                    $that->load->model('extension/customer_preferences_updater');
                    $total = $that->model_extension_customer_preferences_updater->getTotalMsgIds();
                    if ($total > '0') {
                        $msg_ids = $that->model_extension_customer_preferences_updater->getMsgIdsByCartVersions();
                        foreach ($msg_ids as $msg_id) {
                            $that->messages->deleteMessage($msg_id['msg_id']);
                            $that->model_extension_customer_preferences_updater->deleteMsgID($msg_id['msg_id']);
                        }
                    }
                    $msg_title = str_replace('[new_version]', $latestVersion, $that->language->get('text_new_customer_preferences_version_title'));
                    $msg = str_replace('[version_number]', str_replace('.', '-', $latestVersion), $that->language->get('text_new_customer_preferences_version_description'));
                    $that->messages->saveNotice($msg_title, $msg);
                    $msg_info = $that->messages->getLikeMessage($msg_title);
                    $that->model_extension_customer_preferences_updater->saveMessageId($msg_info['msg_id'], $latestVersion);
                }
            } else {
                $that->view->assign('search_url', $that->html->getNonSecureURL('search/search'));
            }
        }
    }

    private function getVersion() {
        $that =& $this->baseObject;
        $latestVersion = '';
        $license_key = $that->config->get('customer_preferences_license_code');
        if ($license_key) {
            $valid = false;
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('customer_preferences_license_info') . "'");
            if ($exist->num_rows === 1) {
                $that->load->model('extension/customer_preferences_license_info');
                $store_id = $that->model_extension_customer_preferences_license_info->getStoreId();

                $license_key = $that->model_extension_customer_preferences_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_customer_preferences_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);

                if ($validate['status'] === 'valid') {
                    if (stripos($license_key, 'rent-') !== false || stripos($license_key, 'mc-') !== false) {
                        $valid = true;
                    } elseif (stripos($license_key, 'own-') !== false) {
                        $today = date("Y-m-d H:i:s");
                        $support_date = date('Y-m-d H:i:s', strtotime($validate['updates']));
                        if ($today <= $support_date) {
                            $valid = true;
                        }
                    }
                }
            }
            if ($valid) {
                $that->load->language('customer_preferences/customer_preferences');
                $getVersions = customerPreferencesUpdaterGetAllVersions();
                $that->load->model('extension/customer_preferences_updater');
                $current_version = $that->model_extension_customer_preferences_updater->getCurrentVersion();
                if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                    $versions = $getVersions['notification_data']['product_versions'];
                    if ($versions) {
                        $latestVersions = [];
                        foreach ($versions as $version) {
                            if (strpos($version['version_number'], VERSION) !== false) {
                                $latestVersions[] = $version['version_number'];
                            }
                        }
                        usort($latestVersions, 'version_compare');
                        $latestVersion = end($latestVersions);
                        if (version_compare($current_version, $latestVersion, '<') === true) {
                            $msg_ids = $that->model_extension_customer_preferences_updater->getMsgIdsByCurrentCartVersion();
                            foreach ($msg_ids as $msg_id) {
                                $that->messages->deleteMessage($msg_id['msg_id']);
                                $that->model_extension_customer_preferences_updater->deleteMsgID($msg_id['msg_id']);
                            }
                            return $latestVersion;
                        }
                    }
                } else {
                    return '';
                }
            } else {
                return '';
            }
        }
    }

    /** End Of Extension Sections */

    /** Admin Section */
    public function onControllerPagesCatalogAttribute_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        // purge regexp pattern and error text when attribute type is "file"
        if ($that->request->is_POST() && $that->request->post['element_type'] == 'U') {
            $that->request->post['regexp_pattern'] = $that->request->post['error_text'] = '';
        }
    }

    public function onControllerPagesCatalogAttribute_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $am = new AAttribute_Manager('customer_preferences');
        $type_id = $am->getAttributeTypeID('customer_preferences');
        if ((int)$that->request->get['preferences_type_id']
            && $that->request->get['preferences_type_id'] != $type_id
        ) {
            return null;
        } elseif ((int)$that->request->get['preferences_id']) {
            $attr_info = $am->getAttribute((int)$that->request->get['preferences_id']);
            if ($attr_info['preferences_type_id'] != $type_id) {
                return null;
            }
        } elseif (!(int)$that->request->get['preferences_id'] && !(int)$that->request->get['preferences_type_id']) {
            return null;
        }

        $viewData = $that->view->getData();
        if (has_value($viewData['success'])) {
            $that->view->append('success',
                ' '.$that->html->convertLinks($that->language->get('success_saved_preferences')));
        }
        $form = $that->data['form'];
        unset($form['fields']['preferences_parent']);
        $that->view->assign('form', $form);
    }

    public function onControllerResponsesCommonTabs_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject->parent_controller != 'sale/customer_group') {
            return null;
        }

        $that =& $this->baseObject;
        $that->loadLanguage('sale/customer_preferences');

        $that->data['tabs']['customer_preferences'] = [
            'name'       => 'customer_preferences',
            'text'       => $that->language->get('text_customer_preferences'),
            'href'       => $that->html->getSecureURL(
                'sale/customer_preferences/update',
                '&customer_group_id='.$that->request->get['customer_group_id']
            ),
            'active'     => $that->request->get['rt'] == 'sale/customer_preferences/update',
            'sort_order' => 1,
        ];

    }

    public function onControllerPagesSaleCustomer_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->loadLanguage('sale/customer_preferences');
        if (($that->request->is_POST())) {
            if ($this->baseObject_method==='update') {
                /** @var ModelSaleCustomerpreferences $mdl */
                $mdl = $that->load->model('sale/customer_preferences');
                $customer_id = $that->request->get['customer_id'];
                $cust_info = $that->model_sale_customer->getCustomer($customer_id);
                if ((string)$cust_info['customer_group_id'] === (string)$that->request->post['customer_group_id']) {
                    $mdl->updateCustomerPreferencesValues(
                        $that->request->get['customer_id'],
                        $that->request->post['preferences']
                    );
                } else {
                    $that->model_sale_customer_preferences->deleteCustPreferences($customer_id);
                    $preferences = $mdl->getPreferencesForCustGroup(
                        $that->request->post['customer_group_id'],
                        $that->language->getLanguageID()
                    );

                    foreach ($preferences as $pref) {
                        $exist = '-';
                        $values_number = sizeof($pref['values']);
                        foreach ($pref['values'] as $k => $v) {
                            if ($v['default'] === '1') {
                                $exist = $k;
                            }
                        }
                        foreach ($pref['values'] as $key => $val) {
                            if ($values_number === 1) {
                                $data['customer_preferences_id'] = $pref['customer_preferences_id'];
                                $data['value'] = $val['value'];
                                $that->model_sale_customer_preferences->addPreferencesToCustomer($customer_id, $data);
                            } elseif ($values_number > 1) {
                                if ((string)$exist === (string)$key || $exist === '-' && (string)$key === '0') {
                                    $data['customer_preferences_id'] = $pref['customer_preferences_id'];
                                    $data['value'] = $val['value'];
                                    $that->model_sale_customer_preferences->addPreferencesToCustomer($customer_id, $data);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public function onControllerPagesSaleCustomer_UpdateData() {
        if (!$this->_is_enabled()) {
            return;
        }
        if (!isset($this->baseObject->request->get['customer_id'])) {
            return;
        }
        if ($this->baseObject_method === 'update') {
            $that =& $this->baseObject;
            $customer_id = $that->request->get['customer_id'];
            $that->load->model('sale/customer');
            $mdl = $that->load->model('sale/customer_preferences');
            $cust_info = $that->model_sale_customer->getCustomer($customer_id);
            $exist = $mdl->getCustPreferencesByCustId($customer_id);
            if (!$exist) {
                $preferences = $mdl->getPreferencesForCustGroup(
                    $cust_info['customer_group_id'],
                    $that->language->getLanguageID()
                );
                foreach ($preferences as $pref) {
                    $exist = '-';
                    $values_number = sizeof($pref['values']);
                    foreach ($pref['values'] as $k => $v) {
                        if ($v['default'] === '1') {
                            $exist = $k;
                        }
                    }
                    foreach ($pref['values'] as $key => $val) {
                        if ($values_number === 1) {
                            $data['customer_preferences_id'] = $pref['customer_preferences_id'];
                            $data['value'] = $val['value'];
                            $that->model_sale_customer_preferences->addPreferencesToCustomer($customer_id,$data);
                        } elseif ($values_number > 1) {
                            if ((string)$exist === (string)$key || $exist ==='-' && (string)$key==='0') {
                                $data['customer_preferences_id'] = $pref['customer_preferences_id'];
                                $data['value'] = $val['value'];
                                $that->model_sale_customer_preferences->addPreferencesToCustomer($customer_id,$data);
                            }
                        }
                    }
                }
            }

            $that =& $this->baseObject;
            $this->data = $that->view->getData();
            $form = new AForm('HS');
            $form->setForm(
                [
                    'form_name' => 'cgFrm',
                    'update' => $this->data['update'],
                ]
            );

            /** @var ModelSaleCustomerpreferences $mdl */
            $mdl = $that->load->model('sale/customer_preferences');
            $customer_id = $that->request->get['customer_id'];
            $preferences = $mdl->getCustomerPreferences($customer_id);
            $customer_info = $that->model_sale_customer->getCustomer($customer_id);

            $elements = HtmlElementFactory::getAvailableElements();
            $html_multivalue_elements = HtmlElementFactory::getMultivalueElements();
            $html_elements_with_options = HtmlElementFactory::getElementsWithOptions();
            foreach ($preferences as $attribute) {
                $html_type = $elements[$attribute['element_type']]['type'];
                if (!$html_type) {
                    continue;
                }
                $values = $value = [];

                //values that was set
                if (in_array($attribute['element_type'], $html_elements_with_options)) {
                    if ($html_type == 'radio') {
                        $value = current($attribute['selected_values']);
                        $value = $value['customer_preferences_value'];
                    } else {
                        foreach ($attribute['selected_values'] as $val) {
                            $value[] = $val['customer_preferences_value'];
                        }
                    }
                } else {
                    $value = current($attribute['selected_values']);
                    $value = $value['customer_preferences_value'];
                }
                // possible values
                foreach ($attribute['values'] as $val) {
                    $values[$val['value']] = $val['value'];
                }

                $customerAttributeId = $attribute['customer_preferences_id'];
                if (!in_array($attribute['element_type'], $html_multivalue_elements)) {
                    $option_name = 'preferences[' . $customerAttributeId . ']';
                } else {
                    $option_name = 'preferences[' . $customerAttributeId . '][' . $attribute['customer_preferences_value_id'] . ']';
                }

                $option_data = [
                    'type' => $html_type,
                    'name' => $option_name,
                    'value' => $value,
                    'options' => $values,
                    'required' => $attribute['required'],
                ];

                if ($html_type == 'checkbox') {
                    $option_data['value'] = $option_data['label_text'] = current($values);
                    if ($value) {
                        $option_data['checked'] = true;
                    }
                } elseif ($html_type == 'checkboxgroup') {
                    $option_data['scrollbox'] = true;
                }

                $this->data['entry_preferences_' . $attribute['customer_preferences_id']] = $attribute['name'];

                if ($html_type == 'file') {
                    $dir = DIR_APP_SECTION . 'system/uploads/' . $attribute['settings']['directory'];
                    $dir = rtrim($dir, '/');
                    if (is_file($dir . '/' . $value) && is_readable($dir . '/' . $value)) {
                        $field_value = '<a style="display:block; padding-top: 7px;" href="' . $that->html->getSecureURL(
                                'sale/customer_preferences/download',
                                '&filename=' . urlencode($value) .
                                '&customer_preferences_id=' . (int)$attribute['customer_preferences_id'] .
                                '&customer_group_id=' . $customer_info['customer_group_id'])
                            . '" title=" to download file" target="_blank">' . $value . '</a>';

                    } else {
                        $field_value = $that->html->buildElement(
                            [
                                'type' => 'input',
                                'value' => $value,
                                'attr' => 'disabled',
                            ]
                        );

                    }
                } elseif ($html_type == 'hidden') {
                    $field_value = $value;
                } else {
                    $field_value = $that->html->buildElement($option_data);
                }
                $this->data['form']['fields']['preferences']['preferences_' . $attribute['customer_preferences_id']]
                    = $field_value;
            }

            $this->data['tab_customer_preferences'] = $that->language->get('text_customer_preferences');

            $that->view->batchAssign($this->data);
        }
    }

    public function onControllerResponsesListingGridCustomer_InitData() {
        if (!$this->_is_enabled()) {
            return;
        }
        $that =& $this->baseObject;
        if (isset($that->request->get['id']) && isset($that->request->post['preferences'])) {
            /** @var ModelSaleCustomerPreferences $mdl */
            $mdl = $that->load->model('sale/customer_preferences');
            $mdl->updateCustomerPreferencesValues(
                $that->request->get['id'],
                $that->request->post['preferences']
            );
            unset($that->request->post['preferences']);
        }
    }

    public function onControllerCommonListingGrid_InitData()  {
        /** @var ControllerPagesSaleCustomerGroup $that */
        $that =& $this->baseObject;
        if (!in_array($that->data['table_id'], ['cg_grid','order_grid'])) {
            return;
        }

        if ($that->data['table_id'] === 'order_grid') {
            $that->load->language('sale/customer_preferences');
            $that->data['actions']['dropdown']['children']['admin_invoice'] =[
                'text' => $that->language->get( 'text_admin_invoice' ),
                'href' => $that->html->getSecureURL( 'sale/admin_invoice', '&order_id=%ID%' ),
            ];
        } elseif ($that->data['table_id']==='cg_grid') {
            $editUrl = $that->html->getSecureURL('sale/customer_group/update', '&customer_group_id=%ID%');
            $attrUrl = $that->html->getSecureURL('sale/customer_preferences/update', '&customer_group_id=%ID%');
            $that->loadLanguage('customer_preferences/customer_preferences');

            if (!$that->data['actions']['dropdown']) {
                $that->data['actions']['dropdown'] = [
                    'text' => $that->language->get('text_choose_action'),
                    'href' => $editUrl,
                    'children' => [
                        'general' => [
                            'text' => $that->language->get('tab_general'),
                            'href' => $editUrl,
                        ],
                    ],
                ];
            }
            $that->data['actions']['dropdown']['children']['customer_preferences'] =
                [
                    'text' => $that->language->get('customer_preferences_name'),
                    'href' => $attrUrl,
                ];
        }
    }

    public function onControllerPagesSaleOrder_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='details') {
            $that->load->model('sale/order');
            $that->load->model('sale/customer_preferences');
            $that->load->language('customer_preferences/customer_preferences');
            $order_id = $that->request->get['order_id'];
            $order_info = $that->model_sale_order->getOrder($order_id);
            $customer_id = $order_info['customer_id'];
            $preferences = $that->model_sale_customer_preferences->getOrderPreferences($order_id,$customer_id);
            $data['preferences'] = $preferences;
            $data['text_your_preferences'] = $that->language->get('text_your_preferences','customer_preferences/customer_preferences');
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('order_pre_details', $view->fetch('pages/sale/order_details_customer_preferences_fields.tpl'));
            $data['admin_invoice_url'] = $that->html->getSecureURL('sale/admin_invoice','&order_id='.$that->request->get['order_id'] );
            $data['text_admin_invoice'] = $that->language->get('text_admin_invoice','sale/customer_preferences');
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('order_details_top_button', $view->fetch('pages/sale/admin_invoice_url.tpl'));
        }
    }

    public function onControllerResponsesListingGridCustomer_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'update') {
            $that->load->model('sale/customer_preferences');
            switch ($that->request->post['oper']) {
                case 'del':
                    $ids = explode(',', $that->request->post['id']);
                    if (!empty($ids)) {
                        foreach ($ids as $id) {
                            $that->model_sale_customer_preferences->removePreferencesByCustomerId($id);
                        }
                    }
                    break;
            }
        } elseif ($this->baseObject_method==='update_field') {
            $mdl = $that->load->model('sale/customer_preferences');
            $customer_id = (int)$that->request->get['id'] ?: null;
            if ($customer_id) {
                $mdl->deleteCustPreferences($customer_id);
                $preferences = $mdl->getPreferencesForCustGroup(
                    $that->request->post['customer_group_id'],
                    $that->language->getLanguageID()
                );

                foreach ($preferences as $pref) {
                    $exist = '-';
                    $values_number = sizeof($pref['values']);
                    foreach ($pref['values'] as $k => $v) {
                        if ($v['default'] === '1') {
                            $exist = $k;
                        }
                    }
                    foreach ($pref['values'] as $key => $val) {
                        if ($values_number === 1) {
                            $data['customer_preferences_id'] = $pref['customer_preferences_id'];
                            $data['value'] = $val['value'];
                            $that->model_sale_customer_preferences->addPreferencesToCustomer($customer_id, $data);
                        } elseif ($values_number > 1) {
                            if ((string)$exist === (string)$key || $exist === '-' && (string)$key === '0') {
                                $data['customer_preferences_id'] = $pref['customer_preferences_id'];
                                $data['value'] = $val['value'];
                                $that->model_sale_customer_preferences->addPreferencesToCustomer($customer_id, $data);
                            }
                        }
                    }
                }
            }
        }
    }

    public function onControllerResponsesSaleInvoice_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->load->model('sale/order');
            $that->load->model('sale/customer_preferences');
            $that->load->language('customer_preferences/customer_preferences');
            $order_id = $that->request->get['order_id'];
            $order_info = $that->model_sale_order->getOrder($order_id);
            $customer_id = $order_info['customer_id'];
            $preferences = $that->model_sale_customer_preferences->getOrderPreferences($order_id,$customer_id);
            $data['preferences'] = $preferences;
            $data['text_your_preferences'] = $that->language->get('text_your_preferences','customer_preferences/customer_preferences');
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('order_invoice_'.$order_id.'_top_info', $view->fetch('responses/sale/sale_invoice_customer_preferences_fields.tpl'));
        }
    }

    /** End Of Admin Section */

    /** Storefront Section */

    public function onControllerPagesAccountEdit_InitData() {
        if (!$this->_is_enabled()) {
            return;
        }
        $that =& $this->baseObject;
        $that->loadLanguage('account/customer_preferences');
        if ($that->request->is_POST()) {
            /** @var ModelSaleCustomerpreferences $mdl */
            $mdl = $that->load->model('sale/customer_preferences');
            if (has_value($that->request->files['preferences']['name'])) {
                $this->processFileUpload(0);
            }

            $errors = $mdl->validatePreferencesForEdit(
                $that->customer->getCustomerGroupId(),
                $that->request->post['preferences']
            );
            //append file upload errors
            foreach ($this->errors as $id => $err) {
                $errors[$id] = $err;
            }

            if (!empty($errors)) {
                $that->loadModel('account/customer');
                $that->session->data['base_post'] = $that->request->post;
                $that->session->data['attr_errors'] = $errors;
                $that->session->data['file_errors'] = $this->errors;
                redirect($that->html->getSecureURL('account/edit'));
            } else {
                $mdl->updateCustomerPreferencesValues(
                    $that->session->data['customer_id'],
                    $that->request->post['preferences']
                );
                
                 if ($this->verifyAutoAssigned()) {
            $that->load->model('extension/customer_group_auto_assigned');
            $customer_id = $that->customer->getId();
            $customer_group_id = $that->customer->getCustomerGroupId();
            $customer_group_info = $that->model_extension_customer_group_auto_assigned->getValues($customer_group_id);
            if ($customer_group_info['upload_tax_exemption'] === '1') {
                $accept = ["image/jpeg", "image/png", "image/gif", "application/pdf"];
                $upmime = strtolower($_FILES["upload_tax_exemption"]["type"]);
                if (in_array($upmime, $accept)) {
                    $filename = $_FILES['upload_tax_exemption']['name'];
                    $temp_name = $_FILES['upload_tax_exemption']['tmp_name'];
                    $current_year = date('Y');
                    $current_month = date('m');
                    if ($filename) {
                        if (!file_exists(DIR_IMAGE . 'customer_group_auto_assigned')) {
                            mkdir(DIR_IMAGE . 'customer_group_auto_assigned',0755);
                        }
                        if (!file_exists(DIR_IMAGE . 'customer_group_auto_assigned/files')) {
                            mkdir(DIR_IMAGE . 'customer_group_auto_assigned/files',0755);
                        }
                        if (!file_exists(DIR_IMAGE . 'customer_group_auto_assigned/files/' . $customer_id)) {
                            mkdir(DIR_IMAGE . 'customer_group_auto_assigned/files/' . $customer_id, 0755);
                        }

                        if (!file_exists(DIR_IMAGE . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year)) {
                            mkdir(DIR_IMAGE . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year, 0755);
                        }
                        if (!file_exists(DIR_IMAGE . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year . '/' . $current_month)) {
                            mkdir(DIR_IMAGE . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year . '/' . $current_month, 0755);
                        }

                        $upload_dir = DIR_IMAGE . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year . '/' . $current_month . '/';

                        // move file
                        $uploaded = move_uploaded_file($temp_name, $upload_dir . $filename);
                        
                        if ($uploaded && $filename) {
                            $data['image_url'] = 'files/' . $customer_id . '/' . $current_year . '/' . $current_month . '/' . $filename;
                            if ($that->config->get('customer_group_auto_assigned_notify_new_cert')) {
                                $this->sendNotif($that);
                            }
                        } else {
                            //$that->log->write('Unable to upload file');
                        }
                        $data['customer_id'] = $customer_id;
                        $data['customer_group_id'] = $customer_group_id;
                        $data['expire'] = $that->request->post['expire'];
                        $data['expiration_date'] = $that->request->post['expiration_date'];
                        $that->model_extension_customer_group_auto_assigned->addInfo($data);
                    }
                } else {
                    $info_id = $that->model_extension_customer_group_auto_assigned->getImage($customer_id);
                    $data['customer_group_auto_assigned_info_id'] = $info_id['customer_group_auto_assigned_info_id'];
                    $data['customer_id'] = $customer_id;
                    $data['expire'] = $that->request->post['expire'];
                    $that->customer->getFirstName().' '.$that->customer->getLastName();
                    $data['expiration_date'] = $that->request->post['expiration_date'];
                    $that->model_extension_customer_group_auto_assigned->editInfo($data);
                }
            }
        }
            }
        }
        
        
        if (isset($that->session->data['base_post'])) {
            $that->request->post = $that->session->data['base_post'];
            unset($that->session->data['base_post']);
        }
    }

     public function sendNotif($that) {
        $that =& $this->baseObject;
        $that->load->model('account/address');
        $that->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
        $mail = new AMail($that->config);
        $mail->setTo($that->config->get('store_main_email'));
        $mail->setFrom($that->config->get('store_main_email'));
        $mail->setSender($that->config->get('store_name'));
        $mail->setSubject($that->language->get('text_tax_cert_subject'));
        $admin_url = $that->html->getSecureURL('sale/tax_certificate','&customer_id='.$that->customer->getId().'&s='.ADMIN_PATH);
        $info =  $that->config->get('customer_group_auto_assigned_customer_info');
        if ($info==='customer_name') {
            $customer = $that->customer->getFirstName() . ' ' . $that->customer->getLastName();
        } else {
            $customer_address_id = $that->customer->getAddressId();
            $address_info = $that->model_account_address->getAddress($customer_address_id);
            $customer = $address_info['company'];
        }
        $url = '<a href="'.$admin_url.'" target="_blank">'.$customer.'</a>';
        $message = str_replace('[customer]',$url,$that->language->get('text_tax_cert_uploaded'));
        $mail->setHtml(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
        $mail->send();
    }

    public function onControllerPagesAccountEdit_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method==='main') {
            $that =& $this->baseObject;
            $data = [];

            /** @var ModelSaleCustomerpreferences $mdl */
            $mdl = $that->load->model('sale/customer_preferences');

            $data['text_your_preferences'] = $that->language->get('text_your_preferences');
            $attr_errors = $that->session->data['attr_errors'];
            if ($attr_errors) {
                foreach ($attr_errors as $key => $attr_error) {
                    $data['errors']['preferences_' . $key] = $attr_error;
                }
                unset($that->session->data['attr_errors']);
            }

            $preferences = $mdl->getCustomerVisiblePreferences(
                $that->customer->getCustomerGroupId()
            );

            $elements = HtmlElementFactory::getAvailableElements();
            $html_multivalue_elements = HtmlElementFactory::getMultivalueElements();
            $html_elements_with_options = HtmlElementFactory::getElementsWithOptions();

            foreach ($preferences as $attribute) {
                $html_type = $elements[$attribute['element_type']]['type'];
                if (!$html_type) {
                    continue;
                }
                $values = $value = [];
                //values that was set
                if (in_array($attribute['element_type'], $html_elements_with_options)) {
                    if ($html_type == 'radio') {
                        $value = current($attribute['selected_values']);
                        $value = stripslashes($value['customer_preferences_value']);
                    } else {
                        foreach ($attribute['selected_values'] as $val) {
                            $value[] = stripslashes($val['customer_preferences_value']);
                        }
                    }
                } else {
                    $value = current($attribute['selected_values']);
                    $value = stripslashes($value['customer_preferences_value']);
                }

                // possible values
                foreach ($attribute['values'] as $val) {
                    $values[$val['value']] = stripslashes($val['value']);
                }

                if (!in_array($attribute['element_type'], $html_multivalue_elements)) {
                    $option_name = 'preferences[' . $attribute['customer_preferences_id'] . ']';
                } else {
                    $option_name =
                        'preferences[' . $attribute['customer_preferences_id'] . '][' . $attribute['customer_preferences_value_id'] . ']';
                }

                if (isset($attribute['editable_by_customer']) && $attribute['editable_by_customer'] > 0) {
                    $disabled = '';
                    $required = $attribute['required'];
                } else {
                    $disabled = 'disabled="disabled"';
                    $required = '';
                }

                $option_data = [
                    'type' => $html_type,
                    'name' => $option_name,
                    'value' => $value,
                    'options' => $values,
                    'required' => $required,
                    'attr' => $disabled,
                ];

                if ($html_type == 'checkbox') {
                    $option_data['value'] = $option_data['label_text'] = current($values);
                    if ($value) {
                        $option_data['checked'] = true;
                    }
                } elseif ($html_type == 'checkboxgroup') {
                    $option_data['scrollbox'] = true;
                }

                $data['entry_preferences_' . $attribute['customer_preferences_id']] = $attribute['name'];
                $data['preferences']['preferences_' . $attribute['customer_preferences_id']] =
                    $that->html->buildElement($option_data);
            }

            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('customer_attributes', $view->fetch('pages/account/preferences_edit.tpl'));
        }
    }

    public function onControllerPagesAccountCreate_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        /** @var ModelSaleCustomerPreferences $mdl */
        if ($that->request->is_POST()) {
            $customer_id= $that->data['customer_id'];
            $mdl = $that->load->model('sale/customer_preferences');
            $preferences = $mdl->getPreferencesForGroup(
                $that->config->get('config_customer_group_id'),
                $that->language->getLanguageID()
            );

            foreach ($preferences as $pref) {
                $exist = '-';
                $values_number = sizeof($pref['values']);
                foreach ($pref['values'] as $k => $v) {
                    if ($v['default']==='1') {
                        $exist = $k;
                    }
                }
                foreach ($pref['values'] as $key => $val) {
                    if ($values_number === 1) {
                        $data['customer_preferences_id'] = $pref['customer_preferences_id'];
                        $data['value'] = $val['value'];
                        $that->model_sale_customer_preferences->addPreferencesToCustomer($customer_id,$data);
                    } elseif ($values_number > 1) {
                        if ((string)$exist === (string)$key || $exist ==='-' && (string)$key==='0') {
                            $data['customer_preferences_id'] = $pref['customer_preferences_id'];
                            $data['value'] = $val['value'];
                            $that->model_sale_customer_preferences->addPreferencesToCustomer($customer_id,$data);
                        }
                    }
                }
            }
        }
    }

    public function onControllerPagesAccountEdit_ProcessData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if (isset($that->session->data['account_edit_redirect_url'])) {
            //redirect($that->html->getSecureURL($that->session->data['account_edit_redirect_url']));
            unset($that->session->data['account_edit_redirect_url']);
        }
    }

    protected function processFileUpload($customer_id) {
        $that =& $this->baseObject;
        $fm = new AFile();
        /** @var ModelSaleCustomerpreferences $mdl */
        $mdl = $that->load->model('sale/customer_preferences');
        $customer_id = !$customer_id ? $that->customer->getId() : $customer_id;
        foreach ($that->request->files['preferences']['name'] as $id => $name) {
            $preferences_data = $mdl->getPreferencesInfo($id);
            if ($preferences_data['required'] && !has_value($name)) {
                $this->errors[$id] = $that->language->get('error_required');
            } else {
                if (!has_value($name)) {
                    continue;
                }

                $name = $customer_id.'_'.$name; //adds customer_id to set filename unique per customer
                $file_path_info = $fm->getUploadFilePath($preferences_data['settings']['directory'], $name);
                $mdl->addPreferencesToCustomer($customer_id, [$id => $name]);

                $file_data = [
                    'option_id' => $id,
                    'name'      => $file_path_info['name'],
                    'path'      => $file_path_info['path'],
                    'type'      => $that->request->files['preferences']['type'][$id],
                    'tmp_name'  => $that->request->files['preferences']['tmp_name'][$id],
                    'error'     => $that->request->files['preferences']['error'][$id],
                    'size'      => $that->request->files['preferences']['size'][$id],
                ];

                $file_errors = $fm->validateFileOption($preferences_data['settings'], $file_data);
                if (has_value($file_errors)) {
                    $this->errors[$id] = $file_errors[0];
                }

                if (!has_value($this->errors)) {
                    move_uploaded_file($file_data['tmp_name'], $file_path_info['path']);
                    $dataset = new ADataset('file_uploads', 'admin');
                    $dataset->addRows(
                        [
                            'date_added' => date("Y-m-d H:i:s", time()),
                            'name'       => $file_path_info['name'],
                            'type'       => $file_data['type'],
                            'section'    => 'customer_preferences',
                            'section_id' => $preferences_data['preferences_id'],
                            'path'       => $file_path_info['path'],
                        ]
                    );
                }
            }
        }
    }

    public function onControllerResponsesCheckoutPay_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            if ($that->customer->isLogged()) {
                unset($that->session->data['account_edit_redirect_url']);
                $that->session->data['account_edit_redirect_url'] = 'checkout/fast_checkout';
                $that->load->model('sale/customer_preferences');
                $that->load->language('account/customer_preferences');
                $customer_id = $that->customer->getId();
                $preferences = $that->model_sale_customer_preferences->getPreferencesByCustId($customer_id,'fast_checkout');
                if ($preferences) {
                    $data['preferences'] = $preferences;
                    $data['text_your_preferences'] = $that->language->get('text_your_preferences','account/customer_preferences');
                } else {
                    $mdl = $that->load->model('sale/customer_preferences');
                    $preferences = $mdl->getPreferencesForGroup(
                        $that->customer->getCustomerGroupId(),
                        $that->language->getLanguageID()
                    );

                    foreach ($preferences as $pref) {
                        $exist = '-';
                        $values_number = sizeof($pref['values']);
                        foreach ($pref['values'] as $k => $v) {
                            if ($v['default']==='1') {
                                $exist = $k;
                            }
                        }
                        foreach ($pref['values'] as $key => $val) {
                            if ($values_number === 1) {
                                $data['customer_preferences_id'] = $pref['customer_preferences_id'];
                                $data['value'] = $val['value'];
                                $that->model_sale_customer_preferences->addPreferencesToCustomer($customer_id,$data);
                            } elseif ($values_number > 1) {
                                if ((string)$exist === (string)$key || $exist ==='-' && (string)$key==='0') {
                                    $data['customer_preferences_id'] = $pref['customer_preferences_id'];
                                    $data['value'] = $val['value'];
                                    $that->model_sale_customer_preferences->addPreferencesToCustomer($customer_id,$data);
                                }
                            }
                        }
                    }
                    $preferences = $that->model_sale_customer_preferences->getPreferencesByCustId($customer_id,'shipping');
                    $data['preferences'] = $preferences;
                    $data['text_your_preferences'] = $that->language->get('text_your_preferences','account/customer_preferences');
                }
                $view = new AView($this->registry, 0);
                $view->batchAssign($data);
                $that->view->addHookVar('customer_additional_attributes', $view->fetch('pages/account/fc_preferences_fields.tpl'));
            }
        }
    }

    public function onControllerPagesCheckoutShipping_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            if ($that->customer->isLogged()) {
                unset($that->session->data['account_edit_redirect_url']);
                $that->session->data['account_edit_redirect_url'] = 'checkout/shipping';
                $that->load->model('sale/customer_preferences');
                $that->load->language('account/customer_preferences');
                $customer_id = $that->customer->getId();
                $preferences = $that->model_sale_customer_preferences->getPreferencesByCustId($customer_id,'shipping');
                if ($preferences) {
                    $data['preferences'] = $preferences;
                    $data['text_your_preferences'] = $that->language->get('text_your_preferences','account/customer_preferences');
                } else {
                    $mdl = $that->load->model('sale/customer_preferences');
                    $preferences = $mdl->getPreferencesForGroup(
                        $that->customer->getCustomerGroupId(),
                        $that->language->getLanguageID()
                    );

                    foreach ($preferences as $pref) {
                        $exist = '-';
                        $values_number = sizeof($pref['values']);
                        foreach ($pref['values'] as $k => $v) {
                            if ($v['default']==='1') {
                                $exist = $k;
                            }
                        }
                        foreach ($pref['values'] as $key => $val) {
                            if ($values_number === 1) {
                                $data['customer_preferences_id'] = $pref['customer_preferences_id'];
                                $data['value'] = $val['value'];
                                $that->model_sale_customer_preferences->addPreferencesToCustomer($customer_id,$data);
                            } elseif ($values_number > 1) {
                                if ((string)$exist === (string)$key || $exist ==='-' && (string)$key==='0') {
                                    $data['customer_preferences_id'] = $pref['customer_preferences_id'];
                                    $data['value'] = $val['value'];
                                    $that->model_sale_customer_preferences->addPreferencesToCustomer($customer_id,$data);
                                }
                            }
                        }
                    }
                    $preferences = $that->model_sale_customer_preferences->getPreferencesByCustId($customer_id,'shipping');
                    $data['preferences'] = $preferences;
                    $data['text_your_preferences'] = $that->language->get('text_your_preferences','account/customer_preferences');
                }
                $view = new AView($this->registry, 0);
                $view->batchAssign($data);
                $that->view->addHookVar('order_attributes', $view->fetch('pages/checkout/shipping_preferences_fields.tpl'));
            }
        }
    }

    public function onControllerPagesCheckoutConfirm_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            if ($that->customer->isLogged()) {
                unset($that->session->data['account_edit_redirect_url']);
                $that->session->data['account_edit_redirect_url'] = 'checkout/confirm';
                $that->load->model('sale/customer_preferences');
                $that->load->language('account/customer_preferences');
                $customer_id = $that->customer->getId();
                $preferences = $that->model_sale_customer_preferences->getPreferencesByCustId($customer_id,'checkout_confirm');
                $data['preferences'] = $preferences;
                $data['text_your_preferences'] = $that->language->get('text_your_preferences','account/customer_preferences');
                $view = new AView($this->registry, 0);
                $view->batchAssign($data);
                $that->view->addHookVar('order_pre_attributes', $view->fetch('pages/checkout/confirm_preferences_fields.tpl'));
            }
        }
    }

    public function beforeModelCheckoutOrder_ProcessData()  {
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'sf_order_confirm_mail') {
            if ($that->customer->isLogged()) {
                $that->load->language('account/customer_preferences');
                $that->load->model('sale/customer_preferences');
                $customer_id = $that->customer->getId();
                $preferences = $that->model_sale_customer_preferences->getPreferencesByCustId($customer_id,'confirmation_email');
                $that->load->model('sale/customer_preferences');
                $order_id = $that->data['mail_template_data']['order_id'];
                $data['preferences'] = $preferences;
                $data['text_your_preferences'] = $that->language->get('text_your_preferences', 'account/customer_preferences');
                $invoice_preferences = $that->model_sale_customer_preferences->getPreferencesByCustId($customer_id,'invoice');
                $that->model_sale_customer_preferences->saveOrderPreferences($order_id,$customer_id,$invoice_preferences);
                //$admin_invoice_preferences = $that->model_sale_customer_preferences->getPreferencesByCustId($customer_id,'admin_invoice');
                //$that->model_sale_customer_preferences->saveOrderPreferences($order_id,$customer_id,$admin_invoice_preferences);
                $view = new AView($this->registry, 0);
                $view->batchAssign($data);
                $that->data['mail_template_data']['customer_preferences'] = $view->fetch('pages/checkout/order_preferences_fields.tpl');
            }
        }
    }
    
    public function onControllerPagesAccountOrderDetails_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->loadModel('account/order');
            $that->loadModel('extension/fast_checkout');
            $that->loadModel('sale/customer_preferences');
            $that->load->language('account/customer_preferences');
            $order_id = 0;
            if ($that->customer->isLogged()) {
                //logged in customer, missing order ID?
                $order_id = (int) $that->request->get['order_id'];
                if (!$order_id) {
                    redirect($that->html->getSecureURL('account/history'));
                    return;
                }
                $order_info = $that->model_account_order->getOrder($order_id);
                if ($order_info) {
                    $customer_id = $that->customer->getId();
                    $preferences = $that->model_sale_customer_preferences->getOrderPreferences($order_id,$customer_id);
                    if ($preferences['show_admin_invoice']==0) {
                        $data['preferences'] = $preferences;
                        $data['text_your_preferences'] = $that->language->get('text_your_preferences', 'account/customer_preferences');
                        $view = new AView($this->registry, 0);
                        $view->batchAssign($data);
                        $that->view->addHookVar('order_pre_attributes', $view->fetch('pages/account/fc_invoice_preferences_fields.tpl'));
                    }
                }
            }
        }
    }

    public function onControllerPagesAccountInvoice_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->loadModel('account/customer');
            $that->load->model('account/order');
            $that->load->model('sale/customer_preferences');
            $that->load->language('account/customer_preferences');

            $order_id = (int) $that->request->get['order_id'];
            $guest = false;

            $enc = new AEncryption($that->config->get('encryption_key'));
            if (isset($that->request->get['ot']) && $that->config->get('config_guest_checkout')) {
                //try to decrypt order token
                $order_token = $that->request->get['ot'];
                if ($order_token) {
                    list($order_id, $email) = $that->model_account_customer->parseOrderToken($order_token);
                    if ($order_id && $email) {
                        $guest = true;
                        $order_info = $that->model_account_order->getOrder($order_id, '', 'view');
                    }
                }
            }

            if ($that->request->is_POST() && $this->_validate()) {
                $guest = true;
                $order_id = $that->request->post['order_id'];
                $email = $that->request->post['email'];
                $order_info = $that->model_account_order->getOrder($order_id);

                //compare emails
                if ($order_info['email'] != $email) {
                    unset($order_info, $order_id, $email);
                }
            }

            if (!$that->customer->isLogged() && !$guest) {
                $that->session->data['redirect'] = $that->html->getSecureURL('account/invoice', '&order_id=' . $order_id);
                $this->getInvoiceForm();
                return null;
            }

            if (!$order_id && $that->customer->isLogged()) {
                redirect($that->html->getSecureURL('account/history'));
            }

            //get info for registered customers
            if (!$order_info) {
                $order_info = $that->model_account_order->getOrder($order_id);
            }

            if ($order_info) {
                $customer_id = $order_info['customer_id'];
                $order_id = $order_info['order_id'];
                $preferences = $that->model_sale_customer_preferences->getOrderPreferences($order_id,$customer_id);
                if ($preferences['show_admin_invoice']==0) {
                    $data['preferences'] = $preferences;
                    $data['text_your_preferences'] = $that->language->get('text_your_preferences', 'account/customer_preferences');
                    $view = new AView($this->registry, 0);
                    $view->batchAssign($data);
                    $that->view->addHookVar('order_pre_attributes', $view->fetch('pages/account/invoice_preferences_fields.tpl'));
                }
            }
        }
    }

    public function onModelAccountCustomer_ProcessData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='sf_account_welcome_mail' || $this->baseObject_method==='sf_account_activation_mail' ) {
            $that->load->language('account/customer_preferences');
            $account_edit_redirect_url = $that->html->getSecureURL('account/edit');
            $that->data['mail_template_data']['account_edit_url'] = '<a href="'.$account_edit_redirect_url.'">'.$that->language->get('text_here','account/customer_preferences').'</a>';
        }
    }

    public function onModelExtensionCustomerGroupAutoAssigned_ProcessData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='sf_account_welcome_mail' || $this->baseObject_method==='sf_account_activation_mail' ) {
            $that->load->language('account/customer_preferences');
            $account_edit_redirect_url = $that->html->getSecureURL('account/edit');
            $that->data['mail_template_data']['account_edit_url'] = '<a href="'.$account_edit_redirect_url.'">'.$that->language->get('text_here','account/customer_preferences').'</a>';
        }
    }

    private function getInvoiceForm() {
        $that =& $this->baseObject;
        $that->document->resetBreadcrumbs();

        $that->document->addBreadcrumb([
            'href' => $that->html->getURL('index/home'),
            'text' => $that->language->get('text_home'),
            'separator' => false
        ]);

        $that->document->addBreadcrumb([
            'href' => $that->html->getURL('account/account'),
            'text' => $that->language->get('text_account'),
            'separator' => $that->language->get('text_separator')
        ]);

        $that->document->addBreadcrumb([
            'href' => $that->html->getURL('account/invoice'),
            'text' => $that->language->get('heading_title'),
            'separator' => $that->language->get('text_separator')
        ]);

        $this->data['back'] = $that->html->getHomeURL();

        $form = new AForm();
        $form->setForm(['form_name' => 'CheckOrderFrm']);

        $this->data['form']['form_open'] = $form->getFieldHtml(
            [
                'type' => 'form',
                'name' => 'CheckOrderFrm',
                'action' => $that->html->getSecureURL('account/invoice'),
                'csrf' => true
            ]);

        $order_id = (int)$that->request->post['order_id'] ? (int)$that->request->post['order_id'] : '';
        $this->data['form']['order_id'] = $form->getFieldHtml(
            [
                'type' => 'input',
                'name' => 'order_id',
                'value' => $order_id,
                'required' => true]);

        $this->data['entry_order_id'] = $that->language->get('text_order_id');

        $this->data['form']['email'] = $form->getFieldHtml(
            [
                'type' => 'input',
                'name' => 'email',
                'value' => $that->request->post['email'],
                'required' => true]);

        $this->data['entry_email'] = $that->language->get('text_email');

        $this->data['form']['back'] = $form->getFieldHtml(
            [
                'type' => 'button',
                'name' => 'back',
                'text' => $that->language->get('button_back'),
                'icon' => 'fa fa-arrow-left',
                'style' => 'button']);

        $this->data['form']['submit'] = $form->getFieldHtml(
            [
                'type' => 'submit',
                'icon' => 'fa fa-check',
                'name' => $that->language->get('button_continue')
            ]);

        $that->view->batchAssign($this->data);
        $that->processTemplate('pages/account/order.tpl');
    }

    private function _validate() {
        $that =& $this->baseObject;
        if (!(int)$that->request->post['order_id']){
            $this->error['order_id'] = $that->language->get('error_order_id');
        }

        if (mb_strlen($that->request->post['email']) > 96 || !preg_match(EMAIL_REGEX_PATTERN, $that->request->post['email'])){
            $this->error['email'] = $that->language->get('error_email');
        }

        $that->extensions->hk_ValidateData($this);

        return !$this->error ? true : false;
    }

    /** End Of Storefront Section */
}