<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerPagesSaleCustomerPreferences
 *
 * @property ModelSaleCustomerPreferences $model_sale_customer_preferences
 */
class ControllerPagesSaleCustomerPreferences extends AController {
    public $error = [];
    /** @var AAttribute_Manager */
    protected $attribute_manager;

    public function main() {
        $this->loadModel('sale/customer_preferences');

        if ($this->request->is_POST() && $this->_validateForm()) {
            $data = $this->request->post;
            $customer_preferences_id = $this->model_sale_customer_preferences->addCustomerPreferences(
                $this->request->get['customer_group_id'],
                $data
            );

            $data['customer_preferences_id'] = $customer_preferences_id;
            $this->model_sale_customer_preferences->addPreferencesToGroup($this->request->get['customer_group_id'], $data);
            redirect(
                $this->html->getSecureURL(
                    'sale/customer_preferences/update',
                    '&customer_group_id='.$this->request->get['customer_group_id']
                )
            );
        }
    }

    public function update() {
        $this->loadLanguage('sale/customer_preferences');
        $this->document->setTitle($this->language->get('text_customer_preferences'));
        $this->document->initBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('index/home', '', true),
                'text'      => $this->language->get('text_home'),
                'separator' => false,
            ]
        );

        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('sale/customer_group', '', true),
                'text'      => $this->language->get('breadcrumb_customer_groups'),
                'separator' => ' :: ',
            ]
        );

        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL(
                    'sale/customer_group/update',
                    '&customer_group_id='.$this->request->get['customer_group_id'],
                    true
                ),
                'text'      => $this->language->get('breadcrumb_edit_group'),
                'separator' => ' :: ',
            ]
        );

        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL(
                    'sale/customer_preferences/update',
                    '&customer_group_id='.$this->request->get['customer_group_id'],
                    true
                ),
                'text'      => $this->language->get('text_customer_preferences'),
                'separator' => ' :: ',
                'current'   => true,
            ]
        );

        $this->data['heading_title'] = $this->language->get('text_customer_preferences');

        $tabs['general'] = [
            'name'       => 'customer_group_edit',
            'text'       => $this->language->get('tab_general'),
            'href'       => $this->html->getSecureURL(
                'sale/customer_group/update',
                '&customer_group_id='.$this->request->get['customer_group_id'],
                true
            ),
            'sort_order' => 0,
        ];

        $tabs['customer_preferences'] = [
            'name'       => 'customer_preferences',
            'text'       => $this->language->get('text_customer_preferences'),
            'href'       => $this->html->getSecureURL(
                'sale/customer_preferences/update',
                '&customer_group_id='.$this->request->get['customer_group_id'],
                true
            ),
            'active'     => true,
            'class'      => 'active', //deprecated since 1.2.2!
            'sort_order' => 1,
        ];

        $obj = $this->dispatch(
            'responses/common/tabs',
            [
                'sale/customer_group',
                //parent controller. Use customer group to use for other extensions that will add tabs via their hooks
                ['tabs' => $tabs],
            ]
        );
        $this->data['tabs'] = $obj->dispatchGetOutput();

        $this->data['text_customer_preferences'] = $this->language->get('text_customer_preferences');
        $this->data['error_required'] = $this->language->get('error_required');

        $this->loadModel('sale/customer_preferences');

        $this->data['group_attributes'] = [];
        if ($this->request->get['customer_group_id']) {
            $group_attributes = $this->model_sale_customer_preferences->getPreferencesForGroup(
                $this->request->get['customer_group_id'],
                $this->language->getContentLanguageID()
            );
            $options = [];
            foreach ($group_attributes as $row) {
                $options[$row['customer_preferences_id']] = $row['name'];
            }
            $this->data['group_attributes'] = $this->html->buildElement(
                [
                    'type'    => 'selectbox',
                    'name'    => 'customer_preferences_id',
                    'options' => $options,
                ]
            );
        }

        $attributes = ['new' => $this->language->get('text_add_new_preferences')];

        $this->attribute_manager = new AAttribute_Manager();
        $results = $this->attribute_manager->getAttributes(
            [
                'search' => " ga.attribute_type_id = '".$this->attribute_manager->getAttributeTypeID(
                        'customer_preferences'
                    )."'
                AND ga.status = 1
                AND ga.attribute_parent_id = 0 ",
            ],
            $this->language->getContentLanguageID()
        );

        foreach ($results as $type) {
            $attributes[$type['attribute_id']] = $type['name'];
        }

        $form = new AForm('HT');

        $form->setForm(
            [
                'form_name' => 'new_attribute_form',
                'update'    => '',
            ]
        );

        $this->data['action'] = $this->html->getSecureURL(
            'sale/customer_preferences',
            '&customer_group_id='.$this->request->get['customer_group_id']
        );

        $this->data['form']['form_open'] = $form->getFieldHtml(
            [
                'type'   => 'form',
                'name'   => 'attributes_form',
                'action' => $this->data['action'],
                'attr'   => 'data-confirm-exit="true"  class="form-horizontal"',
            ]
        );

        $this->data['attributes'] = $form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'global_attribute_id',
                'options' => $attributes,
                'style'   => 'chosen',
            ]
        );

        $this->data['form']['submit'] = $form->getFieldHtml(
            [
                'type'  => 'button',
                'name'  => 'submit',
                'text'  => $this->language->get('button_add_preferences'),
                'style' => 'button1',
            ]
        );

        $this->data['button_reset'] = $this->html->buildButton(
            [
                'text'  => $this->language->get('button_reset'),
                'style' => 'button2',
            ]
        );

        $results = HtmlElementFactory::getAvailableElements();
        $element_types = ['' => $this->language->get('text_select')];
        foreach ($results as $key => $type) {
            // allowed field types
            if (in_array($key, ['I', 'T', 'S', 'M', 'R', 'C', 'G', 'H', 'U'])) {
                $element_types[$key] = $type['type'];
            }
        }

        $this->data['entry_attribute_name'] = $this->language->get('entry_attribute');
        $this->data['attribute_name'] = $form->getFieldHtml(
            [
                'type'     => 'input',
                'name'     => 'name',
                'required' => true,

            ]
        );

        $this->data['status'] = $form->getFieldHtml(
            [
                'type'  => 'checkbox',
                'name'  => 'status',
                'value' => 1,
                'style' => 'btn_switch',
            ]
        );

        $this->data['sort_order'] = $form->getFieldHtml(
            [
                'type'  => 'input',
                'name'  => 'sort_order',
                'style' => 'small-field',
            ]
        );

        $this->data['required'] = $form->getFieldHtml(
            [
                'type'  => 'checkbox',
                'name'  => 'required',
                'value' => 1,
            ]
        );

        $this->data['entry_element_type'] = $this->language->get('entry_element_type');
        $this->data['element_type'] = $form->getFieldHtml(
            [
                'type'     => 'selectbox',
                'name'     => 'element_type',
                'required' => true,
                'options'  => $element_types,
            ]
        );

        $this->data['urls'] = [];
        $this->data['urls']['get_attributes_list'] = $this->html->getSecureURL(
            'sale/customer_preferences_response/get_attributes_list',
            '&customer_group_id='.$this->request->get['customer_group_id']
        );
        $this->data['urls']['load_attribute'] = $this->html->getSecureURL(
            'sale/customer_preferences_response/load_attribute',
            '&customer_group_id='.$this->request->get['customer_group_id']
        );
        $this->data['urls']['update_attribute'] = $this->html->getSecureURL(
            'sale/customer_preferences_response/update_attribute',
            '&customer_group_id='.$this->request->get['customer_group_id']
        );
        $this->data['add_attribute_url'] = $this->html->getSecureURL(
            'catalog/attribute/insert',
            '&attribute_type_id='.$this->attribute_manager->getAttributeTypeID('customer_preferences')
        );
        $this->data['text_success_preferences'] = $this->language->get('text_success_preferences');
        $this->data['form_language_switch'] = $this->html->getContentLanguageSwitcher();

        $this->view->batchAssign($this->data);
        $this->processTemplate('pages/sale/preferences_form.tpl');
    }

    private function _validateForm()
    {
        if (!$this->user->hasPermission('modify', 'sale/customer_preferences')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        $this->extensions->hk_ValidateData($this);
        return (!$this->error);
    }

    public function download() {
        $this->loadModel('sale/customer_preferences');

        $attribute_data = $this->model_sale_customer_preferences->getPreferencesInfo(
            $this->request->get['customer_preferences_id'], $this->request->get['customer_group_id']
        );
        $attribute_data = $attribute_data[0];
        $filename = str_replace(['../', '..\\', '\\', '/'], '', $this->request->get['filename']);

        if (has_value($attribute_data['settings']['directory'])) {
            $file = DIR_APP_SECTION.'system/uploads/'.$attribute_data['settings']['directory'].'/'.$filename;
        } else {
            $file = DIR_APP_SECTION.'system/uploads/'.$filename;
        }

        if (file_exists($file)) {
            header('Content-Description: File Transfer');
            header('Content-Type: '.mime_content_type($filename));
            header('Content-Disposition: attachment; filename='.str_replace(' ', '_', $filename));
            header('Content-Transfer-Encoding: binary');
            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            header('Content-Length: '.filesize($file));
            ob_clean();
            flush();
            readfile($file);
        } else {
            echo 'File '.$file.' does not exists!';
        }
        exit;
    }

}