<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

$mc_server_url = "https://abantecartplus.com/clientarea/plugin/license_manager/validate/";
$diy_server_url = "https://wehearyou2.com/clientarea/plugin/license_manager/validate/";
$shared_secret = "customer_group_auto_assigned";

$public_key = "";
$path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";

if ($this->config->get('customer_group_auto_assigned_license_code')) {
    $license_key = $this->config->get('customer_group_auto_assigned_license_code');
    $license = new License($path_to_phpseclib);
    $license_manager = $license->getManager();
    if (stripos($license_key, 'mc-') !== false) {
        $server_url = $mc_server_url;
    } else {
        $server_url = $diy_server_url;
    }
    $license_manager->setLicenseServerUrl($server_url);
    $license_manager->setKeys($license_key, "", $shared_secret);
    $public_key = $license_manager->requestKey();
    $this->load->model('extension/customer_group_auto_assigned_license_info');

    $store_id = (int)$this->config->get('config_store_id');

    $license_manager->setKeys($license_key, $public_key, $shared_secret);
    $custom_data = ['version' => '1.3.4.1'];
    $license_data = $license_manager->requestData($custom_data);
    if (!is_null($license_data)) {
        $ttl = 1209600;
        $validate = $license_manager->validate($license_data, $ttl);

        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
            $data['public_key'] = $public_key;
            $data['license_data'] = $license_data;
            $data['license_key'] = $license_key;
            $data['store_id'] = $store_id;
            $data['last_check'] = time();
            $this->load->model('extension/customer_group_auto_assigned_license_info');
            $this->model_extension_customer_group_auto_assigned_license_info->saveLicenseData($data);
        }
    }
}

$language_id = $this->language->getContentLanguageID();
$rm = new AResourceManager();
$rm->setType('image');
$menu = new AMenu ( "admin" );
$menu->deleteMenuItem ("tax_exempt_certificate_list");

$data = [];
$data['resource_code'] = '<i class="fa fa-file-text"></i>&nbsp;';
$data['name'] = [$language_id => 'Menu Icon Tax Exempt Certificate'];
$data['title'] = [$language_id => ''];
$data['description'] = [$language_id => ''];
$resource_id = $rm->addResource($data);

$menu = new AMenu ( "admin" );
$menu->insertMenuItem ( [ "item_id" => "tax_exempt_certificate",
        "parent_id" => "",
        "item_text" => "Tax Exempt Certificate",
        "item_url" => "",
        "item_type"=>"core",
        "sort_order"=>"",
        "item_icon_rl_id" => $resource_id
    ]
);

$menu->insertMenuItem ( [ "item_id" => "tax_exempt_certificate_list",
        "parent_id" => "tax_exempt_certificate",
        "item_text" => "Tax Exempt Certificate List",
        "item_url" => "extension/tax_exempt_certificate_list",
        "item_type"=>"core",
        "sort_order"=>"",
        "item_icon_rl_id" => $resource_id
    ]
);

$menu->insertMenuItem ( [ "item_id" => "expired_tax_exempt_certificate_list",
        "parent_id" => "tax_exempt_certificate",
        "item_text" => "Expired Tax Exempt Certificate List",
        "item_url" => "extension/expired_tax_cert",
        "item_type"=>"core",
        "sort_order"=>"",
        "item_icon_rl_id" => $resource_id
    ]
);

$check1= "SHOW columns from ".$this->db->table('customer_group_auto_assigned_values')." where field='upload_later'";
$q1=$this->db->query($check1);
$exist1=count($q1->rows);
if ($exist1==0) {
    $sql11 = "ALTER TABLE ".$this->db->table('customer_group_auto_assigned_values')." ADD `upload_later` CHAR(1) COLLATE utf8_general_ci AFTER `custom_email`";
    $this->db->query($sql11);
}

$check4= "SHOW columns from ".$this->db->table('customer_group_auto_assigned_values')." where field='show_tax_exempt_status'";
$q4=$this->db->query($check4);
$exist4=count($q4->rows);
if ($exist4==0) {
    $sql14 = "ALTER TABLE ".$this->db->table('customer_group_auto_assigned_values')." ADD `show_tax_exempt_status` SMALLINT(1) COLLATE utf8_general_ci AFTER `upload_later`";
    $this->db->query($sql14);
}

$check5= "SHOW columns from ".$this->db->table('customer_group_auto_assigned_values')." where field='no_tax_exemption_message'";
$q5=$this->db->query($check5);
$exist5=count($q5->rows);
if ($exist5==0) {
    $sql15 = "ALTER TABLE ".$this->db->table('customer_group_auto_assigned_values')." ADD `no_tax_exemption_message` TEXT COLLATE utf8_general_ci AFTER `show_tax_exempt_status`";
    $this->db->query($sql15);
}

$check6= "SHOW columns from ".$this->db->table('customer_group_auto_assigned_values')." where field='show_checkout_confirm'";
$q6=$this->db->query($check6);
$exist6=count($q6->rows);
if ($exist6==0) {
    $sql16 = "ALTER TABLE ".$this->db->table('customer_group_auto_assigned_values')." ADD `show_checkout_confirm` SMALLINT(1) COLLATE utf8_general_ci AFTER `no_tax_exemption_message`";
    $this->db->query($sql16);
}

$check7= "SHOW columns from ".$this->db->table('customer_group_auto_assigned_values')." where field='show_fast_checkout'";
$q7=$this->db->query($check7);
$exist7=count($q7->rows);
if ($exist7==0) {
    $sql17 = "ALTER TABLE ".$this->db->table('customer_group_auto_assigned_values')." ADD `show_fast_checkout` SMALLINT(1) COLLATE utf8_general_ci AFTER `show_checkout_confirm`";
    $this->db->query($sql17);
}

$check8= "SHOW columns from ".$this->db->table('customer_group_auto_assigned_values')." where field='show_invoice'";
$q8=$this->db->query($check8);
$exist8=count($q8->rows);
if ($exist8==0) {
    $sql18 = "ALTER TABLE ".$this->db->table('customer_group_auto_assigned_values')." ADD `show_invoice` SMALLINT(1) COLLATE utf8_general_ci AFTER `show_fast_checkout`";
    $this->db->query($sql18);
}

$check9= "SHOW columns from ".$this->db->table('customer_group_auto_assigned_values')." where field='show_confirmation_email'";
$q9=$this->db->query($check9);
$exist9=count($q9->rows);
if ($exist9==0) {
    $sql10= "ALTER TABLE ".$this->db->table('customer_group_auto_assigned_values')." ADD `show_confirmation_email` SMALLINT(1) COLLATE utf8_general_ci AFTER `show_invoice`";
    $this->db->query($sql10);
}

$check19= "SHOW columns from ".$this->db->table('customer_group_auto_assigned_info')." where field='verified'";
$q19=$this->db->query($check19);
$exist19=count($q19->rows);
if ($exist19==0) {
    $sql20= "ALTER TABLE ".$this->db->table('customer_group_auto_assigned_info')." ADD `verified` CHAR(1) COLLATE utf8_general_ci AFTER `upload_later`";
    $this->db->query($sql20);
}

$check20= "SHOW columns from ".$this->db->table('customer_group_auto_assigned_info')." where field='verified_by'";
$q20=$this->db->query($check20);
$exist20=count($q20->rows);
if ($exist20==0) {
    $sql21= "ALTER TABLE ".$this->db->table('customer_group_auto_assigned_info')." ADD `verified_by` VARCHAR(64) COLLATE utf8_general_ci AFTER `verified`";
    $this->db->query($sql21);
}

$check21= "SHOW columns from ".$this->db->table('customer_group_auto_assigned_info')." where field='verified_date'";
$q21=$this->db->query($check21);
$exist21=count($q21->rows);
if ($exist21==0) {
    $sql22= "ALTER TABLE ".$this->db->table('customer_group_auto_assigned_info')." ADD `verified_date` DATETIME NULL COLLATE utf8_general_ci AFTER `verified_by`";
    $this->db->query($sql22);
}

$check21= "SHOW columns from ".$this->db->table('customer_group_auto_assigned_info')." where field='comment'";
$q21=$this->db->query($check21);
$exist21=count($q21->rows);
if ($exist21==0) {
    $sql22= "ALTER TABLE ".$this->db->table('customer_group_auto_assigned_info')." ADD `comment`TEXT COLLATE utf8_general_ci AFTER `verified_date`";
    $this->db->query($sql22);
}

$sql11 = "SELECT `store_id` FROM " . $this->db->table("stores");
$query11 = $this->db->query($sql11);
$results11 = $query11->rows;

if (file_exists(DIR_EXT.'email_editor') && $this->config->get('email_editor_status')) {

    $sql12='CREATE TABLE IF NOT EXISTS ' . $this->db->table('email_editor_customer_group') . ' (
`email_editor_customer_group_id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
`email_template_id` int(11),
`customer_group_id` int(11),
`section_name` VARCHAR(256)
)ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci';

    $this->db->query($sql12);

    foreach ($results11 as $result) {
        $store_id = $result["store_id"];

        $query_customer_groups = $this->db->query("SELECT * FROM " . $this->db->table("customer_groups"));
        $customer_groups = $query_customer_groups->rows;
        foreach ($customer_groups as $cust_group) {
            $search = [" ", "'",];
            $replace = "_";
            $section = str_replace($search, $replace, strtolower($cust_group['name']));

            $account_activated_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='" . $section . "_account_create' AND `store_id`=" . $store_id);
            if ($account_activated_exist->row['total'] === '0') {
                $account_activated = $this->db->query("SELECT * FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_create'");
                $account_activated_info = $account_activated->row;
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_templates') . "  
                          SET `section` = '" . $section . "_account_create', 
                          `sender_name`='" . $account_activated_info['sender_name'] . "',`sender_email`='" . $account_activated_info['sender_email'] . "',`subject`='" . $account_activated_info['subject'] . "', 
                          `default_subject`='" . $account_activated_info['default_subject'] . "',
                          `content` = '" . $account_activated_info['content'] . "', 
                          `default_content` = '" . $account_activated_info['default_content'] . "',`email_signature_id` = '" . $account_activated_info['email_signature_id'] . "',
                          `notify_admin`='" . $account_activated_info['notify_admin'] . "', `store_id`='" . $store_id . "'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
                $account_create_email_id = $this->db->getLastId();
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=" . $account_create_email_id . ",`customer_group_id`=" . $cust_group['customer_group_id'] . ",`section_name`='" . $section . "'");
            }

            $account_approval_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='" . $section . "_account_approval' AND `store_id`=" . $store_id);
            if ($account_approval_exist->row['total'] === '0') {
                $account_approval = $this->db->query("SELECT * FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_approval'");
                $account_approval_info = $account_approval->row;
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_templates') . "  
                          SET `section` = '" . $section . "_account_approval', 
                          `sender_name`='" . $account_approval_info['sender_name'] . "',`sender_email`='" . $account_approval_info['sender_email'] . "',`subject`='" . $account_approval_info['subject'] . "', 
                          `default_subject`='" . $account_approval_info['default_subject'] . "',
                          `content` = '" . $account_approval_info['content'] . "', 
                          `default_content` = '" . $account_approval_info['default_content'] . "',`email_signature_id` = '" . $account_approval_info['email_signature_id'] . "',
                          `notify_admin`='" . $account_approval_info['notify_admin'] . "', `store_id`='" . $store_id . "'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
                $account_approval_email_id = $this->db->getLastId();
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=" . $account_approval_email_id . ",`customer_group_id`=" . $cust_group['customer_group_id'] . ",`section_name`='" . $section . "'");
            }
            $account_activation_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='" . $section . "_account_activation' AND `store_id`=" . $store_id);
            if ($account_activation_exist->row['total'] === '0') {
                $account_activation = $this->db->query("SELECT * FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_activation'");
                $account_activation_info = $account_activation->row;
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_templates') . "  
                          SET `section` = '" . $section . "_account_activation', 
                          `sender_name`='" . $account_activation_info['sender_name'] . "',`sender_email`='" . $account_activation_info['sender_email'] . "',`subject`='" . $account_activation_info['subject'] . "', 
                          `default_subject`='" . $account_activation_info['default_subject'] . "',
                          `content` = '" . $account_activation_info['content'] . "', 
                          `default_content` = '" . $account_activation_info['default_content'] . "',`email_signature_id` = '" . $account_activation_info['email_signature_id'] . "',
                          `notify_admin`='" . $account_activation_info['notify_admin'] . "', `store_id`='" . $store_id . "'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
                $account_activation_email_id = $this->db->getLastId();
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=" . $account_activation_email_id . ",`customer_group_id`=" . $cust_group['customer_group_id'] . ",`section_name`='" . $section . "'");
            }

            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_create_info'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_create_subject'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_create_content'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_activation_info'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_activation_subject'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_activation_content'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_approval_info'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_approval_subject'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_approval_content'");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_create_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {login_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_create_subject','Account Create Email Subject:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_create_content','Account Create Email Content:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_activation_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {activate_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_activation_subject','Account Activation Email Subject:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_activation_content','Account Activation Email Content:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_approval_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {login_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_approval_subject','Account Needs Approval Email Subject:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_approval_content','Account Needs Approval Email Content:',now(),now())");
        }

        $query_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='expired_tax_exempt_certificate'");
        $exist = $query_exist->row['total'];
        if ($exist === '0') {
            $expired_tax_exempt_certificate_subject = 'Your Tax Exempt Certificate Is Expired';

            $expired_tax_exempt_certificate_content = 'Dear {{customer_name}},<br>We noticed that your tax exempt certificate has expired or is about to expire on: {{expired_at}}. You can update it by uploading the current tax exempt certificate via your edit account {{edit_account_url}}.<br>';
            $expired_tax_exempt_certificate_content .= 'If you want us to upload the certificate for you simply reply to this e-mail and provide us your name along with the updated tax exempt certificate file.<br><br>';
            $expired_tax_exempt_certificate_content .= 'Sincerely, {{store_url}}';

            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
                              SET `section` = 'expired_tax_exempt_certificate', 
                              `sender_name`='',`sender_email`='',`subject`='" . $this->db->escape($expired_tax_exempt_certificate_subject) . "', 
                              `default_subject`='" . $this->db->escape($expired_tax_exempt_certificate_subject) . "',
                              `content` = '" . $this->db->escape($expired_tax_exempt_certificate_content) . "', 
                              `default_content` = '" . $this->db->escape($expired_tax_exempt_certificate_content) . "',
                              `allowed_placeholders`='customer_name, expired_at, edit_account_url, store_url',
                              `email_signature_id` = 0,
                              `notify_admin`=0, `store_id`='" . $store_id . "'
                              ON DUPLICATE KEY UPDATE  
                              `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_expired_tax_exempt_certificate_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {{customer_name}}, {{expired_at}}, {{edit_account_url}}, {{store_url}}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_expired_tax_exempt_certificate_subject','Expired Tax Exempt Email Subject:',now(),now()");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_expired_tax_exempt_certificate_content','Expired Tax Exempt Email Content:',now(),now()");
        }

    }
}

$sql13 = "UPDATE ".$this->db->table('language_definitions')." set language_value='
       This is a WHY2 extension.  All support and updates are managed from WHY2. <br>
        Read about WHY2\'s 12 months support <a href=\"https://why2central.net/knowledgebase/why2-support-and-updates-policy/\" target=\"_blank\" style=\"font-weight:bold;\">here</a> and how WHY2 updates are delivered <a href=\"https://why2central.net/knowledgebase/extension-updater/\" target=\"_blank\" style=\"font-weight:bold;\">here</a>.<br>
        You can safely ignore Support expired notification within the Admin Dashboard.<br><br>
       This extension helps you to auto assign a customer to the desired customer group when they register their account.
     This can be beneficial if you have wholesalers or non-profits  who will need tax exemption documents on file,  or a group of customers that you want to offer specials too, perhaps students or crafters or something else that will benefit your business model.  Using Customer Group Auto Assign gives you the ability to have unique registration page for each customer group that will assign those at  registration to the preferred group.
     <ul>
     <li>Each  customer group has fields for Exempt from all Taxes,  Approve New Customers, Email Activation for New Customers, Upload Tax Exemption Certificate, and the ability to use a separate email template with specific message for that group.</li>
     <li>You can allow customers to upload their tax exemption certificate and set the expiration date,  if there is one.   Admins (store owners) can manage them easily via the built-in tax exemption list.</li>
     <li>Customer can update their tax exemption certificate via customer information. They will see their latest uploaded certificate while the old ones are not removed from your server.</li>
     <li>You can use custom email template that was copied from the default email template so you can send different message if needed.</li>
     <li>There is no limit to the number of customer groups you can add to your store.</li>
     </ul><br>
<strong>Notes: There are two ways to obtain the license key. <br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;a. Use this <a href=\"https://wehearyou2.com/clientarea/reg/register.php\" target=\"_blank\" style=\"font-weight:bold;\">form</a> to register to our Support system and generate your license key.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;b. Already registered -  click <a href=\"https://wehearyou2.com/clientarea/reg/index.php\" target=\"_blank\" style=\"font-weight:bold;\">here</a> to log into your account to obtain license key.<br>
        Refer to our <a href=\"https://why2central.net/faq/license-key/\" target=\"_BLANK\">F.A.Q</a> for more information on how to obtain the license key.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;c. If you already have an account in our support system and you are using multiple extensions from WHY2,  you do NOT need to create another account in the support system.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;d. Updating extension in same location does NOT require a new key.<br> Refer to our <a href=\"https://why2central.net/faq/license-key/\" target=\"_BLANK\">F.A.Q</a> for more information on how to Update extension in same location.</strong><br><br>
	1. Enter your WHY2 license key here.<br>
	2. Notify when customer upload tax exemption certificate: Turn ON if you want to be notified when customer upload tax exemption certificate.<br>
	3. Customer info: Select which customer info that you want to use in the notification.<br>
	4. Language Definitions if using Default email: These are the language definitions if you are using default email.
	' WHERE language_key='customer_group_auto_assigned_note';";
$this->db->query($sql13);

$sql14 = "UPDATE ".$this->db->table('language_definitions')." set language_value='Enter your WHY2 license key:' WHERE language_key='customer_group_auto_assigned_license_code';";
$this->db->query($sql14);

$sql15 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("customer_group_auto_assigned_license_info") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `public_key` TEXT NOT NULL,
  `license_data` TEXT NOT NULL,
  `license_key` TEXT NOT NULL,
  `store_id` int(11) NOT NULL,
  `last_check` int(11),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql15);

$sql16 = "SELECT * FROM ".$this->db->table("order_status_ids") ." WHERE `status_text_id` ='exempt_hold'";
$query = $this->db->query($sql16);
if (!$query->row) {
    $sql17 = "INSERT INTO " . $this->db->table("order_statuses") . " (`order_status_id`, `language_id`, `name`) VALUES ('23','1','Exempt Hold') ON DUPLICATE KEY UPDATE `name` = VALUES(`name`);";
    $this->db->query($sql17);
    $sql18 = "INSERT INTO " . $this->db->table("order_status_ids") . " (`order_status_id`, `status_text_id`) VALUES ('23','exempt_hold') ON DUPLICATE KEY UPDATE `status_text_id` = VALUES(`status_text_id`)";
    $this->db->query($sql18);
}

$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_additional_fields'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_allow_upload_later'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='column_upload_later'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_no'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_yes'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='button_diy_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='button_mc_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_update_customer_group_auto_assigned_available'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='customer_group_auto_assigned_license_expired'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='error_upload_type'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='error_upload_certificate'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_date_format'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_upload_tax_exemption'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='breadcrumb_customer_groups'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='breadcrumb_edit_group'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_customer_group_auto_assigned_settings'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='tab_general'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_checkout_settings_note'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_customer_group_name'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_customer_group_name'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_show_tax_exempt_status_notes'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_show_tax_exempt_status'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_show_checkout_confirm'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_show_fast_checkout'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_show_invoice'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_show_confirmation_email'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_no_tax_exemption_message_notes'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_no_tax_exemption_message'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_tax_exempt_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_no_tax_exemption_message'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_tax_exempt_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_tax_exempt_company_name'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_tax_exempt_upload_date'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_tax_exempt_have_expiration_date'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_tax_exempt_expiration_date'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_here'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_your_tax_exempt_certificate'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_expires_on'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_expire'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_expiration_date'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_order_confirmation_no_exempt_file'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_tax_exempt_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_tax_exempt_company_name'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_no_exempt_certificate'");

$this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_upload_customer_tax_exemption'");
$this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_verified'");
$this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_verified_by'");
$this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_verified_date'");
$this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_tax_certificate_tab_name'");
$this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='tab_certificate'");
$this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_history'");
$this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='heading_title_tax_certificate'");
$this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='column_verified'");
$this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='column_verified_by'");
$this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='column_verified_date'");
$this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_customer_tax_exempt_certificate'");
$this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_date_format'");
$this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_comment'");
$this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_allowed_filename'");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','text_additional_fields','If you are Tax Exempt',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_allow_upload_later','Allow tax exempt certificate to be uploaded later: <span class=\"help\">Turn ON if you want to allow customer upload the tax exempt certificate later.</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','column_upload_later','Upload after account created',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_no','No',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_yes','Yes',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','entry_upload_later','Will upload after account created',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_support_by_why2','Support and updates from WHY2.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','button_diy_support_by_why2','If you are self-managed users click here for support. Support and updates from WHY2.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','button_mc_support_by_why2','If you are a WHY2 Managed Client click here for support. Updates are part of the Managed Services.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_update_customer_group_auto_assigned_available','New version (%s) is available. <a href=\"%s\" target=\"_BLANK\"><strong>Click to update now.</strong></a>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','customer_group_auto_assigned_license_expired','Your license key is expired. Possibly due to inactive with the extension for more than 14 days. Please click on the SAVE button at the bottom of this page.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','error_upload_type','Use formats:  png, jpg, gif or PDF.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','error_upload_certificate','You need to upload tax exempt certificate!',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','entry_date_format','Use the following date format: ',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','entry_upload_tax_exemption','Upload your tax exemption certificate: (PNG, JPG, GIF or PDF)',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','breadcrumb_customer_groups','Customer Groups',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','breadcrumb_edit_group','Edit Customer Group',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','text_customer_group_auto_assigned_settings','Customer Group Auto Assigned Settings',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','tab_general','General',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','text_checkout_settings_note','<strong>Notes: Check your Settings > Checkout [here] to make sure that you set the correct settings if you want to restrict customers from being able to login until they are approved or they have confirm their account.</strong>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','entry_customer_group_name','Customer Group Name: ',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_show_tax_exempt_status_notes','<b>Notes: You must turn ON Show tax exemption status in order to show tax exemption status and no tax exemption message in checkout confirm page, fast checkout page, invoice page and order confirmation email.</b>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_show_tax_exempt_status','Show tax exemption status: <span class=\"help\">Turn ON if you want to show the tax exemption status.</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_show_checkout_confirm','Show in checkout confirm page: <span class=\"help\">Turn ON if you want to show the tax exemption status in checkout confirm page.</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_show_fast_checkout','Show in fast checkout page: <span class=\"help\">Turn ON if you want to show the tax exemption status in fast checkout page.</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_show_invoice','Show in invoice page: <span class=\"help\">Turn ON if you want to show the tax exemption status in invoice page.</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_show_confirmation_email','Show in order confirmation email: <span class=\"help\">Turn ON if you want to show the tax exemption status in order confirmation email.</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_no_tax_exemption_message_notes','<b>Notes for no tax exemption message: You can change the message into your desired message, but don\'t remove the [account_edit_url] from the message as it is used by the extension to redirect customer to the correct account edit URL.</b>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_no_tax_exemption_message','Enter the desired no tax exemption message that will be shown to customer:<span class=\"help\">. Leave empty if you don\'t want to show the message.</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','text_tax_exempt_title','Tax Exemption Certification Status',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','text_tax_exempt_company_name','Company name: ',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','text_tax_exempt_upload_date','Upload date: ',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','text_tax_exempt_have_expiration_date','Have expiration date: ',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','text_tax_exempt_expiration_date','Expiration date: ',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','text_here','here',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','entry_your_tax_exempt_certificate','Your tax exemption certificate:',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','entry_expires_on','Expires On:',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','entry_expire','Has Expiration Date:',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','entry_expiration_date','Expiration Date:',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_expire','Has Expiration Date:',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_expiration_date','Expiration Date:',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','text_order_confirmation_no_exempt_file','<b>Your order status will be on Exempt Hold. An Exemption Certificate is required before we can ship. Please upload your tax exemption certificate [account_edit_url].</b>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_tax_exempt_title','Tax Exemption Certification Status',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_tax_exempt_company_name','Company name: ',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_tax_exempt_upload_date','Upload date: ',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_tax_exempt_have_expiration_date','Have expiration date: ',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_tax_exempt_expiration_date','Expiration date: ',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_no_exempt_certificate','This customer hasn\'t uploaded the tax exempt certificate yet.',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_upload_customer_tax_exemption','Upload customer tax exemption certificate: (PNG, JPG, GIF or PDF)',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_verified','Verified: ',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_verified_by','Verified By: ',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_verified_date','Verified Date: ',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_tax_certificate_tab_name','Tax Certificate',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','tab_certificate','Tax Certificate',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_history','History (deletion is managed within the master list)',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','column_verified','Verified',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','column_verified_by','Verified By',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','column_verified_date','Verified Date',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_customer_tax_exempt_certificate','Customer tax exemption certificate: ',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_date_format','Use the following date format: ',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_comment','Comment: ',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','text_allowed_filename','Filename should only contain alpha, numeric, hyphen, underscore or whitespace.<br>The accepted file extensions are: jpg, png, gif or pdf only. For example: my_tax-exemption.pdf or My tax-exemption.pdf.',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_verified','Verified: ',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','text_verified','Verified: ',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','text_yes','Yes',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','text_no','No',now(),now())");

$query = $this->db->query("SELECT count(*) AS exist FROM ".$this->db->table("language_definitions")." WHERE `language_key`='expired_tax_exempt_email_subject'");
$exist = $query->row;
if ($exist==='0') {
    $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','expired_tax_exempt_email_subject','Your Tax Exempt Certificate Is Expired',now(),now())");

    $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','expired_tax_exempt_email_content','Dear %s,\nWe noticed that your tax exempt certificate has expired or is about to expire on : %s. You can update it by uploading the current tax exempt certificate via your edit account %s.',now(),now())");

    $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','expired_tax_exempt_email_footer','If you want us to upload the certificate for you simply reply to this e-mail and provide us your name along with the updated tax exempt certificate file.\n\nSincerely,\n%s %s',now(),now())");
}

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','search_name_placeholder','Enter Customer Name',now(),now())");
$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_search_name','Customer Name: ',now(),now())");
$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','column_id','ID',now(),now())");
$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','column_company','Company',now(),now())");
$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_search_company','Company: ',now(),now())");
$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','column_expire_date','Expire Date',now(),now())");
$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','search_from_expired_date_placeholder','Enter Starting Expire Date',now(),now())");
$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','search_to_expired_date_placeholder','Enter Ending Expire Date ',now(),now())");
$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','column_emailed','E-mailed',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_search_emailed','E-mailed: ',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','column_action','Action',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','customer_group_auto_assigned_entry_date_range','Date Range:',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_last_24','Last 24 Hours',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_last_week','Last Week',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_last_month','Last Month',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_last_year','Last Year',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','customer_group_auto_assigned_button_email_auto','Automatic E-mailing',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','customer_group_auto_assigned_button_email_selected','E-mail Selected',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','customer_group_auto_assigned_button_cancel_selected','Cancel Selected',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','customer_group_auto_assigned_button_dialog_send','Send E-mails',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','customer_group_auto_assigned_button_dialog_dryrun','Dry Run',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','customer_group_auto_assigned_text_show_all','- Show All -',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_select_all','- Select All -',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_select_company','- Select Company -',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_blank','-',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','sort_columns_note','Note: Click on any column name to sort up or down.',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_edit_email_template','Edit WHY2 Email Template',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_search_from_expired_date_placeholder','Starting Expire Date: ',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_search_to_expired_date_placeholder','Ending Expire Date: ',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','expired_tax_exempt_cert_list','Expired Tax Exempt Certificate List',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_instructions','Automatically send e-mails to expired tax exempt certificate within the Date Range. In order to prevent duplicate or inaccurate e-mails, only one e-mail will go out per customer e-mail address. In addition, no e-mails will be sent to customers that have active tax exempt certificate.<br /><br />Choose Dry Run to see which customer(s) would receive e-mails without actually sending any e-mails.
',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_dryrun','<b>Performing Dry Run, no e-mails will actually be sent.</b>',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','error_no_matching_expired_tax_cert','There are no expired tax exempt certificate holders that need to be sent an e-mail.',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','error_date_range','Warning: Invalid date range!',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','error_email_already_sent','<b>ID %s:</b> E-mail already sent for this expired tax exempt certificate!',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','success_emailed','<b>ID %s:</b> Customer e-mailed successfully!',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','customer_group_auto_assigned_languages','Language Definitions if using Default email:',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_yes_on','Yes on ',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_here','here',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','text_tax_cert_subject','New tax exemption certificate is uploaded',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','text_tax_cert_uploaded','Customer [customer] has uploaded their tax exemption certificate directly to their account.',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','customer_group_auto_assigned_notify_new_cert','Notify when customer upload tax exemption certificate: <span class=\"help\">Turn ON if you want to be notified when customer upload tax exemption certificate.</span>',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','customer_group_auto_assigned_customer_info','Customer info: <span class=\"help\">Select which customer info that you want to use in the notification.</span>',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','customer_group_auto_assigned_customer_info_customer_name','Customer Name',now(),now())");

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','customer_group_auto_assigned_customer_info_company_name','Company Name',now(),now())");

$exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('customer_group_auto_assigned_license') . "'");
if ($exist->num_rows === 1) {
    $this->db->query("DROP TABLE ".$this->db->table("customer_group_auto_assigned_license"));
}

if (file_exists(DIR_EXT.'customer_group_auto_assigned/admin/view/default/template/pages/extension/extensions_edit.tpl')) {
    unlink(DIR_EXT.'customer_group_auto_assigned/admin/view/default/template/pages/extension/extensions_edit.tpl');
}

$sql7 = "CREATE TABLE IF NOT EXISTS ".$this->db->table('customer_group_auto_assigned_history')." (
    `customer_group_auto_assigned_info_id` int(11) NOT NULL,
	`emailed` tinyint(1) NOT NULL DEFAULT '1',
	`date_added` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
	PRIMARY KEY (`customer_group_auto_assigned_info_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin";

$this->db->query($sql7);

if (!file_exists(DIR_SYSTEM.'lib/license.php')) {
    /**
     *  Function to Copy folders and files
     * @param $src
     * @param $dst
     * @return array
     */
    function custom_copy($src, $dst) {
        $error = [];
        // open the source directory
        $dir = opendir($src);
        if (!is_dir($dst)) {
            @mkdir($dst);
        }
        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    // Recursively calling custom copy function
                    // for sub directory
                    custom_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    if (!copy($src . '/' . $file, $dst . '/' . $file)) {
                        $error['error_copy'][] = "Failed to copy $file";
                    }
                }
            }
        }
        if (sizeof($error)>0) {
            $log=new ALog(DIR_SYSTEM.'logs/error.txt');
            $log->write(var_export($error,true));
        }
        closedir($dir);
        return $error;
    }
    $copy = custom_copy(DIR_EXT . 'customer_group_auto_assigned' . DIR_EXT_CORE . 'lib', DIR_SYSTEM.'lib');
}