<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * ModelExtensionCustomerGroupAutoAssigned
 */
class ModelExtensionCustomerGroupAutoAssigned extends Model {

    /**
     * @param $customer_group_id
     * @param $data
     * @throws AException
     */
	public function addValues($customer_group_id,$data) {
        $store_id = $this->getStoreId();
	    $this->removeValue($customer_group_id);
		$this->db->query("INSERT INTO ".$this->db->table('customer_group_auto_assigned_values')." SET `customer_group_id`=".(int)$customer_group_id.",`activated`='".$data['activated']."',
		                 `admin_approval`='".$data['admin_approval']."',`email_activation`='".$data['email_activation']."',`upload_tax_exemption`='".$data['upload_tax_exemption']."',`custom_email`='".$data['custom_email']."',
		                 `upload_later`='".$data['upload_later']."',`show_tax_exempt_status`='".$data['show_tax_exempt_status']."',
		                 `no_tax_exemption_message`='".addslashes($data['no_tax_exemption_message'])."',`show_checkout_confirm`='".$data['show_checkout_confirm']."',`show_fast_checkout`='".$data['show_fast_checkout']."',
		                 `show_invoice`='".$data['show_invoice']."',`show_confirmation_email`='".$data['show_confirmation_email']."',`store_id`=".$store_id);
	}

    /**
     * @param $customer_group_id
     * @param $data
     * @throws AException
     */
    public function updateValues($customer_group_id,$data) {
        $store_id = $this->getStoreId();
        $exist = $this->getValues($customer_group_id);
        $fields = ['activated','admin_approval', 'email_activation', 'upload_tax_exemption', 'custom_email','upload_later','show_tax_exempt_status','no_tax_exemption_message','show_checkout_confirm',
                   'show_fast_checkout','show_invoice','show_confirmation_email'];
        $update = [];
        foreach ($fields as $f) {
            if (isset($data[$f])) {
                if ($f==='no_tax_exemption_message') {
                    $update[] = $f . " = '" . addslashes([$f]) . "'";
                } else {
                    $update[] = $f . " = '" . $data[$f] . "'";
                }
            }
        }

        if (!empty($update)) {
            if ($exist) {
                $this->db->query(
                    "UPDATE " . $this->db->table("customer_group_auto_assigned_values") . " 
                        SET " . implode(',', $update) . " 
                        WHERE customer_group_id = '" . (int)$customer_group_id . "' AND store_id=".$store_id
                );
            } else {
                $update['store_id'] = 'store_id='.$this->getStoreId();
                $this->db->query(
                    "INSERT INTO " . $this->db->table("customer_group_auto_assigned_values") . " 
                        SET " . implode(',', $update) . " 
                         ,customer_group_id = '" . (int)$customer_group_id . "'"
                );
            }
        }
    }

    /**
     * @param $customer_group_id
     * @param $data
     * @throws AException
     */
    public function updateCustomerValues($customer_id,$data) {
        $store_id = $this->getStoreId();
        $exist = $data['customer_group_auto_assigned_info_id'];

        if ($data['verified_date']) {
            $verified_date = date_create($data['verified_date'])->format('Y-m-d');
        } else {
            $verified_date = '0000-00-00';
        }

        if ($data['expiration_date']) {
            $expire_date = date_create($data['expiration_date'])->format('Y-m-d');
        } else {
            $expire_date = '0000-00-00';
        }

        $fields = ['customer_group_id','verified','verified_by', 'verified_date','comment','image_url','expire','expiration_date'];
        $update = [];
        foreach ($fields as $f) {
            if ($f==='verified_date') {
                $update[] = $f . ' = "' . $verified_date. '"';
            } elseif ($f==='expiration_date') {
                $update[] =  'expire_date = "' . $expire_date. '"';
            } elseif (isset($data[$f])) {
                $update[] = $f . ' = "' . $data[$f] . '"';
                if ($f==='image_url') {
                    if ($data['update']) {
                        $update[] = '`uploaded_at`="'.$data['uploaded_at'].'"';
                    } else {
                        $update[] = '`uploaded_at`=NOW()';
                    }
                }
            }
        }
        if (!empty($update)) {
            if ($data['update']) {
                $this->db->query(
                    "UPDATE " . $this->db->table("customer_group_auto_assigned_info") . "
                        SET " . implode(',', $update) . "
                        WHERE customer_id = '" . (int)$customer_id . "' AND store_id=".$store_id." AND `customer_group_auto_assigned_info_id`=".$data['customer_group_auto_assigned_info_id']
                );
            } else {
                $update['store_id'] = 'store_id='.$this->getStoreId();
                $this->db->query(
                    "INSERT INTO " . $this->db->table("customer_group_auto_assigned_info") . " 
                        SET " . implode(',', $update) . " 
                         ,customer_id = '" . (int)$customer_id . "'"
                );
            }
        }
    }

    /**
     * @param $customer_id
     * @return mixed
     * @throws AException
     */
    public function getImage($customer_id) {
        $query = $this->db->query("SELECT * FROM ".$this->db->table('customer_group_auto_assigned_info') ." WHERE `customer_id`=".(int)$customer_id. " ORDER BY uploaded_at DESC LIMIT 1");
        return $query->row;
    }

    /**
     * @param $customer_id
     * @return mixed
     * @throws AException
     */
    public function getInfoByInfoId($customer_group_auto_assigned_info_id) {
        $query = $this->db->query("SELECT * FROM ".$this->db->table('customer_group_auto_assigned_info') ." WHERE `customer_group_auto_assigned_info_id`=".(int)$customer_group_auto_assigned_info_id);
        return $query->row;
    }

    /**
     * @param $data
     * @return void
     * @throws AException
     */
    public function addInfo($data) {
        $store_id = $this->getStoreId();
        $expire_date = '';
        if ($data['expiration_date'] && $data['expire']==='1') {
            $expire_date = date_create($data['expiration_date'])->format('Y-m-d');
        } else {
            $expire_date = '0000-00-00';
        }

        $fields = ['verified','verified_by', 'verified_date','image_url',''];
        $update = [];
        foreach ($fields as $f) {
            if (isset($data[$f])) {
                $update[] = $f . " = '" . $data[$f] . "'";
            }
        }

        if (!empty($update)) {
            $this->db->query(
                "UPDATE " . $this->db->table("customer_group_auto_assigned_values") . " 
                        SET " . implode(',', $update) . " 
                        WHERE customer_id = '" . (int)$data['customer_id'] . "' AND store_id=" . $store_id . " AND `customer_group_auto_assigned_info_id`=" . $data['customer_group_auto_assigned_info_id']
            );
        }

        $this->db->query("INSERT INTO ".$this->db->table('customer_group_auto_assigned_info') ." SET `customer_group_id`=".(int)$data['customer_group_id'].",`verified`='".$data['verified']."',`verified_by`='".$data['verified_by']."'
                         `verified_date`='".$data['verified_date']."',`customer_id`=".$data['customer_id'].",`image_url`='".$data['image_url']."',`uploaded_at`=NOW(),`expire`='".$data['expire']."',`expire_date`='".$expire_date."'");
    }

    /**
     * @param $customer_group_id
     * @return mixed
     * @throws AException
     */
    public function getValues($customer_group_id) {
        $store_id = $this->getStoreId();
        $query = $this->db->query("SELECT * FROM ". $this->db->table("customer_group_auto_assigned_values") . " WHERE `customer_group_id`=".(int)$customer_group_id." AND `store_id`=".$store_id);
        return $query->row;
    }

    /**
     * @param $customer_id
     * @return mixed
     * @throws AException
     */
    public function getCustomerValues($customer_id) {
        $store_id = $this->getStoreId();
        $query = $this->db->query("SELECT * FROM ". $this->db->table("customer_group_auto_assigned_info") . " WHERE `customer_id`=".(int)$customer_id." AND `store_id`=".$store_id." ORDER BY customer_group_auto_assigned_info_id DESC ");
        return $query->row;
    }

    public function getCustomerValuesById($customer_id,$customer_group_auto_assigned_info_id) {
        $store_id = $this->getStoreId();
        $query = $this->db->query("SELECT * FROM ". $this->db->table("customer_group_auto_assigned_info") . " WHERE `customer_id`=".(int)$customer_id." AND `store_id`=".$store_id." AND `customer_group_auto_assigned_info_id`='".$customer_group_auto_assigned_info_id."'");
        return $query->row;
    }

    /**
     * @param $customer_id
     * @return mixed
     * @throws AException
     */
    public function getCustomerGroupId($customer_id) {
        $query = $this->db->query("SELECT `customer_group_id` FROM ".$this->db->table("customers")." WHERE `customer_id`=".(int)$customer_id);
        return $query->row['customer_group_id'];
    }

    /**
     * @param $customer_group_id
     * @throws AException
     */
    public function removeValue($customer_group_id) {
        $store_id = $this->getStoreId();
        $this->db->query("DELETE FROM ". $this->db->table("customer_group_auto_assigned_values") . " WHERE `customer_group_id`=".(int)$customer_group_id." AND `store_id`=".$store_id);
    }

    /**
     * @param $customer_id
     * @return mixed
     * @throws AException
     */
    public function getInfo($customer_id) {
	    $query = $this->db->query("SELECT * FROM ".$this->db->table('customer_group_auto_assigned_info') ." WHERE `customer_id`=".(int)$customer_id);
	    return $query->row;
    }

    /**
     * @param array $data
     *
     * @return array|null
     */
    public function getTotalTaxExemptList($data = [])  {
        return $this->getTaxExemptList($data, 'total_only');
    }

    /**
     * @param $data
     * @param $mode
     * @return false|mixed
     * @throws AException
     */
    public function getTaxExemptList($data = [], $mode = 'default') {
        if (!empty($data['content_language_id'])) {
            $language_id = ( int )$data['content_language_id'];
        } else {
            $language_id = (int)$this->config->get('storefront_language_id');
        }

        $store_id = $this->getStoreId();

        if ($data || $mode == 'total_only') {
            $filter = (isset($data['filter']) ? $data['filter'] : []);

            if ($mode == 'total_only') {
                $sql = "SELECT COUNT(*) as total
						FROM ".$this->db->table("customer_group_auto_assigned_info")." info 
                       LEFT JOIN ".$this->db->table("customers")." c ON c.customer_id=info.customer_id
                       LEFT JOIN ".$this->db->table("addresses")." addr ON c.customer_id=addr.customer_id AND addr.address_id = c.address_id";
            } else {
                $sql = "SELECT info.*,CONCAT(c.firstname,' ',c.lastname) as customer_name,addr.company FROM ".$this->db->table("customer_group_auto_assigned_info")." info 
                       LEFT JOIN ".$this->db->table("customers")." c ON c.customer_id=info.customer_id
                       LEFT JOIN ".$this->db->table("addresses")." addr ON c.customer_id=addr.customer_id AND addr.address_id = c.address_id
                       ";
            }

            $sql .= " WHERE 1 AND info.store_id=".$store_id;

            if (isset($filter['customer_id']) && $filter['customer_id']!=='none') {
                $sql .= " AND c.customer_id = ".$filter['customer_id'];
            }

            if (isset($filter['company']) && $filter['company']!=='none') {
                if ($filter['company']==='empty') {
                    $sql .= ' AND addr.company = ""';
                } else {
                    $sql .= ' AND addr.company = "'.html_entity_decode($filter['company']).'"';
                }
            }

            if (!empty($filter['filter_date_start'])) {
                $deliver_start = date_create($filter['filter_date_start'])->format('Y-m-d');
                $sql .= " AND DATE(info.uploaded_at) >= DATE('" . $deliver_start . "')";
            }
            if (!empty($filter['filter_date_end'])) {
                $deliver_end = date_create($filter['filter_date_end'])->format('Y-m-d');
                $sql .= " AND DATE(info.uploaded_at) <= DATE('" . $deliver_end . "')";
            }

            //If for total, we done building the query
            if ($mode == 'total_only') {
                $query = $this->db->query($sql);
                return $query->row['total'];
            }

            $sort_data = [
                'name'          => 'customer_name',
                'company'       => 'company',
                'uploaded_at'   => 'info.uploaded_at',
                'expire'        => 'info.expire',
                'expire_date'   => 'info.expire_date',
                'upload_later'  => 'info.upload_later',
                'verified'      => 'info.verified',
                'verified_by'   => 'info.verified_by',
                'verified_date' => 'info.verified_date',
            ];

            if (isset($data['sort']) && in_array($data['sort'], array_keys($sort_data))) {
                $sql .= " ORDER BY ".$sort_data[$data['sort']];
            } else {
                $sql .= " ORDER BY customer_name";
            }

            if (isset($data['order']) && strtolower($data['order']) === 'desc') {
                $sql .= " DESC, customer_group_auto_assigned_info_id DESC";
            } else {
                $sql .= " ASC, customer_group_auto_assigned_info_id DESC";
            }

            if (isset($data['start']) || isset($data['limit'])) {
                if ($data['start'] < 0) {
                    $data['start'] = 0;
                }

                if ($data['limit'] < 1) {
                    $data['limit'] = 20;
                }

                $sql .= " LIMIT ".(int)$data['start'].",".(int)$data['limit'];
            }
            $query = $this->db->query($sql);
            return $query->rows;
        } else {
            $sql = "SELECT info.*,CONCAT(c.first_name,' ',c.last_name) as customer_name FROM " . $this->db->table("customer_group_auto_assigned_info") . " info 
                       LEFT JOIN " . $this->db->table("customers") . " c ON c.customer_id=info.customer_id WHERE info.store_id=" . $store_id;
            $query = $this->db->query($sql);
            $product_data = $query->rows;
            return $product_data;
        }
    }

    public function getCustomers() {
        $sql = "SELECT c.customer_id, CONCAT(c.firstname,' ',c.lastname) as customer_name FROM ".$this->db->table("customer_group_auto_assigned_info")." cagd 
                       LEFT JOIN ".$this->db->table("customers")." c ON c.customer_id=cagd.customer_id ORDER BY customer_name ASC";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getCompanies() {
        $sql = "SELECT addr.company FROM ".$this->db->table("customer_group_auto_assigned_info")." cagd 
                   LEFT JOIN ".$this->db->table("customers")." c ON c.customer_id=cagd.customer_id
                   LEFT JOIN ".$this->db->table("addresses")." addr ON c.customer_id=addr.customer_id AND addr.address_id = c.address_id ORDER BY company ASC";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    /**
     * @param $customer_id
     * @return mixed
     * @throws AException
     */
    public function getExemptionInfo($customer_id) {
        $query = $this->db->query("SELECT * FROM ".$this->db->table('customer_group_auto_assigned_info') ." WHERE `customer_id`=".(int)$customer_id. " AND `image_url` <> '' ORDER BY uploaded_at DESC LIMIT 1");
        return $query->row;
    }

    /**
     * @param $customer_group_auto_assigned_info_id
     * @return void
     * @throws AException
     */
    public function removeData($customer_group_auto_assigned_info_id) {
        $query = $this->db->query("SELECT image_url FROM ".$this->db->table("customer_group_auto_assigned_info")." WHERE `customer_group_auto_assigned_info_id`=".$customer_group_auto_assigned_info_id);
        $image_url = $query->row['image_url'];
        if (file_exists(DIR_IMAGE.'customer_group_auto_assigned/'.$image_url)) {
            unlink(DIR_IMAGE.'customer_group_auto_assigned/'.$image_url);
        }

        $this->db->query("DELETE FROM ".$this->db->table("customer_group_auto_assigned_info")." WHERE `customer_group_auto_assigned_info_id`=".$customer_group_auto_assigned_info_id);
    }

    /**
     * @param $customer_id
     * @return void
     * @throws AException
     */
    public function removeDataByCustomerId($customer_id) {
        $this->deleteAll(DIR_EXT . 'customer_group_auto_assigned/files/'.$customer_id);
        $this->db->query("DELETE FROM ".$this->db->table("customer_group_auto_assigned_info")." WHERE `customer_id`=".$customer_id);
    }

    /**
     * @param $data
     * @param mode $
     * @return int
     * @throws AException
     */
    public function getExpiredTaxCerts($data = [],$mode="default") {
        $store_id = $this->getStoreId();

        $sql = "SELECT info.customer_group_auto_assigned_info_id,
                CONCAT(c.firstname, ' ', c.lastname) AS name,
                c.customer_id,
                a.company AS company,
                info.expire_date,
                CASE WHEN ISNULL(h.customer_group_auto_assigned_info_id) THEN 0 ELSE h.emailed END as emailed,
                h.date_added as emailed_date
                FROM " . $this->db->table("customer_group_auto_assigned_info") . " info 
                LEFT JOIN " . $this->db->table("customer_group_auto_assigned_history") . " h ON h.customer_group_auto_assigned_info_id = info.customer_group_auto_assigned_info_id
                LEFT JOIN " . $this->db->table("customers") . " c ON c.customer_id = info.customer_id
                LEFT JOIN " . $this->db->table("addresses") . " a ON c.customer_id = a.customer_id AND a.address_id = c.address_id
               ";

        $sql .= " WHERE c.store_id='".$store_id."' AND info.expire_date = (SELECT MAX(info1.expire_date)
                                 FROM ".$this->db->table("customer_group_auto_assigned_info")." info1
                                 WHERE info1.customer_id = info.customer_id) ";

        if (!empty($data['filter_name'])) {
            $sql .= " AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%".$this->db->escape($data['filter_name'])."%'";
        }

        if (!empty($data['filter_company'])) {
            if ($data['filter_company']==='empty') {
                $sql .= " AND a.company = ''";
            } else {
                $sql .= " AND a.company LIKE '%".$this->db->escape($data['filter_company'])."%'";
            }
        }

        if (!empty($data['filter_name'])) {
            $sql .= " AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%".$this->db->escape($data['filter_name'])."%'";
        }

        if (!empty($data['filter_company'])) {
            $sql .= " AND a.company LIKE '%".$this->db->escape($data['filter_name'])."%'";
        }

        if (isset($data['filter_emailed']) && !is_null($data['filter_emailed'])) {
            if ($data['filter_emailed']) {
                $sql .= " AND h.emailed = '1'";
            } else {
                $sql .= " AND COALESCE(h.emailed, 0) = 0";
            }
        }
        
        if (has_value($data['filter_emailed'])) {
            if ($data['filter_emailed']) {
                $sql .= " AND h.emailed = '1'";
            } else {
                $sql .= " AND COALESCE(h.emailed,0) = 0";
            }
        }

        $sort_data = [
            'info.customer_group_auto_assigned_info_id',
            'name',
            'company',
            'info.expire_date',
            'emailed',
        ];

        $first_date = date("Y-m-01");
        $last_date = date("Y-m-t");

        if (has_value($data['filter_from_expired_date']) && has_value($data['filter_to_expired_date'])) {
            $from= date_create($data['filter_from_expired_date']);
            $from_date = $from->format("Y-m-d");
            $to= date_create($data['filter_to_expired_date']);
            $to_date = $to->format("Y-m-d");
            $sql .= " AND DATE(expire_date) >= DATE('" . $from_date . "') AND DATE(info.expire_date) <= DATE('" . $to_date . "')";
        } elseif (has_value($data['filter_from_expired_date']) && is_null($data['filter_to_expired_date'])) {
            $from= date_create($data['filter_from_expired_date']);
            $from_date = $from->format("Y-m-d");
            $sql .= " AND DATE(expire_date) >= DATE('" . $from_date . "')";
        } elseif (is_null($data['filter_from_expired_date']) && has_value($data['filter_to_expired_date'])) {
            $to= date_create($data['filter_to_expired_date']);
            $to_date = $to->format("Y-m-d");
            $sql .= " AND DATE(expire_date) <= DATE('" . $to_date . "')";
        } else {
            $sql .= " AND DATE(expire_date) >= DATE('" . $first_date . "') AND DATE(expire_date) <= DATE('" . $last_date . "')";
        }

        $sql .= "AND DATE(expire_date) <> '0000-00-00 00:00:00'";

        if (!empty($data['filter_date_range'])) {
            $sql .= " AND DATE(info.expire_date) >= DATE_SUB(CURDATE(), INTERVAL "
                .$this->db->escape($data['filter_date_range']).")";
        }

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY ".$data['sort'];
        } else {
            $sql .= " ORDER BY info.customer_group_auto_assigned_info_id";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if ($mode!=='total_only') {
            if (isset($data['start']) || isset($data['limit'])) {
                if ($data['start'] < 0) {
                    $data['start'] = 0;
                }

                if ($data['limit'] < 1) {
                    $data['limit'] = 20;
                }

                $sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
            }
        }

        $query = $this->db->query($sql);
        if ($mode==='total_only') {
            return sizeof($query->rows);
        } else {
            return $query->rows;
        }
    }

    public function getEmailed($customer_group_auto_asssigned_info_id) {
        $sql = "SELECT emailed, date_added as expire_date FROM ".$this->db->table("customer_group_auto_assigned_history")." WHERE customer_group_auto_asssigned_info_id='".$customer_group_auto_asssigned_info_id."'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    /**
     * @param $customer_group_auto_assigned_info_id
     * @return void
     */
    public function getExpiredInfo($customer_group_auto_assigned_info_id) {
        $sql = "SELECT CONCAT(c.firstname,' ',c.lastname) AS customer_name,c.email,info.expire_date,info.customer_group_auto_assigned_info_id FROM ".$this->db->table("customer_group_auto_assigned_info")." info
                LEFT JOIN ".$this->db->table("customers")." c ON c.customer_id=info.customer_id
                WHERE info.customer_group_auto_assigned_info_id='".$customer_group_auto_assigned_info_id."'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    /**
     * @param $order_id
     * @param $testing
     * @return void
     * @throws AException
     */
    public function addHistory($customer_group_auto_assigned_info_id, $testing = false) {
        if ($this->getHistory($customer_group_auto_assigned_info_id)) {
            $this->db->query(
                "UPDATE ".$this->db->table('customer_group_auto_assigned_history')."
                SET emailed = '1',
                    date_added = NOW()
                WHERE customer_group_auto_assigned_info_id = '".(int) $customer_group_auto_assigned_info_id."'"
            );
        } else {
            if ($testing) {
                if (!isset($this->session->data['temporary_customer_group_auto_assigned_ids'])) {
                    $this->session->data['temporary_customer_group_auto_assigned_ids'] = [];
                }
                $this->session->data['temporary_customer_group_auto_assigned_ids'][] = $customer_group_auto_assigned_info_id;
            }
            $this->db->query(
                "INSERT INTO ".$this->db->table('customer_group_auto_assigned_history')."
                SET customer_group_auto_assigned_info_id = '".(int) $customer_group_auto_assigned_info_id."', emailed = '1', date_added = NOW()"
            );
        }
    }

    /**
     * @param $customer_group_auto_assigned_info_id
     * @return void
     * @throws AException
     */
    public function removeHistory($customer_group_auto_assigned_info_id) {
        $this->db->query(
            "DELETE FROM ".$this->db->table('customer_group_auto_assigned_history')."
            WHERE customer_group_auto_assigned_info_id = '".(int) $customer_group_auto_assigned_info_id."'"
        );
    }

    /**
     * @param $customer_group_auto_assigned_info_id
     * @return false
     * @throws AException
     */
    public function getHistory($customer_group_auto_assigned_info_id) {
        $result = $this->db->query(
            "SELECT *
            FROM ".$this->db->table('customer_group_auto_assigned_history')."
            WHERE customer_group_auto_assigned_info_id = '".(int) $customer_group_auto_assigned_info_id."'"
        );

        if ($result->num_rows) {
            return $result->row;
        } else {
            return false;
        }
    }

    /**
     * @param $section
     * @return mixed
     * @throws AException
     */
    public function getDetails($section) {
        $store_id = $this->getStoreId();
        $sql="SELECT mail.sender_name,mail.sender_email,mail.subject,mail.content,mail.allowed_placeholders, sigs.content as signature, notify_admin
              FROM ". $this->db->table('email_editor_templates') . " mail 
              LEFT JOIN ". $this->db->table('email_editor_signatures') . " sigs on sigs.email_signature_id=mail.email_signature_id
              WHERE mail.section='".$section."' AND mail.store_id=".$store_id;
        $result=$this->db->query($sql);
        return $result->row;
    }

    /**
     * @param $dir
     * @return void
     */
    public function deleteAll($dir) {
        if(is_dir($dir)){
            $files = glob( $dir . '*', GLOB_MARK );
            foreach( $files as $file )
            {
                $this->deleteAll( $file );
            }
            rmdir( $dir );
        } elseif(is_file($dir)) {
            unlink( $dir );
        }
    }

    /**
     * @return int
     */
    public function getStoreId() {
        $store_id = (int)$this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int)$this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int)$this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }

}
