<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' ) || !IS_ADMIN) {
header ( 'Location: static_pages/' );
}

/**
 * ControllerResponsesListingGridCustomerTaxCertificateHistoryList
 * @property ModelExtensionCustomerGroupAutoAssigned $model_extension_customer_group_auto_assigned
 */
class ControllerResponsesListingGridCustomerTaxCertificateHistoryList extends AController {
    public $error = [];
    public $data = [];

    public function main() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('customer_group_auto_assigned/customer_group_auto_assigned');
        $this->loadModel('extension/customer_group_auto_assigned');

        //Prepare filter config
        $filter_params      = [ 'customer_id', 'company','filter_date_start', 'filter_date_end','upload_later' ];
        $grid_filter_params = [ 'customer_name','company', 'uploaded_at', 'expire','expire_date','verified','verified_by','verified_date'];
        $filter_form = new AFilter( [ 'method' => 'get', 'filter_params' => $filter_params ] );
        $filter_grid = new AFilter( [ 'method' => 'post', 'grid_filter_params' => $grid_filter_params ] );
        $data        = array_merge( $filter_form->getFilterData(), $filter_grid->getFilterData() );
        $data['filter']['customer_id'] = $this->request->get['customer_id'];
        $data['sort'] = isset($this->request->post['sidx']) ? $this->request->post['sidx'] : 'uploaded_at';
        $data['order'] = isset($this->request->post['sord']) ? $this->request->post['sord'] : 'DESC';
        $total = $this->model_extension_customer_group_auto_assigned->getTotalTaxExemptList($data);
        $response = new stdClass();
        $response->page = $filter_grid->getParam('page');
        $response->total = $filter_grid->calcTotalPages($total);
        $response->records = $total;
        $response->userdata = new stdClass();
        $response->userdata->classes = [];
        $results = $this->model_extension_customer_group_auto_assigned->getTaxExemptList($data);

        $i = 0;
        foreach ($results as $result) {
            $image_url='';
            $response->rows[$i]['id'] = $result['customer_group_auto_assigned_info_id'];
            if ($result['image_url']) {
                $base = HTTPS ? HTTPS_SERVER : HTTP_SERVER;
                $tax_certificate = $base . "image/customer_group_auto_assigned/";
                $image_url = '<strong><a href="' . $tax_certificate . $result['image_url'] . '" target="_BLANK">' . $tax_certificate . $result['image_url'] . '</a></strong>';
            } else {
                $image_url = '---';
            }
            $response->rows[$i]['cell'] = array(
                $result['customer_name'],
                $result['company'],
                $result['upload_later'] === '1' ? $this->language->get('text_yes') : $this->language->get('text_no'),
                $image_url,
                dateISO2Display($result['uploaded_at'], $this->language->get('date_format_short')),
                $result['expire'] === '1' ? $this->language->get('text_yes') : $this->language->get('text_no'),
                dateISO2Display($result['expire_date'], $this->language->get('date_format_short')),
                $result['verified']==='1' ? $this->language->get('text_yes'): $this->language->get('text_no'),
                $result['verified_by'],
                dateISO2Display($result['verified_date'], $this->language->get('date_format_short')),
            );
            $i++;
        }

        $this->data['response'] = $response;
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
        $this->load->library('json');
        $this->response->setOutput(AJson::encode($this->data['response']));
    }

    public function update() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        if (!$this->user->canModify('listing_grid/customer_tax_certificate_history_list')) {
            $error = new AError('');
            return $error->toJSONResponse('NO_PERMISSIONS_402',
                array( 'error_text' => sprintf($this->language->get('error_permission_modify'), 'listing_grid/customer_tax_certificate_history_list'),
                    'reset_value' => true
                ));
        }

        $this->loadLanguage('customer_group_auto_assigned/customer_group_auto_assigned');
        $this->loadModel('extension/customer_group_auto_assigned');

        switch ($this->request->post[ 'oper' ]) {
            case 'del':
                $ids = explode(',', $this->request->post[ 'id' ]);
                if (!empty($ids))
                    foreach ($ids as $id) {
                        $this->model_extension_customer_group_auto_assigned->removeData($id);
                    }
                break;
            default:
                //print_r($this->request->post);
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

}