<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}


/**
 * Class ControllerPagesSaleTaxCertificate
 * @property ModelExtensionCustomerGroupAutoAssignedLicenseInfo $model_extension_customer_group_auto_assigned_license_info
 * @property ModelExtensionCustomerGroupAutoAssigned $model_extension_customer_group_auto_assigned
 */

class ControllerPagesSaleTaxCertificate extends AController {
    private $error = [];
    public $data = [];
    public $datas = [];

    public function verify() {
        $this->load->model('extension/customer_group_auto_assigned_license_info');
        $license_key = $this->config->get('customer_group_auto_assigned_license_code');
        if ($license_key) {
            $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('customer_group_auto_assigned_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $this->model_extension_customer_group_auto_assigned_license_info->getStoreId();
                $license_key = $this->model_extension_customer_group_auto_assigned_license_info->getLicenseCode($store_id);
                $license_info = $this->model_extension_customer_group_auto_assigned_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], 'customer_group_auto_assigned');
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $this->model_extension_customer_group_auto_assigned_license_info->getLicensedStoreStatus();
                if ($validate['status'] === 'valid' && $store_status == 1) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function main() {
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadLanguage('customer_group_auto_assigned/customer_group_auto_assigned');
        $this->loadLanguage('sale/customer');
        $this->loadModel('sale/customer_transaction');
        $this->loadModel('sale/customer');
        $this->loadModel('sale/order');
        $this->load->model('extension/customer_group_auto_assigned');

        if ($this->request->get['customer_group_auto_assigned_info_id']) {
            $info = $this->model_extension_customer_group_auto_assigned->getInfoByInfoId($this->request->get['customer_group_auto_assigned_info_id']);
            $customer_id = $info['customer_id'];
            redirect($this->html->getSecureURL('sale/tax_certificate','&customer_id='.$customer_id));
        }

        if ($this->request->get['order_id']) {
            $order_info = $this->model_sale_order->getOrder($this->request->get['order_id']);
            $customer_id = $order_info['customer_id'];
            redirect($this->html->getSecureURL('sale/tax_certificate','&customer_id='.$customer_id));
        } elseif ($this->request->get['customer_id']) {
            $customer_id = $this->request->get['customer_id'];
            $customer_info = $this->model_sale_customer->getCustomer($customer_id);
            if (!has_value($customer_info)) {
                redirect($this->html->getSecureURL('sale/customer'));
            }
        }

        $this->document->setTitle($this->language->get('heading_title_tax_certificate'));

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/custgroup.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->initBreadcrumb(array(
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => false,
        ));
        $this->document->addBreadcrumb(array(
            'href'      => $this->html->getSecureURL('sale/customer'),
            'text'      => $this->language->get('heading_title'),
            'separator' => ' :: ',
        ));
        $this->document->addBreadcrumb(array(
            'href'      => $this->html->getSecureURL('sale/customer/update', '&customer_id='.$customer_id),
            'text'      => $this->language->get('text_edit').' '.$this->language->get('text_customer').' - '.$customer_info['firstname'].' '.$customer_info['lastname'],
            'separator' => ' :: ',
        ));
        $this->document->addBreadcrumb(array(
            'href'      => $this->html->getSecureURL('sale/tax_certificate', '&customer_id='.$customer_id),
            'text'      => $this->language->get('heading_title_tax_certificate'),
            'separator' => ' :: ',
            'current'   => true,
        ));

        $this->data['tabs']['general'] = [
            'href'   => $this->html->getSecureURL('sale/customer/update', '&customer_id='.$customer_id),
            'text'   => $this->language->get('tab_customer_details'),
        ];

        $this->data['tabs'][] = [
            'href' => $this->html->getSecureURL('sale/customer_transaction', '&customer_id=' . $customer_id),
            'text' => $this->language->get('tab_transactions'),
        ];

        $this->data['tabs'][] = [
            'href' => $this->html->getSecureURL('sale/tax_certificate', '&customer_id='.$customer_id),
            'text' => $this->language->get('tab_certificate'),
            'active' => true,
        ];

        if ($this->request->is_POST()) {
            $this->load->model('extension/customer_group_auto_assigned');

            if ($_FILES['upload_tax_exemption']) {
                $accept = ["image/jpeg", "image/png", "image/gif", "application/pdf"];
                $upmime = strtolower($_FILES["upload_tax_exemption"]["type"]);
                if (in_array($upmime, $accept)) {
                    $filename = $_FILES['upload_tax_exemption']['name'];
                    $temp_name = $_FILES['upload_tax_exemption']['tmp_name'];
                    $current_year = date('Y');
                    $current_month = date('m');
                    if ($filename) {
                        if (!file_exists(DIR_IMAGE . 'customer_group_auto_assigned/files/')) {
                            mkdir(DIR_IMAGE . 'customer_group_auto_assigned/files/');
                        }
                        if (!file_exists(DIR_IMAGE . 'customer_group_auto_assigned/files/' . $customer_id)) {
                            mkdir(DIR_IMAGE . 'customer_group_auto_assigned/files/' . $customer_id, 0755);
                        }

                        if (!file_exists(DIR_IMAGE . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year)) {
                            mkdir(DIR_IMAGE . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year, 0755);
                        }
                        if (!file_exists(DIR_IMAGE . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year . '/' . $current_month)) {
                            mkdir(DIR_IMAGE . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year . '/' . $current_month, 0755);
                        }

                        $upload_dir = DIR_IMAGE . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year . '/' . $current_month . '/';

                        // move file
                        $uploaded = move_uploaded_file($temp_name, $upload_dir . $filename);

                        if ($uploaded && $filename) {
                            $data['image_url'] = 'files/' . $customer_id . '/' . $current_year . '/' . $current_month . '/' . $filename;
                            $data['update'] = false;
                        }
                    }
                }
            }
            if (!isset($data['image_url'])) {
                $data['customer_group_auto_assigned_info_id'] = $this->request->post['customer_group_auto_assigned_info_id'];
                $info = $this->model_extension_customer_group_auto_assigned->getInfoByInfoId($this->request->post['customer_group_auto_assigned_info_id']);
                $data['image_url'] = $info['image_url'];
                $data['uploaded_at'] = $info['uploaded_at'];
                $data['update'] = true;
            }
            $data['verified'] = $this->request->post['verified'];
            $data['verified_by'] = $this->request->post['verified_by'];
            $data['verified_date'] = $this->request->post['verified_date'];

            $customer_group_id = $this->model_extension_customer_group_auto_assigned->getCustomerGroupId($customer_id);
            $data['customer_group_id'] = $customer_group_id;
            $data['expire'] = $this->request->post['expire'];
            $data['expiration_date'] = $this->request->post['expiration_date'];
            $data['comment'] = $this->request->post['comment'];
            $this->model_extension_customer_group_auto_assigned->updateCustomerValues($customer_id,$data);
            redirect($this->html->getSecureURL('sale/tax_certificate', '&customer_id='.$customer_id));
        }

        if ($this->request->get['tec_id']) {
            $tax_cert_info = $this->model_extension_customer_group_auto_assigned->getCustomerValuesById($customer_id,$this->request->get['tec_id']);
        } else {
            $tax_cert_info = $this->model_extension_customer_group_auto_assigned->getCustomerValues($customer_id);
        }

        if ($tax_cert_info) {
            $this->datas['verified'] = $tax_cert_info['verified'];
            $this->datas['verified_by'] = $tax_cert_info['verified_by'];
            $this->datas['verified_date'] = $tax_cert_info['verified_date'];
            $this->datas['comment'] = $tax_cert_info['comment'];
            $this->datas['expire'] = $tax_cert_info['expire'];
            $this->datas['expiration_date'] = $tax_cert_info['expire_date'];
            $this->datas['customer_group_auto_assigned_info_id'] = $tax_cert_info['customer_group_auto_assigned_info_id'];
        } else {
            $this->datas['verified'] = '';
            $this->datas['verified_by'] = '';
            $this->datas['verified_date'] = '';
            $this->datas['expire'] = '';
            $this->datas['expiration_date'] = '';
            $this->datas['customer_group_auto_assigned_info_id'] = '';
        }

        $this->data['action'] = $this->html->getSecureURL(
            'sale/tax_certificate',
            '&customer_id='.$this->request->get['customer_id']
        );

        $this->data ['update'] = '';

        $form = new AForm('HS');
        $form->setForm ( array ('form_name' => 'editFrm', 'update' => $this->data ['update'] ) );

        $this->data['form']['form_open'] = $form->getFieldHtml(
            [
                'type'   => 'form',
                'name'   => 'editFrm',
                'action' => $this->data['action'],
                'attr'   => 'data-confirm-exit="true"  class="form-horizontal"',
            ]
        );

        $this->data['form']['fields']['customer_group_auto_assigned_info_id'] = $form->getFieldHtml([
            'type'    => 'hidden',
            'name'    => 'customer_group_auto_assigned_info_id',
            'value'   => $this->datas['customer_group_auto_assigned_info_id'],
            'style' => 'small-field',
        ]);

        $verified=[
            '1' => $this->language->get('text_yes'),
            '0' => $this->language->get('text_no')
        ];

        $this->data['form']['fields']['verified_date'] = $form->getFieldHtml([
            'type' => 'date',
            'name' => 'verified_date',
            'value' => dateISO2Display($this->datas[ 'verified_date' ]),
            'default' => dateISO2Display($this->datas[ 'verified_date' ]),
            'dateformat' => format4Datepicker($this->language->get('date_format_short')),
            'highlight' => 'future',
            'style' => 'small-field',
        ]);

        $this->view->assign('entry_verified_date',$this->language->get('entry_verified_date'));

        $this->data['form']['fields']['verified'] = $form->getFieldHtml([
            'type'    => 'selectbox',
            'name'    => 'verified',
            'options' => $verified,
            'value'   => $this->datas['verified'],
            'style' => 'small-field',
        ]);
        $this->view->assign('entry_verified',$this->language->get('entry_verified'));

        $this->data['form']['fields']['verified_by'] = $form->getFieldHtml([
            'type'     => 'input',
            'name'     => 'verified_by',
            'value'    => $this->datas['verified_by'],
            'style'    => 'small-field',
            'required' => false,
        ]);
        $this->view->assign('entry_verified_by',$this->language->get('entry_verified_by'));

        $this->data['form']['fields']['comment'] = $form->getFieldHtml([
            'type'     => 'input',
            'name'     => 'comment',
            'value'    => $this->datas['comment'],
            'style'    => 'medium-field',
            'required' => false,
        ]);
        $this->view->assign('entry_comment',$this->language->get('entry_comment'));

        $this->data['form']['fields']['upload_tax_exemption'] = $form->getFieldHtml([
            'type'     => 'file',
            'name'     => 'upload_tax_exemption',
            'attr'     => 'accept="image/png, image/gif, image/jpeg,application/pdf"',
            'style' => 'small-field',
        ]);
        $this->view->assign('entry_upload_tax_exemption',$this->language->get('entry_upload_customer_tax_exemption'));

        $options = [
            '1' => $this->language->get('text_yes'),
            '0' => $this->language->get('text_no')
        ];

        $this->data['form']['fields']['expire'] = $form->getFieldHtml([
            'type'    => 'selectbox',
            'name'    => 'expire',
            'options' => $options,
            'value'   => $this->datas['expire'],
            'style' => 'small-field',
        ]);
        $this->view->assign('entry_expire',$this->language->get('entry_expire'));

        $this->data['form']['fields']['expiration_date'] = $form->getFieldHtml([
            'type' => 'date',
            'name' => 'expiration_date',
            'value' => dateISO2Display($this->datas[ 'expiration_date' ]),
            'default' => dateISO2Display($this->datas[ 'expiration_date' ]),
            'dateformat' => format4Datepicker($this->language->get('date_format_short')),
            'highlight' => 'future',
            'style' => 'small-field',
        ]);

        $this->view->assign('entry_expiration_date',$this->language->get('entry_expiration_date'));

        $this->data['entry_customer_tax_exempt_certificate'] = $this->language->get('entry_customer_tax_exempt_certificate');

        //$tax_certificate = $this->model_extension_customer_group_auto_assigned->getImage($customer_id);

        $base = HTTPS ? HTTPS_SERVER : HTTP_SERVER;
        if ($tax_cert_info['image_url']) {
            $ext = pathinfo($tax_cert_info['image_url'], PATHINFO_EXTENSION);
            if (strtolower($ext)==='pdf') {
                $this->data['tax_certificate'] = '<object width="400px" height="400px" data="' . $base . 'image/customer_group_auto_assigned/' . $tax_cert_info['image_url'] . '"></object>';
            } else {
                $this->data['tax_certificate'] = '<a href="' . $base . 'image/customer_group_auto_assigned/' . $tax_cert_info['image_url'] . '" target="_empty"><img src="' . $base . 'image/customer_group_auto_assigned/' . $tax_cert_info['image_url'] . '" style="max-width: 100%;height: auto;"/></a>';
            }
        }

        $this->data['text_history'] = $this->language->get('text_history');
        $this->data['tax_certificate_note'] = $this->language->get('tax_certificate_note');
        $this->view->assign('button_save',$this->language->get('button_save'));
        $this->view->assign('button_cancel',$this->language->get('button_cancel'));
        $this->view->assign('cancel_url',$this->html->getSecureURL('sale/tax_certificate','&customer_id='.$this->request->get['customer_id'],true));

        $grid_settings = [
            'table_id'     => 'customer_tax_certificate_history_list',
            'url'          => $this->html->getSecureURL('listing_grid/customer_tax_certificate_history_list','&customer_id='.$this->request->get['customer_id']),
            'editurl'      => $this->html->getSecureURL('listing_grid/customer_tax_certificate_history_list/update'),
            'sortname'     => 'customer_name',
            'sortorder'    => 'asc',
            'sortorder'    => 'asc',
            'actions'      => [
                'edit'     => [
                    'text' => $this->language->get('text_edit'),
                    'href' => $this->html->getSecureURL('sale/edit_tax_certificate', '&customer_group_auto_assigned_info_id=%ID%'),
                ],
                'delete' => [
                    'text' => $this->language->get('button_delete')
                ],
            ],
        ];

        $grid_settings['colNames'] = [
            $this->language->get('column_customer_name'),
            $this->language->get('column_company'),
            $this->language->get('column_upload_later'),
            $this->language->get('column_image_url'),
            $this->language->get('column_uploaded_at'),
            $this->language->get('column_expire'),
            $this->language->get('column_expire_date'),
            $this->language->get('column_verified'),
            $this->language->get('column_verified_by'),
            $this->language->get('column_verified_date'),
        ];
        $grid_settings['colModel'] = [
            [
                'name'  => 'customer_name',
                'index' => 'customer_name',
                'align' => 'center',
                'width' => 200,
                'search'   => false,
            ],
            [
                'name'  => 'company',
                'index' => 'company',
                'align' => 'center',
                'width' => 150,
                'search'   => false,
            ],
            [
                'name'  => 'upload_later',
                'index' => 'upload_later',
                'align' => 'center',
                'width' => 120,
                'search'   => false,
            ],
            [
                'name'  => 'image_url',
                'index' => 'image_url',
                'align' => 'center',
                'width' => 250,
                'search'   => false,
                'sortable'   => false,
            ],
            [
                'name'   => 'uploaded_at',
                'index'  => 'uploaded_at',
                'align'  => 'center',
                'width'  => 150,
                'search' => false,
            ],
            [
                'name'   => 'expire',
                'index'  => 'expire',
                'align'  => 'center',
                'width'  => 130,
                'search' => false,
                'sortable'   => false,
            ],
            [
                'name'   => 'expire_date',
                'index'  => 'expire_date',
                'align'  => 'center',
                'width'  => 150,
                'search' => false,
            ],
            [
                'name'     => 'verified',
                'index'    => 'verified',
                'align'    => 'center',
                'width'    => 120,
                'search'   => false,
            ],
            [
                'name'     => 'verified_by',
                'index'    => 'verified_by',
                'align'    => 'center',
                'width'    => 150,
                'search'   => false,
            ],
            [
                'name'     => 'verified_date',
                'index'    => 'verified_date',
                'align'    => 'center',
                'width'    => 150,
                'search'   => false,
            ],
        ];

        $grid_settings['search_form'] = false;
        $grid_settings['multiselect'] = "true";
        $grid_settings['multiaction_options']['delete'] = $this->language->get('text_delete_selected');

        $grid = $this->dispatch('common/listing_grid', [$grid_settings]);

        $this->data['listing_grid'] =  $grid->dispatchGetOutput();
        $this->data['license_status'] = $this->verify();
        $this->data['text_unauthorized'] = $this->language->get('text_customer_group_auto_assigned_unauthorized');

        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());
        $this->view->batchAssign($this->data);
        $this->processTemplate('pages/sale/tax_certificate.tpl');
    }
}