<?php
if ( !defined ( 'DIR_CORE' )) {
	header ( 'Location: static_pages/' );
}
/**
 * Class ModelSaleCustomerAttributes
 */
/** @noinspection PhpUndefinedClassInspection */
class ModelSaleCustomerAttributes extends Model {
	/**
	 * @param int $customer_group_id
	 * @param int $language_id
	 * @return array
	 */
	public function getAttributesForGroup($customer_group_id, $language_id) {
		$language_id = !$language_id ? $this->language->getContentLanguageID() : $language_id;
		$results = $this->db->query(
			"SELECT
				cag.customer_attribute_id,
				cag.customer_group_id,
				cad.name, cad.error_text
			FROM " . DB_PREFIX . "customer_attributes_to_groups cag
			LEFT JOIN " . DB_PREFIX . "customer_attributes ca ON ca.customer_attribute_id = cag.customer_attribute_id
			INNER JOIN " . DB_PREFIX . "customer_attribute_descriptions cad	ON ca.customer_attribute_id = cad.customer_attribute_id
			WHERE
				cag.customer_group_id = " . (int) $customer_group_id . "
				AND cad.language_id = " . (int) $language_id
		);

		return $results->rows;
	}

	/**
	 * @param int $customer_attribute_id
	 * @param int $customer_group_id
	 * @return array
	 */
	public function getAttributeInfo($customer_attribute_id, $customer_group_id) {
		$language_id = $this->language->getContentLanguageID();
		$sql = "SELECT
						cag.customer_group_id,
						cag.editable_by_customer,
						cag.visible_by_customer,
						cag.status,
						gad.name,
						gad.error_text,
						ca.customer_attribute_id,
						ca.element_type,
						ca.sort_order,
						ca.settings,
						ca.required,
						ca.regexp_pattern
					FROM " . $this->db->table('customer_attributes_to_groups')." cag
					LEFT JOIN " . $this->db->table('customer_attributes')." ca ON cag.customer_attribute_id = ca.customer_attribute_id
					LEFT JOIN " . $this->db->table('customer_attribute_descriptions')." gad
						ON ( cag.customer_attribute_id = gad.customer_attribute_id AND gad.language_id = '" . (int) $language_id . "')
					WHERE ca.customer_attribute_id = " . (int) $customer_attribute_id . "
					".((int)$customer_group_id ? " AND cag.customer_group_id='".(int)$customer_group_id."'" :"")."
					ORDER BY ca.sort_order ASC";
		$results = $this->db->query($sql);
		$output = $results->rows;
		foreach($output as &$row){
			$settings = unserialize($row['settings']);
			$row['settings'] = array();
			$row['settings'] = $settings;
			$row['values'] = $this->getAttributeValues($row['customer_attribute_id'], $language_id);
		}
		return $output;
	}

	/**
	 * @param int $attribute_id
	 * @param int $language_id
	 * @return array
	 */
	public function getAttributeValues($attribute_id, $language_id) {
		$language_id = !$language_id ? $this->language->getContentLanguageID() : $language_id;
		$sql = "SELECT gav.customer_attribute_value_id, gav.sort_order, gavd.value
				FROM " . DB_PREFIX . "customer_attribute_values_to_groups gav
				INNER JOIN " . DB_PREFIX . "customer_attribute_value_descriptions_to_groups gavd
					ON (gav.customer_attribute_value_id = gavd.customer_attribute_value_id AND gavd.language_id = " . (int) $language_id . ")
				WHERE gav.customer_attribute_id = " . (int) $attribute_id . "
				ORDER BY gav.sort_order ASC";
		$results = $this->db->query($sql);
		return (array)$results->rows;
	}

	/**
	 * @param int $customer_group_id
	 * @param array $data
	 * @return bool
	 */
	public function addAttributeToGroup($customer_group_id, $data) {
		if(!$data || !$customer_group_id){
			return null;
		}
		if ( (int)$data['attribute_id'] ) {

			$sql = "INSERT INTO " . DB_PREFIX . "customer_attributes_to_groups
					SET
					customer_attribute_id = ". (int) $data['customer_attribute_id'] .",
					customer_group_id = ". (int) $customer_group_id;

			if ( isset($data['editable']) ) {
				$edit = ( (int) $data['editable'] > 0 ) ? 1 : 0;
				$sql .= ", editable_by_customer = " . $edit;
			}

			if ( isset($data['visible']) ) {
				$visible = ( (int) $data['visible'] > 0 ) ? 1 : 0;
				$sql .= ", visible_by_customer = " . $visible;
			}

			if ( isset($data['status']) ) {
				$status = ( (int) $data['status'] > 0 ) ? 1 : 0;

			} else {
				$status = 0;
			}
			$sql .= ", status = " . $status;

			$this->db->query($sql);
			return true;
		}
		return false;
	}

	/**
	 * Function delete ONLY assistanse of customer attribute to customer group
	 * @param int $customer_attribute_id
	 * @param int $customer_group_id
	 */
	public function removeCustomerAttributeFromGroup($customer_attribute_id, $customer_group_id) {

		$this->db->query('DELETE FROM ' . DB_PREFIX . 'customer_attributes_to_groups
						  WHERE customer_attribute_id = ' . (int) $customer_attribute_id . '
						  		AND customer_group_id = ' . (int) $customer_group_id);

		$this->db->query('DELETE FROM ' . DB_PREFIX . 'customer_attribute_values_to_groups
						  WHERE customer_attribute_id = ' . (int) $customer_attribute_id . ' AND customer_group_id = ' . (int) $customer_group_id);
		$this->db->query('DELETE FROM ' . DB_PREFIX . 'customer_attribute_value_descriptions_to_groups
						  WHERE customer_attribute_id = ' . (int) $customer_attribute_id . ' AND customer_group_id = ' . (int) $customer_group_id);
	}

	/**
	 * @param int $customer_group_id
	 * @param array $data
	 * @return bool|int
	 */
	public function addCustomerAttribute($customer_group_id, $data){
		if(!(int)$customer_group_id || !is_array($data)){
			return false;
		}
		$attribute_manager = new AAttribute_Manager();
		if((int)$data['global_attribute_id']){
			$ga_info = $attribute_manager->getAttribute((int)$data['global_attribute_id']);
			if(!$ga_info){
				return false;
			}
			$ga_info['attribute_descriptions'] = $attribute_manager->getAttributeDescriptions((int)$data['global_attribute_id']);
			$data = array_merge($data,$ga_info);
		}else{
			$data['attribute_descriptions'][$this->language->getContentLanguageID()] = array(
																			'name' => $data['name'],
																			'error_text' => $data['error_text'],
			);
		}

		$this->db->query("INSERT INTO ".$this->db->table('customer_attributes')."
							SET global_attribute_id = '" . (int)$data['global_attribute_id'] . "',
								element_type = '" . $this->db->escape($data['element_type']) . "',
								sort_order = '" . (int)$data['sort_order'] . "',
								required = '" . (int)$data['required'] . "',
								settings = '" . $this->db->escape($data['settings']) . "',
								regexp_pattern = '" . $this->db->escape($data['regexp_pattern']) . "'");
		$customer_attribute_id = $this->db->getLastId();
		// assign customer attribute to customer group
		$this->db->query("INSERT INTO ".$this->db->table('customer_attributes_to_groups')."
							SET customer_attribute_id = '" . (int)$customer_attribute_id . "',
								customer_group_id = '" . (int)$customer_group_id . "',
								editable_by_customer = '" . (int)$data['editable_by_customer'] . "',
								visible_by_customer = '" . (int)$data['visible_by_customer'] . "',
								status = '" . (int)$data['status'] . "'");

		// insert descriptions for used content language and translate
		$allowed_fields = array('name', 'error_text');
		foreach($data['attribute_descriptions'] as $lang_id => $values){
			foreach($values as $n=>$v){
				if(!in_array($n, $allowed_fields)){
					continue;
				}
				$attr_descriptions[$lang_id][$n] = $v;
			}
		}

		$this->language->replaceDescriptions('customer_attribute_descriptions',
											 array('customer_attribute_id' => (int)$customer_attribute_id),
											$attr_descriptions );
		if((int)$data['global_attribute_id']){
			$ga_values = $attribute_manager->getAttributeValues($data['global_attribute_id']);
			foreach($ga_values as $ga_value){
				$attribute_value_id = $this->addCustomerAttributeValue(array('customer_attribute_id' => $customer_attribute_id,
				                                                             'customer_group_id'     => $customer_group_id,
				                                                             'editable_by_customer'  => (int)$data['editable_by_customer'],
				                                                             'visible_by_customer'   => (int)$data['visible_by_customer'],
				                                                             'sort_order'            => (int)$ga_value['sort_order']));

				$ga_values_descriptions = $attribute_manager->getAttributeValueDescriptions($ga_value['attribute_value_id']);
				foreach($ga_values_descriptions as $lang_id => $ga_val){
					$descriptions[$lang_id] = array('value' => $ga_val);
				}
				$all_languages = $this->language->getActiveLanguages();
				if(!$descriptions[$this->language->getDefaultLanguageID()]){
					$default_descriptions = current($descriptions);
				} else{
					$default_descriptions = $descriptions[$this->language->getDefaultLanguageID()];
				}


				foreach($all_languages as $lang){
					if(!in_array($lang['language_id'], array_keys($descriptions))){
						$descriptions[$lang['language_id']] = $default_descriptions;
					}
				}

				$this->language->replaceDescriptions('customer_attribute_value_descriptions_to_groups',
						array('customer_attribute_value_id' => $attribute_value_id,
						      'customer_attribute_id'       => (int)$customer_attribute_id,
						      'customer_group_id'           => (int)$customer_group_id),
						$descriptions);

			}
		}else{
			//add empty option value for single value attributes
			$elements_with_options = HtmlElementFactory::getElementsWithOptions();
			if(!in_array($data['element_type'], $elements_with_options)){
				$attr_val_id = $this->addCustomerAttributeValue(array(
						'customer_attribute_id' => $customer_attribute_id,
						'customer_group_id' => (int)$customer_group_id
				));
				$all_languages = $this->language->getActiveLanguages();
				foreach($all_languages as $lang){
					$descr[$lang['language_id']] = array('value' => $value_data['name']);
				}
				$this->language->replaceDescriptions('customer_attribute_value_descriptions_to_groups',
							 array(	'customer_attribute_value_id' => (int)$attr_val_id,
							        'customer_attribute_id' => $customer_attribute_id,
							        'customer_group_id' => $customer_group_id),
							 $descr
							 );
			}
		}
		return $customer_attribute_id;
	}

	/**
	 * @param array $data
	 * @return bool|int
	 */
	public function addCustomerAttributeValue($data=array()) {
		if ( empty($data['customer_attribute_id']) || empty($data['customer_group_id'])) {
			return false;
		}
		$sql = "INSERT INTO `".$this->db->table('customer_attribute_values_to_groups')."`
				SET customer_attribute_id = '" . (int)$data['customer_attribute_id'] . "',
				    customer_group_id = '" . (int)$data['customer_group_id'] . "',
					sort_order = '" . (int)$data['sort_order'] . "'";
		$this->db->query( $sql );
		return $this->db->getLastId();
	}

	/**
	 * @param int $customer_attribute_id
	 * @param array $data
	 */
	public function updateAttribute($customer_attribute_id, $data=array()) {
		//Note: update is done per 1 language
	    $language_id = $this->session->data['content_language_id'];
        $fields = array( 'required',
                         'sort_order',
						 'settings',
						 'regexp_pattern');

		if ( has_value($data['settings']) ) {
			$data['settings'] = serialize($data['settings']);
		}

        $update = array();
        foreach ( $fields as $f ) {
            if ( isset($data[$f]) ) {
                $update[] = "$f = '".$this->db->escape($data[$f])."'";
			}
        }

        if ( !empty($update) ) {
	        $sql = "UPDATE " . DB_PREFIX . "customer_attributes
					SET ". implode(',', $update) ."
					WHERE customer_attribute_id = '" . (int)$customer_attribute_id . "'";
            $this->db->query( $sql );
        }

		$sql = "UPDATE " . DB_PREFIX . "customer_attributes_to_groups
				SET
				status = '".(int)$data['status']."',
				editable_by_customer = '".(int)$data['editable']."',
				visible_by_customer = '".(int)$data['visible']."'
				WHERE customer_attribute_id = '" . (int)$customer_attribute_id . "'
						AND customer_group_id = '".(int)$data['customer_group_id']."'";
		$this->db->query( $sql );

		$update = array();
		if(isset($data['name'])){
			$update['name'] = $data['name'];
		}
		if(isset($data['error_text'])){
			$update['error_text'] = $data['error_text'];
		}

		$this->language->replaceDescriptions('customer_attribute_descriptions',
											 array('customer_attribute_id' => (int)$customer_attribute_id),
											 array($language_id => $update) );
        $this->clearCache();
    }

	/**
	 * @param array $data
	 */
	public function updateAttributesToGroups($data = array()) {
		$data = (array)$data;
		$this->db->query(
			"UPDATE " . DB_PREFIX . "customer_attributes_to_groups
			SET
				editable_by_customer = " . (int) $data['editable'] . ",
				visible_by_customer = " . (int) $data['visible'] . ",
				status = " . (int) $data['status'] . "
			WHERE
				global_attribute_id = ". (int) $data['attribute_id'] . "
				AND customer_group_id = ". (int) $data['customer_group_id']	);

		$this->clearCache();
	}

	/**
	 * @param int $customer_attribute_id
	 * @param int $customer_group_id
	 * @param array $data
	 */
	public function updateAttributeValues($customer_attribute_id, $customer_group_id=0, $data=array()) {

		$language_id = $this->language->getContentLanguageID();

		if ( isset($data['settings']) ) {
			if ( isset($this->request->get['name']) ) {
				$data['name'] = $this->request->get['name'];
			}
			$this->updateAttribute($customer_attribute_id, $data);
		} else {
			$data['attribute_value_id'] = (array)$data['attribute_value_id'];
			foreach ( $data['attribute_value_id'] as $key => $status ) {
				$value_data = array(
					'attribute_value_id' => $data['attribute_value_id'][$key],
					'name' => $data['name'][$key],
					'sort_order' => $data['sort_order'][$key],
				);

				//Check if new, delete or update
				if ( $status == 'delete' && strpos($key,'new')===FALSE) {
					//delete this attribute value for all languages
					$languages = $this->language->getActiveLanguages();
					foreach ( $languages as $lang ) {
						$this->language->deleteDescriptions('customer_attribute_value_descriptions_to_groups',
															 array(	'customer_attribute_value_id' => (int)$key,
																 	'customer_group_id' => (int)$customer_group_id,
																	'language_id' => (int)$lang['language_id'] )
															 );
					}
					$sql = "DELETE FROM `".DB_PREFIX."customer_attribute_values_to_groups`
							WHERE customer_attribute_value_id = '" . (int)$key . "'
								AND customer_attribute_id = '" . $customer_attribute_id . "'
								AND customer_group_id = ".(int)$customer_group_id;
					$this->db->query($sql);
				}
				else if ( $status == 'new') {
					// Need to create new attribute value
					$sql = "INSERT INTO `".DB_PREFIX."customer_attribute_values_to_groups`
							SET customer_attribute_id = '" . $customer_attribute_id . "',
								sort_order = '" . (int)$value_data['sort_order'] . "',
								customer_group_id = '" . (int)$customer_group_id . "'";
					$this->db->query( $sql );
					$val_id = $this->db->getLastId();
					$descr = array();
					if($language_id!=$this->language->getDefaultLanguageID()){
						$all_languages = $this->language->getActiveLanguages();
						foreach($all_languages as $lang){
							$descr[$lang['language_id']] = array('value'=>$value_data['name']);
						}

					}else{
						$descr = array(   $language_id => array('value'=>$value_data['name']));
					}
					$this->language->replaceDescriptions('customer_attribute_value_descriptions_to_groups',
														 array(	'customer_attribute_value_id' => (int)$val_id,
														 		'customer_attribute_id' => $customer_attribute_id,
														 		'customer_group_id' => $customer_group_id),
														 $descr
														 );

				} else {
					//Existing need to update
					$sql = "UPDATE `".DB_PREFIX."customer_attribute_values_to_groups`
							SET sort_order = '" . (int)$value_data['sort_order'] . "'
							WHERE customer_attribute_id = '" . $customer_attribute_id . "' AND customer_attribute_value_id = '".$key."' AND customer_group_id=".(int)$customer_group_id;
					$this->db->query( $sql );
					$this->language->replaceDescriptions('customer_attribute_value_descriptions_to_groups',
														 array(	'customer_attribute_value_id' => (int)$key,
																'customer_attribute_id' => $customer_attribute_id,
														 		'customer_group_id' =>(int)$customer_group_id ),
														array(   $language_id => array('value' => $value_data['name'])) );
				}
			}
		}
		$this->clearCache();
	}

	/**
	 * @param int $attribute_value_id
	 */
	public function deleteGlobalAttributeValueDescription($attribute_value_id) {
		$this->db->query("DELETE FROM " . $this->db->table('global_attributes_value_descriptions')."
						WHERE attribute_value_id = " . (int) $attribute_value_id );
        $this->clearCache();
	}

	/**
	 * @param int $customer_id
	 * @return array
	 */
	public function getCustomerAttributes($customer_id) {

		$sql = "SELECT customer_group_id FROM ".$this->db->table('customers')." WHERE customer_id = " . (int) $customer_id;
		$result = $this->db->query($sql);
		$customer_group_id = $result->row['customer_group_id'];

		$attributes = $this->db->query(" SELECT ca.*, cag.*
										FROM " . $this->db->table('customer_attributes') . " ca
										INNER JOIN " . $this->db->table('customer_attributes_to_groups') . " cag
											ON cag.customer_attribute_id = ca.customer_attribute_id
										WHERE customer_group_id = " . (int) $customer_group_id."
												AND cag.status=1
										ORDER BY ca.sort_order" );

		$results = $attributes->rows;
		$output = array();
		foreach ( $results as $k=>$item ) {
			$selected_values = $this->db->query("SELECT customer_attribute_value_id, customer_attribute_value
												FROM " . $this->db->table('customer_attribute_values')."
												WHERE customer_attribute_id = " . $item['customer_attribute_id']."
													AND customer_id = '".$customer_id."'"
			);
			$item['selected_values'] = $selected_values->rows;
			$attr = $this->getAttributeInfo($item['customer_attribute_id'],$customer_group_id);
			$output[$k] = array_merge($item, $attr[0]);
		}
		return $output;
	}

	/**
	 * @param int $customer_id
	 * @return array
	 */
	public function getCustomerAttributesIds($customer_id) {
		$ids = array();
		$res = $this->db->query("SELECT customer_attribute_id
								FROM " . $this->db->table('customer_attributes_to_groups')."
								WHERE customer_group_id = (
									SELECT customer_group_id
									FROM ".$this->db->table('customers')."
									WHERE customer_id=".(int) $customer_id." )");
		foreach ( $res->rows as $row ) {
			$ids[] = $row['customer_attribute_id'];
		}
		return $ids;
	}

	/**
	 * @param int $customer_id
	 * @param array $data
	 * @return bool
	 */
	public function updateCustomerAttributeValues($customer_id, $data) {

		if ( !has_value($data) ) {
			return false;
		}

		$attributes = $this->getCustomerAttributes($customer_id);
		foreach($attributes as $attribute){
			$item = $data[$attribute['customer_attribute_id']];
			if(isset($data[$attribute['customer_attribute_id']])
			 || (!isset($data[$attribute['customer_attribute_id']]) && $attribute['element_type']=='C')
			){
				// for unchecked checkbox
				if((!isset($data[$attribute['customer_attribute_id']]) && $attribute['element_type']=='C')
				&& sizeof($data)!=1){
					$item = '';
				}

				$this->db->query( "DELETE FROM  " . DB_PREFIX . "customer_attribute_values
								WHERE customer_attribute_id = '" . (int) $attribute['customer_attribute_id']."'
								AND customer_id = '" . (int) $customer_id ."'" );
				if ( is_array($item) ) {
					foreach ( $item as $val ) {
						$this->db->query(  "INSERT INTO " . DB_PREFIX . "customer_attribute_values
											SET customer_id = '" . (int) $customer_id ."',
												customer_attribute_id = '" . (int) $attribute['customer_attribute_id'] ."',
												customer_attribute_value = '" . $this->db->escape($val) . "'");
					}
				} else {
					$this->db->query( "INSERT INTO " . DB_PREFIX . "customer_attribute_values
										SET customer_id = '" . (int) $customer_id ."',
											customer_attribute_id = '" . (int) $attribute['customer_attribute_id'] ."',
											customer_attribute_value = '" . $this->db->escape($item) . "'");
				}
			}
		}

		$this->clearCache();
		return true;
	}

	private function clearCache(){
		$this->cache->delete('customer_attribute');
	}
}