<?php
/*------------------------------------------------------------------------------
  $Id$

  AbanteCart, Ideal OpenSource Ecommerce Solution
  http://www.AbanteCart.com

  Copyright © 2011 Belavier Commerce LLC

  This source file is subject to Open Software License (OSL 3.0)
  License details is bundled with this package in the file LICENSE.txt.
  It is also available at this URL:
  <http://www.opensource.org/licenses/OSL-3.0>

 UPGRADE NOTE:
   Do not edit or add to this file if you wish to upgrade AbanteCart to newer
   versions in the future. If you wish to customize AbanteCart for your
   needs please refer to http://www.AbanteCart.com for more information.
------------------------------------------------------------------------------*/
if (!defined('DIR_CORE') || !IS_ADMIN) {
	header('Location: static_pages/');
}
/** @noinspection PhpUndefinedClassInspection
 *
 * Class ControllerResponsesSaleCustomerAttributesResponse
 * @property ModelSaleCustomerAttributes $model_sale_customer_attributes
 */
class ControllerResponsesSaleCustomerAttributesResponse extends AController {

	public $data = array();

	public function get_attributes_list() {
		//init controller data
		$this->extensions->hk_InitData($this, __FUNCTION__);

		$this->loadModel('sale/customer_attributes');

		$attributes = $this->model_sale_customer_attributes->getAttributesForGroup(
			$this->request->get['customer_group_id'],
			$this->language->getContentLanguageID()
		);
		foreach($attributes as $attr){
			$this->data['attributes'][$attr['customer_attribute_id']] = $attr['name'];
		}
		//update controller data
		$this->extensions->hk_UpdateData($this, __FUNCTION__);

		$this->load->library('json');
		$this->response->addJSONHeader();
		$this->response->setOutput(AJson::encode($this->data['attributes']));
	}

	public function remove_attribute() {
		$this->loadLanguage('sale/customer_attributes');
		$this->loadModel('sale/customer_attributes');
		$this->model_sale_customer_attributes->removeCustomerAttributeFromGroup($this->request->get['attribute_id'], $this->request->get['customer_group_id']);
		$this->response->setOutput($this->language->get('text_attribute_removed'));
	}

	public function update_attribute() {

		$this->loadLanguage('sale/customer_attributes');
		$this->loadModel('sale/customer_attributes');

		//needs to validate attribute properties
		// first - prepare data for validation
		if (!isset($this->request->get['required'])) {
			$this->request->get['required'] = 0;
		}

		if (has_value($this->request->get['regexp_pattern'])) {
			$this->request->get['regexp_pattern'] = trim($this->request->get['regexp_pattern']);
		}

		$attribute_manager = new AAttribute_Manager('customer_attribute');


		$data = $this->request->get;
		$data['attribute_type_id'] = $attribute_manager->getAttributeTypeID('customer_attribute');

		$errors = $attribute_manager->validateAttributeCommonData($data);
		if (!$errors) {
			$this->model_sale_customer_attributes->updateAttribute($this->request->get['attribute_id'], $data);
			$this->response->setOutput($this->language->get('text_success_attribute'));
		} else {
			$error = new AError('');
			return $error->toJSONResponse('',
				array('error_title' => implode('<br>', $errors)));
		}
	}

	public function update_attribute_values() {
		$this->loadLanguage('sale/customer_attributes');
		$this->loadModel('sale/customer_attributes');
		$this->model_sale_customer_attributes->updateAttributeValues($this->request->get['attribute_id'], $this->request->get['customer_group_id'], $this->request->post);
		$this->session->data['success'] = $this->language->get('text_success_attribute');

		$this->redirect($this->html->getSecureURL(
			'sale/customer_attributes_response/load_attribute',
				'&customer_group_id=' . $this->request->get['customer_group_id'] .
				'&attribute_id=' . $this->request->get['attribute_id']
		));
	}

	public function load_attribute() {

		$this->loadLanguage('sale/customer_attributes');
		$this->loadLanguage('catalog/attribute');

		$this->loadModel('sale/customer_attributes');

		$this->view->assign('success', $this->session->data['success']);
		unset($this->session->data['success']);

		$this->data['language_id'] = $this->language->getContentLanguageID();

		$this->data['attribute_data'] = $this->model_sale_customer_attributes->getAttributeInfo($this->request->get['attribute_id'], $this->request->get['customer_group_id']);
		$this->data['attribute_data'] = $this->data['attribute_data'][0];

		$this->data['element_types'] = HtmlElementFactory::getAvailableElements();
		$this->data['elements_with_options'] = HtmlElementFactory::getElementsWithOptions();
		$this->data['selectable'] = in_array($this->data['attribute_data']['element_type'], $this->data['elements_with_options']) ? 1 : 0;
		$this->data['attribute_type'] = $this->data['element_types'][$this->data['attribute_data']['element_type']]['type'];


		$this->data['update_attribute'] = $this->html->getSecureURL(
			'sale/customer_attributes_response/update_attribute',
				'&customer_group_id=' . $this->request->get['customer_group_id'] .
				'&attribute_id=' . $this->request->get['attribute_id']
		);

		$this->data['attribute_name'] = $this->html->buildElement(array(
			'type' => 'input',
			'name' => 'name',
			'value' => $this->data['attribute_data']['name'],
			'style' => 'large-field'
		));
		$this->data['status'] = $this->html->buildElement(array(
			'type' => 'checkbox',
			'name' => 'status',
			'value' => $this->data['attribute_data']['status'],
			'style' => 'btn_switch btn-group-xs',
		));
		$this->data['sort_order'] = $this->html->buildElement(array(
			'type' => 'input',
			'name' => 'sort_order',
			'value' => $this->data['attribute_data']['sort_order'],
			'style' => 'small-field'
		));
		$this->data['editable'] = $this->html->buildElement(array(
			'type' => 'checkbox',
			'name' => 'editable',
			'value' => $this->data['attribute_data']['editable_by_customer'],
			'style' => 'btn_switch btn-group-xs'
		));
		$this->data['visible'] = $this->html->buildElement(array(
			'type' => 'checkbox',
			'name' => 'visible',
			'value' => $this->data['attribute_data']['visible_by_customer'],
			'style' => 'btn_switch btn-group-xs'
		));

		$this->data['required'] = $this->html->buildElement(array(
			'type' => 'checkbox',
			'name' => 'required',
			'value' => $this->data['attribute_data']['required'],
			'style' => 'btn_switch btn-group-xs'
		));
		$this->data['element_type'] = $this->html->buildElement(array(
			'type' => 'hidden',
			'name' => 'element_type',
			'value' => $this->data['attribute_data']['element_type'],
		));

		//for file-option
		if($this->data['attribute_data']['element_type'] == 'U'){
			$this->_file_upload_settings_form();
		} else{

			$this->data['entry_regexp_pattern'] = $this->language->get('entry_regexp_pattern');
			$this->data['regexp_pattern'] = $this->html->buildElement(array(
				'type' => 'input',
				'name' => 'regexp_pattern',
				'value' => $this->data['attribute_data']['regexp_pattern'],
				'style' => 'medium-field'
			));

			$this->data['entry_error_text'] = $this->language->get('entry_error_text');
			$this->data['error_text'] = $this->html->buildElement(array(
				'type' => 'input',
				'name' => 'error_text',
				'value' => $this->data['attribute_data']['error_text'],
				'style' => 'large-field'
			));
		}

		$this->data['button_remove_attribute'] = $this->html->buildElement(array(
				'type' => 'button',
				'href' => $this->html->getSecureURL('sale/customer_attributes_response/remove_attribute',
													'&attribute_id='.$this->request->get['attribute_id'].'&customer_group_id='.$this->request->get['customer_group_id']),
				'text' => $this->language->get('button_remove_attribute'),
				'style' => 'button3',
		));
		$this->data['button_save'] = $this->html->buildElement(array(
				'type' => 'button',
				'text' => $this->language->get('button_save'),
				'style' => 'button1',
		));
		$this->data['button_reset'] = $this->html->buildElement(array(
				'type' => 'button',
				'text' => $this->language->get('button_reset'),
				'style' => 'button2',
		));

		$this->data['update_attribute_values'] = $this->html->getSecureURL(
			'sale/customer_attributes_response/update_attribute_values',
				'&customer_group_id=' . $this->request->get['customer_group_id'] .
				'&attribute_id=' . $this->request->get['attribute_id']
		);

		$this->data['remove_attribute_link'] = $this->html->getSecureURL(
			'sale/customer_attributes_response/remove_attribute',
				'&customer_group_id=' . $this->request->get['customer_group_id'] .
				'&attribute_id=' . $this->request->get['attribute_id']
		);

		// form of option values list
		$form = new AForm('HT');
		$form->setForm(array('form_name' => 'update_option_values'));
		$this->data['form']['id'] = 'update_option_values';
		$this->data['update_option_values_form']['open'] = $form->getFieldHtml(array(
			'type' => 'form',
			'name' => 'update_option_values',
			'action' => $this->data['update_attribute_values']));

		//form of option
		$form = new AForm('HT');
		$form->setForm(array(
			'form_name' => 'option_value_form',
		));

		$this->data['form']['id'] = 'option_value_form';
		$this->data['form']['form_open'] = $form->getFieldHtml(array(
			'type' => 'form',
			'name' => 'option_value_form',
			'action' => $this->data['update_attribute_values']
		));

		//Load option values rows except file-attr
		if($this->data['attribute_data']['element_type']!='U'){
			if($this->data['attribute_data']['values']){
				foreach($this->data['attribute_data']['values'] as $key => $item){
					$this->data['attribute_values'][$key]['row'] = $this->_attribute_value_form($item, $form);
				}
			}

			$this->data['new_attribute_row'] = '';
			if(in_array($this->data['attribute_data']['element_type'], $this->data['elements_with_options'])){
				$this->data['new_attribute_row'] = $this->_attribute_value_form(null, $form);
			}
		}


		$this->view->batchAssign($this->data);
		$this->processTemplate('responses/sale/attribute_values.tpl');
	}

	private function _file_upload_settings_form() {

		$this->data['extensions'] = $this->html->buildElement(array(
				'type'  => 'input',
				'name'  => 'settings[extensions]',
				'value' => $this->data['attribute_data']['settings']['extensions'],
				'style' => 'no-save'
		));

		$this->data['min_size'] = $this->html->buildElement(array(
				'type'  => 'input',
				'name'  => 'settings[min_size]',
				'value' => $this->data['attribute_data']['settings']['min_size'],
				'style' => 'small-field no-save'
		));
		$this->data['max_size'] = $this->html->buildElement(array(
				'type'  => 'input',
				'name'  => 'settings[max_size]',
				'value' => $this->data['attribute_data']['settings']['max_size'],
				'style' => 'small-field no-save'
		));
		$this->data['directory'] = $this->html->buildElement(array(
				'type'  => 'input',
				'name'  => 'settings[directory]',
				'value' => $this->data['attribute_data']['settings']['directory'],
				'style' => 'no-save'
		));

		$this->data['entry_upload_dir'] = sprintf($this->language->get('entry_upload_dir'), 'admin/system/upload/');
	}

	/**
	 * @param $item
	 * @param $form AForm
	 * @return string
	 */
	private function _attribute_value_form($item, $form) {

		if (isset($item['customer_attribute_value_id'])) {
			$attribute_value_id = $item['customer_attribute_value_id'];
			$this->data['row_id'] = 'row' . $attribute_value_id;
			$this->data['attr_val_id'] = $attribute_value_id;
		} else {
			$this->data['row_id'] = 'new_row';
		}

		$this->data['form']['fields']['attribute_value_id'] = $form->getFieldHtml(array(
			'type' => 'hidden',
			'name' => 'attribute_value_id[' . $attribute_value_id . ']',
			'value' => $attribute_value_id,
		));

		$this->data['form']['fields']['attribute_value'] = $form->getFieldHtml(array(
			'type' => 'input',
			'name' => 'name[' . $attribute_value_id . ']',
			'value' => $item['value'],
			'required' => ($this->data['attribute_data']['element_type'] == 'C' ? true : false)
		));

		$this->data['form']['fields']['sort_order'] = $form->getFieldHtml(array(
			'type' => 'input',
			'name' => 'sort_order[' . $attribute_value_id . ']',
			'value' => $item['sort_order'],
			'style' => 'small-field'
		));

		$this->view->batchAssign($this->data);
		return $this->view->fetch('responses/sale/attribute_value_row.tpl');
	}

	/**
	 * method that return part of attribute form
	 * @internal param array $param
	 * @param array $params
	 */
	public function getCustomerAttributeSubform($params = array()) {

		$this->loadLanguage('catalog/attribute');
		$this->loadLanguage('sale/customer_attributes');

		$this->data = array_merge($this->data, $params['data']);

		unset($this->data['form']['fields']); // remove form fields that do not needed here

		$this->data['elements_with_options'] = HtmlElementFactory::getElementsWithOptions();

		$results = HtmlElementFactory::getAvailableElements();
		$element_types = array('' => $this->language->get('text_select'));
		foreach ($results as $key => $type) {
			// allowed field types
			if (in_array($key, array('I', 'T', 'S', 'M', 'R', 'C', 'G', 'H', 'U'))) {
				$element_types[$key] = $type['type'];
			}
		}
		/**
		 * @var $form AForm
		 */
		$form = $params['aform'];
		/**
		 * @var $attribute_manager AAttribute_Manager
		 */
		$attribute_manager = $params['attribute_manager'];

		$this->data['form']['fields']['element_type'] = $form->getFieldHtml(array(
			'type' => 'selectbox',
			'name' => 'element_type',
			'value' => $this->data['element_type'],
			'required' => true,
			'options' => $element_types,
		));
		$this->data['form']['fields']['sort_order'] = $form->getFieldHtml(array(
			'type' => 'input',
			'name' => 'sort_order',
			'value' => $this->data['sort_order'],
			'style' => 'small-field'
		));
		$this->data['form']['fields']['required'] = $form->getFieldHtml(array(
			'type' => 'checkbox',
			'name' => 'required',
			'value' => $this->data['required'],
			'style' => 'btn_switch'
		));

		$this->data['form']['fields']['regexp_pattern'] = $form->getFieldHtml(array(
			'type' => 'input',
			'name' => 'regexp_pattern',
			'value' => $this->data['regexp_pattern'],
			'style' => 'large-field',
		));
		$this->data['form']['fields']['error_text'] = $form->getFieldHtml(array(
			'type' => 'input',
			'name' => 'error_text',
			'value' => $this->data['error_text'],
			'style' => 'large-field',
		));


		//Build atribute values part of the form
		if ($this->request->get['attribute_id']) {

			$this->data['child_count'] = $attribute_manager->totalChildren($this->request->get['attribute_id']);
			if ($this->data['child_count'] > 0) {
				$children_attr = $attribute_manager->getAttributes(array(), 0, $this->request->get['attribute_id']);
				foreach ($children_attr as $attr) {
					$this->data['children'][] = array('name' => $attr['name'],
						'link' => $this->html->getSecureURL('catalog/attribute/update', '&attribute_id=' . $attr['attribute_id']));
				}
			}

			$attribute_values = $attribute_manager->getAttributeValues($this->request->get['attribute_id']);
			foreach ($attribute_values as $atr_val) {
				$atr_val_id = $atr_val['attribute_value_id'];
				$attributes_fields[$atr_val_id]['sort_order'] = $form->getFieldHtml(array(
					'type' => 'input',
					'name' => 'sort_orders[' . $atr_val_id . ']',
					'value' => $atr_val['sort_order'],
					'style' => 'small-field'
				));
				$attributes_fields[$atr_val_id]['values'] = $form->getFieldHtml(array(
					'type' => 'input',
					'name' => 'values[' . $atr_val_id . ']',
					'value' => $atr_val['value'],
					'style' => 'medium-field'
				));
				$attributes_fields[$atr_val_id]['attribute_value_ids'] = $form->getFieldHtml(array(
					'type' => 'hidden',
					'name' => 'attribute_value_ids[' . $atr_val_id . ']',
					'value' => $atr_val_id,
					'style' => 'medium-field'
				));
			}
		}
		if (!$attributes_fields) {
			$attributes_fields[0]['sort_order'] = $form->getFieldHtml(array(
				'type' => 'input',
				'name' => 'sort_orders[]',
				'value' => '',
				'style' => 'small-field no-save'
			));
			$attributes_fields[0]['values'] = $form->getFieldHtml(array(
				'type' => 'input',
				'name' => 'values[]',
				'value' => '',
				'style' => 'medium-field no-save'
			));
			$attributes_fields[0]['attribute_value_ids'] = $form->getFieldHtml(array(
				'type' => 'hidden',
				'name' => 'attribute_value_ids[' . $atr_val_id . ']',
				'value' => 'new',
				'style' => 'medium-field'
			));
		}
		if ($this->request->get['attribute_id']) {
			$attribute_info = $attribute_manager->getAttribute($this->request->get['attribute_id']);
			$attribute_info['settings'] = unserialize($attribute_info['settings']);
		}

		$this->data['form']['settings_fields'] = array(
			'extensions' => $form->getFieldHtml(array(
				'type' => 'input',
				'name' => 'settings[extensions]',
				'value' => $attribute_info['settings']['extensions'],
				'style' => 'no-save'
			)),
			'min_size' => $form->getFieldHtml(array(
				'type' => 'input',
				'name' => 'settings[min_size]',
				'value' => $attribute_info['settings']['min_size'],
				'style' => 'small-field no-save'
			)),
			'max_size' => $form->getFieldHtml(array(
				'type' => 'input',
				'name' => 'settings[max_size]',
				'value' => $attribute_info['settings']['max_size'],
				'style' => 'small-field no-save'
			)),
			'directory' => $form->getFieldHtml(array(
				'type' => 'input',
				'name' => 'settings[directory]',
				'value' => $attribute_info['settings']['directory'],
				'style' => 'no-save'
			)),
		);

		$this->data['entry_upload_dir'] = sprintf($this->language->get('entry_upload_dir'),'admin/system/upload/');
		$this->data['form']['attribute_values'] = $attributes_fields;

		$this->view->batchAssign($this->data);


		$this->processTemplate('responses/sale/global_attribute_customer_attribute_subform.tpl');
	}
}