<?php
if (!defined('DIR_CORE')) {
	header('Location: static_pages/');
}
/** @noinspection PhpUndefinedClassInspection */
/**
 * Class ControllerPagesSaleCustomerAttributes
 * @property ModelSaleCustomerAttributes $model_sale_customer_attributes
 */
class ControllerPagesSaleCustomerAttributes extends AController {
	public $data = array();

	public function main() {

		$this->loadModel('sale/customer_attributes');

		if ($this->request->is_POST() && $this->_validateForm()) {
			$data = $this->request->post;
			$customer_attribute_id = $this->model_sale_customer_attributes->addCustomerAttribute($this->request->get['customer_group_id'], $data);

			$data['customer_attribute_id'] = $customer_attribute_id;
			$this->model_sale_customer_attributes->addAttributeToGroup($this->request->get['customer_group_id'], $data);
			$this->redirect($this->html->getSecureURL('sale/customer_attributes/update', '&customer_group_id=' . $this->request->get['customer_group_id']));
		}
	}

	public function update() {
		$this->loadLanguage('sale/customer_attributes');
		$this->document->setTitle($this->language->get('text_customer_attributes'));
		$this->document->initBreadcrumb(array(
			'href' => $this->html->getSecureURL('index/home', '', true),
			'text' => $this->language->get('text_home'),
			'separator' => FALSE
		));

		$this->document->addBreadcrumb(array(
			'href' => $this->html->getSecureURL('sale/customer_group', '', true),
			'text' => $this->language->get('breadcrumb_customer_groups'),
			'separator' => ' :: '
		));

		$this->document->addBreadcrumb(array(
			'href' => $this->html->getSecureURL('sale/customer_group/update', '&customer_group_id=' . $this->request->get['customer_group_id'], true),
			'text' => $this->language->get('breadcrumb_edit_group'),
			'separator' => ' :: '
		));


		$this->document->addBreadcrumb(array(
			'href' => $this->html->getSecureURL('sale/customer_attributes/update', '&customer_group_id=' . $this->request->get['customer_group_id'], true),
			'text' => $this->language->get('text_customer_attributes'),
			'separator' => ' :: ',
			'current'   => true
		));


		$this->data['heading_title'] = $this->language->get('text_customer_attributes');

		$tabs['general'] = array(
			'name' => 'customer_group_edit',
			'text' => $this->language->get('tab_general'),
			'href' => $this->html->getSecureURL('sale/customer_group/update', '&customer_group_id=' . $this->request->get['customer_group_id'], true),
			'sort_order' => 0
		);

		$tabs['customer_attributes'] = array(
				'name' => 'customer_attributes',
				'text' => $this->language->get('text_customer_attributes'),
				'href' => $this->html->getSecureURL('sale/customer_attributes/update', '&customer_group_id=' . $this->request->get['customer_group_id'], true),
				'active' => true,
				'class' => 'active', //deprecated since 1.2.2!
				'sort_order' => 1
		);


		$obj = $this->dispatch('responses/common/tabs', array(
						'sale/customer_group', //parent controller. Use customer group to use for other extensions that will add tabs via their hooks
						array('tabs' => $tabs))
		);
		$this->data['tabs'] = $obj->dispatchGetOutput();



		$this->data['text_customer_attributes'] = $this->language->get('text_customer_attributes');
		$this->data['error_required'] = $this->language->get('error_required');

		$this->loadModel('sale/customer_attributes');

		$this->data['group_attributes'] = array();
		if ($this->request->get['customer_group_id']) {
			$group_attributes = $this->model_sale_customer_attributes->getAttributesForGroup(
				$this->request->get['customer_group_id'],
				$this->language->getContentLanguageID()
			);
			foreach($group_attributes as $row){
				$options[$row['customer_attribute_id']] = $row['name'];
			}
			$this->data['group_attributes'] = $this->html->buildElement(array(
						'type' => 'selectbox',
						'name' => 'customer_attribute_id',
						'options' => $options,
					));
		}

		$attributes = array('new' => $this->language->get('text_add_new_attribute'));

		$this->attribute_manager = new AAttribute_Manager();
		$results = $this->attribute_manager->getAttributes(
			array(
				'search' => " ga.attribute_type_id = '" . $this->attribute_manager->getAttributeTypeID('customer_attribute') . "'
				AND ga.status = 1
				AND ga.attribute_parent_id = 0 ",
			),
			$this->language->getContentLanguageID()
		);

		foreach ($results as $type) {
			$attributes[$type['attribute_id']] = $type['name'];
		}



		$form = new AForm('HT');

		$form->setForm(array(
			'form_name' => 'new_attribute_form',
			'update' => ''
		));

		$this->data['action'] = $this->html->getSecureURL(
			'sale/customer_attributes',
				'&customer_group_id=' . $this->request->get['customer_group_id']
		);

		$this->data['form']['form_open'] = $form->getFieldHtml(array(
			'type' => 'form',
			'name' => 'attributes_form',
			'action' => $this->data['action'],
			'attr' => 'data-confirm-exit="true"  class="form-horizontal"',
		));

		$this->data['attributes'] = $form->getFieldHtml(array(
			'type' => 'selectbox',
			'name' => 'global_attribute_id',
			'options' => $attributes,
			'style' => 'chosen',
		));


		$this->data['form']['submit'] = $form->getFieldHtml(array(
			'type' => 'button',
			'name' => 'submit',
			'text' => $this->language->get('button_add_attribute'),
			'style' => 'button1',
		));

		$this->data['button_reset'] = $this->html->buildButton(array(
			'text' => $this->language->get('button_reset'),
			'style' => 'button2',
		));


		$results = HtmlElementFactory::getAvailableElements();
		$element_types = array('' => $this->language->get('text_select'));
		foreach ($results as $key => $type) {
			// allowed field types
			if (in_array($key, array('I', 'T', 'S', 'M', 'R', 'C', 'G', 'H', 'U'))) {
				$element_types[$key] = $type['type'];
			}
		}

		$this->data['entry_attribute_name'] = $this->language->get('entry_attribute');
		$this->data['attribute_name'] = $form->getFieldHtml(array(
			'type' => 'input',
			'name' => 'name',
			'required' => true,

		));

		$this->data['status'] = $form->getFieldHtml(array(
			'type' => 'checkbox',
			'name' => 'status',
			'value' => 1,
			'style' => 'btn_switch',
		));

		$this->data['sort_order'] = $form->getFieldHtml(array(
			'type' => 'input',
			'name' => 'sort_order',
			'style' => 'small-field'
		));

		$this->data['required'] = $form->getFieldHtml(array(
			'type' => 'checkbox',
			'name' => 'required',
			'value'=>1
		));

		$this->data['entry_element_type'] = $this->language->get('entry_element_type');
		$this->data['element_type'] = $form->getFieldHtml(array(
			'type' => 'selectbox',
			'name' => 'element_type',
			'required' => true,
			'options' => $element_types,
		));

		$this->data['urls'] = array();
		$this->data['urls']['get_attributes_list'] = $this->html->getSecureURL('sale/customer_attributes_response/get_attributes_list', '&customer_group_id=' . $this->request->get['customer_group_id']);
		$this->data['urls']['load_attribute'] = $this->html->getSecureURL('sale/customer_attributes_response/load_attribute', '&customer_group_id=' . $this->request->get['customer_group_id']);
		$this->data['urls']['update_attribute'] = $this->html->getSecureURL('sale/customer_attributes_response/update_attribute', '&customer_group_id=' . $this->request->get['customer_group_id']);
		$this->data['add_attribute_url'] = $this->html->getSecureURL('catalog/attribute/insert', '&attribute_type_id='.$this->attribute_manager->getAttributeTypeID('customer_attribute'));
		$this->data['text_success_attribute'] = $this->language->get('text_success_attribute');
		$this->data['help_url'] = $this->gen_help_url('customer_attributes');
		$this->data['form_language_switch'] = $this->html->getContentLanguageSwitcher();

		$this->view->batchAssign($this->data);
		$this->processTemplate('pages/sale/attributes_form.tpl');
	}


	private function _validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/customer_attributes')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}
	}

	public function download() {
			$this->loadModel('sale/customer_attributes');

			$attribute_data = $this->model_sale_customer_attributes->getAttributeInfo($this->request->get['customer_attribute_id'], $this->request->get['customer_group_id'] );
			$attribute_data = $attribute_data[0];
			$filename = str_replace(array('../', '..\\', '\\', '/'), '', $this->request->get['filename']);


			if (has_value($attribute_data['settings']['directory'])) {
				$file = DIR_APP_SECTION . 'system/uploads/' . $attribute_data['settings']['directory'] . '/' . $filename;
			}else{
				$file = DIR_APP_SECTION . 'system/uploads/' . $filename;
			}

			if (file_exists($file)) {
				header('Content-Description: File Transfer');
				header('Content-Type: application/x-gzip');
				header('Content-Disposition: attachment; filename=' . str_replace(' ','_',$filename));
				header('Content-Transfer-Encoding: binary');
				header('Expires: 0');
				header('Cache-Control: must-revalidate');
				header('Pragma: public');
				header('Content-Length: ' . filesize($file));
				ob_clean();
				flush();
				readfile($file);
				exit;
			} else {
				echo 'File '.$file.' does not exists!';
				exit;
			}
	}

}