<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( !defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

$mc_server_url = "https://abantecartplus.com/clientarea/plugin/license_manager/validate/";
$diy_server_url = "https://wehearyou2.com/clientarea/plugin/license_manager/validate/";
$shared_secret = "constantcontact_integration";

$public_key = "";
$path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";

if ($this->config->get('constantcontact_integration_license_code')) {
    $license_key = $this->config->get('constantcontact_integration_license_code');
    $license = new License($path_to_phpseclib);
    $license_manager = $license->getManager();
    if (stripos($license_key, 'mc-') !== false) {
        $server_url = $mc_server_url;
    } else {
        $server_url = $diy_server_url;
    }
    $license_manager->setLicenseServerUrl($server_url);
    $license_manager->setKeys($license_key, "", $shared_secret);
    $public_key = $license_manager->requestKey();
    $this->load->model('extension/constantcontact_integration_license_info');

    $store_id = (int)$this->config->get('config_store_id');

    $license_manager->setKeys($license_key, $public_key, $shared_secret);
    $custom_data = ['version' => '1.3.4.1'];
    $license_data = $license_manager->requestData($custom_data);
    if (!is_null($license_data)) {
        $ttl = 1209600;
        $validate = $license_manager->validate($license_data, $ttl);

        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
            $data['public_key'] = $public_key;
            $data['license_data'] = $license_data;
            $data['license_key'] = $license_key;
            $data['store_id'] = $store_id;
            $data['last_check'] = time();
            $this->load->model('extension/constantcontact_integration_license_info');
            $this->model_extension_constantcontact_integration_license_info->saveLicenseData($data);
        }
    }
}
$sql = "UPDATE ".$this->db->table('language_definitions')." set language_value='
        This is a WHY2 extension.  All support and updates are managed from WHY2. <br>
        Read about WHY2\'s 12 months support <a href=\"https://why2central.net/knowledgebase/why2-support-and-updates-policy/\" target=\"_blank\" style=\"font-weight:bold;\">here</a> and how WHY2 updates are delivered <a href=\"https://why2central.net/knowledgebase/extension-updater/\" target=\"_blank\" style=\"font-weight:bold;\">here</a>.<br>
        You can safely ignore Support expired notification within the Admin Dashboard.<br><br>
        <strong>Important Notes: <br>
        &nbsp;&nbsp;I.&nbsp;Please Save the settings before turning on the extension.<br>
        &nbsp;&nbsp;II.&nbsp;There are two ways to obtain the license key: <br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;a. Use this <a href=\"https://wehearyou2.com/clientarea/reg/register.php\" target=\"_blank\" style=\"font-weight:bold;\">form</a> to register to our Support system and generate your license key.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;b. Already registered -  click <a href=\"https://wehearyou2.com/clientarea/reg/index.php\" target=\"_blank\" style=\"font-weight:bold;\">here</a> to log into your account to obtain license key.<br>
        &nbsp;&nbsp;Refer to our <a href=\"https://why2central.net/faq/license-key/\" target=\"_BLANK\">F.A.Q</a> for more information on how to obtain the license key.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;c. If you already have an account in our support system and you are using multiple extensions from WHY2,  you do NOT need to create another account in the support system.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;d. Updating extension in same location does NOT require a new key.<br>
        &nbsp;&nbsp;Refer to our <a href=\"https://why2central.net/faq/license-key/\" target=\"_BLANK\">F.A.Q</a> for more information on how to Update extension in same location.</strong><br><br>
        Enter your WHY2 license key here.' WHERE language_key='constantcontact_integration_note';";
$this->db->query($sql);

$sql1 = "UPDATE ".$this->db->table('language_definitions')." set language_value='Enter your WHY2 license key:' WHERE language_key='constantcontact_integration_license_code';";
$this->db->query($sql1);

$sql2 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("constantcontact_integration_license_info") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `public_key` TEXT NOT NULL,
  `license_data` TEXT NOT NULL,
  `license_key` TEXT NOT NULL,
  `store_id` int(11) NOT NULL,
  `last_check` int(11),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql2);

$sql3 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("constantcontact_integration_updater_notification") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL,
  `cart_version` VARCHAR(10),
  `extension_version` VARCHAR(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql3);

$sql4 = "CREATE TABLE IF NOT EXISTS " . $this->db->table("constantcontact_integration_token") ."(
                    `id` int(2) NOT NULL AUTO_INCREMENT,
                    `store_id` int(11),
                    `code` varchar(200)  NOT NULL,
                    `state` varchar(200)  NOT NULL,
                    `access_token` text  NOT NULL,
                    `refresh_token` text  NOT NULL,
                    PRIMARY KEY (`id`)
			) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;";

$this->db->query($sql4);

$sql5 = "CREATE TABLE IF NOT EXISTS " . $this->db->table("constantcontact_integration_redirect") ."(
                    `redirect_url` text
			) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1 ;";

$this->db->query($sql5);

$check1= "SHOW columns from ".$this->db->table('constantcontact_integration_content')." where field='store_id'";
$q1=$this->db->query($check1);
$exist1=count($q1->rows);
if ($exist1==0) {
    $sql12 = "ALTER TABLE ".$this->db->table('constantcontact_integration_content')." ADD `store_id` INT(11) COLLATE utf8_general_ci AFTER `positions`";
    $this->db->query($sql12);
}

$sql13 = "SELECT `store_id` FROM ".$this->db->table("stores");
$query13 = $this->db->query($sql13);
$results13 = $query13->rows;
foreach ($results13 as $result) {
    $exist = $this->db->query("SELECT * FROM ".$this->db->table('constantcontact_integration_content')." WHERE `store_id`=".$result['store_id']);
    $query_result = $exist->row;
    if ($query_result || $result['store_id']==='0') {
        $this->db->query("UPDATE ".$this->db->table('constantcontact_integration_content')." SET `store_id`=".$result['store_id']." WHERE `positions`='top'" );
        $this->db->query("UPDATE ".$this->db->table('constantcontact_integration_content')." SET `store_id`=".$result['store_id']." WHERE `positions`='bottom'" );
    } else {
        $this->db->query("INSERT INTO ".$this->db->table('constantcontact_integration_content')." SET `positions`='top',`store_id`=".$result['store_id'] );
        $this->db->query("INSERT INTO ".$this->db->table('constantcontact_integration_content')." SET `positions`='bottom',`store_id`=".$result['store_id'] );
    }
}

$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='text_login'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='entry_client_id'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='entry_client_secret'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='login_heading_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='settings_heading_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='additional_settings_heading_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='text_settings'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='button_obtain'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='button_logout'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='constantcontact_integration_settings_note'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='text_settings_success'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='entry_constantcontact_integration_list'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='entry_constantcontact_integration_admin_email'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='entry_constantcontact_integration_universal_code'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='entry_universal_code'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='entry_constantcontact_integration_inline_code'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='entry_constantcontact_integration_firstname'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='entry_constantcontact_integration_lastname'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='text_yes'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='text_no'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='text_new_ctct_version_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='text_new_ctct_version_description'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='text_update_success'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='text_update_failed'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='button_start_update'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='button_cancel_update'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='text_update_ctct_note'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='text_ctct_updater_heading_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='text_changelog'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='text_no_updates'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='button_go_back'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='text_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='button_diy_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='constantcontact_integration_license_expired'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='button_mc_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='text_update_constantcontact_integration_available'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='constantcontact_integration_constantcontact_integration' AND `language_key`='entry_constantcontact_integration_popup_list'");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','text_login','Obtain OAuth Token',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','entry_client_id','Enter your client id:',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','entry_client_secret','Enter your client secret:',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','login_heading_title','Obtain OAuth Token',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','settings_heading_title','Settings',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','additional_settings_heading_title','Additional Settings',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','text_settings','Settings',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','button_obtain','Obtain',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','constantcontact_integration_settings_note','<br>
        1.&nbsp;Choose the desired Contact List Name you want subscribers added to. When you register by default it creates General Interest List.<br>
              2.&nbsp;Choose the desired Contact List Name you want popup subscribers added to. This is for our WHY2 Constant Contact Popup.<br><br>
        <b>IMPORTANT NOTES:</b>&nbsp;There are <b>two different contact forms</b> that can be used.  You must <b>use only one at a time</b>. Use a form that is designed within your Constant Contact account -- see No. 4-5 for details. OR use an extension generated form following the instructions in NO. 6-7 fields. You can change your choice at any time.<br><br>
        <b>No 3 is for excluding your Constant Contact email address from being imported to the cart during importing Constant Contact Contacts to your store.</b><br>
        3.&nbsp;Fill this field with your Constant Contact email address.<br><br>
        <b>No 4-5 is for using Constant Contact Sign Up Form tools and Popup Form.<br>
        NOTES:<br>
        Click this <a href=\"https://knowledgebase.constantcontact.com/email-digital-marketing/articles/KnowledgeBase/18265-Create-a-Sign-Up-Form-with-the-new-sign-up-form-experience?lang=en_US\" target=\"_blank\" style=\"font-weight:bold;\"> link </a> to understand more about how to create the form.<br>
        Click this <a href=\"https://knowledgebase.constantcontact.com/email-digital-marketing/articles/KnowledgeBase/18053-activating-and-installing-your-sign-up-form?lang=en_US\" target=\"_blank\" style=\"font-weight:bold;\"> link </a> to understand more about the universal and inline code.<br>
IMPORTANT NOTES: You will need to manually synchronize Constant Contact List with the cart as Constant Contact doesn\'t have webhooks to automatically add subscribers to cart list.</b><br>
        4.&nbsp;Fill this field with the Active Forms Universal Code which was obtained from Constant Contact Sign up Form tools.<br>
        5.&nbsp;Fill this field with the desired Form\'s Inline Form Code which was obtained from Constant Contact Sign up Form tools.<br><br>
        <b>No 6-7 is for Form that comes with the extension</b><br>
6.&nbsp;Choose Yes if you want customer to fill their First Name.<br>
7.&nbsp;Choose Yes if you want customer to fill their Last Name.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','text_settings_success','Success: You have modified Constant Contact Integration Settings!',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','entry_constantcontact_integration_list','Default Constant Contact List &nbsp;<br/><span class=\"help\">Choose the desired Contact List name you want subscribers added to. When you registered, by default it creates General Interest List.</span>',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','entry_constantcontact_integration_admin_email','Input your Admin email that is used as Constant Contact username&nbsp;<br/><span class=\"help\">The extension will exclude this email while importing contacts from Constant Contact.</span>',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','entry_constantcontact_integration_universal_code','Input Active Forms Universal Code&nbsp;<br/><span class=\"help\">Fill this field with the universal code if you want to use your Constant Contact Form instead of using form that comes with the extension.</span>',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','entry_universal_code','Input Active Forms Universal Code&nbsp;<br/><span class=\"help\">Fill this field with the universal code if you want to use your Constant Contact Form instead of using form that comes with the extension.</span>',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','entry_constantcontact_integration_inline_code','Input desired Form\'s Inline Form Code&nbsp;<br/><span class=\"help\">Fill this field with the inline code provided by Constant Contact. You must fill the universal code in order to show the form.</span>',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','entry_constantcontact_integration_firstname','Subscribers must fill their firstname on newsletter form&nbsp;<br/><span class=\"help\">Choose yes if you want customers to fill their firstname in form that comes with extension.</span>',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','entry_constantcontact_integration_lastname','Subscribers must fill their lastname on newsletter form&nbsp;<br/><span class=\"help\">Choose yes if you want customers to fill their lastname in form that comes with extension.</span>',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','text_yes','Yes',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','text_no','No',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','button_logout','Log Out',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','text_new_ctct_version_title','New version (v[new_version]) of Constant Contact Integration Extension',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','text_new_ctct_version_description','There is a new version of Constant Contact Integration Extension. Please open -->#admin#rt=extension/constantcontact_integration_updater&version=[version_number] to update the extension. <br><br>
                        The update will replace existing files with the update files.<br><br>Make sure that you have made a backup of your store prior to updating. Use your normal backup method or Softaculous to make a backup prior to updating your site. Need help on how to backup an installation by using Softaculous click <a href=\"https://why2central.net/knowledgebase/how-to-backup-an-installation/\" target=\"_BLANK\"><b>here</b></a>.<br><br>
                        Do not delete this message until you have updated.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','text_update_success','The Constant Contact Integration extension has been successfully updated.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','text_update_failed','We are unable to update the Constant Contact Integration extension, please check <a target=\"_BLANK\" href=\"#admin#rt=tool/error_log\">error log</a> for more information.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','button_start_update','Start Update',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','button_cancel_update','Cancel Update',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','text_update_ctct_note','Note:<br>We are going to update Constant Contact Integration extension. The update will replace existing files with the update files.<br><br>Make sure that you have made a backup of your store prior to updating. Use your normal backup method or Softaculous to make a backup prior to updating your site. Need help on how to backup an installation by using Softaculous click <a href=\"https://why2central.net/knowledgebase/how-to-backup-an-installation/\" target=\"_BLANK\"><b>here</b></a>.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','text_ctct_updater_heading_title', 'Constant Contact Integration Updater',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','text_changelog','Changelog:',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','text_no_updates','There are no new updates for this extension.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','button_go_back','Go Back',now(),now())");

$this->db->query("UPDATE ".$this->db->table("language_definitions")." SET `language_value`='Cancel' WHERE `language_key`='button_cancel' AND `block`='constantcontact_integration_constantcontact_integration'");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','text_support_by_why2','Support and updates from WHY2.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','button_diy_support_by_why2','If you are self-managed users click here for support. Support and updates from WHY2.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','button_mc_support_by_why2','If you are a WHY2 Managed Client click here for support. Updates are part of the Managed Services.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','text_update_constantcontact_integration_available','New version (%s) is available. <a href=\"%s\" target=\"_BLANK\"><strong>Click to update now.</strong></a>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','constantcontact_integration_license_expired','Your license key is expired. Possibly due to inactive with the extension for more than 14 days. Please click on the SAVE button at the bottom of this page.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','constantcontact_integration_constantcontact_integration','entry_constantcontact_integration_popup_list','Constant Contact Popup List &nbsp;<br/><span class=\"help\">Choose the desired Contact List name you want the popup subscribers added to. This is for our WHY2 Constant Contact Popup.</span>',now(),now())");

$exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('ctct_license') . "'");
if ($exist->num_rows === 1) {
    $this->db->query("DROP TABLE ".$this->db->table("ctct_license"));
}

$rm = new AResourceManager();
$rm->setType('image');

$language_id = $this->language->getLanguageID();
$data = [];
$data['resource_code'] = '<i class="fa fa-cog"></i>&nbsp;';
$data['name'] = [$language_id => 'Menu Icon Constant Contact Integration Settings'];
$data['title'] = [$language_id => ''];
$data['description'] = [$language_id => ''];
$resource_id = $rm->addResource($data);

$language_id = $this->language->getLanguageID();
$data = [];
$data['resource_code'] = '<i class="fa fa-envelope-o"></i>&nbsp;';
$data['name'] = [$language_id => 'Menu Icon Constant Contact Integration'];
$data['title'] = [$language_id => ''];
$data['description'] = [$language_id => ''];
$resource_id2 = $rm->addResource($data);

$menu = new AMenu ( "admin" );

$exist = $menu->getMenuItem("constantcontact_integration_extension");

if (!$exist) {

    $menu->insertMenuItem(["item_id" => "constantcontact_integration_extension",
            "parent_id" => "",
            "item_text" => "Constant Contact Integration",
            "item_url" => "",
            "item_type" => "core",
            "sort_order" => "17",
            "item_icon_rl_id" => $resource_id
        ]
    );

    $menu->insertMenuItem(["item_id" => "constantcontact_integration_settings",
            "parent_id" => "constantcontact_integration_extension",
            "item_text" => "Constant Contact Integration Settings",
            "item_url" => "extension/constantcontact_integration_settings",
            "item_type" => "core",
            "sort_order" => "18",
            "item_icon_rl_id" => $resource_id
        ]
    );

    $menu->insertMenuItem(["item_id" => "constantcontact_integration",
            "parent_id" => "constantcontact_integration_extension",
            "item_text" => "Constant Contact Integration Additional Settings",
            "item_url" => "extension/constantcontact_integration",
            "item_type" => "core",
            "sort_order" => "19",
            "item_icon_rl_id" => $resource_id2
        ]
    );
}

if (!file_exists(DIR_SYSTEM.'lib/license.php')) {
    /**
     *  Function to Copy folders and files
     * @param $src
     * @param $dst
     * @return array
     */
    function custom_copy($src, $dst) {
        $error = array();
        // open the source directory
        $dir = opendir($src);
        if (!is_dir($dst)) {
            @mkdir($dst);
        }
        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    // Recursively calling custom copy function
                    // for sub directory
                    custom_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    if (!copy($src . '/' . $file, $dst . '/' . $file)) {
                        $error['error_copy'][] = "Failed to copy $file";
                    }
                }
            }
        }
        if (sizeof($error)>0) {
            $log=new ALog(DIR_SYSTEM.'logs/error.txt');
            $log->write(var_export($error,true));
        }
        closedir($dir);
        return $error;
    }

    $copy = custom_copy(DIR_EXT . 'constantcontact_integration' . DIR_EXT_CORE . 'lib/license', DIR_SYSTEM.'lib');
}