<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}
require_once DIR_EXT.'constantcontact_integration'.DIR_EXT_CORE.'lib/ctct/vendor/autoload.php';

/**
 * Class ControllerPagesExtensionConstantContactIntegration
 * @property ModelExtensionCtct $model_extension_ctct
 */
class ControllerResponsesBlocksCtct extends AController
{
    public $data = [];

    public function addContact() {

        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadModel('account/customer');
        $this->loadModel('extension/ctct');

        $store_id = $this->getStoreId();
        $settings = $this->getSetting('constantcontact_integration',$store_id);

        $data=$this->_prepareData();

        $client = new \PHPFUI\ConstantContact\Client($settings['client_id'], $settings['client_secret'], HTTPS_SERVER);
        $token_info = $this->model_extension_ctct->getInfo();
        // Set access and refresh tokens on client
        $client->accessToken = $token_info['access_token'];
        $client->refreshToken = $token_info['refresh_token'];

        $contactsEndPoint = new \PHPFUI\ConstantContact\V3\Contacts($client);
        $list_id = $settings['constantcontact_integration_list'];

        $contactsResponse = $contactsEndPoint->get(status:'all',email:$data['email']);
        $contactClientEndPoint = new \PHPFUI\ConstantContact\V3\Contact($client);

        $exist = $this->model_account_customer->getCustomerByEmail($data['email']);
        $this->loadLanguage('blocks/constantcontact_integration');
        $status = $this->model_extension_ctct->getNewsletterStatus($data['email']);
        $list_id = $settings['constantcontact_integration_list'];
        if ($contactsResponse['contacts'] && $exist) {
            $ccStatus = $contactsResponse['email_address']['permission_to_send'];
            if( ($ccStatus==='implicit' || $ccStatus==='explicit') && $status['newsletter']== '1' ) {
                $this->data['status']='Error';
                $this->data['err']=$this->language->get('newsletter_email_exist');
            } else {
                $this->model_extension_ctct->updateNewsletter('1',$data['email']);
                $this->data['status']='Success';
                $this->data['sccs']=$this->language->get('newsletter_success');
                $contact['list_memberships'][] = $list_id;
                $email_address = new \PHPFUI\ConstantContact\Definition\EmailAddressPut($contactsResponse['contacts'][0]['email_address']);
                $email_address->permission_to_send = 'explicit';
                $contact['email_address'] = $email_address;
                $contact['first_name'] = $data['firstname'];
                $contact['last_name'] = $data['lastname'];
                $contactBody = new \PHPFUI\ConstantContact\Definition\ContactPutRequest($contact);
                $contactBody->update_source = 'Contact';
                $contactClientEndPoint->put($contactsResponse['contacts'][0]['contact_id'], $contactBody);
                if (!$contactClientEndPoint->success()) {
                    $this->log->write('Constant Contact Via Sign Up Block Existing Subscriber Response: ' . $contactClientEndPoint->getLastError());
                }
            }
        } else {
            $contactBody = new \PHPFUI\ConstantContact\Definition\ContactPostRequest();
            $contactBody->first_name = $data['firstname'];
            $contactBody->last_name = $data['lastname'];
            $contactBody->create_source = 'Account';
            $contactBody->list_memberships = [new \PHPFUI\ConstantContact\UUID($list_id)];
            $contactBody->street_addresses = [];
            $contactBody->phone_numbers = [];
            $email = new \PHPFUI\ConstantContact\Definition\EmailAddressPost();
            $email->address = $data['email'];
            $email->permission_to_send = 'explicit';
            $contactBody->email_address = $email;
            $contactsEndPoint->post($contactBody);
            $request_data['firstname']=$data['firstname'];
            $request_data['lastname']=$data['lastname'];
            $request_data['email']=$data['email'];
            $request_data['password'] = md5(mt_rand(0,10000)); //random password
            $request_data['loginname'] =uniqid("", true); // loginname must be unique!
            $request_data['newsletter'] = 1; // sign of subscriber
            $request_data['status'] = $request_data['approved'] = 0; //disable login ability for subscribers
            $request_data['customer_group_id'] = $this->model_account_customer->getSubscribersCustomerGroupId();
            $request_data['ip'] = $this->request->server['REMOTE_ADDR'];
            $this->model_account_customer->addCustomer($request_data);
            $this->data['status']='Success';
            $this->data['sccs']=$this->language->get('newsletter_success');

            if (!$contactsEndPoint->success()) {
                $this->log->write('Constant Contact Subscribe Result: ' . $contactsEndPoint->getLastError());
            }
        }
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
        $this->load->library('json');
        $this->response->setOutput(AJson::encode($this->data));
    }

    private function _prepareData() {
        if (isset($this->request->post['data'])) {
            $this->load->library('json');
            $obj = AJson::decode(html_entity_decode($this->request->post['data']));
            $data['firstname']=$obj->firstname;
            $data['email']=$obj->email;
            $data['lastname']=$obj->lastname;
            return $data;
        }
    }

    public function getStoreId() {
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }

    /**
     * @param string $group
     * @param int    $store_id
     *
     * @return array
     */
    public function getSetting($group, $store_id = 0) {
        $data = [];

        $query = $this->db->query(
            "SELECT *
            FROM ".$this->db->table("settings")." 
            WHERE `group` = '".$this->db->escape($group)."'
                AND store_id = '".(int)$store_id."'"
        );
        foreach ($query->rows as $result) {
            $value = $result['value'];
            if (is_serialized($value)) {
                $value = unserialize($value);
            }
            $data[$result['key']] = $value;
        }
        return $data;
    }
}