<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

require_once DIR_EXT.'constantcontact_integration'.DIR_EXT_CORE.'lib/ctct/vendor/autoload.php';

set_time_limit(0);

class ModelExtensionConstantContactIntegration extends Model{
    public $data = [];
    private $error = [];
    private $api='9u2zpz9pyxwreaqrhg9bu7ng';

    public function syncNewsletter($newsletter,$email) {
      $this->db->query("UPDATE " . $this->db->table("customers") . " SET newsletter = '" . (int)$newsletter . "' WHERE email = '" . $email . "'");
    }

    public function getContent($position) {
        $store_id = $this->getStoreId();
        $sql="SELECT * FROM " . $this->db->table("constantcontact_integration_content")." WHERE positions='" . $position . "' AND `store_id`=".$store_id;
        $results=$this->db->query($sql);
        return $results->row;
    }

    public function updateContent($position,$data) {
        $store_id = $this->getStoreId();
        $fields=[
            'content'
        ];
        $query = $this->db->query("SELECT COUNT(*) as total FROM ".$this->db->table("constantcontact_integration_content")." WHERE `store_id`=".$store_id);
        $result = $query->row['total'];
        if ($result === '0') {
            $this->addPositions();
        }
        $update=[];
        foreach ($fields as $f) {
            if (isset($data[$f])) {
                $update[] = "$f = '" . $this->db->escape($data[$f]) . "'";
            }
        }

        if (!empty($update)) {
            if ($this->db->query("UPDATE " . $this->db->table("constantcontact_integration_content")." SET " . implode(',', $update) . " WHERE positions = '" . $position . "' AND `store_id`=".$store_id)) {
                return true;
            };
        }
    }

    public function addPositions() {
        $store_id = $this->getStoreId();

        $this->db->query("INSERT INTO " . $this->db->table('onstantcontact_integration_content') . " ( `content`, `positions`,`store_id` ) VALUES
             ('', 'top','" . $store_id . "'),
             ('', 'bottom','" . $store_id . "')");
    }

    public function getCustomerByEmail($email) {
        $sql="SELECT * FROM " . $this->db->table("customers") . " WHERE email='" . $email . "'";
        $results=$this->db->query($sql);
        return $results->row;
    }

    public function getSubscribersCustomerGroupId() {
        $query = $this->db->query("SELECT customer_group_id	FROM `" . $this->db->table("customer_groups") . "` WHERE `name` = 'Newsletter Subscribers' LIMIT 0,1");
        $result = !$query->row['customer_group_id'] ? (int)$this->config->get('config_customer_group_id') :  $query->row['customer_group_id'];
        return $result;
    }

    /**
     * @param $email
     * @param $first_name
     * @param $last_name
     * @param $action - subscribe for new, resubscribe for existing
     * @param string $id
     */

    public function Subscribe($email,$first_name,$last_name,$action,$id='') {
        $store_id = $this->getStoreId();
        $this->load->model('setting/setting');
        $settings = $this->model_setting_setting->getSetting('constantcontact_integration', $store_id);
        $client = new \PHPFUI\ConstantContact\Client($settings['client_id'], $settings['client_secret'], HTTPS_SERVER);
        $token_info = $this->getInfo();
        // Set access and refresh tokens on client
        $client->accessToken = $token_info['access_token'];
        $client->refreshToken = $token_info['refresh_token'];

        $contactsEndPoint = new \PHPFUI\ConstantContact\V3\Contacts($client);
        $list_id = $settings['constantcontact_integration_list'];

        $contactsResponse = $contactsEndPoint->get(status:'all',email:$email,lists: $list_id);
        $contactClientEndPoint = new \PHPFUI\ConstantContact\V3\Contact($client);

        if ($contactsResponse['contacts'] || $action==1) {
            $contact['list_memberships'][] = $list_id;
            $email_address = new \PHPFUI\ConstantContact\Definition\EmailAddressPut($contactsResponse['contacts'][0]['email_address']);
            $email_address->permission_to_send = 'explicit';
            $contact['email_address'] = $email;
            $contactBody = new \PHPFUI\ConstantContact\Definition\ContactPutRequest($contact);
            $contactBody->update_source = 'Account';
            $contactClientEndPoint->put($contactsResponse['contacts'][0]['contact_id'], $contactBody);
            if (!$contactClientEndPoint->success()) {
                $this->log->write('Constant Contact Subscribe Result: ' . $contactClientEndPoint->getLastError());
            }
        } else {
            $contactBody = new \PHPFUI\ConstantContact\Definition\ContactPostRequest();
            $contactBody->first_name = $first_name;
            $contactBody->last_name = $last_name;
            $contactBody->create_source = 'Account';
            $contactBody->list_memberships = [new \PHPFUI\ConstantContact\UUID($list_id)];
            $email = new \PHPFUI\ConstantContact\Definition\EmailAddressPost();
            $email->address = $email;
            $email->permission_to_send = 'explicit';
            $contactBody->email_address = $email;
            $contactsEndPoint->post($contactBody);
            if (!$contactsEndPoint->success()) {
                $this->log->write('Constant Contact Subscribe Result: ' . $contactsEndPoint->getLastError());
            }
        }
    }

    /**
     * @param string $email
     */
    public function Unsubscribe($email) {
        $store_id = $this->getStoreId();
        $this->load->model('setting/setting');
        $settings = $this->model_setting_setting->getSetting('constantcontact_integration', $store_id);

        $client = new \PHPFUI\ConstantContact\Client($settings['client_id'], $settings['client_secret'], HTTPS_SERVER);
        $token_info = $this->getInfo();
        // Set access and refresh tokens on client
        $client->accessToken = $token_info['access_token'];
        $client->refreshToken = $token_info['refresh_token'];

        $contactsEndPoint = new \PHPFUI\ConstantContact\V3\Contacts($client);
        $contactClientEndPoint = new \PHPFUI\ConstantContact\V3\Contact($client);
        $list_id = $settings['constantcontact_integration_list'];

        $contactsResponse = $contactsEndPoint->get(status:'all',email:$email,lists:$list_id);

        if ($contactsResponse['contacts']) {
            $email_address = new \PHPFUI\ConstantContact\Definition\EmailAddressPut($contactsResponse['contacts'][0]['email_address']);
            $email_address->permission_to_send = 'unsubscribed';
            $email_address->opt_out_reason = '';
            $contact['email_address'] = $email_address;
            $contactBody = new \PHPFUI\ConstantContact\Definition\ContactPutRequest($contact);
            $contactBody->update_source = 'Account';
            $contactClientEndPoint->put($contactsResponse['contacts'][0]['contact_id'], $contactBody);
            if (!$contactClientEndPoint->success()) {
                $this->log->write('Constant Contact Unsubscribe Result: ' . $contactClientEndPoint->getLastError());
            }
        }
    }

    /**
     * @param $email
     * @return array
     */
    public function getContact($email) {
        $store_id = $this->getStoreId();
        $this->load->model('setting/setting');
        $settings = $this->model_setting_setting->getSetting('constantcontact_integration', $store_id);
        $client = new \PHPFUI\ConstantContact\Client($settings['client_id'], $settings['client_secret'], HTTPS_SERVER);
        $token_info = $this->getInfo();
        // Set access and refresh tokens on client
        $client->accessToken = $token_info['access_token'];
        $client->refreshToken = $token_info['refresh_token'];

        $contactsEndPoint = new \PHPFUI\ConstantContact\V3\Contacts($client);
        $list_id = $settings['constantcontact_integration_list'];

        $contactsResponse = $contactsEndPoint->get(status: 'all',email: $email,lists: $list_id);
        if (!$contactsEndPoint->success()) {
            $this->log->write('Constant Contact Get Contact Result: ' . $contactsEndPoint->getLastError());
        }
        return $contactsResponse['contacts'];
    }

    /**
     * @param $before_date
     * @param $after_date
     * @return array
     * @throws AException
     */
    public function getCtctCampaigns($before_date='',$after_date='') {
        $store_id = $this->getStoreId();
        $this->load->model('setting/setting');
        $settings = $this->model_setting_setting->getSetting('constantcontact_integration', $store_id);
        $client = new \PHPFUI\ConstantContact\Client($settings['client_id'], $settings['client_secret'], HTTPS_SERVER);
        $token_info = $this->getInfo();
        // Set access and refresh tokens on client
        $client->accessToken = $token_info['access_token'];
        $client->refreshToken = $token_info['refresh_token'];

        $campaignsEndPoint = new \PHPFUI\ConstantContact\V3\Emails($client);
        $start_date = $after_date ? $after_date: null;
        $end_date = $before_date ? $before_date: null;

        $campaigns = $campaignsEndPoint->get(limit:500, before_date:$end_date,after_date: $start_date);

        for ($i = 2; $i <= 10; $i++) {
            $campaignsResponseNext = $campaignsEndPoint->next();
            if ($campaignsEndPoint->success() && $campaignsResponseNext ) {
                foreach ($campaignsResponseNext['campaigns'] as $camp) {
                    if (array_search($camp['campaign_id'], array_column($campaigns['campaigns'], 'campaign_id')) != false) {
                        continue;
                    }
                    $campaigns['campaigns'][] = $camp;
                }
            }
        }

        if (!$campaignsEndPoint->success()) {
            $this->log->write('Constant Contact Get Campaigns: ' . $campaignsEndPoint->getLastError());
        }

        return $campaigns;
    }

    /**
     * @param $type
     * @param $campaign_id
     * @return array
     * @throws AException
     */
    public function getCtctIndividualCampaign($campaign_id) {
        $store_id = $this->getStoreId();
        $this->load->model('setting/setting');
        $settings = $this->model_setting_setting->getSetting('constantcontact_integration', $store_id);
        $client = new \PHPFUI\ConstantContact\Client($settings['client_id'], $settings['client_secret'], HTTPS_SERVER);
        $token_info = $this->getInfo();
        // Set access and refresh tokens on client
        $client->accessToken = $token_info['access_token'];
        $client->refreshToken = $token_info['refresh_token'];

        $campaignEndPoint = new \PHPFUI\ConstantContact\V3\Email($client);
        $campaign = $campaignEndPoint->get($campaign_id);
        if (!$campaignEndPoint->success()) {
            $this->log->write('Constant Contact Get Individual Campaigns: ' . $campaign->getLastError());
        }
        return $campaign;
    }

    public function getCtctIndividualCampaignActivity($campaign_activity_id) {
        $store_id = $this->getStoreId();
        $this->load->model('setting/setting');
        $settings = $this->model_setting_setting->getSetting('constantcontact_integration', $store_id);
        $client = new \PHPFUI\ConstantContact\Client($settings['client_id'], $settings['client_secret'], HTTPS_SERVER);
        $token_info = $this->getInfo();
        // Set access and refresh tokens on client
        $client->accessToken = $token_info['access_token'];
        $client->refreshToken = $token_info['refresh_token'];

        $campaignActivityEndPoint = new \PHPFUI\ConstantContact\V3\Emails\Activities($client);
        $campaign = $campaignActivityEndPoint->get(campaign_activity_id: $campaign_activity_id, include: 'html_content');
        if (!$campaignActivityEndPoint->success()) {
            $this->log->write('Constant Contact Get Individual Campaigns: ' . $campaignActivityEndPoint->getLastError());
        }
        return $campaign;
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getInfo() {
        $sql = "SELECT * FROM ".$this->db->table("constantcontact_integration_token");
        $query = $this->db->query($sql);
        return $query->row;
    }

    /**
     * @return void
     * @throws AException
     */
    public function resetInfo() {
        $sql = "DELETE FROM ".$this->db->table("constantcontact_integration_token");
        $this->db->query($sql);
    }

    /**
     * @param $data
     * @return void
     */
    public function saveInfo($data) {
        $sql = "INSERT INTO ".$this->db->table("constantcontact_integration_token")." SET `store_id`='".$data['store_id']."',`code`='".$data['code']."',`state`='".$data['state']."',`access_token`='".$data['access_token']."',
                `refresh_token`='".$data['refresh_token']."'";
        $this->db->query($sql);
    }

    /**
     * @param $data
     * @return void
     */
    public function updateInfo($data) {
        $sql = "UPDATE ".$this->db->table("constantcontact_integration_token")." SET `access_token`='".$data['access_token']."',`refresh_token`='".$data['refresh_token']."' WHERE `store_id`='".$data['store_id']."'";
        $this->db->query($sql);
    }

    /**
     * @param $url
     * @return void
     * @throws AException
     */
    public function setRedirect($url) {
        $sql = "INSERT INTO ".$this->db->table("constantcontact_integration_redirect")." SET  `redirect_url`='".$url."'";
        $this->db->query($sql);
    }

    /**
     * @return void
     * @throws AException
     */
    public function resetRedirect() {
        $sql = "DELETE FROM ".$this->db->table("constantcontact_integration_redirect");
        $this->db->query($sql);
    }


    public function getStoreId() {
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }

}