<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

require_once DIR_EXT.'constantcontact_integration'.DIR_EXT_CORE.'lib/ctct/vendor/autoload.php';

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ControllerPagesExtensionConstantContactIntegration
 * @property ModelExtensionConstantContactIntegration $model_extension_constantcontact_integration
 */

class ControllerPagesExtensionConstantContactIntegration extends AController {

    public $data=[];

    public function verify() {
        $this->load->model('extension/constantcontact_integration_license_info');
        $license_key = $this->config->get('constantcontact_integration_license_code');
        if ($license_key) {
            $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('constantcontact_integration_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $this->model_extension_constantcontact_integration_license_info->getStoreId();
                $license_key = $this->model_extension_constantcontact_integration_license_info->getLicenseCode($store_id);
                $license_info = $this->model_extension_constantcontact_integration_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], 'constantcontact_integration');
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $this->model_extension_constantcontact_integration_license_info->getLicensedStoreStatus();
                if ($validate['status'] === 'valid' && $store_status == 1) {
                    return true;
                } else {
                    return false;
                }
            }
        } else {
            return false;
        }
    }

    public function verifyEditor() {
        if ( $this->config->get( 'editor_status' ) === '1' ) {
            $this->load->model('extension/editor_license_info');
            $license_key = $this->config->get('editor_license_code');
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('editor_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_editor_license_info->getStoreId();
                    $license_key = $this->model_extension_editor_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_editor_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'editor');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_editor_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function main() {
        $this->loadLanguage('constantcontact_integration/constantcontact_integration');
        $this->loadLanguage('extension/extensions');
        $this->load->model('setting/setting');
        $store_id = $this->getStoreId();
        $this->load->model('extension/constantcontact_integration');
        $exist = $this->model_extension_constantcontact_integration->getInfo();
        // Create a client
        if ($exist) {
            $this->view->assign('heading_title',$this->language->get('additional_settings_heading_title'));
            $this->view->assign('text_sync_description',$this->language->get('text_sync_description'));
            $store_id = $this->getStoreId();
            $this->load->model('setting/setting');
            $settings = $this->model_setting_setting->getSetting('constantcontact_integration', $store_id);

            $client = new \PHPFUI\ConstantContact\Client($settings['client_id'], $settings['client_secret'], HTTPS_SERVER);
            $token_info = $this->model_extension_constantcontact_integration->getInfo();
            // Set access and refresh tokens on client
            $client->accessToken = $token_info['access_token'];
            $client->refreshToken = $token_info['refresh_token'];

            $this->loadModel('extension/constantcontact_integration');
            $this->loadModel('setting/setting');
            $this->data['addition_note']=$this->language->get('constantcontact_integration_addition_note');
            $this->data['ext_man']=  $this->language->get('constantcontact_integration_name').' Manual';
            $this->data['tools']=$this->language->get('constantcontact_integration_tools');
            $this->data['contact_title']=$this->language->get('constantcontact_integration_name');
            $this->data['content']=$this->language->get('constantcontact_integration_content');
            $this->data['textTopContent']=$this->language->get('constantcontact_integration_top_content');
            $this->data['textBottomContent']=$this->language->get('constantcontact_integration_bottom_content');
            $this->data['topContentUrl']=$this->html->getSecureURL('r/extension/constantcontact_integration/addTop');
            $this->data['bottomContentUrl']=$this->html->getSecureURL('r/extension/constantcontact_integration/addBottom');
            $this->data['help_url']='https://why2central.net/v1/ctct-134';
            $this->data['text_unauthorized'] = $this->language->get('text_ctct_unauthorized');
            $topContent=$this->model_extension_constantcontact_integration->getContent('top');
            $bottomContent=$this->model_extension_constantcontact_integration->getContent('bottom');
            $this->data['topContent'] = $topContent['content'];
            $this->data['bottomContent'] = $bottomContent['content'];

            if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->request->post['export'] == 'export') {
                $store_id = $this->getStoreId();
                $this->load->model('setting/setting');
                $settings = $this->model_setting_setting->getSetting('constantcontact_integration', $store_id);
                $this->loadModel('sale/customer');
                $list_id = $settings['constantcontact_integration_list'];
                $results = $this->model_sale_customer->getCustomersByNewsletter();
                if ($results) {
                    $import_data = [];
                    foreach ($results as $rst) {
                        $contact['email'] = $rst['email'];
                        $contact['first_name'] = $rst['firstname'];
                        $contact['last_name'] = $rst['lastname'];
                        $import_data[] = new \PHPFUI\ConstantContact\Definition\JsonImportContact($contact);
                    }
                    $list_ids = [new \PHPFUI\ConstantContact\UUID($list_id)];
                    $contactsJsonImportDefinition = new \PHPFUI\ConstantContact\Definition\ContactsJsonImport();
                    $contactsJsonImportDefinition->import_data = $import_data;
                    $contactsJsonImportDefinition->list_ids = $list_ids;

                    $contactsJsonImport = new \PHPFUI\ConstantContact\V3\Activities\ContactsJsonImport($client);
                    $contactsJsonImport->post($contactsJsonImportDefinition);
                    if (!$contactsJsonImport->success()) {
                        $this->log->write('Constant Contact Integration Export Status: ' . $contactsJsonImport->getLastError());
                    }
                    $this->session->data['success'] = $this->language->get('text_export_success');
                } else {
                    $this->session->data['warning'] = $this->language->get('text_export_empty');
                }
                redirect($this->html->getSecureURL('extension/constantcontact_integration', '&extension=constantcontact_integration'));
            } elseif ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->request->post['sync'] == 'sync') {
                $store_id = $this->getStoreId();
                $this->load->model('sale/customer');
                $this->load->model('setting/setting');
                $settings = $this->model_setting_setting->getSetting('constantcontact_integration', $store_id);
                $contacts = $this->getAllContacts();
                $admin_email = $settings['constantcontact_integration_admin_email'];
                foreach ($contacts as $ct) {
                    set_time_limit(0);
                    $email = $ct['email_address']['address'];
                    if ($email === $admin_email) {
                        continue;
                    }
                    $exist = $this->model_extension_constantcontact_integration->getCustomerByEmail($email);
                    $newsletter = $exist['newsletter'];
                    if (!($exist)) {
                        $request_data['firstname'] = $ct['first_name'];
                        $request_data['lastname'] = $ct['last_name'];
                        $request_data['email'] = $email;
                        $request_data['password'] = md5(mt_rand(0, 10000)); //random password
                        $request_data['loginname'] = uniqid("", true); // loginname must be unique!
                        $request_data['newsletter'] = 1; // sign of subscriber
                        $request_data['status'] = $request_data['approved'] = 0; //disable login ability for subscribers
                        $request_data['customer_group_id'] = $this->model_extension_constantcontact_integration->getSubscribersCustomerGroupId();
                        $this->model_sale_customer->addCustomer($request_data);
                    } elseif ($newsletter == 0) {
                        $this->model_extension_constantcontact_integration->syncNewsletter('1', $email);
                    }
                    $stat = $ct['permission_to_send'];
                    if ($stat == 'pending_confirmation' || $stat == 'unsubscribed' || $stat == 'not_set') {
                        $this->model_extension_constantcontact_integration->syncNewsletter('0', $email);
                    }
                }

                $this->session->data['success'] = $this->language->get('text_sync_success');
                redirect($this->html->getSecureURL('extension/constantcontact_integration', '&extension=constantcontact_integration'));
            }
            $template = 'pages/extension/constantcontact_integration.tpl';
        } else {
            $redirectURI = $this->html->getSecureURL('extension/constantcontact_integration_settings', '&extension=constantcontact_integration');
            header('location: ' . $redirectURI);
        }

        $this->document->setTitle($this->language->get('additional_settings_heading_title'));

        $this->document->initBreadcrumb([
            'href' => $this->html->getSecureURL('index/home'),
            'text' => $this->language->get('text_home'),
            'separator' => FALSE
        ]);

        $this->document->addBreadcrumb( [
            'href'      => $this->html->getSecureURL('extension/extensions/extensions'),
            'text'      => $this->language->get('text_extensions'),
            'separator' => ' :: '
        ]);

        $this->document->addBreadcrumb([
            'href' => $this->html->getSecureURL('extension/constantcontact_integration'),
            'text' => $this->language->get('additional_settings_heading_title'),
            'separator' => ' :: '
        ]);

        $this->view->assign('error_warning', $this->session->data[ 'warning' ]);
        $this->view->assign('success', $this->session->data[ 'success' ]);
        $this->view->assign( 'heading_title', $this->language->get('additional_settings_heading_title'));
        if (isset($this->session->data[ 'success' ])) {
            unset($this->session->data[ 'success' ]);
        }
        if (isset($this->session->data[ 'warning' ])) {

            unset($this->session->data[ 'warning' ]);

        }
        $form = new AForm ( 'ST' );
        $this->data ['action'] = $this->html->getSecureURL ( 'extension/constantcontact_integration' );
        $this->data ['update'] = '';
        $form->setForm ( ['form_name' => 'syncForm', 'update' => $this->data ['update'] ] );
        $this->data['form']['form_open'] = $form->getFieldHtml ( ['type' => 'form', 'name' => 'syncForm', 'action' => $this->data ['action'] ] );
        $this->data['form']['submit'] = $form->getFieldHtml ( ['type' => 'button', 'name' => 'submit', 'text' => $this->language->get ( 'button_go' ), 'style' => 'button1' ] );
        $this->data['form']['cancel'] = $form->getFieldHtml ( ['type' => 'button', 'name' => 'cancel', 'text' => $this->language->get ( 'button_cancel' ), 'style' => 'button2' ] );
        $this->view->assign('text_export',$this->language->get ( 'text_export' ));
        $this->view->assign('text_sync',$this->language->get ( 'text_sync' ));
        $this->data['license_status'] = $this->verify();
        $this->data['editor_status'] = $this->verifyEditor();
        $this->data['editor']=$this->config->get('editor_status');
        $this->data['groups'][] = 'additional_settings';
        $this->data['link_additional_settings'] = $this->html->getSecureURL('extension/constantcontact_integration','&extension=constantcontact_integration');
        $this->data['active_group'] = 'additional_settings';
        $this->data['text_unauthorized'] = $this->language->get( 'text_ctct_unauthorized' );
        $this->data['form_store_switch']= $this->html->getStoreSwitcher();
        $this->view->batchAssign($this->data);
        $this->processTemplate($template);
    }

    private function getAllContacts() {
        $store_id = $this->getStoreId();
        $this->load->model('setting/setting');
        $settings = $this->model_setting_setting->getSetting('constantcontact_integration', $store_id);

        $client = new \PHPFUI\ConstantContact\Client($settings['client_id'], $settings['client_secret'], HTTPS_SERVER);
        $token_info = $this->model_extension_constantcontact_integration->getInfo();
        // Set access and refresh tokens on client
        $client->accessToken = $token_info['access_token'];
        $client->refreshToken = $token_info['refresh_token'];

        $contactsEndPoint = new \PHPFUI\ConstantContact\V3\Contacts($client);
        $list_id = $settings['constantcontact_integration_list'];

        $contactsResponse = $contactsEndPoint->get(status: 'all',include_count: true,lists: $list_id, limit: 500);

        if (!$contactsEndPoint->success()) {
            $this->log->write('Constant Contact Get All Contacts Result Page 1: ' . $contactsEndPoint->getLastError());
        }

        $counts = $contactsResponse['contacts_count'];
        $contacts = $contactsResponse['contacts'];
        $pages =  1;
        if ($counts > 500) {
            $pages = intdiv($counts,500);
            $remains = fmod($counts,500);
            if ($remains) {
                $pages += 1;
            }
        }

        if ($pages > 1) {
            for ($i = 2; $i <= $pages; $i++) {
                $contactsResponseNext = $contactsEndPoint->next();
                if (!$contactsEndPoint->success()) {
                    $this->log->write('Constant Contact Get All Contacts Result Page ' .$i.' Result: '. $contactsEndPoint->getLastError());
                }
                $contacts = array_merge($contacts,$contactsResponseNext['contacts']);
            }
        }

        return $contacts;
    }

    public function getStoreId() {
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
}