<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( ! defined( 'DIR_CORE' ) ) {
	header( 'Location: static_pages/' );
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";
require_once DIR_EXT . "company_reference" . DIR_EXT_CORE . "updater.php";

class ExtensionCompanyReference extends Extension {

	public $data = [];
	public $error = [];
    private $mc_server_url = "https://abantecartplus.com/clientarea/plugin/license_manager/validate/";
    private $diy_server_url = "https://wehearyou2.com/clientarea/plugin/license_manager/validate/";
    private $shared_secret = "company_reference";

    public function __construct() {
        $this->registry = Registry::getInstance();
    }

	private function _is_enabled() {
      	return $this->baseObject->config->get('company_reference_status') && $this->verify();
	}

	public function verify() {
		$that =& $this->baseObject;
        $that->load->model('extension/company_reference_license_info');
        $license_key = $that->config->get('company_reference_license_code');
        if ($license_key) {
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('company_reference_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $that->model_extension_company_reference_license_info->getStoreId();
                $license_key = $that->model_extension_company_reference_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_company_reference_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $that->model_extension_company_reference_license_info->getLicensedStoreStatus();
                if ($validate['status']==='expired') {
                    $that->load->model('extension/company_reference_license_info');
                    $store_id = $that->model_extension_company_reference_license_info->getStoreId();
                    $public_key = "";
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license_key = $that->model_extension_company_reference_license_info->getLicenseCode($store_id);
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }

                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $that->load->model('extension/company_reference_license_info');
                    $current_version = $that->model_extension_company_reference_license_info->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_data, $ttl);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/company_reference_license_info');
                            $that->model_extension_company_reference_license_info->saveLicenseData($data);
                        } elseif ($validate['status'] === 'valid' && $store_status == 1) {
                            return true;
                        } else {
                            return false;
                        }
                    }
                } else {
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
	}

    public function onControllerPagesIndexLogin_InitData() {
        $that =& $this->baseObject;
        if ($that->request->is_POST()) {
            $logged_in = $that->session->data['LAST_ACTIVITY'];
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('company_reference_license_info') . "'");
            if ($exist->num_rows === 1) {
                if (isset($logged_in)) {
                    $that->load->model('extension/company_reference_license_info');
                    $store_id = $that->model_extension_company_reference_license_info->getStoreId();

                    $license_info = $that->model_extension_company_reference_license_info->getLicenseData($store_id);
                    $last_check = $license_info['last_check'];
                    $daily_check = 86400;
                    if (time() > $daily_check + $last_check) {
                        $public_key = "";
                        $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                        $license_key = $that->model_extension_company_reference_license_info->getLicenseCode($store_id);
                        $license = new License($path_to_phpseclib);
                        $license_manager = $license->getManager();
                        if (stripos($license_key,'mc-')!==false) {
                            $server_url = $this->mc_server_url;
                        } else {
                            $server_url = $this->diy_server_url;
                        }

                        $license_manager->setLicenseServerUrl($server_url);
                        $license_manager->setKeys($license_key, "", $this->shared_secret);
                        $public_key = $license_manager->requestKey();
                        $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                        $that->load->model('extension/company_reference_updater');
                        $current_version = $that->model_extension_company_reference_updater->getCurrentVersion();
                        $custom_data = ['version' => $current_version];
                        $license_data = $license_manager->requestData($custom_data);
                        if (!is_null($license_data)) {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $ttl = 1209600;
                            $validate = $license_manager->validate($license_data, $ttl);
                            if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                                $data['public_key'] = $public_key;
                                $data['license_data'] = $license_data;
                                $data['store_id'] = $store_id;
                                $data['last_check'] = time();
                                $that->load->model('extension/company_reference_license_info');
                                $that->model_extension_company_reference_license_info->saveLicenseData($data);
                            }
                        }
                    }
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensions_InitData() {
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'edit' ) {
            $extension = $that->request->get['extension'];
            if ( $extension === 'company_reference' ) {
                if ( $that->request->is_POST()) {
                    $public_key = "";
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license_key = trim($that->request->post['company_reference_license_code']);
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }
                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $that->load->model('extension/company_reference_license_info');

                    $store_id = (int) $that->config->get('config_store_id');
                    if (has_value($that->request->get_or_post('store_id'))) {
                        $store_id = (int) $that->request->get_or_post('store_id');
                    } else {
                        if ($that->session->data['config_store_id']) {
                            $store_id = (int) $that->session->data['config_store_id'];
                        }
                    }

                    $installed_store_id = $that->model_extension_company_reference_license_info->getInstalledLicense($license_key);

                    if ($installed_store_id!=='' && !is_null($installed_store_id)) {
                        $that->model_extension_company_reference_license_info->deleteLicenseInfo($installed_store_id);
                    }
                    $existing_license_key = $that->model_extension_company_reference_license_info->getLicenseCode($store_id);
                    $data['multi']=false;
                    $split_existing_license_key = explode('-',$existing_license_key);
                    $split_license_key = explode('-',$license_key);
                    if ($existing_license_key && $split_existing_license_key[0] !== $split_license_key[0]) {
                        $data['multi']=true;
                    }

                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $that->load->model('extension/company_reference_updater');
                    $current_version = $that->model_extension_company_reference_updater->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_data, $ttl);

                        $that->load->model('setting/setting');
                        $that->load->model('extension/company_reference_license_info');
                        $data['company_reference_licensed_store_id_'.$store_id] = 1;

                        $that->model_setting_setting->editSetting('company_reference', $data);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            if (file_exists(DIR_EXT.'company_reference/core/helpers.php')) {
                                unlink(DIR_EXT.'company_reference/core/helpers.php');
                            }
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['license_key'] = $license_key;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/company_reference_license_info');
                            $that->model_extension_company_reference_license_info->saveLicenseData($data);
                        }
                    } else {
                        $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                    }
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensions_UpdateData() {
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'edit' ) {
            $extension = $that->request->get['extension'];
            $that->load->language('company_reference/company_reference');
            if ( $extension === 'company_reference' ) {
                $latestVersion = $this->getVersion();
                $that->loadLanguage('extension/extensions');
                if (!is_null($latestVersion) && $latestVersion!=='') {
                    $info = sprintf(
                        $that->language->get('text_update_company_reference_available'),
                        $latestVersion,
                        $that->html->getSecureURL('extension/company_reference_updater','&version='.str_replace('.', '-', $latestVersion))
                    );
                    $that->view->assign('info',$info);
                } else {
                    $that->view->assign('info','');
                }
                $view = new AView($this->registry, 0);
                $data['manual_url'] = 'https://why2central.net/v1/company-reference';
                $data['manual_title'] = $that->language->get('company_reference_name').' Manual';
                $view->batchAssign($data);
                $that->view->addHookVar('extension_toolbar_buttons', $view->fetch('pages/extension/company_reference_manual.tpl'));

                $that->load->model('extension/company_reference_license_info');
                $license_key = $that->config->get('company_reference_license_code');
                if ($license_key) {
                    $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('company_reference_license_info') . "'");
                    if ($exist->num_rows === 1) {
                        $store_id = $that->model_extension_company_reference_license_info->getStoreId();
                        $license_key = $that->model_extension_company_reference_license_info->getLicenseCode($store_id);
                        $license_info = $that->model_extension_company_reference_license_info->getLicenseData($store_id);
                        $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                        $license = new License($path_to_phpseclib);
                        $license_manager = $license->getManager();
                        $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_info['license_data'], $ttl);
                        $message = '';
                        if ($validate['status']==='expired') {
                            $message = $that->language->get('company_reference_license_expired');
                        }
                        $that->view->assign('message',$message);
                    }
                }
                $that->processTemplate();
            }
        }
    }

    public function onControllerResponsesListingGridExtension_InitData() {
        if ($this->baseObject_method != 'update') {
            return false;
        }
        $that =& $this->baseObject;
        if ($that->request->get['id'] != 'company_reference') {
            return false;
        }
        if (isset($that->request->post['company_reference_license_code'])) {
            $that->request->post['company_reference_license_code'] = trim($that->request->post['company_reference_license_code']);
        }
    }

    public function onControllerResponsesListingGridExtension_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $store_id = (int)$that->config->get('current_store_id');
            if ($that->request->get_or_post('store_id')) {
                $store_id = $that->request->get_or_post('store_id');
            }
            $that->load->language('company_reference/company_reference');
            $response = json_decode(json_encode($that->data['response']), true);
            $extension_rows = $response['rows'];
            $ext_name = $that->language->get('company_reference_name');
            foreach ($extension_rows as $k => $extensions) {
                if ($extensions['id'] === 'company_reference_' . $store_id) {
                    $cells = $extensions['cell'];
                    foreach ($cells as $key => $cell) {
                        if ($cell===$ext_name || strpos($cell,'<p class="alert-info">'.$ext_name)!==false) {
                            $latestVersion = $this->getVersion();
                            if (!is_null($latestVersion) && $latestVersion !== '') {
                                $update_now_url = $that->html->getSecureURL('extension/company_reference_updater', '&version=' . str_replace('.', '-', $latestVersion));
                                $cells[$key] = '<p class="alert-info">'
                                    .$ext_name.' (WHY2)'
                                    . '<br>'
                                    . sprintf(
                                        $that->language->get('text_update_company_reference_available'),
                                        $latestVersion,
                                        $update_now_url
                                    )
                                    . '</p>';
                                $that->data['response']->rows[$k]['cell'][$key] = $cells[$key];
                            } else {
                                $that->data['response']->rows[$k]['cell'][$key] = $ext_name;
                            }
                        }
                    }
                }
            }
        } elseif ($this->baseObject_method==='update') {
            if ($that->request->post['company_reference_license_code']) {
                $public_key = "";
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";

                $license_key = trim($that->request->post['company_reference_license_code']);
                if (stripos($license_key,'mc-')!==false) {
                    $server_url = $this->mc_server_url;
                } else {
                    $server_url = $this->diy_server_url;
                }
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setLicenseServerUrl($server_url);
                $license_manager->setKeys($license_key, "", $this->shared_secret);
                $public_key = $license_manager->requestKey();

                $store_id = (int) $that->config->get('config_store_id');
                if ($that->request->get_or_post('store_id')) {
                    $store_id = $that->request->get_or_post('store_id');
                }

                $that->load->model('extension/company_reference_license_info');

                $installed_store_id = $that->model_extension_company_reference_license_info->getInstalledLicense($license_key);

                if ($installed_store_id!=='' && !is_null($installed_store_id)) {
                    $that->model_extension_company_reference_license_info->deleteLicenseInfo($installed_store_id);
                }

                $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                $that->load->model('extension/company_reference_updater');
                $current_version = $that->model_extension_company_reference_updater->getCurrentVersion();
                $custom_data = ['version' => $current_version];
                $license_data = $license_manager->requestData($custom_data);
                if (!is_null($license_data)) {
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_data, $ttl);

                    $that->load->model('setting/setting');
                    $that->load->model('extension/company_reference_license_info');

                    if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $data['license_key'] = $license_key;
                        $data['store_id'] = $store_id;
                        $data['last_check'] = time();
                        $that->load->model('extension/company_reference_license_info');
                        $that->model_extension_company_reference_license_info->saveLicenseData($data);
                    }
                } else {
                    $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensionSummary_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $extension = $that->request->get['extension'];
            if ($extension==='company_reference') {
                $that->load->language('company_reference/company_reference');
                $extension_info = $that->extensions->getExtensionInfo($extension);
                $support_expiration_int =  strtotime($extension_info['support_expiration']);
                if ($extension_info['support_expiration'] && $support_expiration_int !== 0) {
                    if ($support_expiration_int < time()) {
                        if ($that->data['text_support_expiration']) {
                            $that->view->assign('text_support_expired', $that->language->get('text_support_by_why2'));
                        } else {
                            $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                        }
                    } else {
                        $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                    }
                } else {
                    $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                }
                $that->view->assign('get_support_button', '');
                $data['get_diy_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'diy_support',
                        'target' => "_new",
                        'href'   => 'https://wehearyou2.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_diy_support_by_why2'),
                    ]
                );
                $data['get_mc_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'mc_support',
                        'target' => "_new",
                        'href'   => 'https://abantecartplus.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_mc_support_by_why2'),
                    ]
                );
                $view = new AView(Registry::getInstance(), 0);
                $view->batchAssign($data);
                $that->view->addHookVar('extension_summary_item', $view->fetch('pages/extension/extension_summary_buttons.tpl'));
                $that->view->batchAssign($this->data);
                $that->processTemplate();
            }
        }
    }

    public function onControllerCommonHead_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (IS_ADMIN) {
                $latestVersion = $this->getVersion();
                if ($latestVersion) {
                    $that->load->language('company_reference/company_reference');
                    $that->load->model('extension/company_reference_updater');
                    $total = $that->model_extension_company_reference_updater->getTotalMsgIds();
                    if ($total > '0') {
                        $msg_ids = $that->model_extension_company_reference_updater->getMsgIdsByCartVersions();
                        foreach ($msg_ids as $msg_id) {
                            $that->messages->deleteMessage($msg_id['msg_id']);
                            $that->model_extension_company_reference_updater->deleteMsgID($msg_id['msg_id']);
                        }
                    }
                    $msg_title = str_replace('[new_version]', $latestVersion, $that->language->get('text_new_company_reference_version_title'));
                    $msg = str_replace('[version_number]', str_replace('.', '-', $latestVersion), $that->language->get('text_new_company_reference_version_description'));
                    $that->messages->saveNotice($msg_title, $msg);
                    $msg_info = $that->messages->getLikeMessage($msg_title);
                    $that->model_extension_company_reference_updater->saveMessageId($msg_info['msg_id'], $latestVersion);
                }
            }
        }
    }

    private function getVersion() {
        $that =& $this->baseObject;
        $latestVersion = '';
        $license_key = $that->config->get('company_reference_license_code');
        if ($license_key) {
            $valid = false;
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('company_reference_license_info') . "'");
            if ($exist->num_rows === 1) {
                $that->load->model('extension/company_reference_license_info');
                $store_id = $that->model_extension_company_reference_license_info->getStoreId();

                $license_key = $that->model_extension_company_reference_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_company_reference_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);

                if ($validate['status'] === 'valid') {
                    if (stripos($license_key, 'rent-') !== false || stripos($license_key, 'mc-') !== false) {
                        $valid = true;
                    } elseif (stripos($license_key, 'own-') !== false) {
                        $today = date("Y-m-d H:i:s");
                        $support_date = date('Y-m-d H:i:s', strtotime($validate['updates']));
                        if ($today <= $support_date) {
                            $valid = true;
                        }
                    }
                }
            }
            if ($valid) {
                $that->load->language('company_reference/company_reference');
                $getVersions = companyReferenceUpdaterGetAllVersions();
                $that->load->model('extension/company_reference_updater');
                $current_version = $that->model_extension_company_reference_updater->getCurrentVersion();
                if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                    $versions = $getVersions['notification_data']['product_versions'];
                    if ($versions) {
                        $latestVersions = [];
                        foreach ($versions as $version) {
                            if (strpos($version['version_number'], VERSION) !== false) {
                                $latestVersions[] = $version['version_number'];
                            }
                        }
                        usort($latestVersions, 'version_compare');
                        $latestVersion = end($latestVersions);
                        if (version_compare($current_version, $latestVersion, '<') === true) {
                            $msg_ids = $that->model_extension_company_reference_updater->getMsgIdsByCurrentCartVersion();
                            foreach ($msg_ids as $msg_id) {
                                $that->messages->deleteMessage($msg_id['msg_id']);
                                $that->model_extension_company_reference_updater->deleteMsgID($msg_id['msg_id']);
                            }
                            return $latestVersion;
                        }
                    }
                } else {
                    return '';
                }
            } else {
                return '';
            }
        }
    }

    /** Admin Section */

    public function onModelSaleOrder_ProcessData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'order_status_notify') {
            $that->load->model('extension/company_reference');
            $that->load->language('company_reference/company_reference');
            $order_id = $that->data['mail_template_data']['order_id'];
            $reference_number = '';
            if ($order_id) {
                $reference_number = $that->model_extension_company_reference->getReference($order_id);
            }
            $data['text_company_reference'] = $that->language->get('text_company_reference', 'company_reference/company_reference');
            $data['reference_number'] = $reference_number;
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->data['mail_template_data']['company_reference'] = $view->fetch('pages/checkout/company_reference_order_status_update.tpl');
        }
    }

    public function onControllerPagesSaleOrder_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'details') {
            $that->load->model('extension/company_reference');
            $that->load->language('company_reference/company_reference');
            $order_id = $that->request->get['order_id'];
            $reference_number = '';
            if ($order_id) {
                $reference_number = $that->model_extension_company_reference->getReference($order_id);
            }
            $this->data['text_company_reference'] = $that->language->get('text_company_reference');
            $this->data['reference_number'] = $reference_number;

            $view = new AView(Registry::getInstance(), 0);
            $view->batchAssign($this->data);
            $that->view->addHookVar('order_details_left_top_attributes', $view->fetch('pages/sale/company_reference_order_details.tpl'));
        }
    }

    public function onControllerResponsesSaleInvoice_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->load->model('extension/company_reference');
            $that->load->language('company_reference/company_reference');
            $order_id = $that->request->get['order_id'];
            $reference_number = '';
            if ($order_id) {
                $reference_number = $that->model_extension_company_reference->getReference($order_id);
            }
            $this->data['text_company_reference'] = $that->language->get('text_company_reference');
            $this->data['reference_number'] = $reference_number;

            $view = new AView(Registry::getInstance(), 0);
            $view->batchAssign($this->data);
            $that->view->addHookVar('order_invoice_'.$order_id.'_more_order_info_2', $view->fetch('pages/sale/company_reference_order_invoice.tpl'));
        }
    }

    public function onControllerResponsesSaleAdminInvoice_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->load->model('extension/company_reference');
            $that->load->language('company_reference/company_reference');
            $order_id = $that->request->get['order_id'];
            $reference_number = '';

            if ($order_id) {
                $reference_number = $that->model_extension_company_reference->getReference($order_id);
            }
            $this->data['text_company_reference'] = $that->language->get('text_company_reference');
            $this->data['reference_number'] = $reference_number;

            $view = new AView(Registry::getInstance(), 0);
            $view->batchAssign($this->data);
            $that->view->addHookVar('order_invoice_'.$order_id.'_more_order_info_2', $view->fetch('pages/sale/company_reference_order_invoice.tpl'));
        }
    }
    /** End Of Admin Section */

    /** StoreFront Section */

    /** Fast Checkout */
    public function onControllerResponsesCheckoutPay_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {

        }
    }

    public function onControllerResponsesCheckoutPay_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->loadLanguage('company_reference/company_reference');
            $that->loadLanguage('fast_checkout/fast_checkout');
            $data = [];
            $data['reference_number_placeholder'] = $that->language->get('fc_company_reference_placeholder');
            if (isset($that->session->data['fc']['reference_number'])) {
                $reference_number = $that->session->data['fc']['reference_number'];
            } elseif ($that->request->post['reference_number']) {
                $reference_number = $that->request->post['reference_number'];
            } else {
                $reference_number = '';
            }
            $data['reference_number_data'] = $reference_number;
            $data['save_session_url'] = $that->html->getSecureUrl('r/extension/company_reference/saveSession');
            $data['fast_checkout_text_apply'] = $that->language->get('fast_checkout_text_apply');
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('customer_additional_attributes', $view->fetch('pages/checkout/fc_company_reference_field.tpl'));
        }
    }
    
    public function onControllerPagesAccountOrderDetails_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->load->language('company_reference/company_reference');
            $that->load->model('extension/company_reference');
            $that->loadModel('account/order');
            $that->loadModel('extension/fast_checkout');

            $data = [];
            if ($that->customer->isLogged()) {
                //logged in customer, missing order ID?
                $order_id = (int) $that->request->get['order_id'];
            } else {
                if (isset($that->request->get['ot']) && $that->config->get('config_guest_checkout')) {
                    //try to decrypt order token
                    $order_token = $that->request->get['ot'];
                    list($order_id, $email) = $that->model_extension_fast_checkout->parseOrderToken($order_token);
                }
            }

            if ($order_id) {
                $reference_number = $that->model_extension_company_reference->getReference($order_id);
            }
            $data['company_reference_title'] = $that->language->get('company_reference_title');
            $data['reference_number'] = $reference_number;
            $data['text_company_reference'] = $that->language->get('text_company_reference');
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('more_order_info', $view->fetch('pages/account/company_reference_invoice.tpl'));
        }
    }

    /** End Of Fast Checkout Section */

    /** Default Checkout Section */

    public function onControllerPagesCheckoutShipping_ProcessData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->session->data['reference_number'] = $that->request->post['reference_number'];
    }

    public function onControllerPagesCheckoutShipping_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->loadLanguage('company_reference/company_reference');
            $data = [];
            $data['company_reference_title'] = $that->language->get('company_reference_title');
            if (isset($that->session->data['reference_number'])) {
                $reference_number = $that->session->data['reference_number'];
            } elseif ($that->request->post['reference_number']) {
                $reference_number = $that->request->post['reference_number'];
            } else {
                $reference_number = '';
            }
            $data['reference_number'] = $that->html->buildInput([
                'name' => 'reference_number',
                'value' => $reference_number,
            ]);
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('order_attributes', $view->fetch('pages/checkout/company_reference_field.tpl'));
        }
    }

    public function onControllerPagesCheckoutPayment_ProcessData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'confirm') {
          $that->session->data['reference_number'] = $that->request->post['reference_number'];
        }
    }

    public function onControllerPagesCheckoutPayment_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->loadLanguage('company_reference/company_reference');
            $data = [];
            $data['company_reference_title'] = $that->language->get('company_reference_title');
            if (isset($that->session->data['reference_number'])) {
                $reference_number = $that->session->data['reference_number'];
            } elseif ($that->request->post['reference_number']) {
                $reference_number = $that->request->post['reference_number'];
            } else {
                $reference_number = '';
            }
            $data['reference_number'] = $that->html->buildInput([
                'name' => 'reference_number',
                'value' => $reference_number,
            ]);
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('order_attributes', $view->fetch('pages/checkout/company_reference_field.tpl'));
        }
    }
    
    public function onControllerPagesCheckoutGuestStep2_ProcessData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->session->data['reference_number'] = $that->request->post['reference_number'];
    }

    public function onControllerPagesCheckoutGuestStep2_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->loadLanguage('company_reference/company_reference');
            $data['company_reference_title'] = $that->language->get('company_reference_title');
            if (isset($that->session->data['reference_number'])) {
                $reference_number = $that->session->data['reference_number'];
            } elseif ($that->request->post['reference_number']) {
                $reference_number = $that->request->post['reference_number'];
            } else {
                $reference_number = '';
            }
            $data['reference_number'] = $that->html->buildInput([
                'name' => 'reference_number',
                'value' => $reference_number,
            ]);

            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('order_attributes', $view->fetch('pages/checkout/company_reference_field.tpl'));
        }
    }

    public function onControllerPagesCheckoutGuestStep3_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->loadLanguage('company_reference/company_reference');
            $data['company_reference_title'] = $that->language->get('text_company_reference');
            $data['reference_number'] = $that->session->data['reference_number'];

            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('order_pre_attributes', $view->fetch('pages/checkout/company_reference_confirm.tpl'));
        }
    }

    public function onControllerPagesCheckoutConfirm_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->loadLanguage('company_reference/company_reference');
            $data['company_reference_title'] = $that->language->get('company_reference_title');
            $data['reference_number'] = $that->session->data['reference_number'];

            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('order_pre_attributes', $view->fetch('pages/checkout/company_reference_confirm.tpl'));
        }
    }

    public function onControllerPagesAccountHistory_UpdateData(){
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $order_histories=$that->data['orders'];
            $this->data['orders']=$that->data['orders'];
            $that->loadLanguage('company_reference/company_reference');
            $that->load->model('extension/company_reference');
            foreach ($order_histories as $key => $history) {
                $order_id = $history['order_id'];

                if ($order_id) {
                    $reference_number = $that->model_extension_company_reference->getReference($order_id);
                }
                $that->loadLanguage('company_reference/company_reference');
                $data['text_company_reference'] = $that->language->get('text_company_reference');
                $data['reference_number'] = $reference_number;
                $view = new AView($this->registry, 0);
                $view->batchAssign($data);
                $that->view->addHookVar('order_history_order_id'.$order_id.'_additional_info', $view->fetch('pages/account/company_reference_history.tpl'));
            }
        }
    }

    public function onControllerPagesAccountInvoice_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->load->language('company_reference/company_reference');
            $that->load->model('extension/company_reference');
            $data = [];

            $order_id = (int) $that->request->get['order_id'];

            $that->loadModel('account/customer');
            $that->loadModel('account/order');
            $reference_number = '';
            $guest = false;
            $enc = new AEncryption($that->config->get('encryption_key'));
            if (isset($that->request->get['ot']) && $that->config->get('config_guest_checkout')) {
                //try to decrypt order token
                $order_token = $that->request->get['ot'];
                if ($order_token) {
                    list($order_id, $email) = $that->model_account_customer->parseOrderToken($order_token);
                }
            }

            if ($that->request->is_POST()) {
                $guest = true;

                $order_id = $that->request->post['order_id'];
                $email = $that->request->post['email'];
                $order_token = $enc->encrypt($order_id . '::' . $email);
                $order_info = $that->model_account_order->getOrder($order_id, '', 'view');
                //compare emails
                if ($order_info['email'] != $email) {
                    unset($order_info, $order_id, $email);
                }
            }

            if ($order_id) {
                $reference_number = $that->model_extension_company_reference->getReference($order_id);
            }
            $data['company_reference_title'] = $that->language->get('company_reference_title');
            $data['reference_number'] = $reference_number;
            $data['text_company_reference'] = $that->language->get('text_company_reference');
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('more_order_info', $view->fetch('pages/account/company_reference_invoice.tpl'));
        }
    }

    /** End Of Default Checkout Section */

    /** Checkout Section */

    public function beforeModelCheckoutOrder_ProcessData()  {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'sf_order_confirm_mail') {
            $that->load->language('company_reference/company_reference');
            $that->load->model('extension/company_reference');
            $order_id = $that->data['mail_template_data']['order_id'];
            if (isset($that->session->data['fc']['reference_number'])){
                $reference_number = $that->session->data['fc']['reference_number'];
            } elseif (isset($that->session->data['reference_number'])) {
                $reference_number = $that->session->data['reference_number'];
            }
            $data['reference_number'] = $reference_number;
            $data['text_company_reference'] = $that->language->get('text_company_reference', 'company_reference/company_reference');
            $data['order_id'] = $order_id;
            $that->model_extension_company_reference->save($data);
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->data['mail_template_data']['company_reference'] = $view->fetch('pages/checkout/company_reference_order_confirmation.tpl');
        }
    }

    /** End Of Checkout Section */

    public function onControllerPagesCheckoutSuccess_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            if (isset($that->session->data['reference_number'])) {
                unset($that->session->data['reference_number']);
            }
        }
    }

    public function onControllerResponsesCheckoutFastCheckoutSuccess_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            if (isset($that->session->data['fc']['reference_number'])) {
                unset($that->session->data['fc']['reference_number']);
            }
        }
    }

    /** End Of StoreFront Section */
} ?>