<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

$language_id = $this->language->getContentLanguageID();

// add new menu item
$rm = new AResourceManager();
$rm->setType('image');
$menu = new AMenu ( "admin" );
$data = [];
$data['resource_code'] = '<i class="fa fa-file-text"></i>&nbsp;';
$data['name'] = [$language_id => 'Menu Icon Tax Exempt Certificate'];
$data['title'] = [$language_id => ''];
$data['description'] = [$language_id => ''];
$resource_id = $rm->addResource($data);

$menu = new AMenu ( "admin" );
$menu->insertMenuItem ( [ "item_id" => "tax_exempt_certificate",
        "parent_id" => "",
        "item_text" => "Tax Exempt Certificate",
        "item_url" => "",
        "item_type"=>"core",
        "sort_order"=>"",
        "item_icon_rl_id" => $resource_id
    ]
);

$menu->insertMenuItem ( [ "item_id" => "tax_exempt_certificate_list",
        "parent_id" => "tax_exempt_certificate",
        "item_text" => "Tax Exempt Certificate List",
        "item_url" => "extension/tax_exempt_certificate_list",
        "item_type"=>"core",
        "sort_order"=>"",
        "item_icon_rl_id" => $resource_id
    ]
);

$menu->insertMenuItem ( [ "item_id" => "expired_tax_exempt_certificate_list",
        "parent_id" => "tax_exempt_certificate",
        "item_text" => "Expired Tax Exempt Certificate List",
        "item_url" => "extension/expired_tax_cert",
        "item_type"=>"core",
        "sort_order"=>"",
        "item_icon_rl_id" => $resource_id
    ]
);

$sql1 = "SELECT `store_id` FROM " . $this->db->table("stores");
$query1 = $this->db->query($sql1);
$results1 = $query1->rows;

foreach ($results1 as $store_id) {
    $custom_email_activated_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_templates') . " WHERE text_id='custgroup_storefront_welcome_email_activated' AND `store_id`='".$store_id['store_id']."'");
    if ($custom_email_activated_exist->row['total'] === '0') {
        $email_activated = $this->db->query("SELECT * FROM " . $this->db->table('email_templates') . " WHERE text_id='storefront_welcome_email_activated' 
                                                                        AND language_id = " . (int)$language_id . "
                                                                        AND status = 1 and store_id = " . (int)$store_id['store_id']. " LIMIT 1");
        $email_activated_info = $email_activated->row;
        $this->db->query("INSERT INTO " . $this->db->table('email_templates') . ' SET `status`=' . (int)$email_activated_info['status'] . ',
                                                                       `text_id`="custgroup_storefront_welcome_email_activated", `language_id`=' . (int)$email_activated_info['language_id'] . ', 
                                                                       `headers`="' . $email_activated_info['headers'] . '", `subject`="' . $email_activated_info['subject'] . '", `html_body`="' . addslashes($email_activated_info['html_body']) . '", 
                                                                       `text_body`="' . $email_activated_info['text_body'] . '", `allowed_placeholders`="' . $email_activated_info['allowed_placeholders'] . '", `store_id`="' . $email_activated_info['store_id'] . '"');
    }

    $custom_email_approval_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_templates') . " WHERE text_id='custgroup_storefront_welcome_email_approval' AND `store_id`='".$store_id['store_id']."'");
    if ($custom_email_activated_exist->row['total'] === '0') {
        $email_approval = $this->db->query("SELECT * FROM " . $this->db->table('email_templates') . " WHERE text_id='storefront_welcome_email_approval' 
                                                                        AND language_id = " . (int)$language_id . "
                                                                        AND status = 1 and store_id = " . (int)$store_id['store_id'] . " LIMIT 1");
        $email_approval_info = $email_approval->row;
        $this->db->query("INSERT INTO " . $this->db->table('email_templates') . ' SET `status`=' . (int)$email_approval_info['status'] . ',
                                                                       `text_id`="custgroup_storefront_welcome_email_approval", `language_id`=' . (int)$email_approval_info['language_id'] . ', 
                                                                       `headers`="' . $email_approval_info['headers'] . '", `subject`="' . $email_approval_info['subject'] . '", `html_body`="' . addslashes($email_approval_info['html_body']) . '", 
                                                                       `text_body`="' . $email_approval_info['text_body'] . '", `allowed_placeholders`="' . $email_approval_info['allowed_placeholders'] . '", `store_id`="' . $email_approval_info['store_id'] . '"');
    }

    $custom_email_activation_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_templates') . " WHERE text_id='custgroup_storefront_send_activate_link' AND `store_id`='".$store_id['store_id']."'");
    if ($custom_email_activated_exist->row['total'] === '0') {
        $email_activation = $this->db->query("SELECT * FROM " . $this->db->table('email_templates') . " WHERE text_id='storefront_send_activate_link' 
                                                                        AND language_id = " . (int)$language_id . "
                                                                        AND status = 1 and store_id = " . (int)$store_id['store_id'] . " LIMIT 1");
        $email_activation_info = $email_activation->row;
        $this->db->query("INSERT INTO " . $this->db->table('email_templates') . ' SET `status`=' . (int)$email_activation_info['status'] . ',
                                                                       `text_id`="custgroup_storefront_send_activate_link", `language_id`=' . (int)$email_activation_info['language_id'] . ', 
                                                                       `headers`="' . $email_activation_info['headers'] . '", `subject`="' . $email_activation_info['subject'] . '", `html_body`="' . addslashes($email_activation_info['html_body']) . '", 
                                                                       `text_body`="' . $email_activation_info['text_body'] . '", `allowed_placeholders`="' . $email_activation_info['allowed_placeholders'] . '", `store_id`="' . $email_activation_info['store_id'] . '"');
    }
}

if (file_exists(DIR_EXT.'email_editor') && $this->config->get('email_editor_status')) {
    $sql5 = "SELECT `store_id` FROM " . $this->db->table("stores");
    $query5 = $this->db->query($sql5);
    $results5 = $query5->rows;

        $sql2 = 'CREATE TABLE IF NOT EXISTS ' . $this->db->table('email_editor_customer_group') . ' (
        `email_editor_customer_group_id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
        `email_template_id` int(11),
        `customer_group_id` int(11),
        `section_name` VARCHAR(256)
        )ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci';

        $this->db->query($sql2);

    foreach ($results5 as $result) {
        $store_id = $result["store_id"];
        $query_customer_groups = $this->db->query("SELECT * FROM " . $this->db->table("customer_groups"));
        $customer_groups = $query_customer_groups->rows;
        foreach ($customer_groups as $cust_group) {
            $search = [" ", "'",];
            $replace = "_";
            $section = str_replace($search, $replace, strtolower($cust_group['name']));

            $account_activated_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='" . $section . "_account_create' AND `store_id`='.$store_id'");
            if ($account_activated_exist->row['total'] === '0') {
                $account_activated = $this->db->query("SELECT * FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_create'");
                $account_activated_info = $account_activated->row;
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_templates') . "  
                          SET `section` = '" . $section . "_account_create', 
                          `sender_name`='" . $account_activated_info['sender_name'] . "',`sender_email`='" . $account_activated_info['sender_email'] . "',`subject`='" . $account_activated_info['subject'] . "', 
                          `default_subject`='" . $account_activated_info['default_subject'] . "',
                          `content` = '" . $account_activated_info['content'] . "', 
                          `default_content` = '" . $account_activated_info['default_content'] . "',`email_signature_id` = '" . $account_activated_info['email_signature_id'] . "',
                          `notify_admin`='" . $account_activated_info['notify_admin'] . "', `store_id`='" . $store_id . "'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
                $account_create_email_id = $this->db->getLastId();
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=" . $account_create_email_id . ",`customer_group_id`=" . $cust_group['customer_group_id'] . ",`section_name`='" . $section . "'");
            }

            $account_approval_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='" . $section . "_account_approval' AND `store_id`='.$store_id'");
            if ($account_approval_exist->row['total'] === '0') {
                $account_approval = $this->db->query("SELECT * FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_approval'");
                $account_approval_info = $account_approval->row;
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_templates') . "  
                          SET `section` = '" . $section . "_account_approval', 
                          `sender_name`='" . $account_approval_info['sender_name'] . "',`sender_email`='" . $account_approval_info['sender_email'] . "',`subject`='" . $account_approval_info['subject'] . "', 
                          `default_subject`='" . $account_approval_info['default_subject'] . "',
                          `content` = '" . $account_approval_info['content'] . "', 
                          `default_content` = '" . $account_approval_info['default_content'] . "',`email_signature_id` = '" . $account_approval_info['email_signature_id'] . "',
                          `notify_admin`='" . $account_approval_info['notify_admin'] . "', `store_id`='" . $store_id . "'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
                $account_approval_email_id = $this->db->getLastId();
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=" . $account_approval_email_id . ",`customer_group_id`=" . $cust_group['customer_group_id'] . ",`section_name`='" . $section . "'");
            }
            $account_activation_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='" . $section . "_account_activation' AND `store_id`='.$store_id'");
            if ($account_activation_exist->row['total'] === '0') {
                $account_activation = $this->db->query("SELECT * FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_activation'");
                $account_activation_info = $account_activation->row;
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_templates') . "  
                          SET `section` = '" . $section . "_account_activation', 
                          `sender_name`='" . $account_activation_info['sender_name'] . "',`sender_email`='" . $account_activation_info['sender_email'] . "',`subject`='" . $account_activation_info['subject'] . "', 
                          `default_subject`='" . $account_activation_info['default_subject'] . "',
                          `content` = '" . $account_activation_info['content'] . "', 
                          `default_content` = '" . $account_activation_info['default_content'] . "',`email_signature_id` = '" . $account_activation_info['email_signature_id'] . "',
                          `notify_admin`='" . $account_activation_info['notify_admin'] . "', `store_id`='" . $store_id . "'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
                $account_activation_email_id = $this->db->getLastId();
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=" . $account_activation_email_id . ",`customer_group_id`=" . $cust_group['customer_group_id'] . ",`section_name`='" . $section . "'");
            }

            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_create_info'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_create_subject'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_create_content'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_activation_info'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_activation_subject'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_activation_content'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_approval_info'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_approval_subject'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_approval_content'");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_create_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {login_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_create_subject','Account Create Email Subject:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_create_content','Account Create Email Content:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_activation_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {activate_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_activation_subject','Account Activation Email Subject:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_activation_content','Account Activation Email Content:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_approval_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {login_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_approval_subject','Account Needs Approval Email Subject:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_approval_content','Account Needs Approval Email Content:',now(),now())");
        }

        $query_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='expired_tax_exempt_certificate'");
        $exist = $query_exist->row['total'];
        if ($exist === '0') {
            $expired_tax_exempt_certificate_subject = 'Your Tax Exempt Certificate Is Expired';

            $expired_tax_exempt_certificate_content = 'Dear {{customer_name}},<br>We noticed that your tax exempt certificate has expired or is about to expire on: {{expired_at}}. You can update it by uploading the current tax exempt certificate via your edit account {{edit_account_url}}.<br>';
            $expired_tax_exempt_certificate_content .= 'If you want us to upload the certificate for you simply reply to this e-mail and provide us your name along with the updated tax exempt certificate file.<br><br>';
            $expired_tax_exempt_certificate_content .= 'Sincerely, {{store_url}}';

            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  
                              SET `section` = 'expired_tax_exempt_certificate', 
                              `sender_name`='',`sender_email`='',`subject`='" . $this->db->escape($expired_tax_exempt_certificate_subject) . "', 
                              `default_subject`='" . $this->db->escape($expired_tax_exempt_certificate_subject) . "',
                              `content` = '" . $this->db->escape($expired_tax_exempt_certificate_content) . "', 
                              `default_content` = '" . $this->db->escape($expired_tax_exempt_certificate_content) . "',
                              `allowed_placeholders`='customer_name, expired_at, edit_account_url, store_url',
                              `email_signature_id` = 0,
                              `notify_admin`=0, `store_id`='" . $store_id . "'
                              ON DUPLICATE KEY UPDATE  
                              `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_expired_tax_exempt_certificate_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {{customer_name}}, {{expired_at}}, {{edit_account_url}}, {{store_url}}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_expired_tax_exempt_certificate_subject','Expired Tax Exempt Email Subject:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_expired_tax_exempt_certificate_content','Expired Tax Exempt Email Content:',now(),now())");
        }
    }
}

$sql="CREATE TABLE IF NOT EXISTS " .$this->db->table('customer_group_auto_assigned_values') . " (
	`customer_group_auto_assigned_value_id` int(11) NOT NULL AUTO_INCREMENT,
    `customer_group_id` int(11) NOT NULL,
    `activated` char(1) NOT NULL DEFAULT 0,
    `admin_approval` char(1) NOT NULL DEFAULT 0,
	`email_activation` char(1) NOT NULL DEFAULT 0,
	`upload_tax_exemption` char(1) NOT NULL DEFAULT 0,
	`custom_email` char(1) NOT NULL DEFAULT 0,
	`upload_later` CHAR(1),
	`show_tax_exempt_status` smallint(1) NOT NULL DEFAULT '1',
	`no_tax_exemption_message` TEXT,
	`show_checkout_confirm` smallint(1) NOT NULL DEFAULT '1',
    `show_fast_checkout` smallint(1) NOT NULL DEFAULT '1',
    `show_invoice` smallint(1) NOT NULL DEFAULT '1',
    `show_confirmation_email` smallint(1) NOT NULL DEFAULT '1',
    `store_id` INT(11),
	PRIMARY KEY (`customer_group_auto_assigned_value_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;";
$this->db->query($sql);

$sql1="CREATE TABLE IF NOT EXISTS " .$this->db->table('customer_group_auto_assigned_info') . " (
	`customer_group_auto_assigned_info_id` int(11) NOT NULL AUTO_INCREMENT,
    `customer_group_id` int(11) NOT NULL,
    `customer_id` int(11) NOT NULL,
	`image_url` TEXT,
	`uploaded_at` DATETIME NULL,
	`expire` VARCHAR(8),
	`expire_date` DATETIME NULL,
	`upload_later` CHAR(1),
	`verified` CHAR(1),
	`verified_by` VARCHAR(64),
	`verified_date` DATETIME NULL, 
	`comment` TEXT,  
	`store_id` INT(11),
	PRIMARY KEY (`customer_group_auto_assigned_info_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;";
$this->db->query($sql1);

$sql2 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("customer_group_auto_assigned_license_info") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `public_key` TEXT NOT NULL,
  `license_data` TEXT NOT NULL,
  `license_key` TEXT NOT NULL,
  `store_id` int(11) NOT NULL,
  `last_check` int(11),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql2);

$sql3 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("customer_group_auto_assigned_updater_notification") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL,
  `cart_version` VARCHAR(10),
  `extension_version` VARCHAR(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql3);

$sql4 = "SELECT * FROM ".$this->db->table("order_status_ids") ." WHERE `status_text_id` ='exempt_hold'";
$query = $this->db->query($sql4);
if (!$query->row) {
    $sql5 = "INSERT INTO " . $this->db->table("order_statuses") . " (`order_status_id`, `language_id`, `name`) VALUES ('23','1','Exempt Hold') ON DUPLICATE KEY UPDATE `name` = VALUES(`name`);";
    $this->db->query($sql5);
    $sql6 = "INSERT INTO " . $this->db->table("order_status_ids") . " (`order_status_id`, `status_text_id`) VALUES ('23','exempt_hold') ON DUPLICATE KEY UPDATE `status_text_id` = VALUES(`status_text_id`)";
    $this->db->query($sql6);
}

$sql7 = "CREATE TABLE IF NOT EXISTS ".$this->db->table('customer_group_auto_assigned_history')." (
    `customer_group_auto_assigned_info_id` int(11) NOT NULL,
	`emailed` tinyint(1) NOT NULL DEFAULT '1',
	`date_added` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
	PRIMARY KEY (`customer_group_auto_assigned_info_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin";

$this->db->query($sql7);

if (!file_exists(DIR_SYSTEM.'lib/license.php')) {
    /**
     *  Function to Copy folders and files
     * @param $src
     * @param $dst
     * @return array
     */
    function custom_copy($src, $dst) {
        $error = [];
        // open the source directory
        $dir = opendir($src);
        if (!is_dir($dst)) {
            @mkdir($dst);
        }
        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    // Recursively calling custom copy function
                    // for sub directory
                    custom_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    if (!copy($src . '/' . $file, $dst . '/' . $file)) {
                        $error['error_copy'][] = "Failed to copy $file";
                    }
                }
            }
        }
        if (sizeof($error)>0) {
            $log=new ALog(DIR_SYSTEM.'logs/error.txt');
            $log->write(var_export($error,true));
        }
        closedir($dir);
        return $error;
    }

    $copy = custom_copy(DIR_EXT . 'customer_group_auto_assigned' . DIR_EXT_CORE . 'lib', DIR_SYSTEM.'lib');
}