<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

$sql= "UPDATE ".$this->db->table('language_definitions')." set language_value='Share to your friends' WHERE language_key='b2b_text' and section='b2b_b2b' and block='0';";
$this->db->query($sql);

$sql1 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("b2b_license_info") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `public_key` TEXT NOT NULL,
  `license_data` TEXT NOT NULL,
  `license_key` TEXT NOT NULL,
  `store_id` int(11) NOT NULL,
  `last_check` int(11),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql1);

$sql2 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("b2b_updater_notification") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL,
  `cart_version` VARCHAR(10),
  `extension_version` VARCHAR(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql2);


$rm = new AResourceManager();
$rm->setType('image');

$language_id = $this->language->getLanguageID();
$data = [];
$data['resource_code'] = '<i class="fa fa-user-circle"></i>&nbsp;';
$data['name'] = [$language_id => 'Menu Icon B2B'];
$data['title'] = [$language_id => ''];
$data['description'] = [$language_id => ''];
$resource_id = $rm->addResource($data);

$menu = new AMenu ( "admin" );

$menu->insertMenuItem ( [
        "item_id"         => "b2b",
        "parent_id"       =>"",
        "item_text"       => "B2B",
        "item_url"        => "",
        "item_icon_rl_id" => $resource_id,
        "item_type"       =>"core",
        "sort_order"      =>"29"
    ]
);

$data2 = [];
$data2['resource_code'] = '<i class="fa fa-user"></i>&nbsp;';
$data2['name'] = [$language_id => 'Menu Icon B2B Customer'];
$data2['title'] = [$language_id => ''];
$data2['description'] = [$language_id => ''];
$resource_id2 = $rm->addResource($data2);

$menu->insertMenuItem ( [
        "item_id"         => "b2b_customer",
        "parent_id"       => "b2b",
        "item_text"       => "B2B Customers",
        "item_url"        => "sale/b2b_customer",
        "item_type"       => "core",
        "sort_order"      => "30",
        "item_icon_rl_id" => $resource_id2
    ]
);

$data3 = [];
$data3['resource_code'] = '<i class="fa fa-money"></i>&nbsp;';
$data3['name'] = [$language_id => 'Menu Icon B2B Orders'];
$data3['title'] = [$language_id => ''];
$data3['description'] = [$language_id => ''];
$resource_id3 = $rm->addResource($data3);

$menu->insertMenuItem ( [
        "item_id"         => "b2b_order",
        "parent_id"       => "b2b",
        "item_text"       => "B2B Orders",
        "item_url"        => "sale/b2b_order",
        "item_type"       => "core",
        "sort_order"      => "31",
        "item_icon_rl_id" => $resource_id3
    ]
);

if (!file_exists(DIR_SYSTEM.'lib/license.php')) {
    /**
     *  Function to Copy folders and files
     * @param $src
     * @param $dst
     * @return array
     */
    function custom_copy($src, $dst) {
        $error = [];
        // open the source directory
        $dir = opendir($src);
        if (!is_dir($dst)) {
            @mkdir($dst);
        }
        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    // Recursively calling custom copy function
                    // for sub directory
                    custom_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    if (!copy($src . '/' . $file, $dst . '/' . $file)) {
                        $error['error_copy'][] = "Failed to copy $file";
                    }
                }
            }
        }
        if (sizeof($error)>0) {
            $log=new ALog(DIR_SYSTEM.'logs/error.txt');
            $log->write(var_export($error,true));
        }
        closedir($dir);
        return $error;
    }

    $copy = custom_copy(DIR_EXT . 'b2b' . DIR_EXT_CORE . 'lib', DIR_SYSTEM.'lib');
}