<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelSaleB2bOrder extends Model {

    /**
     * @param array $data
     * @param string $mode
     *
     * @return int|array
     * @throws AException
     */
    public function getOrders($data = [], $mode = 'default') {
        $language_id = $this->language->getLanguageID();

        if (array_key_exists('store_id', $data)) {
            $store_id = $data['store_id'];
        } else {
            $store_id = (int) $this->config->get('current_store_id');
        }

        if ($mode == 'total_only') {
            $total_sql = 'count(*) as total';
        } else {
            if ($data['company_ref_status']) {
                $total_sql = "o.order_id,
                        CONCAT(o.firstname, ' ', o.lastname) AS name,
                        (SELECT os.name
                         FROM " . $this->db->table("order_statuses") . " os
                         WHERE os.order_status_id = o.order_status_id
                            AND os.language_id = '" . (int)$language_id . "') AS status,
                         o.order_status_id,
                         o.date_added,
                         o.total,
                         o.currency,
                         o.value,
                         o.payment_company,
                         ref.reference_number as reference_number";
            } else {
                $total_sql = "o.order_id,
                        CONCAT(o.firstname, ' ', o.lastname) AS name,
                        (SELECT os.name
                         FROM " . $this->db->table("order_statuses") . " os
                         WHERE os.order_status_id = o.order_status_id
                            AND os.language_id = '" . (int)$language_id . "') AS status,
                         o.order_status_id,
                         o.date_added,
                         o.total,
                         o.currency,
                         o.value,
                         o.payment_company";
            }
        }

        $sql = "SELECT ".$total_sql."
                FROM `".$this->db->table("orders")."` o";

       if ($data['company_ref_status']) {
           $sql .= " LEFT JOIN ".$this->db->table("company_reference_order_relation")." ref ON ref.order_id = o.order_id";
       }

        if (isset($data['filter_product_id']) && has_value($data['filter_product_id'])) {
            $sql .= " LEFT JOIN  `".$this->db->table("order_products")."` op ON o.order_id = op.order_id ";
        }

        if (($data['filter_order_status_id'] ?? '') == 'all') {
            $sql .= " WHERE o.order_status_id >= 0";
        } else {
            if (isset($data['filter_order_status_id'])) {
                $sql .= " WHERE o.order_status_id = '".(int) $data['filter_order_status_id']."'";
            } else {
                $sql .= " WHERE o.order_status_id > '0'";
            }
        }

        if ($data['company_ref_status'] && isset($data['filter_reference_number'])) {
            $sql .= ' AND ref.reference_number = "'.$this->db->escape($data['filter_reference_number'], true).'"';
        }

        if ($data['company_ref_status'] && isset($data['filter_sub_reference_number'])) {
            $sql .= ' AND ref.reference_number LIKE "%'.$this->db->escape($data['filter_sub_reference_number'], true).'%"';
        }

        if (isset($data['filter_payment_company'])) {
            $sql .= ' AND o.payment_company = "'.$this->db->escape($data['filter_payment_company'], true).'"';
        }

        if (isset($data['filter_sub_payment_company'])) {
            $sql .= ' AND o.payment_company LIKE "%'.$this->db->escape($data['filter_sub_payment_company'], true).'%"';
        }

        if (isset($data['filter_product_id'])) {
            $sql .= " AND op.product_id = '".(int) $data['filter_product_id']."'";
        }
        if (isset($data['filter_coupon_id'])) {
            $sql .= " AND o.coupon_id = '".(int) $data['filter_coupon_id']."'";
        }

        if (isset($data['filter_customer_id'])) {
            $sql .= " AND o.customer_id = '".(int) $data['filter_customer_id']."'";
        }

        if (isset($data['filter_order_id'])) {
            $sql .= " AND o.order_id = '".(int) $data['filter_order_id']."'";
        }

        if (isset($data['filter_name'])) {
            $sql .= " AND LOWER(CONCAT(TRIM(o.firstname), ' ', TRIM(o.lastname))) 
                    LIKE LOWER('%".$this->db->escape(str_replace("  "," ",$data['filter_name']), true)."%') ";
        }

        if (isset($data['filter_date_added'])) {
            $sql .= " AND DATE(o.date_added) = DATE('".$this->db->escape($data['filter_date_added'])."')";
        }

        if ($store_id !== null) {
            $sql .= " AND o.store_id = '".(int) $store_id."'";
        }

        if (isset($data['filter_total'])) {
            $data['filter_total'] = trim($data['filter_total']);
            //check if compare signs are used in the request
            $compare = '';
            if (in_array(substr($data['filter_total'], 0, 2), ['>=', '<='])) {
                $compare = substr($data['filter_total'], 0, 2);
                $data['filter_total'] = substr($data['filter_total'], 2, strlen($data['filter_total']));
                $data['filter_total'] = trim($data['filter_total']);
            } else {
                if (in_array(substr($data['filter_total'], 0, 1), ['>', '<', '='])) {
                    $compare = substr($data['filter_total'], 0, 1);
                    $data['filter_total'] = substr($data['filter_total'], 1, strlen($data['filter_total']));
                    $data['filter_total'] = trim($data['filter_total']);
                }
            }

            $data['filter_total'] = (float) $data['filter_total'];
            //if we compare, easier select
            if ($compare) {
                $sql .= " AND FLOOR(CAST(o.total as DECIMAL(15,4))) ".$compare."  FLOOR(CAST(".$data['filter_total']
                    ." as DECIMAL(15,4)))";
            } else {
                $currencies = $this->currency->getCurrencies();
                $temp =
                $temp2 = [$data['filter_total'], ceil($data['filter_total']), floor($data['filter_total'])];
                foreach ($currencies as $currency1) {
                    foreach ($currencies as $currency2) {
                        if ($currency1['code'] != $currency2['code']) {
                            $temp[] = floor(
                                $this->currency->convert($data['filter_total'], $currency1['code'], $currency2['code'])
                            );
                            $temp2[] = ceil(
                                $this->currency->convert($data['filter_total'], $currency1['code'], $currency2['code'])
                            );
                        }
                    }
                }
                $sql .= " AND ( FLOOR(o.total) IN  (".implode(",", $temp).")
                                OR FLOOR(CAST(o.total as DECIMAL(15,4)) * CAST(o.value as DECIMAL(15,4))) IN  ("
                    .implode(",", $temp).")
                                OR CEIL(o.total) IN  (".implode(",", $temp2).")
                                OR CEIL(CAST(o.total as DECIMAL(15,4)) * CAST(o.value as DECIMAL(15,4))) IN  (".implode(
                        ",", $temp2
                    ).") )";
            }
        }

        //If for total, we done building the query
        if ($mode == 'total_only') {
            $query = $this->db->query($sql);
            return $query->row['total'];
        }

        $sort_data = [
            'o.order_id',
            'name',
            'status',
            'o.date_added',
            'o.total',
            'o.payment_company',
            'ref.reference_number',
        ];

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY ".$data['sort'];
        } else {
            $sql .= " ORDER BY o.order_id";
        }

        if (isset($data['order']) && (strtoupper($data['order']) == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT ".(int) $data['start'].",".(int) $data['limit'];
        }

        $query = $this->db->query($sql);
        $result_rows = [];
        foreach ($query->rows as $row) {
            $result_rows[] = $this->dcrypt->decrypt_data($row, 'orders');
        }
        return $result_rows;
    }

    /**
     * @param array $data
     *
     * @return int
     * @throws AException
     */
    public function getTotalOrders($data = []) {
        return $this->getOrders($data, 'total_only');
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getCompanyRef() {
        $sql = "SELECT `company_reference_order_relation_id`,`reference_number` FROM ".$this->db->table("company_reference_order_relation")." ref 
                LEFT JOIN ".$this->db->table("orders")." o ON o.order_id=ref.order_id";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getCompanies() {
        $sql = "SELECT DISTINCT `payment_company` FROM ".$this->db->table("orders");
        $query = $this->db->query($sql);
        return $query->rows;
    }

}