<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * ControllerPagesSaleB2bCustomer
 * @property ModelSaleB2bCustomer $model_sale_b2b_customer
 * @property ModelExtensionb2bLicenseInfo $model_extension_b2b_license_info
 */

class ControllerPagesSaleB2bCustomer extends AController {
    public $error = [];
    public $zeroDates = [
        '0000-00-00 00:00:00',
        '1970-01-01 00:00:00',
    ];

    /*
     * @var array - key -s field name mask, value - requirement
     */
    public $address_fields = [
        'firstname'  => [
            'type'     => 'input',
            'required' => true,
        ],
        'lastname'   => [
            'type'     => 'input',
            'required' => true,
        ],
        'company'    => [
            'type'     => 'input',
            'required' => false,
        ],
        'address_1'  => [
            'type'     => 'input',
            'required' => true,
        ],
        'address_2'  => [
            'type'     => 'input',
            'required' => false,
        ],
        'city'       => [
            'type'     => 'input',
            'required' => true,
        ],
        'postcode'   => [
            'type'     => 'input',
            'required' => false,
        ],
        //note! this field is pair of country_id and zone_id
        'country_id' => [
            'type'     => 'zones',
            'required' => true,
        ],
    ];

    public function verify() {
        $this->load->model('extension/b2b_license_info');
        $license_key = $this->config->get('b2b_license_code');
        if ($license_key && $this->config->get('b2b_status')) {
            $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('b2b_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $this->model_extension_b2b_license_info->getStoreId();
                $license_key = $this->model_extension_b2b_license_info->getLicenseCode($store_id);
                $license_info = $this->model_extension_b2b_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], 'b2b');
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $this->model_extension_b2b_license_info->getLicensedStoreStatus();
                if ($validate['status'] === 'valid' && $store_status == 1) {
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    public function verifyAutoAssigned() {
        if ($this->config->get('customer_group_auto_assigned_status')) {
            $this->load->model('extension/customer_group_auto_assigned_license_info');
            $license_key = $this->config->get('customer_group_auto_assigned_license_code');
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('customer_group_auto_assigned_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_customer_group_auto_assigned_license_info->getStoreId();
                    $license_key = $this->model_extension_customer_group_auto_assigned_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_customer_group_auto_assigned_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'customer_group_auto_assigned');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_customer_group_auto_assigned_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }


    public function main()  {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->load->language('sale/customer');
        $this->load->language('b2b/b2b');

        $this->document->setTitle($this->language->get('b2b_customer_heading_title'));

        $this->document->initBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('index/home'),
                'text'      => $this->language->get('text_home'),
                'separator' => false,
            ]
        );
        $this->document->addBreadcrumb(
            [
                'href'    => $this->html->getSecureURL('sale/b2b_customer'),
                'text'    => $this->language->get('b2b_customer_heading_title'),
                'current' => true,
            ]
        );

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/b2b.css'),
                'rel' => 'stylesheet',
            ]
        );

        //add phone validation js for quick preview modal
        $this->document->addScript($this->view->templateResource('/javascript/intl-tel-input/js/intlTelInput.min.js'));

        //set store selector
        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());

        if (isset($this->session->data['error'])) {
            $this->data['error_warning'] = $this->session->data['error'];
            unset($this->session->data['error']);
        } elseif (isset($this->error['warning'])) {
            $this->data['error_warning'] = $this->error['warning'];
        } else {
            $this->data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $this->data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $this->data['success'] = '';
        }

        $tax_cert_url = [];

        if ($this->verifyAutoAssigned()) {
            $this->loadLanguage('customer_group_auto_assigned/customer_group_auto_assigned');
            $tax_cert_url = [
                'href' => $this->html->getSecureURL('sale/tax_certificate', '&customer_id=%ID%'),
                'text' => $this->language->get('tab_certificate'),
            ];
        }

        $grid_settings = [
            //id of grid
            'table_id'     => 'b2b_customer_grid',
            // url to load data from
            'url'          => $this->html->getSecureURL('listing_grid/b2b_customer'),
            'editurl'      => $this->html->getSecureURL('listing_grid/b2b_customer/update'),
            'update_field' => $this->html->getSecureURL('listing_grid/b2b_customer/update_field'),
            'sortname'     => 'date_added',
            'sortorder'    => 'desc',
            'multiselect'  => 'true',
            // actions
            'actions'      => [
                'edit'          => [
                    'text' => $this->language->get('text_edit'),
                    'href' => $this->html->getSecureURL('sale/customer/update', '&customer_id=%ID%'),
                ],
                'save'          => [
                    'text' => $this->language->get('button_save'),
                ],
                'delete'        => [
                    'text' => $this->language->get('button_delete'),
                ],
                'actonbehalfof' => [
                    'text'   => $this->language->get('button_actas'),
                    'href'   => $this->html->getSecureURL('sale/customer/actonbehalf', '&customer_id=%ID%'),
                    'target' => 'new',
                ],
                'dropdown'      => [
                    'text'     => $this->language->get('text_choose_action'),
                    'href'     => $this->html->getSecureURL('sale/customer/update', '&customer_id=%ID%'),
                    'children' => array_merge(
                        [
                            'quickview'   => [
                                'text'  => $this->language->get('text_quick_view'),
                                'href'  => $this->html->getSecureURL('sale/customer/update', '&customer_id=%ID%'),
                                //quick view port URL
                                'vhref' => $this->html->getSecureURL(
                                    'r/common/viewport/modal',
                                    '&viewport_rt=sale/customer/update&customer_id=%ID%'
                                ),
                            ],
                            'details'     => [
                                'text' => $this->language->get('tab_customer_details'),
                                'href' => $this->html->getSecureURL('sale/customer/update', '&customer_id=%ID%'),
                            ],
                            'transaction' => [
                                'text' => $this->language->get('tab_transactions'),
                                'href' => $this->html->getSecureURL('sale/customer_transaction', '&customer_id=%ID%'),
                            ],
                            $tax_cert_url,
                        ], (array) $this->data['grid_edit_expand']
                    ),
                ],
            ],
            'grid_ready'   => 'grid_ready();',
        ];

        $this->load->model('setting/store');
        if (!$this->model_setting_store->isDefaultStore()) {
            $this->view->assign(
                'warning_actonbehalf', htmlspecialchars(
                                         $this->language->get('warning_actonbehalf_additional_store'), ENT_QUOTES,
                                         'UTF-8'
                                     )
            );
        }

        $grid_settings['colNames'] = [
            $this->language->get('column_id'),
            $this->language->get('column_name'),
            $this->language->get('column_company'),
            $this->language->get('column_email'),
            $this->language->get('column_group'),
            $this->language->get('column_status'),
            $this->language->get('column_approved'),
            $this->language->get('text_order'),
            $this->language->get('column_date_added'),
        ];
        $grid_settings['colModel'] = [
            [
                'name'  => 'customer_id',
                'index' => 'customer_id',
                'width' => 40,
                'align' => 'center',
            ],
            [
                'name'  => 'name',
                'index' => 'name',
                'width' => 120,
                'align' => 'center',
            ],
            [
                'name'  => 'company',
                'index' => 'company',
                'width' => 160,
                'align' => 'center',
            ],
            [
                'name'  => 'email',
                'index' => 'email',
                'width' => 180,
                'align' => 'center',
            ],
            [
                'name'   => 'customer_group',
                'index'  => 'customer_group',
                'width'  => 70,
                'align'  => 'center',
                'search' => false,
            ],
            [
                'name'   => 'status',
                'index'  => 'status',
                'width'  => 160,
                'align'  => 'center',
                'search' => false,
            ],
            [
                'name'   => 'approved',
                'index'  => 'approved',
                'width'  => 100,
                'align'  => 'center',
                'search' => false,
            ],
            [
                'name'   => 'orders',
                'index'  => 'orders_count',
                'width'  => 70,
                'align'  => 'center',
                'search' => false,
            ],
            [
                'name'   => 'date_added',
                'index'  => 'date_added',
                'width'  => 80,
                'align'  => 'center',
                'search' => false,
            ],
        ];

        $this->loadModel('sale/customer_group');
        $results = $this->model_sale_customer_group->getCustomerGroups();
        $groups = ['' => $this->language->get('text_select_group'),];
        foreach ($results as $item) {
            $groups[$item['customer_group_id']] = $item['name'];
        }

        $this->load->model('sale/b2b_customer');

        $companies_result = $this->model_sale_b2b_customer->getCompanies();
        $companies = ['' => $this->language->get('text_select_company'),];
        foreach ($companies_result as $company) {
            if ($company['company']==='') {
                continue;
            }
            $companies[$company['company']] = $company['company'];
        }

        $statuses = [
            '' => $this->language->get('text_select_status'),
            1  => $this->language->get('text_enabled'),
            0  => $this->language->get('text_disabled'),
        ];

        $approved = [
            '' => $this->language->get('text_select_approved'),
            1  => $this->language->get('text_yes'),
            0  => $this->language->get('text_no'),
        ];

        $form = new AForm();
        $form->setForm(
            [
                'form_name' => 'b2b_customer_grid_search',
            ]
        );

        //get search filter from cookie if required
        $search_params = [];
        if ($this->request->get['saved_list']) {
            $grid_search_form = json_decode(html_entity_decode($this->request->cookie['grid_search_form']));
            if ($grid_search_form->table_id == $grid_settings['table_id']) {
                parse_str($grid_search_form->params, $search_params);
            }
        }

        $grid_search_form = [];
        $grid_search_form['id'] = 'b2b_customer_grid_search';
        $grid_search_form['form_open'] = $form->getFieldHtml(
            [
                'type'   => 'form',
                'name'   => 'b2b_customer_grid_search',
                'action' => '',
            ]
        );
        $grid_search_form['submit'] = $form->getFieldHtml(
            [
                'type'  => 'button',
                'name'  => 'submit',
                'text'  => $this->language->get('button_go'),
                'style' => 'button1',
            ]
        );
        $grid_search_form['reset'] = $form->getFieldHtml(
            [
                'type'  => 'button',
                'name'  => 'reset',
                'text'  => $this->language->get('button_reset'),
                'style' => 'button2',
            ]
        );

        $grid_search_form['fields']['company'] = $form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'company',
                'options' => $companies,
                'style' => 'chosen'
            ]
        );

        $grid_search_form['fields']['customer_group'] = $form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'customer_group',
                'options' => $groups,
                'style' => 'chosen'
            ]
        );
        $grid_search_form['fields']['status'] = $form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'status',
                'options' => $statuses,
            ]
        );
        $grid_search_form['fields']['approved'] = $form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'approved',
                'options' => $approved,
            ]
        );

        $grid_settings['search_form'] = true;

        $this->data['license_status'] = $this->verify();
        $this->data['text_unauthorized'] = $this->language->get('text_b2b_unauthorized');

        $grid = $this->dispatch('common/listing_grid', [$grid_settings]);
        $this->view->assign('listing_grid', $grid->dispatchGetOutput());
        $this->view->assign('search_form', $grid_search_form);

        $this->view->assign('insert', $this->html->getSecureURL('sale/customer/insert'));

        $this->view->assign('help_url', $this->gen_help_url('customer_listing'));

        $this->view->batchAssign($this->data);
        $this->processTemplate('pages/sale/b2b_customer_list.tpl');

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

}
