<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

$mc_server_url = "https://abantecartplus.com/clientarea/plugin/license_manager/validate/";
$diy_server_url = "https://wehearyou2.com/clientarea/plugin/license_manager/validate/";
$shared_secret = "advanced_reports";

$public_key = "";
$path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";

if ($this->config->get('advanced_reports_license_code')) {
    $license_key = $this->config->get('advanced_reports_license_code');
    $license = new License($path_to_phpseclib);
    $license_manager = $license->getManager();
    if (stripos($license_key, 'mc-') !== false) {
        $server_url = $mc_server_url;
    } else {
        $server_url = $diy_server_url;
    }
    $license_manager->setLicenseServerUrl($server_url);
    $license_manager->setKeys($license_key, "", $shared_secret);
    $public_key = $license_manager->requestKey();
    $this->load->model('extension/advanced_reports_license_info');

    $store_id = (int)$this->config->get('config_store_id');

    $license_manager->setKeys($license_key, $public_key, $shared_secret);
    $custom_data = ['version' => '1.3.3.1'];
    $license_data = $license_manager->requestData($custom_data);
    if (!is_null($license_data)) {
        $ttl = 1209600;
        $validate = $license_manager->validate($license_data, $ttl);

        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
            $data['public_key'] = $public_key;
            $data['license_data'] = $license_data;
            $data['license_key'] = $license_key;
            $data['store_id'] = $store_id;
            $data['last_check'] = time();
            $this->load->model('extension/advanced_reports_license_info');
            $this->model_extension_advanced_reports_license_info->saveLicenseData($data);
        }
    }
}

$table1="CREATE TABLE IF NOT EXISTS ".$this->db->table('advanced_reports_order_products')."(
 `advanced_reports_order_product_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NULL DEFAULT '0',
  `order_product_id` int(11) NULL DEFAULT '0',
  `product_id` int(11) NOT NULL,
  `original_price` decimal(15,4) NULL DEFAULT '0.0000',
  `price` decimal(15,4) NULL DEFAULT '0.0000',
  `store_id` int(11),
  PRIMARY KEY (`advanced_reports_order_product_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;";

$this->db->query($table1);

$check1= "SHOW columns from ".$this->db->table('advanced_reports_order_products')." where field='store_id'";
$q1=$this->db->query($check1);
$exist1=count($q1->rows);
if ($exist1==0) {
    $sql12 = "ALTER TABLE ".$this->db->table('advanced_reports_order_products')." ADD `store_id` INT(11) COLLATE utf8_general_ci AFTER `price`";
    $this->db->query($sql12);
}

$table2="CREATE TABLE IF NOT EXISTS ".$this->db->table('advanced_reports_order_options')."(
 `advanced_reports_order_options_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NULL DEFAULT '0',
  `order_product_id` int(11) NULL DEFAULT '0',
  `product_option_value_id` int(11) NOT NULL DEFAULT '0',
  `option_sort_order` int(3) NOT NULL DEFAULT '0',
  `is_default` char(1) NOT NULL DEFAULT '',
  `original_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `store_id` int(11),
   PRIMARY KEY (`advanced_reports_order_options_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;";

$this->db->query($table2);

$check2= "SHOW columns from ".$this->db->table('advanced_reports_order_options')." where field='store_id'";
$q2=$this->db->query($check2);
$exist2=count($q2->rows);
if ($exist2==0) {
    $sql13 = "ALTER TABLE ".$this->db->table('advanced_reports_order_options')." ADD `store_id` INT(11) COLLATE utf8_general_ci AFTER `price`";
    $this->db->query($sql13);
}

$check3= "SHOW columns from ".$this->db->table('adv_reports_tax')." where field='store_id'";
$q3=$this->db->query($check3);
$exist3=count($q3->rows);
if ($exist3==0) {
    $sql14 = "ALTER TABLE ".$this->db->table('adv_reports_tax')." ADD `store_id` INT(11) COLLATE utf8_general_ci AFTER `description`";
    $this->db->query($sql14);
}

$orders = $this->db->query("SELECT `order_id`,`store_id` FROM ".$this->db->table("orders"));
$results = $orders->rows;
foreach ($results as $result) {
    $this->db->query("UPDATE ".$this->db->table("advanced_reports_order_products")." SET `store_id`=".$result['store_id']." WHERE `order_id`=".$result['order_id']);
    $this->db->query("UPDATE ".$this->db->table("advanced_reports_order_options")." SET `store_id`=".$result['store_id']." WHERE `order_id`=".$result['order_id']);
    $this->db->query("UPDATE ".$this->db->table("adv_reports_tax")." SET `store_id`=".$result['store_id']." WHERE `order_id`=".$result['order_id']);
}

$sql = "UPDATE ".$this->db->table('language_definitions')." set language_value='This is a WHY2 extension.  All support and updates are managed from WHY2. <br>
        Read about WHY2\'s 12 months support <a href=\"https://why2central.net/knowledgebase/why2-support-and-updates-policy/\" target=\"_blank\" style=\"font-weight:bold;\">here</a> and how WHY2 updates are delivered <a href=\"https://why2central.net/knowledgebase/extension-updater/\" target=\"_blank\" style=\"font-weight:bold;\">here</a>.<br>
        You can safely ignore Support expired notification within the Admin Dashboard.<br><br>
<strong>Notes: There are two ways to obtain the license key. <br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;a. Use this <a href=\"https://wehearyou2.com/clientarea/reg/register.php\" target=\"_blank\" style=\"font-weight:bold;\">form</a> to register to our Support system and generate your license key.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;b. Already registered -  click <a href=\"https://wehearyou2.com/clientarea/reg/index.php\" target=\"_blank\" style=\"font-weight:bold;\">here</a> to log into your account to obtain license key.<br>
        Refer to our <a href=\"https://why2central.net/faq/license-key/\" target=\"_BLANK\">F.A.Q</a> for more information on how to obtain the license key.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;c. If you already have an account in our support system and you are using multiple extensions from WHY2,  you do NOT need to create another account in the support system.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;d. Updating extension in same location does NOT require a new key.<br> Refer to our <a href=\"https://why2central.net/faq/license-key/\" target=\"_BLANK\">F.A.Q</a> for more information on how to Update extension in same location.</strong><br><br>
        1.&nbsp;Enter your WHY2 license key here.<br>
	    2.&nbsp;Click the additional settings tab for setup.' WHERE language_key='advanced_reports_note';";
$this->db->query($sql);

$sql2 = "UPDATE ".$this->db->table('language_definitions')." set language_value='Notes:<br>
                    1.&nbsp;Chart Width: Define your desired chart width, by default it\'s using 600px.<br>
                    2.&nbsp;Chart Height: Define your desired chart height, by default it\'s using 400px.<br>
                    3.&nbsp;Number Low Stock: Product quantity is lower the number will be \"Low Stock\". The option is used in report product inventory.<br>
                    4.&nbsp;Export Type PDF Paper: Select PDF paper type that you want to use for the report pages.<br>
                    5.&nbsp;Export Type PDF Orientation: Select PDF orientation.<br>
                    6.&nbsp;Enable Sales Tab: Select Yes if you want to show the product link on the product page.<br>
                    <strong>Notes: Number 7-12 is used in Sales By Country Page.</strong><br>
                    7.&nbsp;Enter Google Map API Key: <span class=\"help\">This is optional, required only if you want to see the map chart.</span><br>
                    8.&nbsp;Map first level color selection: Select your desired first level color for the map.<br>
                    9.&nbsp;Map second level color selection: Select your desired second level color for the map.<br>
                    10.&nbsp;Map third level color selection: Select your desired third level color for the map.<br>
                    11.&nbsp;Map fourth level color selection: Select your desired fourth level color for the map.<br>
                    12.&nbsp;Map fifth level color selection: Select your desired fifth level color for the map.<br>
                    13.&nbsp;Don\'t forget to click the save button after you have setup the settings.' WHERE language_key='advanced_reports_ext_note';";
$this->db->query($sql2);

$sql2 = "UPDATE ".$this->db->table('language_definitions')." set language_value='Enter your WHY2 license key:' WHERE language_key='advanced_reports_license_code';";
$this->db->query($sql2);

$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='text_last_year'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='heading_title_sales_profit_build_a_gift'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='text_report_sale_profit_build_a_gift'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='column_item_model'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='column_items'");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','text_last_year','Last year (Jan 1 - Dec 31)',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','heading_title_sales_profit_build_a_gift','Sales Profit Report - Build A Gift',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','text_report_sale_profit_build_a_gift','Sales Profit - Build A Gift',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','column_item_model','Item Model',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','column_items','Item',now(),now())");

$sql3 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("advanced_reports_updater_notification") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL,
  `cart_version` VARCHAR(10),
  `extension_version` VARCHAR(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql3);

$sql4 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("advanced_reports_license_info") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `public_key` TEXT NOT NULL,
  `license_data` TEXT NOT NULL,
  `license_key` TEXT NOT NULL,
  `store_id` int(11) NOT NULL,
  `last_check` int(11),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql4);

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','column_order_total','Order Total',now(),now())");

$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='advanced_reports_advanced_reports' AND `language_key`='button_filter'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='advanced_reports_advanced_reports' AND `language_key`='button_reset'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='text_new_advanced_reports_version_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='text_new_advanced_reports_version_description'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='text_update_success'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='text_update_failed'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='button_start_update'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='button_cancel_update'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='text_update_advanced_reports_note'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='text_advanced_reports_updater_heading_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='text_changelog'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='text_no_updates'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='button_go_back'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='text_advanced_reports_unauthorized'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='text_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='button_diy_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='button_mc_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='text_update_advanced_reports_available'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='advanced_reports_advanced_reports' AND `language_key`='advanced_reports_license_expired'");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','button_filter','Filter',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','button_reset','Reset',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','text_new_advanced_reports_version_title','New version (v[new_version]) of Advanced Reports Extension',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','text_new_advanced_reports_version_description','There is a new version of Advanced Reports Extension. Please open -->#admin#rt=extension/advanced_reports_updater&version=[version_number] to update the extension. <br><br>
                        The update will replace existing files with the update files.<br><br>Make sure that you have made a backup of your store prior to updating. Use your normal backup method or Softaculous to make a backup prior to updating your site. Need help on how to backup an installation by using Softaculous click <a href=\"https://why2central.net/knowledgebase/how-to-backup-an-installation/\" target=\"_BLANK\"><b>here</b></a>.<br><br>
                        Do not delete this message until you have updated.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','text_update_success','The Advanced Reports extension has been successfully updated.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','text_update_failed','We are unable to update the Advanced Reports extension, please check <a target=\"_BLANK\" href=\"#admin#rt=tool/error_log\">error log</a> for more information.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','button_start_update','Start Update',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','button_cancel_update','Cancel Update',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','text_update_advanced_reports_note','Note:<br>We are going to update Advanced Reports extension. The update will replace existing files with the update files.<br><br>Make sure that you have made a backup of your store prior to updating. Use your normal backup method or Softaculous to make a backup prior to updating your site. Need help on how to backup an installation by using Softaculous click <a href=\"https://why2central.net/knowledgebase/how-to-backup-an-installation/\" target=\"_BLANK\"><b>here</b></a>.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','text_advanced_reports_updater_heading_title', 'Advanced Reports Updater',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','text_changelog','Changelog:',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','text_no_updates','There are no new updates for this extension.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','button_go_back','Go Back',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','button_show_all_column','Show All Column',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','button_toggle_options','Expand/Hide Product Options',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','text_select_columns','Show/Hide Columns: ',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_image','Image',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_product_name','Product Name',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_model','Model',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_sku','SKU',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_stock_status','Stock Status',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_qty','Qty',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_free_shipping','Free Shipping',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_individual_shipping','Individual Shipping',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_downloadable','Downloadable',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_fixed_shipping','Fixed Shipping',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_weight','Weight',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_weight_class','Weight Class',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_length','Length',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_width','Width',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_height','Height',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_length_class','Length Class',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_cost','Cost',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_price','Price',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_value','Value',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_total_cost','Total Cost',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_purchased_qty','Purchased Qty',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','show_purchased_value','Purchased Value',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','button_save_settings','Save Settings',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','text_export_images','Export Images: ',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','column_product_inventory_cost','Actual Cost',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','column_product_inventory_price','Price of base or option modifier',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','column_product_inventory_weight','Weight of base or option modifier',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','text_all_products','All Products',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','text_per','Per',now(),now())");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','text_save_settings_success','The column selection settings has been successfully updated.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','column_final_price','Final Price',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','text_support_by_why2','Support and updates from WHY2.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','button_diy_support_by_why2','If you are self-managed users click here for support. Support and updates from WHY2.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','button_mc_support_by_why2','If you are a WHY2 Managed Client click here for support. Updates are part of the Managed Services.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','text_update_advanced_reports_available','New version (%s) is available. <a href=\"%s\" target=\"_BLANK\"><strong>Click to update now.</strong></a>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','text_advanced_reports_unauthorized','You are not authorized to use this extension. Please make you sure you are using the correct WHY2 license key.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','advanced_reports_advanced_reports','advanced_reports_license_expired','Your license key is expired. Possibly due to inactive with the extension for more than 14 days. Please click on the SAVE button at the bottom of this page.',now(),now())");


$menu = new AMenu ( "admin" );
$menu->deleteMenuItem("advanced_reports");
$menu->deleteMenuItem("advanced_reports_settings");
$menu->deleteMenuItem("advanced_reports_advanced");
$menu->deleteMenuItem("advanced_reports_advanced_sales");
$menu->deleteMenuItem("advanced_reports_advanced_sales");
$menu->deleteMenuItem("advanced_reports_advanced_sales_profit");
$menu->deleteMenuItem("advanced_reports_advanced_sales_statistics");
$menu->deleteMenuItem("advanced_reports_advanced_sales_by_customer_group");
$menu->deleteMenuItem("advanced_reports_advanced_sales_by_customer_company");
$menu->deleteMenuItem("advanced_reports_advanced_customer_reports");
$menu->deleteMenuItem("advanced_reports_advanced_sales_by_guest_group");
$menu->deleteMenuItem("advanced_reports_advanced_sales_by_guest_company");
$menu->deleteMenuItem("advanced_reports_advanced_guest_reports");
$menu->deleteMenuItem("advanced_reports_advanced_sales_by_country");
$menu->deleteMenuItem("advanced_reports_advanced_sales_by_hour");
$menu->deleteMenuItem("advanced_reports_advanced_sales_by_day_of_week");
$menu->deleteMenuItem("advanced_reports_advanced_users_activity_report");
$menu->deleteMenuItem("advanced_reports_advanced_sales_by_product");
$menu->deleteMenuItem("advanced_reports_advanced_sales_by_category");
$menu->deleteMenuItem("advanced_reports_advanced_sales_by_manufacturer");
$menu->deleteMenuItem("advanced_reports_advanced_sales_by_coupon_code");
$menu->deleteMenuItem("advanced_reports_advanced_sales_by_payment_type");
$menu->deleteMenuItem("advanced_reports_advanced_sales_by_region_or_state");
$menu->deleteMenuItem("advanced_reports_advanced_sales_by_zip");
$menu->deleteMenuItem("advanced_reports_products");
$menu->deleteMenuItem("advanced_reports_products_product_report");
$menu->deleteMenuItem("advanced_reports_products_inventory_report");
$menu->deleteMenuItem("advanced_reports_products_bestsellers");
$menu->deleteMenuItem("advanced_reports_products_special_shipping");
$menu->deleteMenuItem("advanced_reports_customers");
$menu->deleteMenuItem("advanced_reports_top_customers");
$menu->deleteMenuItem("advanced_reports_customers_by_city");
$menu->deleteMenuItem("advanced_reports_customers_by_country");
$menu->deleteMenuItem("advanced_reports_guest");
$menu->deleteMenuItem("advanced_reports_top_guest");
$menu->deleteMenuItem("advanced_reports_guest_by_city");
$menu->deleteMenuItem("advanced_reports_guest_by_country");
$menu->deleteMenuItem("advanced_reports_earnings");
$menu->deleteMenuItem("advanced_reports_profit");
$menu->deleteMenuItem("advanced_reports_tax");

$language = $this->registry->get('language');
$language_id = $language->getLanguageID();

$rm = new AResourceManager();
$rm->setType('image');
$data = [];
$data['resource_code'] = '<i class="fa fa-bar-chart-o"></i>&nbsp;';
$data['name'] = [ $language_id => 'Menu Icon Advanced Report' ];
$data['title'] = [ $language_id => '' ];
$data['description'] = [ $language_id => '' ];
$resource_id = $rm->addResource($data);

$menu = new AMenu ( "admin" );
$data = [];

$menu->insertMenuItem ( [  "item_id" => "advanced_reports",
        "parent_id"=>"",
        "item_text" => "Advanced Reports",
        "item_url" => "",
        "item_icon_rl_id" => $resource_id,
        "item_type"=>"core",
        "sort_order"=>"8"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_settings",
        "parent_id"=>"advanced_reports",
        "item_text" => "Settings",
        "item_url" => "advanced_reports/advanced_reports",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"219"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced",
        "parent_id"=>"advanced_reports",
        "item_text" => "Sales",
        "item_url" => "",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"220"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_sales",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales",
        "item_url" => "advanced_reports/sale_order",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"221"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_sales_profit",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales Profit",
        "item_url" => "advanced_reports/sale_profit",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"222"]
);

if ($this->config->get("build_a_gift_status")) {
    if (!$menu->getMenuItem('advanced_reports_advanced_sale_profit_build_a_gift')) {
        $menu->insertMenuItem(["item_id" => "advanced_reports_advanced_sale_profit_build_a_gift",
                "parent_id" => "advanced_reports_advanced",
                "item_text" => "Sales Profit - Build A Gift",
                "item_url" => "advanced_reports/sale_profit_build_a_gift",
                "item_icon_rl_id" => '',
                "item_type" => "core",
                "sort_order" => "223"]
        );
    }
}

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_sales_statistics",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales Statistics",
        "item_url" => "advanced_reports/sale_statistics",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"224"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_sales_by_customer_group",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Customer Group",
        "item_url" => "advanced_reports/customer_group",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"225"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_sales_by_customer_company",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Customer Company",
        "item_url" => "advanced_reports/customer_company",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"226"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_customer_reports",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Customer Reports",
        "item_url" => "advanced_reports/customer",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"227"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_sales_by_guest_group",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Guest Group",
        "item_url" => "advanced_reports/guest_group",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"228"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_sales_by_guest_company",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Guest Company",
        "item_url" => "advanced_reports/guest_company",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"229"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_guest_reports",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Guest Reports",
        "item_url" => "advanced_reports/guest",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"230"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_sales_by_country",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Country",
        "item_url" => "advanced_reports/sale_country",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"231"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_sales_by_hour",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Hour",
        "item_url" => "advanced_reports/sale_hour",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"232"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_sales_by_day_of_week",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Day Of Week",
        "item_url" => "advanced_reports/sale_day_week",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"233"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_users_activity_report",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Users Activity Report",
        "item_url" => "advanced_reports/user_activity",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"234"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_sales_by_product",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Product",
        "item_url" => "advanced_reports/product",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"235"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_sales_by_category",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Category",
        "item_url" => "advanced_reports/category",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"236"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_sales_by_manufacturer",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Manufacturer",
        "item_url" => "advanced_reports/sale_manufacturer",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"237"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_sales_by_coupon_code",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Coupon Code",
        "item_url" => "advanced_reports/sale_coupon",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"238"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_sales_by_payment_type",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Payment Type",
        "item_url" => "advanced_reports/sale_payment",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"239"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_sales_by_region_or_state",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Region Or State",
        "item_url" => "advanced_reports/sale_state",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"240"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_advanced_sales_by_zip",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Zip Code",
        "item_url" => "advanced_reports/sale_zipcode",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"241"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_products",
        "parent_id"=>"advanced_reports",
        "item_text" => "Products",
        "item_url" => "",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"242"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_products_product_report",
        "parent_id"=>"advanced_reports_products",
        "item_text" => "Product Report",
        "item_url" => "advanced_reports/report_product",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"243"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_products_inventory_report",
        "parent_id"=>"advanced_reports_products",
        "item_text" => "Inventory Report",
        "item_url" => "advanced_reports/product_inventory",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"244"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_products_bestsellers",
        "parent_id"=>"advanced_reports_products",
        "item_text" => "Bestsellers",
        "item_url" => "advanced_reports/product_bestseller",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"245"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_products_special_shipping",
        "parent_id"=>"advanced_reports_products",
        "item_text" => "Special Shipping",
        "item_url" => "advanced_reports/product_special",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"246"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_customers",
        "parent_id"=>"advanced_reports",
        "item_text" => "Customers",
        "item_url" => "",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"247"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_top_customers",
        "parent_id"=>"advanced_reports_customers",
        "item_text" => "Top Customers",
        "item_url" => "advanced_reports/top_customer",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"248"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_customers_by_city",
        "parent_id"=>"advanced_reports_customers",
        "item_text" => "Customers By City",
        "item_url" => "advanced_reports/customer_city",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"249"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_customers_by_country",
        "parent_id"=>"advanced_reports_customers",
        "item_text" => "Customers By Country",
        "item_url" => "advanced_reports/customer_country",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"250"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_guest",
        "parent_id"=>"advanced_reports",
        "item_text" => "Guest",
        "item_url" => "",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"251"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_top_guest",
        "parent_id"=>"advanced_reports_guest",
        "item_text" => "Top Guest",
        "item_url" => "advanced_reports/top_guest",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"252"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_guest_by_city",
        "parent_id"=>"advanced_reports_guest",
        "item_text" => "Guest By City",
        "item_url" => "advanced_reports/guest_city",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"253"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_guest_by_country",
        "parent_id"=>"advanced_reports_guest",
        "item_text" => "Guest By Country",
        "item_url" => "advanced_reports/guest_country",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"254"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_earnings",
        "parent_id"=>"advanced_reports",
        "item_text" => "Earnings",
        "item_url" => "advanced_reports/earnings&current=1",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"255"]
);

$menu->insertMenuItem ( [  "item_id" => "advanced_reports_profit",
        "parent_id"=>"advanced_reports",
        "item_text" => "Profit",
        "item_url" => "advanced_reports/profit",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"256"]
);
$menu->insertMenuItem ( [  "item_id" => "advanced_reports_tax",
        "parent_id"=>"advanced_reports",
        "item_text" => "Tax",
        "item_url" => "advanced_reports/tax",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"257"]
);

$this->db->query("UPDATE ".$this->db->table("language_definitions")." SET `language_value`='Cancel' WHERE `language_key`='button_cancel' AND `block`='auspost_integration_auspost_integration'");

if (file_exists(DIR_EXT . 'advanced_reports/core/lib/order_manager.php')) {
    unlink(DIR_EXT . 'advanced_reports/core/lib/order_manager.php');
}

if (file_exists(DIR_EXT . 'advanced_reports/core/lib/order.php')) {
    unlink(DIR_EXT . 'advanced_reports/core/lib/order.php');
}
if (file_exists(DIR_EXT . 'advanced_reports/core/lib/cart.php')) {
    unlink(DIR_EXT . 'advanced_reports/core/lib/cart.php');
}

if (file_exists(DIR_EXT . 'advanced_reports/admin/controller/responses/advanced_reports/product.php')) {
    unlink(DIR_EXT . 'advanced_reports/admin/controller/responses/advanced_reports/product.php');
}

if (file_exists(DIR_EXT . 'advanced_reports/admin/view/default/template/responses/product/option_values.tpl')) {
    unlink(DIR_EXT . 'advanced_reports/admin/view/default/template/responses/product/option_values.tpl');
}

if (file_exists(DIR_EXT . 'advanced_reports/admin/view/default/template/responses/product/option_value_row.tpl')) {
    unlink(DIR_EXT . 'advanced_reports/admin/view/default/template/responses/product/option_value_row.tpl');
}


$exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('advanced_reports_license') . "'");
if ($exist->num_rows === 1) {
    $this->db->query("DROP TABLE ".$this->db->table("advanced_reports_license"));
}

if (file_exists(DIR_EXT.'advanced_reports/admin/view/default/template/pages/extension/extensions_edit.tpl')) {
    unlink(DIR_EXT.'advanced_reports/admin/view/default/template/pages/extension/extensions_edit.tpl');
}

if (!file_exists(DIR_SYSTEM.'lib/license.php')) {
    /**
     *  Function to Copy folders and files
     * @param $src
     * @param $dst
     * @return array
     */
    function custom_copy($src, $dst) {
        $error = [];
        // open the source directory
        $dir = opendir($src);
        if (!is_dir($dst)) {
            @mkdir($dst);
        }
        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    // Recursively calling custom copy function
                    // for sub directory
                    custom_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    if (!copy($src . '/' . $file, $dst . '/' . $file)) {
                        $error['error_copy'][] = "Failed to copy $file";
                    }
                }
            }
        }
        if (sizeof($error)>0) {
            $log=new ALog(DIR_SYSTEM.'logs/error.txt');
            $log->write(var_export($error,true));
        }
        closedir($dir);
        return $error;
    }

    $copy = custom_copy(DIR_EXT . 'advanced_reports' . DIR_EXT_CORE . 'lib/license', DIR_SYSTEM.'lib');
}