<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
	header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ModelAdvancedReportsVerify
 */

class ModelAdvancedReportsVerify extends Model {

    public function verifyPricingCalc() {
        if ($this->config->get('pricing_calculator_status')==='1') {
            $this->load->model('extension/pricing_calculator_license_info');
            $license_key = $this->config->get('pricing_calculator_license_code');
            $shared_secret = 'pricing_calculator';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('pricing_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_pricing_calculator_license_info->getStoreId();
                    $license_key = $this->model_extension_pricing_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_pricing_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_pricing_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyAreaCalculator() {
        if ($this->config->get('area_calculator_status')==='1') {
            $this->load->model('extension/area_calculator_license_info');
            $license_key = $this->config->get('area_calculator_license_code');
            $shared_secret = 'area_calculator';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('area_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_area_calculator_license_info->getStoreId();
                    $license_key = $this->model_extension_area_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_area_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_area_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyLengthCalculator() {
        if ($this->config->get('length_calculator_status')==='1') {
            $this->load->model('extension/length_calculator_license_info');
            $license_key = $this->config->get('length_calculator_license_code');
            $shared_secret = 'length_calculator';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('length_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_length_calculator_license_info->getStoreId();
                    $license_key = $this->model_extension_length_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_length_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_length_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyVolumeCalculator() {
        if ($this->config->get('volume_calculator_status')==='1') {
            $this->load->model('extension/volume_calculator_license_info');
            $license_key = $this->config->get('volume_calculator_license_code');
            $shared_secret = 'volume_calculator';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('volume_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_volume_calculator_license_info->getStoreId();
                    $license_key = $this->model_extension_volume_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_volume_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_volume_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyWeightCalculator() {
        if ($this->config->get('weight_calculator_status')==='1') {
            $this->load->model('extension/weight_calculator_license_info');
            $license_key = $this->config->get('weight_calculator_license_code');
            $shared_secret = 'weight_calculator';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('weight_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_weight_calculator_license_info->getStoreId();
                    $license_key = $this->model_extension_weight_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_weight_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_weight_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyLiquidsCalculator() {
        if ($this->config->get('liquids_calculator_status')==='1') {
            $this->load->model('extension/liquids_calculator_license_info');
            $license_key = $this->config->get('liquids_calculator_license_code');
            $shared_secret = 'liquids_calculator';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('liquids_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_liquids_calculator_license_info->getStoreId();
                    $license_key = $this->model_extension_liquids_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_liquids_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_liquids_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyTaxID() {
        if ($this->config->get('taxid_option_status')==='1') {
            $this->load->model('extension/taxid_option_license_info');
            $license_key = $this->config->get('taxid_option_license_code');
            $shared_secret = 'taxid_option';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('taxid_option_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_taxid_option_license_info->getStoreId();
                    $license_key = $this->model_extension_taxid_option_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_taxid_option_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_taxid_option_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyTelephone() {
        if ($this->config->get('telephone_option_status')==='1') {
            $this->load->model('extension/telephone_option_license_info');
            $license_key = $this->config->get('telephone_option_license_code');
            $shared_secret = 'telephone_option';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('telephone_option_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_telephone_option_license_info->getStoreId();
                    $license_key = $this->model_extension_telephone_option_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_telephone_option_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_telephone_option_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyOptionLink() {
        if ($this->config->get('option_price_link_pro_status')==='1') {
            $this->load->model('extension/option_price_link_pro_license_info');
            $license_key = $this->config->get('option_price_link_pro_license_code');
            $shared_secret = 'option_price_link_pro';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('option_price_link_pro_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_option_price_link_pro_license_info->getStoreId();
                    $license_key = $this->model_extension_option_price_link_pro_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_option_price_link_pro_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_option_price_link_pro_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyOptionPro() {
        if ($this->config->get('option_price_pro_status')==='1') {
            $this->load->model('extension/option_price_pro_license_info');
            $license_key = $this->config->get('option_price_pro_license_code');
            $shared_secret = 'option_price_pro';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('option_price_pro_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_option_price_pro_license_info->getStoreId();
                    $license_key = $this->model_extension_option_price_pro_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_option_price_pro_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_option_price_pro_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyOptionLite() {
        if ($this->config->get('option_price_status')==='1') {
            $this->load->model('extension/option_price_license_info');
            $license_key = $this->config->get('option_price_license_code');
            $shared_secret = 'option_price';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('option_price_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_option_price_license_info->getStoreId();
                    $license_key = $this->model_extension_option_price_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_option_price_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_option_price_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyUpsPlus() {
        if ($this->config->get('ups_integration_plus_status')==='1') {
            $this->load->model('extension/ups_integration_license_info');
            $license_key = $this->config->get('ups_integration_license_code');
            $shared_secret = 'ups_integration_plus';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('ups_integration_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_ups_integration_license_info->getStoreId();
                    $license_key = $this->model_extension_ups_integration_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_ups_integration_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_ups_integration_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyAuspost() {
        if ($this->config->get('auspost_integration_status')==='1') {
            $this->load->model('extension/auspost_integration_license_info');
            $license_key = $this->config->get('auspost_integration_license_code');
            $shared_secret = 'auspost_integration';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('auspost_integration_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_auspost_integration_license_info->getStoreId();
                    $license_key = $this->model_extension_auspost_integration_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_auspost_integration_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_auspost_integration_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyCanpost() {
        if ($this->config->get('canadapost_integration_status')==='1') {
            $this->load->model('extension/canpost_integration_license_info');
            $license_key = $this->config->get('canadapost_integration_license_code');
            $shared_secret = 'canadapost_integration';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('canpost_integration_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_canpost_integration_license_info->getStoreId();
                    $license_key = $this->model_extension_canpost_integration_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_canpost_integration_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_canpost_integration_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyMailchimp() {
        if ($this->config->get('integration_mailchimp_status')==='1') {
            $this->load->model('extension/integration_mailchimp_license_info');
            $license_key = $this->config->get('integration_mailchimp_license_code');
            $shared_secret = 'integration_mailchimp';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('integration_mailchimp_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_integration_mailchimp_license_info->getStoreId();
                    $license_key = $this->model_extension_integration_mailchimp_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_integration_mailchimp_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_integration_mailchimp_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyMailchimpPlus() {
        if ($this->config->get('integration_mailchimp_plus_status')==='1') {
            $this->load->model('extension/integration_mailchimp_plus_license_info');
            $license_key = $this->config->get('integration_mailchimp_plus_license_code');
            $shared_secret = 'integration_mailchimp_plus';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('integration_mailchimp_plus_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_integration_mailchimp_plus_license_info->getStoreId();
                    $license_key = $this->model_extension_integration_mailchimp_plus_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_integration_mailchimp_plus_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_integration_mailchimp_plus_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyCtct() {
        if ($this->config->get('constantcontact_integration_status')==='1') {
            $this->load->model('extension/constantcontact_integration_license_info');
            $license_key = $this->config->get('constantcontact_integration_license_code');
            $shared_secret = 'constantcontact_integration';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('constantcontact_integration_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_constantcontact_integration_license_info->getStoreId();
                    $license_key = $this->model_extension_constantcontact_integration_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_constantcontact_integration_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_constantcontact_integration_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyBuildAGift() {
        if ($this->config->get('build_a_gift_status')==='1') {
            $this->load->model('extension/build_a_gift_license_info');
            $license_key = $this->config->get('build_a_gift_license_code');
            $shared_secret = 'build_a_gift';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('build_a_gift_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_build_a_gift_license_info->getStoreId();
                    $license_key = $this->model_extension_build_a_gift_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_build_a_gift_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_build_a_gift_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyReorder() {
        if ($this->config->get('reorder_status')==='1') {
            $this->load->model('extension/reorder_license_info');
            $license_key = $this->config->get('reorder_license_code');
            $shared_secret = 'reorder';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('reorder_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_reorder_license_info->getStoreId();
                    $license_key = $this->model_extension_reorder_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_reorder_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_reorder_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }
    
}