<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ModelAdvancedReportsOrder
 * @property ModelAdvancedReportsProductCoupon $model_advanced_reports_product_coupon
 * @property ModelAdvancedReportsVerify $model_advanced_reports_verify
 * @property ModelCatalogProduct $model_catalog_product
 */

class ModelAdvancedReportsOrder extends Model {

    /**
     * @param string $data
     * @param $order_id
     * @throws AException
     */
    public function updateOrder($data,$order_id) {
        $this->db->query("UPDATE " . $this->db->table("order_products") . " op INNER JOIN " . $this->db->table("products") . " p ON (p.product_id=op.product_id) SET op.cost=p.cost WHERE order_id=" . (int)$order_id);
        $this->db->query("UPDATE " . $this->db->table("order_options") . " oo INNER JOIN " . $this->db->table("product_option_values") . " pov ON (pov.product_option_value_id=oo.product_option_value_id) SET oo.cost=pov.cost WHERE oo.order_id=" . (int)$order_id);
        if ($data) {
            if ($order_id != 0) {
                $this->deleteInfo($order_id);
                foreach ($data['products'] as $product) {
                    $order_product_id = $this->getOrderProductId($order_id,$product['total']);
                    $discount = is_null($product['discount']) ? 0 : $product['discount'];
                    $product_coupon = is_null($product['product_coupon']) ? "" : $product['product_coupon'];
                    $certain_product = is_null($product['certain_product']) ? "" : $product['certain_product'];
                    $this->db->query("UPDATE " . $this->db->table("order_products") . " SET discount=" . $discount . ",
                                      product_coupon='" . $product_coupon . "',certain_product='" . $certain_product . "'
                                      WHERE product_id=" . (int)$product['product_id'] . " AND order_id=" . (int)$order_id . " AND `total`=" . round($product['total'], 2));

                    $promotion = new APromotion();
                    $discount = $promotion->getProductDiscount($product['product_id']);
                    $special = $promotion->getProductSpecial($product['product_id']);
                    $product_info = $this->model_catalog_product->getProduct($product['product_id']);
                    $currency = $this->currency->getCurrency();
                    $decimal_place = (int)$currency['decimal_place'];
                    $decimal_place = !$decimal_place ? 2 : $decimal_place;

                    $special_price = 0;
                    $product_price = round($product_info['price'], $decimal_place);

                    if ($discount) {
                        $special_price = round($discount, $decimal_place);
                    } else {
                        if ($special) {
                            $special_price = round($special, $decimal_place);
                        }
                    }

                    $store_id = $this->getStoreId();

                    $this->db->query("INSERT INTO " . $this->db->table("advanced_reports_order_products") . " SET `order_id`=" . (int)$order_id . ",`order_product_id`='".$order_product_id."',`original_price`=" . $product_price
                        . ",`price`=" . $special_price.",`store_id`=".$store_id);
                    if ($product['option']) {
                        foreach ($product['option'] as $option) {
                            $product_option_info = $this->getProductOptionInfo($option['product_option_value_id']);
                            $special_option_price = 0;
                            if ($option['prefix'] == '%') {
                                $option_price = $product_price * $option['price'] / 100;
                                if ($special_price !== 0) {
                                    $special_option_price = $special_price * $option['price'] / 100;
                                }
                            } else {
                                $option_price = $option['price'];
                                if ($special_price !== 0) {
                                    $special_option_price = $option['price'];
                                }
                            }

                            $this->db->query("UPDATE " . $this->db->table("order_options") . " SET `price`=" . $option['price'] . " WHERE product_option_value_id=" . (int)$option['product_option_value_id'] . " AND `order_id`=" . (int)$order_id);
                            $this->db->query("INSERT INTO " . $this->db->table("advanced_reports_order_options") . " SET `order_id`=" . (int)$order_id . ",`order_product_id`='".$order_product_id."',`product_option_value_id`=" . (int)$option['product_option_value_id'] . ",
                                                `option_sort_order`='" . $product_option_info['sort_order'] . "',`is_default`='" . $product_option_info['is_default'] . "',`original_price`=" . $option_price
                                . ",`price`=" . $special_option_price.",`store_id`=".$store_id);
                        }
                    }
                }
            }
        }
    }

     public function getProductOptionInfo($product_option_value_id) {
        $sql = "SELECT po.sort_order as sort_order,pov.default as is_default FROM ". $this->db->table("product_option_values")." pov
               LEFT JOIN ".$this->db->table("product_options")." po ON po.product_option_id = pov.product_option_id
               WHERE pov.product_option_value_id=".(int)$product_option_value_id;
        $query = $this->db->query($sql);
        return $query->row;
     }

     public function getOrderProductId($order_id,$total) {
        $sql = "SELECT order_product_id FROM ".$this->db->table("order_products"). " WHERE `order_id`=".(int)$order_id." AND `total`='".number_format(round($total,4),4)."'";
        $query = $this->db->query($sql);
        return $query->row['order_product_id'];
     }

     public function deleteInfo($order_id) {
        $this->db->query("DELETE FROM ".$this->db->table("advanced_reports_order_products")." WHERE `order_id`=".(int)$order_id);
         $this->db->query("DELETE FROM ".$this->db->table("advanced_reports_order_options")." WHERE `order_id`=".(int)$order_id);
     }

    public function getLinkAndCost($data) {
        $result = $this->db->query("SELECT * FROM ".$this->db->table("product_option_values")." WHERE product_option_value_id=".(int)$data['product_option_value_id']." AND product_id=".(int)$data['product_id']);
        return $result->row;
    }

    public function getProductCost($data) {
        $result = $this->db->query("SELECT cost FROM ".$this->db->table("products")." WHERE product_id=".(int)$data['product_id']);
        return $result->row;
    }

    /**
     * @param $country_id
     * @param $zone_id
     * @param $order_id
     * @return mixed
     */
    public function getTaxesDesc($country_id, $zone_id, $order_id)  {
        $country_id = (int)$country_id;
        $zone_id = (int)$zone_id;
        $results=[];
        $language = $this->registry->get('language');
        $language_id = $language->getLanguageID();
        $default_lang_id = $language->getDefaultLanguageID();
        //Note: Default language text is picked up if no selected language available
        $sql = "SELECT zd.name as zone, l.name as location,tr.rate AS rate, tr.rate_prefix AS rate_prefix,
							COALESCE( NULLIF(trd1.description, ''),
									  NULLIF(td1.description, ''),
									  NULLIF(trd2.description, ''),
									  NULLIF(td2.description, ''),
									  COALESCE( td1.title,td2.title)
							) as description
					FROM " . $this->db->table("tax_rates") . " tr
					LEFT JOIN " . $this->db->table("tax_rate_descriptions") . " trd1 ON
						(tr.tax_rate_id = trd1.tax_rate_id AND trd1.language_id = '" . (int)$language_id . "')
					LEFT JOIN " . $this->db->table("tax_rate_descriptions") . " trd2 ON
						(tr.tax_rate_id = trd2.tax_rate_id AND trd2.language_id = '" . (int)$default_lang_id . "')
					LEFT JOIN " . $this->db->table("tax_classes") . " tc ON tc.tax_class_id = tr.tax_class_id
					LEFT JOIN " . $this->db->table("tax_class_descriptions") . " td1 ON
						(tc.tax_class_id = td1.tax_class_id AND td1.language_id = '" . (int)$language_id . "')
					LEFT JOIN " . $this->db->table("tax_class_descriptions") . " td2 ON
						(tc.tax_class_id = td2.tax_class_id AND td2.language_id = '" . (int)$default_lang_id . "')
					LEFT JOIN " . $this->db->table("zone_descriptions") . " zd ON zd.zone_id=tr.zone_id
                    LEFT JOIN " . $this->db->table("locations") . " l ON l.location_id=tr.location_id
					WHERE (tr.zone_id = '0' OR tr.zone_id = '" . $zone_id . "')
						AND tr.location_id in (SELECT z2l.location_id
											   FROM " . $this->db->table("zones_to_locations") . " z2l, " . $this->db->table("locations") . " l
											   WHERE z2l.location_id = l.location_id and z2l.zone_id = '" . $zone_id . "')
					ORDER BY tr.priority ASC";
        $tax_rate_query = $this->db->query($sql);
        $res = $tax_rate_query->rows;

        if ($res) {
            foreach ($res as $k => $v) {
                $row['id'] = $order_id;

                $query_subtotal = $this->db->query("SELECT ot.value as `total` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE TRIM(ot.order_id) = '" . $order_id . "' AND ot.type='subtotal'");

                $row['total'] = $query_subtotal->row['total'];

                /*Get not taxable sales*/
                $not_tax = $this->db->query("SELECT SUM(IFNULL((op.price * op.quantity), 0)) as `non_taxable_sales` FROM " . $this->db->table("order_products") . " op
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = op.order_id
					 WHERE TRIM(op.order_id) = '" . $order_id . "' AND op.tax=0.0000");
                 $row['non_taxable_sales'] = $not_tax->row['non_taxable_sales'];


                $taxable = $this->db->query("SELECT SUM(IFNULL((op.price * op.quantity), 0)) as `taxable_sales` FROM " . $this->db->table("order_products") . " op
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = op.order_id
					 WHERE TRIM(op.order_id) = '" . $order_id . "' AND op.tax!=0.0000");

                $row['taxable_sales'] = $taxable->row['taxable_sales'];

                $sql = $this->db->query("SELECT ot.value as `tax` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE TRIM(ot.order_id) = '" . $order_id . "' AND ot.type='tax' AND ot.title='" . $v['description'] . ":'");

                $row['tax_charged'] = $sql->row['tax'];

                if ($v['rate_prefix'] == '%') {
                    $row['tax_rate'] = round((float)$v['rate'], 2) . $v['rate_prefix'];
                } else {
                    $row['tax_rate'] = $v['rate_prefix'] . round((float)$v['rate'], 2);
                }

                $row['location'] = $v['location'];
                $row['zone'] = $v['zone'];
                $row['description'] = $v['description'];
                $results[] = $row;
            }
        } else {
            $row['id'] = $order_id;

            $query_subtotal = $this->db->query("SELECT ot.value as `total` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE TRIM(ot.order_id) = '" . $order_id . "' AND ot.type='subtotal'");
            $row['total'] = $query_subtotal->row['total'];

            /*Get not taxable sales*/
            $not_tax = $this->db->query("SELECT SUM(IFNULL((op.price * op.quantity), 0)) as `non_taxable_sales` FROM " . $this->db->table("order_products") . " op
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = op.order_id
					 WHERE TRIM(op.order_id) = '" . $order_id . "' AND op.tax=0.0000");
            $row['non_taxable_sales'] = $not_tax->row['non_taxable_sales'];

            $taxable = $this->db->query("SELECT SUM(IFNULL((op.price * op.quantity), 0)) as `taxable_sales` FROM " . $this->db->table("order_products") . " op
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = op.order_id
					 WHERE TRIM(op.order_id) = '" . $order_id . "' AND op.tax!=0.0000");

            $row['taxable_sales'] = $taxable->row['taxable_sales'];

            $row['tax_charged'] = 0;

            $row['tax_rate'] ='';
            $row['location'] = '';
            $row['zone'] = '';
            $row['description'] = '';
            $results[] = $row;
        }
        return $results;
    }

    /**
     * @param $order_id
     * @param $data
     * @param $skip
     * @param string $tax_exempt
     */
    public function saveTax($order_id, $data, $skip, $tax_exempt)  {
        $store_id = $this->getStoreId();
        if ($order_id !==0) {
            if ($order_id !== 0) {
                if ($tax_exempt == '1') {
                    $exist = $this->db->query("SELECT order_id FROM " . $this->db->table("adv_reports_tax") . " WHERE order_id='" . $order_id . "'");
                } else {
                    $exist = $this->db->query("SELECT order_id,description FROM " . $this->db->table("adv_reports_tax") . " WHERE order_id='" . $order_id . "' AND description='" . $this->db->escape($data['description']) . "'");
                }
                $res = $exist->row;
                if ($exist->num_rows > 0) {
                    if ($tax_exempt == '1') {
                        $this->db->query("UPDATE " . $this->db->table("adv_reports_tax") . "
								SET date_added = NOW(),
									total = '" . $data[0]['total'] . "',
									tax_exempt = '" . $data[0]['total'] . "',
									location = '" . $this->db->escape($data[0]['location']) . "',
									zone = '" . $this->db->escape($data[0]['zone']) . "'
									WHERE order_id='" . $res['order_id'] . "'");
                    } else {
                        if ($skip == '1') {
                            $this->db->query("UPDATE " . $this->db->table("adv_reports_tax") . "
								SET date_added = NOW(),
									tax_charged = '" . $data['tax_charged'] . "',
									tax_rate = '" . $this->db->escape($data['tax_rate']) . "',
									location = '" . $this->db->escape($data['location']) . "',
									zone = '" . $this->db->escape($data['zone']) . "',
									description = '" . $this->db->escape($data['description']) . "' WHERE order_id='" . $res['order_id'] . "' AND description='" . $res['description'] . "'");
                        } else {
                            $this->db->query("UPDATE " . $this->db->table("adv_reports_tax") . "
								SET date_added = NOW(),
									total = '" . $data['total'] . "',
									non_taxable_sales = '" . $data['non_taxable_sales'] . "',
									taxable_sales = '" . $data['taxable_sales'] . "',
									tax_charged = '" . $data['tax_charged'] . "',
									tax_rate = '" . $this->db->escape($data['tax_rate']) . "',
									location = '" . $this->db->escape($data['location']) . "',
									zone = '" . $this->db->escape($data['zone']) . "',
									description = '" . $this->db->escape($data['description']) . "' WHERE order_id='" . $res['order_id'] . "' AND description='" . $res['description'] . "'");
                        }
                    }
                } else {
                    if ($tax_exempt == '1') {
                        $this->db->query("INSERT INTO " . $this->db->table("adv_reports_tax") . "
								SET date_added = NOW(),
								    order_id = '" . (int)$order_id . "',
									total = '" . $data[0]['total'] . "',
									tax_exempt = '" . $data[0]['total'] . "',
									location = '" . $this->db->escape($data[0]['location']) . "',
									zone = '" . $this->db->escape($data[0]['zone']) . "',
									store_id=".$store_id);
                    } else {
                        if ($skip == '1') {
                            $this->db->query("INSERT INTO " . $this->db->table("adv_reports_tax") . "
								SET date_added = NOW(),
								    order_id = '" . (int)$order_id . "',
									tax_charged = '" . $data['tax_charged'] . "',
									tax_rate = '" . $this->db->escape($data['tax_rate']) . "',
									location = '" . $this->db->escape($data['location']) . "',
									zone = '" . $this->db->escape($data['zone']) . "',
									description = '" . $this->db->escape($data['description']) . "',
									store_id=".$store_id);
                        } else {
                            $this->db->query("INSERT INTO " . $this->db->table("adv_reports_tax") . "
								SET date_added = NOW(),
								    order_id = '" . (int)$order_id . "',
									total = '" . $data['total'] . "',
									non_taxable_sales = '" . $data['non_taxable_sales'] . "',
									tax_exempt = '',
									taxable_sales = '" . $data['taxable_sales'] . "',
									tax_charged = '" . $data['tax_charged'] . "',
									tax_rate = '" . $this->db->escape($data['tax_rate']) . "',
									location = '" . $this->db->escape($data['location']) . "',
									zone = '" . $this->db->escape($data['zone']) . "',
									description = '" . $this->db->escape($data['description']) . "',
									store_id=".$store_id);
                        }
                    }
                }
            }
        }
    }

    public function getStoreId() {
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
}