<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if (!defined('DIR_CORE')) {
	header('Location: static_pages/');
}

/**
 * Class ModelAdvancedReportsCoupon
 * @property ModelAdvancedReportsProductCoupon $model_advanced_reports_product_coupon
 * @property ModelAdvancedReportsVerify $model_advanced_reports_verify
 */

class ModelAdvancedReportsCoupon extends Model {
    /**
     * @param $product_id
     * @param $product_key
     * @param $product_total
     * @param $cust_data
     * @return float|int|mixed
     */
	public function getDiscount($product_id,$product_key,$product_total,$final_discount,&$cust_data) {
        $coupons = $cust_data['coupon'];
        $this->load->model('advanced_reports/verify');
        $cart = $this->cart;
        if (isset($coupons) && $this->config->get('coupon_status')) {
            $promotion = new APromotion();
            $coupon = $promotion->getCouponData($coupons);
            if (!$coupon['product']) {
                $coupon_total = $cart->getSubTotal();
            } else {
                $coupon_total = 0;

                foreach ($cart->getProducts() as $product) {
                    if (in_array($product['product_id'], $coupon['product'])) {
                        $coupon_total += $product['total'];
                    }
                }
            }

            if ($coupon['type'] == 'F') {
                $coupon['discount'] = min($coupon['discount'], $coupon_total);
            }

            $discount = 0;
            $ship_cost = 0;
            $product_coupon = [];
            if (!$coupon['product']) {
                $status = true;
                $certain_product = '0';
            } else {
                if (in_array($product_id, $coupon['product'])) {
                    $product_coupon[] = $product_id;
                    $status = true;
                    $certain_product = '1';
                } else {
                    $certain_product = '0';
                    $status = false;
                }
            }

            $ship_data = $cust_data['shipping_method'];

            if ($coupon['shipping'] && isset($ship_data)) {
                $ship_cost = $ship_data['cost'];
            }

            if ($status) {
                $discount = round($final_discount * ($product_total / $coupon_total), 4);
            }
            if ($product_key) {
                $row = [$product_key=>['discount' => $discount, 'shipping' => $ship_cost, 'product_coupon' => $product_coupon, 'certain_product' => $certain_product]];
            } else {
                $row = ['discount' => $discount, 'shipping' => $ship_cost, 'product_coupon' => $product_coupon, 'certain_product' => $certain_product];
            }

            return $row;
        }
    }
}
