<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
header('Location: static_pages/');
}

if(!class_exists('ExtensionAdvancedReports')){
    include_once('core/advanced_reports_hook.php');
}
$controllers = [
    'storefront' => [],
    'admin' => [
        'pages/advanced_reports/category',
        'pages/advanced_reports/customer',
        'pages/advanced_reports/customer_city',
        'pages/advanced_reports/customer_company',
        'pages/advanced_reports/customer_country',
        'pages/advanced_reports/customer_group',
        'pages/advanced_reports/guest',
        'pages/advanced_reports/guest_city',
        'pages/advanced_reports/guest_country',
        'pages/advanced_reports/guest_company',
        'pages/advanced_reports/guest_group',
        'pages/advanced_reports/earnings',
        'pages/advanced_reports/product',
        'pages/advanced_reports/product_bestseller',
        'pages/advanced_reports/product_inventory',
        'pages/advanced_reports/product_special',
        'pages/advanced_reports/profit',
        'pages/advanced_reports/report_product',
        'pages/advanced_reports/sale_country',
        'pages/advanced_reports/sale_coupon',
        'pages/advanced_reports/sale_day_week',
        'pages/advanced_reports/sale_hour',
        'pages/advanced_reports/sale_manufacturer',
        'pages/advanced_reports/sale_order',
        'pages/advanced_reports/sale_payment',
        'pages/advanced_reports/sale_profit',
        'pages/advanced_reports/sale_profit_build_a_gift',
        'pages/advanced_reports/sale_state',
        'pages/advanced_reports/sale_statistics',
        'pages/advanced_reports/sale_zipcode',
        'pages/advanced_reports/top_customer',
        'pages/advanced_reports/top_guest',
        'pages/advanced_reports/user_activity',
        'pages/advanced_reports/tax',
        'pages/advanced_reports/advanced_reports',
        'pages/extension/advanced_reports_updater',
        'responses/advanced_reports/advanced_reports_save',
        'responses/advanced_reports/autocomplete',
        'responses/advanced_reports/chart',
        'responses/advanced_reports/settings']];

$models = [
    'storefront' => [
        'advanced_reports/coupon',
        'advanced_reports/order',
        'advanced_reports/verify',
        'extension/advanced_reports_license_info'
        ],
    'admin' => [
        'advanced_reports/coupon',
        'advanced_reports/product',
        'advanced_reports/tax',
        'advanced_reports/sale',
        'advanced_reports/guest',
        'advanced_reports/category',
        'advanced_reports/customer',
        'advanced_reports/chart',
        'advanced_reports/product_options',
        'advanced_reports/sale_order',
	    'advanced_reports/verify',
        'extension/advanced_reports_updater',
        'extension/advanced_reports_license_info']];

$templates = [
    'storefront' => [],
    'admin' => [
        'pages/advanced_reports/customer_city.tpl',
        'pages/advanced_reports/customer_company.tpl',
        'pages/advanced_reports/customer_country.tpl',
        'pages/advanced_reports/customer_group.tpl',
        'pages/advanced_reports/customer_report.tpl',
        'pages/advanced_reports/guest_group.tpl',
        'pages/advanced_reports/guest_company.tpl',
        'pages/advanced_reports/guest_report.tpl',
        'pages/advanced_reports/guest_city.tpl',
        'pages/advanced_reports/guest_country.tpl',
        'pages/advanced_reports/earnings.tpl',
        'pages/advanced_reports/product_bestseller.tpl',
        'pages/advanced_reports/product_inventory.tpl',
        'pages/advanced_reports/product_orders.tpl',
        'pages/advanced_reports/product_purchased.tpl',
        'pages/advanced_reports/product_special.tpl',
        'pages/advanced_reports/profit.tpl',
        'pages/advanced_reports/report_product.tpl',
        'pages/advanced_reports/sale_category.tpl',
        'pages/advanced_reports/sale_country.tpl',
        'pages/advanced_reports/sale_coupon.tpl',
        'pages/advanced_reports/sale_day_week.tpl',
        'pages/advanced_reports/sale_hour.tpl',
        'pages/advanced_reports/sale_manufacturer.tpl',
        'pages/advanced_reports/sale_order.tpl',
        'pages/advanced_reports/sale_payment.tpl',
        'pages/advanced_reports/sale_profit.tpl',
        'pages/advanced_reports/sale_profit_build_a_gift.tpl',
        'pages/advanced_reports/sale_state.tpl',
        'pages/advanced_reports/sale_statistics.tpl',
        'pages/advanced_reports/sale_zipcode.tpl',
        'pages/advanced_reports/tax_country.tpl',
        'pages/advanced_reports/tax.tpl',
        'pages/advanced_reports/top_customer.tpl',
        'pages/advanced_reports/top_guest.tpl',
        'pages/advanced_reports/user_activity.tpl',
        'pages/advanced_reports/advanced_reports.tpl',
        'pages/extension/product_tabs.tpl',
        'pages/extension/advanced_reports_updater.tpl',
        'pages/extension/advanced_reports_manual.tpl',
        'pages/extension/extension_summary_button.tpl',
        'pages/extension/extensions.post.tpl',
        'responses/product/report_option_value_row_additional.tpl',
        'pages/extension/extensions_edit.post.tpl',
        ]];

$languages = [
    'storefront' => [],
    'admin' => [
        'advanced_reports/advanced_reports']];