<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

$check2= "SHOW columns from ".$this->db->table('order_products')." where field='discount'";
$q2=$this->db->query($check2);
$exist2=count($q2->rows);
if ($exist2==0) {
    $sql2 = "ALTER TABLE ".$this->db->table('order_products')." ADD `discount` DECIMAL(15,2) NOT NULL AFTER `cost`";
    $this->db->query($sql2);
}

$check3= "SHOW columns from ".$this->db->table('order_products')." where field='product_coupon'";
$q3=$this->db->query($check3);
$exist3=count($q3->rows);
if ($exist3==0) {
    $sql3 = "ALTER TABLE ".$this->db->table('order_products')." ADD `product_coupon` CHAR(1) NOT NULL AFTER `discount`";
    $this->db->query($sql3);
}

$check4= "SHOW columns from ".$this->db->table('order_products')." where field='certain_product'";
$q4=$this->db->query($check4);
$exist4=count($q4->rows);
if ($exist4==0) {
    $sql4 = "ALTER TABLE ".$this->db->table('order_products')." ADD `certain_product` CHAR(1) NOT NULL AFTER `product_coupon`";
    $this->db->query($sql4);
}

 $this->cache->remove('lang');

$sql7 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("advanced_reports_updater_notification") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL,
  `cart_version` VARCHAR(10),
  `extension_version` VARCHAR(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql7);
$sql8 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("advanced_reports_license_info") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `public_key` TEXT NOT NULL,
  `license_data` TEXT NOT NULL,
  `license_key` TEXT NOT NULL,
  `store_id` int(11) NOT NULL,
  `last_check` int(11),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql8);

$table="CREATE TABLE IF NOT EXISTS ".$this->db->table('adv_reports_tax')."(
  `tax_id` int(11) NOT NULL AUTO_INCREMENT,
  `date_added` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `order_id` int(11) NULL DEFAULT '0',
  `total` decimal(15,4) NULL DEFAULT '0.0000',
  `non_taxable_sales` decimal(15,4) NULL DEFAULT '0.0000',
  `tax_exempt` decimal(15,4) NULL DEFAULT '0.0000',
  `taxable_sales` decimal(15,4) NULL DEFAULT '0.0000',
  `tax_charged` decimal(15,4) NULL DEFAULT '0.0000',
  `tax_rate` varchar(10) COLLATE utf8_general_ci NULL DEFAULT '',
  `location` varchar(128) COLLATE utf8_general_ci NULL,
  `zone` varchar(128) COLLATE utf8_general_ci NULL,
  `description` varchar(128) COLLATE utf8_general_ci NULL,
  `store_id` int(11),
  PRIMARY KEY (`tax_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;";

$this->db->query($table);

$table2="CREATE TABLE IF NOT EXISTS ".$this->db->table('advanced_reports_order_products')."(
  `advanced_reports_order_product_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NULL DEFAULT '0',
  `order_product_id` int(11) NULL DEFAULT '0',
  `product_id` int(11) NOT NULL,
  `original_price` decimal(15,4) NULL DEFAULT '0.0000',
  `price` decimal(15,4) NULL DEFAULT '0.0000',
  `store_id` int(11),
  PRIMARY KEY (`advanced_reports_order_product_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;";

$this->db->query($table2);

$table3="CREATE TABLE IF NOT EXISTS ".$this->db->table('advanced_reports_order_options')."(
  `advanced_reports_order_options_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NULL DEFAULT '0',
  `order_product_id` int(11) NULL DEFAULT '0',
  `product_option_value_id` int(11) NOT NULL DEFAULT '0',
  `option_sort_order` int(3) NOT NULL DEFAULT '0',
  `is_default` char(1) NOT NULL DEFAULT '',
  `original_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `store_id` int(11),
  PRIMARY KEY (`advanced_reports_order_options_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;";

$this->db->query($table3);

$language_id = $this->language->getContentLanguageID();
$rm = new AResourceManager();
$rm->setType('image');
$data = [];
$data['resource_code'] = '<i class="fa fa-bar-chart-o"></i>&nbsp;';
$data['name'] = [$language_id => 'Menu Icon Advanced Report'];
$data['title'] = [$language_id => ''];
$data['description'] = [$language_id => ''];
$resource_id = $rm->addResource($data);

$menu = new AMenu ( "admin" );
$data = [];

$menu->insertMenuItem ([  "item_id" => "advanced_reports",
        "parent_id"=>"",
        "item_text" => "Advanced Reports",
        "item_url" => "",
        "item_icon_rl_id" => $resource_id,
        "item_type"=>"core",
        "sort_order"=>"8"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_settings",
        "parent_id"=>"advanced_reports",
        "item_text" => "Settings",
        "item_url" => "advanced_reports/advanced_reports",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"219"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced",
        "parent_id"=>"advanced_reports",
        "item_text" => "Sales",
        "item_url" => "",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"220"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_sales",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales",
        "item_url" => "advanced_reports/sale_order",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"221"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_sales_profit",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales Profit",
        "item_url" => "advanced_reports/sale_profit",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"222"]
);

if ($this->config->get("build_a_gift_status")) {
    if (!$menu->getMenuItem('advanced_reports_advanced_sale_profit_build_a_gift')) {
        $menu->insertMenuItem(["item_id" => "advanced_reports_advanced_sale_profit_build_a_gift",
                "parent_id" => "advanced_reports_advanced",
                "item_text" => "Sales Profit - Build A Gift",
                "item_url" => "advanced_reports/sale_profit_build_a_gift",
                "item_icon_rl_id" => '',
                "item_type" => "core",
                "sort_order" => "223"]
        );
    }
}

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_sales_statistics",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales Statistics",
        "item_url" => "advanced_reports/sale_statistics",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"224"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_sales_by_customer_group",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Customer Group",
        "item_url" => "advanced_reports/customer_group",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"225"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_sales_by_customer_company",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Customer Company",
        "item_url" => "advanced_reports/customer_company",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"226"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_customer_reports",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Customer Reports",
        "item_url" => "advanced_reports/customer",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"227"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_sales_by_guest_group",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Guest Group",
        "item_url" => "advanced_reports/guest_group",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"228"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_sales_by_guest_company",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Guest Company",
        "item_url" => "advanced_reports/guest_company",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"229"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_guest_reports",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Guest Reports",
        "item_url" => "advanced_reports/guest",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"230"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_sales_by_country",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Country",
        "item_url" => "advanced_reports/sale_country",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"231"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_sales_by_hour",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Hour",
        "item_url" => "advanced_reports/sale_hour",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"232"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_sales_by_day_of_week",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Day Of Week",
        "item_url" => "advanced_reports/sale_day_week",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"233"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_users_activity_report",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Users Activity Report",
        "item_url" => "advanced_reports/user_activity",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"234"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_sales_by_product",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Product",
        "item_url" => "advanced_reports/product",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"235"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_sales_by_category",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Category",
        "item_url" => "advanced_reports/category",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"236"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_sales_by_manufacturer",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Manufacturer",
        "item_url" => "advanced_reports/sale_manufacturer",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"237"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_sales_by_coupon_code",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Coupon Code",
        "item_url" => "advanced_reports/sale_coupon",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"238"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_sales_by_payment_type",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Payment Type",
        "item_url" => "advanced_reports/sale_payment",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"239"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_sales_by_region_or_state",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Region Or State",
        "item_url" => "advanced_reports/sale_state",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"240"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_advanced_sales_by_zip",
        "parent_id"=>"advanced_reports_advanced",
        "item_text" => "Sales By Zip Code",
        "item_url" => "advanced_reports/sale_zipcode",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"241"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_products",
        "parent_id"=>"advanced_reports",
        "item_text" => "Products",
        "item_url" => "",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"242"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_products_product_report",
        "parent_id"=>"advanced_reports_products",
        "item_text" => "Product Report",
        "item_url" => "advanced_reports/report_product",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"243"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_products_inventory_report",
        "parent_id"=>"advanced_reports_products",
        "item_text" => "Inventory Report",
        "item_url" => "advanced_reports/product_inventory",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"244"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_products_bestsellers",
        "parent_id"=>"advanced_reports_products",
        "item_text" => "Bestsellers",
        "item_url" => "advanced_reports/product_bestseller",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"245"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_products_special_shipping",
        "parent_id"=>"advanced_reports_products",
        "item_text" => "Special Shipping",
        "item_url" => "advanced_reports/product_special",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"246"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_customers",
        "parent_id"=>"advanced_reports",
        "item_text" => "Customers",
        "item_url" => "",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"247"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_top_customers",
        "parent_id"=>"advanced_reports_customers",
        "item_text" => "Top Customers",
        "item_url" => "advanced_reports/top_customer",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"248"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_customers_by_city",
        "parent_id"=>"advanced_reports_customers",
        "item_text" => "Customers By City",
        "item_url" => "advanced_reports/customer_city",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"249"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_customers_by_country",
        "parent_id"=>"advanced_reports_customers",
        "item_text" => "Customers By Country",
        "item_url" => "advanced_reports/customer_country",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"250"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_guest",
        "parent_id"=>"advanced_reports",
        "item_text" => "Guest",
        "item_url" => "",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"251"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_top_guest",
        "parent_id"=>"advanced_reports_guest",
        "item_text" => "Top Guest",
        "item_url" => "advanced_reports/top_guest",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"252"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_guest_by_city",
        "parent_id"=>"advanced_reports_guest",
        "item_text" => "Guest By City",
        "item_url" => "advanced_reports/guest_city",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"253"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_guest_by_country",
        "parent_id"=>"advanced_reports_guest",
        "item_text" => "Guest By Country",
        "item_url" => "advanced_reports/guest_country",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"254"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_earnings",
        "parent_id"=>"advanced_reports",
        "item_text" => "Earnings",
        "item_url" => "advanced_reports/earnings&current=1",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"255"]
);

$menu->insertMenuItem ([  "item_id" => "advanced_reports_profit",
        "parent_id"=>"advanced_reports",
        "item_text" => "Profit",
        "item_url" => "advanced_reports/profit",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"256"]
);
$menu->insertMenuItem ([  "item_id" => "advanced_reports_tax",
        "parent_id"=>"advanced_reports",
        "item_text" => "Tax",
        "item_url" => "advanced_reports/tax",
        "item_icon_rl_id" => '',
        "item_type"=>"core",
        "sort_order"=>"257"]
);

$dataset="INSERT INTO ".$this->db->table('settings')." (`group`, `key`, `value`) VALUES
  ('advanced_reports','advanced_reports_chart_width', '600'),
  ('advanced_reports','advanced_reports_chart_height', '400'),
  ('advanced_reports','advance_reports_report_limit', ''),
  ('advanced_reports','advance_reports_number_low_stock', '10'),
  ('advanced_reports','advance_reports_export_pdf_paper', 'letter'),
  ('advanced_reports','advance_reports_export_pdf_orientation', 'P'),
  ('advanced_reports','advance_reports_sales_tab', '1'),
  ('advanced_reports','advanced_reports_product_sales_tab', '1'),
  ('advanced_reports','advance_reports_report_caching', '1');";
$this->db->query($dataset);


$table2="CREATE TABLE IF NOT EXISTS ".$this->db->table('adv_reports_chart')."(
  `chart_id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(64) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `value` mediumtext COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`chart_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci AUTO_INCREMENT=1;";

$this->db->query($table2);


if (!file_exists(DIR_SYSTEM.'lib/license.php')) {
    /**
     *  Function to Copy folders and files
     * @param $src
     * @param $dst
     * @return array
     */
    function custom_copy($src, $dst) {
        $error = array();
        // open the source directory
        $dir = opendir($src);
        if (!is_dir($dst)) {
            @mkdir($dst);
        }
        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    // Recursively calling custom copy function
                    // for sub directory
                    custom_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    if (!copy($src . '/' . $file, $dst . '/' . $file)) {
                        $error['error_copy'][] = "Failed to copy $file";
                    }
                }
            }
        }
        if (sizeof($error)>0) {
            $log=new ALog(DIR_SYSTEM.'logs/error.txt');
            $log->write(var_export($error,true));
        }
        closedir($dir);
        return $error;
    }

    $copy = custom_copy(DIR_EXT . 'advanced_reports' . DIR_EXT_CORE . 'lib/license', DIR_SYSTEM.'lib');
}