<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
require_once(DIR_EXT."advanced_reports".DIR_EXT_CORE."lib/exports/report_format_base.php");
require_once(DIR_EXT."advanced_reports".DIR_EXT_CORE."lib/exports/html_export.php");
require_once(DIR_EXT."advanced_reports".DIR_EXT_CORE."lib/exports/vendor/autoload.php");

use Dompdf\Dompdf;
class PdfExport extends ReportFormatBase {
	public static function display($report, $requests=array()) {

		$file_name = preg_replace(array('/[\s]+/','/[^0-9a-zA-Z\-_\.]/'),array('_',''),$report['name']);

		$content_html = isset($requests['content_html'])?$requests['content_html']:"";

		if(isset($report['data']) && $report['data'] && $content_html ) {
			@ini_set("memory_limit","512M");
			$content_html = stripslashes($content_html);
            $pdf=new Dompdf();
            $pdf->add_info('Title',$file_name. ' reports');
            $pdf->add_info('Subject','Advanced Reports');
            $pdf->add_info('Author','Advanced Reports');
            $pdf->set_option('isRemoteEnabled',true);
            $pdf->loadHtml($content_html);
            $pdf->setPaper($report["paper"],$report["orientation"]);
            $pdf->render();
            $pdf->stream($file_name);

            //Close and output PDF document
            $pdf->output();
		}
		exit(0);
	}
}