<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
require_once(DIR_EXT."advanced_reports".DIR_EXT_CORE."lib/exports/report_format_base.php");
require_once(DIR_EXT."advanced_reports".DIR_EXT_CORE."lib/exports/vendor/autoload.php");

use PhpOffice\PhpSpreadsheet\Spreadsheet;


class ExcelExport extends ReportFormatBase {

    public static function display($report, $requests=array()) {
        $config=new AConfig(Registry::getInstance());
        $file_name = $report['name'];
        set_time_limit(0);
        if(isset($report['data']) && $report['data']) {
            try {
                $spreadsheet = new Spreadsheet();
                $sheet = $spreadsheet->getActiveSheet();
                $spreadsheet->getProperties()->setCreator('AbanteCart')
                    ->setLastModifiedBy('AbanteCart')
                    ->setTitle($file_name)
                    ->setKeywords($file_name);
                $spreadsheet->getDefaultStyle()->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP);
                $spreadsheet->getDefaultStyle()->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                $spreadsheet->getDefaultStyle()->getFont()->setName('Lucida Sans Unicode');
                $spreadsheet->getDefaultStyle()->getFont()->setSize(12);

                //$sheet->setActiveSheetIndex(0);
                //$activeSheet = $sheet->getActiveSheet();
                $sheet->getPageSetup()->setOrientation(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE)
                    ->setFitToWidth(1)
                    ->setFitToHeight(0);

                $sheet->getHeaderFooter()->setOddHeader('&C&B&16' . $spreadsheet->getProperties()->getTitle())
                    ->setOddFooter('&CPage &P of &N');

                $log=new ALog(DIR_SYSTEM.'logs/error.txt');
                $row = $report['data'];
                $colHeaders=$report['headers'];

                $col = 'A';
                $rowNum = 1;
                $colTotals=$report['totals'];

                $sheet->getDefaultRowDimension()->setRowHeight(17);

                $styleArray = array(
                    'borders' => array(
                        'top' => array(
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        ),
                        'left' => array(
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        ),
                        'right' => array(
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        ),
                        'bottom' => array(
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        ),
                    )
                );


                foreach ($colHeaders as $k => $v) {
                    $sheet->setCellValue($col . $rowNum, $v);
                    $sheet->getStyle($col . $rowNum)->getFont()->setBold(true);
                    $sheet->getStyle($col . $rowNum)->applyFromArray($styleArray);
                    $sheet->getColumnDimension($col . $rowNum)->setAutoSize(true);
                    if ($v==='Image') {
                        $sheet->getColumnDimension($col)->setWidth(10);
                    } else {
                        $sheet->getColumnDimension($col)->setAutoSize(true);
                    }
                    $colNames[]=$v;
                    $col++;
                }
                $sheet->calculateColumnWidths();

                foreach ($row as $r=>$val) {
                    $col = 'A';
                    if ($val) {
                        $rowNum++;
                        foreach ($val as $k => $v) {
                            if (is_float($v)){
                                $sheet->getStyle($col . $rowNum)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                                $sheet->getStyle($col . $rowNum)->getNumberFormat()->setFormatCode('0.00');
                            } elseif (is_int($v)){
                                $sheet->getStyle($col . $rowNum)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                                $sheet->getStyle($col . $rowNum)->getNumberFormat()->setFormatCode('0');
                            } elseif (is_string($v)) {
                                $sheet->getStyle($col . $rowNum)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
                            }
                            $sheet->getStyle($col . $rowNum)->applyFromArray($styleArray);
                            if ($k!=='image' || ($k==='image' && $v==='')) {
                                $sheet->setCellValue($col++ . $rowNum, $v);
                            }

                            if ($k==='image' && $report['export_image']==='1' && $v!=='') {
                                $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
                                $drawing->setPath($v); /* put your path and image here */
                                $drawing->setOffsetX(6);
                                $drawing->setOffsetY(10);
                                $drawing->setCoordinates($col++ . $rowNum);
                                $drawing->setWidthAndHeight(57, 57);
                                $drawing->setWorksheet($spreadsheet->getActiveSheet());
                                $spreadsheet->getActiveSheet()->getRowDimension($rowNum)->setRowHeight(57, 'pt');
                            }
                        }
                    }
                }

                $row_total=$sheet->getHighestRow()+1;
                //$activeSheet->setCellValue('A'.$row_total,'Total: ');
                if (isset($report['border'])) {
                    $sheet->getStyle('A'.$row_total.':'.$report['border'].$row_total)->applyFromArray($styleArray);
                }

                if($colTotals) {
                    foreach ($colTotals as $k => $v) {
                        $sheet->getStyle($k . $row_total)->applyFromArray($styleArray);
                        if (is_float($v)) {
                            $sheet->getStyle($k . $row_total)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                            $sheet->getStyle($k . $row_total)->getNumberFormat()->setFormatCode('0.00');
                        } elseif (is_int($v)) {
                            $sheet->getStyle($k . $row_total)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                            $sheet->getStyle($k . $row_total)->getNumberFormat()->setFormatCode('0');
                        } elseif (is_string($v)) {
                            $sheet->getStyle($k . $row_total)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);

                        }

                        $sheet->setCellValue($k . $row_total, $v);
                    }
                }

                if ($report['sheet_title']) {
                    $sheet->setTitle($report['sheet_title']);
                } else {
                    $sheet->setTitle($report['name']);
                }

                $version=$requests['version'];

                header('Content-type: application/vnd.ms-excel');
                // It will be called order.xls
                header("Content-Disposition: attachment; filename=".$report['name'].'.'.$version);
                $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, ucfirst($version));

                // Write file to the browser
                $writer->save('php://output');

                exit;
            } catch (Exception $e) {
                $log=new ALog(DIR_SYSTEM . 'logs/error.txt');
                $log->write('Advanced Reports Excel Export Error: '. $e->getMessage());
            }
        }
    }
}