<?php

/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

require_once(DIR_EXT."advanced_reports".DIR_EXT_CORE."lib/exports/report_format_base.php");

class CsvExport extends ReportFormatBase {

	public static function display($report, $requests=array()) {
		//always use cache for CSV reports
		
		$file_name = preg_replace(array('/[\s]+/','/[^0-9a-zA-Z\-_\.]/'),array('_',''),$report['name']);
		
		// disable caching
	    $now = gmdate("D, d M Y H:i:s");
	    header("Pragma: no-cache");
		header("Expires: 0");
	    header("Cache-Control: max-age=0, no-cache, must-revalidate, proxy-revalidate");
	    header("Last-Modified: {$now} GMT");

	    // force download  
	    header("Content-Type: application/force-download");
	    header("Content-Type: application/octet-stream");
	    header("Content-Type: application/download");

	    // disposition / encoding on response body
	    header("Content-Disposition: attachment;filename={$file_name}.csv");
	    header("Content-Transfer-Encoding: binary");
		
		$data = "";

		if(isset($report['data']) && $report['data']) {
			$data = self::array2csv( $report['data'],$report['headers'],$report['totals'] );
		}
		if(trim($data)) echo $data;
	}

	public static function array2csv(array &$array,$headers,$totals)
	{
	   if (count($array) == 0) {
	     return null;
	   }

	   $df = fopen("php://output", 'w');
	   //fputcsv($df, array_keys(reset($array)));
	   fputcsv($df, $headers);
	   foreach ($array as $row) {
	      fputcsv($df, $row);
	   }
		if ($totals) {
			fputcsv($df, $totals);
		}
	   fclose($df);
	   return exit;
	}
}
