<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if ( ! defined( 'DIR_CORE' ) ) {
    header( 'Location: static_pages/' );
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";
require_once DIR_EXT . "advanced_reports" . DIR_EXT_CORE . "updater.php";
/**
 * Class ExtensionAdvancedReports
 * @property ModelAdvancedReportsSaleOrder $model_advanced_reports_sale_order
 */
class ExtensionAdvancedReports extends Extension {

    public $data = [];
    public $errors = [];
    private $error=[];
    protected $registry;
    private $mc_server_url = "https://abantecartplus.com/clientarea/plugin/license_manager/validate/";
    private $diy_server_url = "https://wehearyou2.com/clientarea/plugin/license_manager/validate/";
    private $shared_secret = "advanced_reports";

    public function __construct() {
        $this->registry = Registry::getInstance();
    }

	private function _is_enabled() {
      	return $this->baseObject->config->get('advanced_reports_status') && $this->verify();
	}

    public function verify() {
        return true;
        $that =& $this->baseObject;
        $that->load->model('extension/advanced_reports_license_info');
        $license_key = $that->config->get('advanced_reports_license_code');
        if ($license_key) {
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('advanced_reports_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $that->model_extension_advanced_reports_license_info->getStoreId();
                $license_key = $that->model_extension_advanced_reports_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_advanced_reports_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $that->model_extension_advanced_reports_license_info->getLicensedStoreStatus();
                if ($validate['status']==='expired') {
                    $that->load->model('extension/advanced_reports_license_info');
                    $store_id = $that->model_extension_advanced_reports_license_info->getStoreId();
                    $public_key = "";
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license_key = $that->model_extension_advanced_reports_license_info->getLicenseCode($store_id);
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }

                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $that->load->model('extension/advanced_reports_license_info');
                    $current_version = $that->model_extension_advanced_reports_license_info->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_data, $ttl);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/advanced_reports_license_info');
                            $that->model_extension_advanced_reports_license_info->saveLicenseData($data);
                        } elseif ($validate['status'] === 'valid' && $store_status == 1) {
                            return true;
                        } else {
                            return false;
                        }
                    }
                } else {
                if ($validate['status'] === 'valid' && $store_status == 1) {
                    return true;
                } else {
                    return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    /**public function onControllerPagesIndexLogin_InitData() {
        $that =& $this->baseObject;
        if ($that->request->is_POST()) {
            $logged_in = $that->session->data['LAST_ACTIVITY'];
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('advanced_reports_license_info') . "'");
            if ($exist->num_rows === 1) {
                if (isset($logged_in)) {
                    $that->load->model('extension/advanced_reports_license_info');
                    $store_id = $that->model_extension_advanced_reports_license_info->getStoreId();

                    $license_info = $that->model_extension_advanced_reports_license_info->getLicenseData($store_id);
                    $last_check = $license_info['last_check'];
                    $daily_check = 86400;
                    if (time() > $daily_check + $last_check) {
                        $public_key = "";
                        $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                        $license_key = $that->model_extension_advanced_reports_license_info->getLicenseCode($store_id);
                        $license = new License($path_to_phpseclib);
                        $license_manager = $license->getManager();
                        if (stripos($license_key,'mc-')!==false) {
                            $server_url = $this->mc_server_url;
                        } else {
                            $server_url = $this->diy_server_url;
                        }

                        $license_manager->setLicenseServerUrl($server_url);
                        $license_manager->setKeys($license_key, "", $this->shared_secret);
                        $public_key = $license_manager->requestKey();
                        $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                        $that->load->model('extension/advanced_reports_updater');
                        $current_version = $that->model_extension_advanced_reports_updater->getCurrentVersion();
                        $custom_data = ['version' => $current_version];
                        $license_data = $license_manager->requestData($custom_data);
                        if (!is_null($license_data)) {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $ttl = 1209600;
                            $validate = $license_manager->validate($license_data, $ttl);
                            if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                                $data['public_key'] = $public_key;
                                $data['license_data'] = $license_data;
                                $data['store_id'] = $store_id;
                                $data['last_check'] = time();
                                $that->load->model('extension/advanced_reports_license_info');
                                $that->model_extension_advanced_reports_license_info->saveLicenseData($data);
                            }
                        }
                    }
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensions_InitData() {
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'edit' ) {
            $extension = $that->request->get['extension'];
            if ( $extension === 'advanced_reports' ) {
                if ( $that->request->is_POST()) {
                    $public_key = "";
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license_key = trim($that->request->post['advanced_reports_license_code']);
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }
                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $that->load->model('extension/advanced_reports_license_info');

                    $store_id = (int) $that->config->get('config_store_id');
                    if (has_value($that->request->get_or_post('store_id'))) {
                        $store_id = (int) $that->request->get_or_post('store_id');
                    } else {
                        if ($that->session->data['current_store_id']) {
                            $store_id = (int) $that->session->data['current_store_id'];
                        }
                    }

                    $installed_store_id = $that->model_extension_advanced_reports_license_info->getInstalledLicense($license_key);

                    if ($installed_store_id!=='' && !is_null($installed_store_id)) {
                        $that->model_extension_advanced_reports_license_info->deleteLicenseInfo($installed_store_id);
                    }
                    $existing_license_key = $that->model_extension_advanced_reports_license_info->getLicenseCode($store_id);
                    $data['multi']=false;
                    $split_existing_license_key = explode('-',$existing_license_key);
                    $split_license_key = explode('-',$license_key);
                    if ($existing_license_key && $split_existing_license_key[0] !== $split_license_key[0]) {
                        $data['multi']=true;
                    }

                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $that->load->model('extension/advanced_reports_updater');
                    $current_version = $that->model_extension_advanced_reports_updater->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_data, $ttl);

                        $that->load->model('setting/setting');
                        $that->load->model('extension/advanced_reports_license_info');
                        $data['advanced_reports_licensed_store_id_'.$store_id] = 1;

                        $that->model_setting_setting->editSetting('advanced_reports', $data);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            if (file_exists(DIR_EXT.'advanced_reports/core/helpers.php')) {
                                unlink(DIR_EXT.'advanced_reports/core/helpers.php');
                            }
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['license_key'] = $license_key;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/advanced_reports_license_info');
                            $that->model_extension_advanced_reports_license_info->saveLicenseData($data);
                        }
                    } else {
                        $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                    }
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensions_UpdateData() {
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'edit' ) {
            $extension = $that->request->get['extension'];
            $that->load->language('advanced_reports/advanced_reports');
            if ( $extension === 'advanced_reports' ) {
                $latestVersion = $this->getVersion();
                $that->loadLanguage('extension/extensions');
                if (!is_null($latestVersion) && $latestVersion!=='') {
                    $info = sprintf(
                        $that->language->get('text_update_advanced_reports_available'),
                        $latestVersion,
                        $that->html->getSecureURL('extension/advanced_reports_updater','&version='.str_replace('.', '-', $latestVersion))
                    );
                    $that->view->assign('info',$info);
                } else {
                    $that->view->assign('info','');
                }
                $view = new AView($this->registry, 0);
                $data['manual_url'] = 'https://why2central.net/v1/new-report/';
                $data['manual_title'] = $that->language->get('advanced_reports_name').' Manual';
                $view->batchAssign($data);
                $that->view->addHookVar('extension_toolbar_buttons', $view->fetch('pages/extension/advanced_reports_manual.tpl'));
                $that->load->model('extension/advanced_reports_license_info');
                $license_key = $that->config->get('advanced_reports_license_code');
                if ($license_key) {
                    $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('advanced_reports_license_info') . "'");
                    if ($exist->num_rows === 1) {
                        $store_id = $that->model_extension_advanced_reports_license_info->getStoreId();
                        $license_key = $that->model_extension_advanced_reports_license_info->getLicenseCode($store_id);
                        $license_info = $that->model_extension_advanced_reports_license_info->getLicenseData($store_id);
                        $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                        $license = new License($path_to_phpseclib);
                        $license_manager = $license->getManager();
                        $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_info['license_data'], $ttl);
                        $message = '';
                        if ($validate['status']==='expired') {
                            $message = $that->language->get('advanced_reports_license_expired');
                        }
                        $that->view->assign('message',$message);
                    }
                }
                $that->processTemplate();
            }
        }
    }

    public function onControllerResponsesListingGridExtension_InitData() {
        if ($this->baseObject_method != 'update') {
            return false;
        }
        $that =& $this->baseObject;
        if ($that->request->get['id'] != 'advanced_reports') {
            return false;
        }
        if (isset($that->request->post['advanced_reports_license_code'])) {
            $that->request->post['advanced_reports_license_code'] = trim($that->request->post['advanced_reports_license_code']);
        }
    }

    public function onControllerResponsesListingGridExtension_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $store_id = (int)$that->config->get('current_store_id');
            if ($that->request->get_or_post('store_id')) {
                $store_id = $that->request->get_or_post('store_id');
            }
            $that->load->language('advanced_reports/advanced_reports');
            $response = json_decode(json_encode($that->data['response']), true);
            $extension_rows = $response['rows'];
            $ext_name = $that->language->get('advanced_reports_name');
            foreach ($extension_rows as $k => $extensions) {
                if ($extensions['id'] === 'advanced_reports_' . $store_id) {
                    $cells = $extensions['cell'];
                    foreach ($cells as $key => $cell) {
                        if ($cell===$ext_name || strpos($cell,'<p class="alert-info">'.$ext_name)!==false) {
                            $latestVersion = $this->getVersion();
                            if (!is_null($latestVersion) && $latestVersion!=='') {
                                $update_now_url = $that->html->getSecureURL('extension/advanced_reports_updater','&version='.str_replace('.', '-', $latestVersion));
                                $cells[$key] = '<p class="alert-info">'
                                    .$ext_name.' (WHY2)'
                                    .'<br>'
                                    .sprintf(
                                        $that->language->get('text_update_advanced_reports_available'),
                                        $latestVersion,
                                        $update_now_url
                                    )
                                    .'</p>';
                                $that->data['response']->rows[$k]['cell'][$key]=$cells[$key];
                            } else {
                                $that->data['response']->rows[$k]['cell'][$key] = $ext_name;
                            }
                        }
                    }
                }
            }
        } elseif ($this->baseObject_method==='update') {
            if ($that->request->post['advanced_reports_license_code']) {
                $public_key = "";
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";

                $license_key = trim($that->request->post['advanced_reports_license_code']);
                if (stripos($license_key,'mc-')!==false) {
                    $server_url = $this->mc_server_url;
                } else {
                    $server_url = $this->diy_server_url;
                }
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setLicenseServerUrl($server_url);
                $license_manager->setKeys($license_key, "", $this->shared_secret);
                $public_key = $license_manager->requestKey();

                $store_id = (int) $that->config->get('config_store_id');
                if ($that->request->get_or_post('store_id')) {
                    $store_id = $that->request->get_or_post('store_id');
                }

                $that->load->model('extension/advanced_reports_license_info');

                $installed_store_id = $that->model_extension_advanced_reports_license_info->getInstalledLicense($license_key);

                if ($installed_store_id!=='' && !is_null($installed_store_id)) {
                    $that->model_extension_advanced_reports_license_info->deleteLicenseInfo($installed_store_id);
                }

                $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                $that->load->model('extension/advanced_reports_updater');
                $current_version = $that->model_extension_advanced_reports_updater->getCurrentVersion();
                $custom_data = ['version' => $current_version];
                $license_data = $license_manager->requestData($custom_data);
                if (!is_null($license_data)) {
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_data, $ttl);

                    $that->load->model('setting/setting');
                    $that->load->model('extension/advanced_reports_license_info');

                    if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $data['license_key'] = $license_key;
                        $data['store_id'] = $store_id;
                        $data['last_check'] = time();
                        $that->load->model('extension/advanced_reports_license_info');
                        $that->model_extension_advanced_reports_license_info->saveLicenseData($data);
                    }
                } else {
                    $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensionSummary_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $extension = $that->request->get['extension'];
            if ($extension==='advanced_reports') {
                $that->load->language('advanced_reports/advanced_reports');
                $extension_info = $that->extensions->getExtensionInfo($extension);
                $support_expiration_int =  strtotime($extension_info['support_expiration']);
                if ($extension_info['support_expiration'] && $support_expiration_int !== 0) {
                    if ($support_expiration_int < time()) {
                        if ($that->data['text_support_expiration']) {
                            $that->view->assign('text_support_expired', $that->language->get('text_support_by_why2'));
                        } else {
                            $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                        }
                    } else {
                        $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                    }
                } else {
                    $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                }
                $that->view->assign('get_support_button', '');
                $data['get_diy_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'diy_support',
                        'target' => "_new",
                        'href'   => 'https://wehearyou2.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_diy_support_by_why2'),
                    ]
                );
                $data['get_mc_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'mc_support',
                        'target' => "_new",
                        'href'   => 'https://abantecartplus.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_mc_support_by_why2'),
                    ]
                );
                $view = new AView(Registry::getInstance(), 0);
                $view->batchAssign($data);
                $that->view->addHookVar('extension_summary_item', $view->fetch('pages/extension/extension_summary_buttons.tpl'));
                $that->view->batchAssign($this->data);
                $that->processTemplate();
            }
        }
    }

    public function onControllerResponsesListingGridOrder_InitData() {
        if ( !$this->_is_enabled() ) {
            return null;
        }
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'update' ) {
            $that->loadModel( 'sale/order' );
            $that->loadModel( 'advanced_reports/tax' );
            $that->loadModel( 'advanced_reports/sale' );
            switch ( $that->request->post['oper'] ) {
                case 'del':
                    $ids = explode( ',', $that->request->post['id'] );
                    if ( ! empty( $ids ) ) {
                        foreach ( $ids as $id ) {
                            $that->model_sale_order->deleteOrder( $id );
                            if ( $that->config->get( 'advanced_reports_status' ) == '1' ) {
                                $that->model_advanced_reports_tax->deleteTax( $id );
                                $that->model_advanced_reports_sale->deleteOrderInfo( $id );
                            }
                        }
                    }
                    break;
                default:
            }
        }
    }
**/
    public function onControllerPagesCatalogProduct_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'main' ) {
            $that->language->load( 'advanced_reports/advanced_reports' );
            $grid_settings = [
                'table_id'     => 'product_grid',
                'url'          => $that->html->getSecureURL( 'listing_grid/product', '&category=' . (int) $that->request->get['category'] ),
                'editurl'      => $that->html->getSecureURL( 'listing_grid/product/update' ),
                'update_field' => $that->html->getSecureURL( 'listing_grid/product/update_field' ),
                //NOTE: set default sorting by date_modified, but column not present in the grid
                'sortname'     => 'date_modified',
                'sortorder'    => 'desc',
                'actions'      => [
                    'edit'   => [
                        'text'     => $that->language->get( 'text_edit' ),
                        'href'     => $that->html->getSecureURL( 'catalog/product/update', '&product_id=%ID%' ),
                    ],
                    'save'   => [
                        'text' => $that->language->get( 'button_save' ),
                    ],
                    'delete' => [
                        'text' => $that->language->get( 'button_delete' ),
                    ],
                    'clone'  => [
                        'text' => $that->language->get( 'text_clone' ),
                        'href' => $that->html->getSecureURL( 'catalog/product/copy', '&product_id=%ID%' )
                    ],
                    'dropdown' => [
                        'text'     => $that->language->get('text_choose_action'),
                        'href'     => $that->html->getSecureURL('catalog/product/update', '&product_id=%ID%'),
                        'children' => array_merge([
                            'quickview'  => [
                                'text'  => $that->language->get('text_quick_view'),
                                'href'  => $that->html->getSecureURL('catalog/product/update', '&product_id=%ID%'),
                                //quick view port URL
                                'vhref' => $that->html->getSecureURL('r/common/viewport/modal',
                                    '&viewport_rt=catalog/product/update&product_id=%ID%'),
                            ],
                            'general'    => [
                                'text' => $that->language->get('tab_general'),
                                'href' => $that->html->getSecureURL('catalog/product/update', '&product_id=%ID%'),
                            ],
                            'media'      => [
                                'text' => $that->language->get('tab_media'),
                                'href' => $that->html->getSecureURL('catalog/product_images', '&product_id=%ID%'),
                            ],
                            'options'    => [
                                'text' => $that->language->get('tab_option'),
                                'href' => $that->html->getSecureURL('catalog/product_options', '&product_id=%ID%'),
                            ],
                            'files'      => [
                                'text' => $that->language->get('tab_files'),
                                'href' => $that->html->getSecureURL('catalog/product_files', '&product_id=%ID%'),
                            ],
                            'relations'  => [
                                'text' => $that->language->get('tab_relations'),
                                'href' => $that->html->getSecureURL('catalog/product_relations', '&product_id=%ID%'),
                            ],
                            'promotions' => [
                                'text' => $that->language->get('tab_promotions'),
                                'href' => $that->html->getSecureURL('catalog/product_promotions', '&product_id=%ID%'),
                            ],
                            'layout'     => [
                                'text' => $that->language->get('tab_layout'),
                                'href' => $that->html->getSecureURL('catalog/product_layout', '&product_id=%ID%'),
                            ],
                        ], (array)$this->data['grid_edit_expand'])
                    ],
                ],
            ];

            if ($that->config->get('advanced_reports_sales_tab')==='1') {
                $grid_settings['actions']['dropdown']['children']['orders'] =[
                    'text' => $that->language->get( 'tab_product_orders' ),
                    'href' => $that->html->getSecureURL( 'advanced_reports/product', '&product_id=%ID%' ),
                ];
            }

            $grid_settings['colNames'] = [
                '',
                $that->language->get( 'column_name' ),
                $that->language->get( 'column_model' ),
                $that->language->get( 'column_price' ),
                $that->language->get( 'column_quantity' ),
                $that->language->get( 'column_status' ),
            ];
            $grid_settings['colModel'] = [
                [
                    'name'     => 'image',
                    'index'    => 'image',
                    'align'    => 'center',
                    'width'    => 65,
                    'sortable' => false,
                    'search'   => false,
                ],
                [
                    'name'  => 'name',
                    'index' => 'name',
                    'align' => 'center',
                    'width' => 200,
                ],
                [
                    'name'  => 'model',
                    'index' => 'model',
                    'align' => 'center',
                    'width' => 120,
                ],
                [
                    'name'   => 'price',
                    'index'  => 'price',
                    'align'  => 'center',
                    'width'  => 90,
                    'search' => false,
                ],
                [
                    'name'   => 'quantity',
                    'index'  => 'quantity',
                    'align'  => 'center',
                    'width'  => 90,
                    'search' => false,
                ],
                [
                    'name'   => 'status',
                    'index'  => 'status',
                    'align'  => 'center',
                    'width'  => 130,
                    'search' => false,
                ],
            ];

            $grid_settings['search_form'] = true;

            $grid = $this->dispatch( 'common/listing_grid', [$grid_settings] );
            $that->view->assign( 'listing_grid', $grid->dispatchGetOutput() );
        }
    }

    public function onControllerPagesCatalogProductTabs_UpdateData() {
        if ( !$this->_is_enabled() ) {
            return null;
        }
        $that =& $this->baseObject;
        $data = $that->data;
        $that->language->load( 'advanced_reports/advanced_reports' );
        $view = new AView( Registry::getInstance(), 0 );
        $view->batchAssign( $data );
        $this->baseObject->view->addHookVar( 'extension_tabs', $view->fetch( 'pages/extension/product_tabs.tpl' ) );
    }

    public function onControllerResponsesProductProduct_UpdateData() {
        if ( ! $this->_is_enabled() ) {
            return null;
        }
        $that = $this->baseObject;
        if ($this->baseObject_method==='update_option_values') {
            $that->load->model('advanced_reports/product_options');
            $that->model_advanced_reports_product_options->updateProductOptionValues($that->request->get['product_id'], $that->request->get['option_id'], $that->request->post);
        }
    }

    public function onControllerPagesSaleOrder_InitData() {
        if ( !$this->_is_enabled() ) {
            return null;
        }
        $that     =& $this->baseObject;
        $order_id = (int) $that->request->get['order_id'];
        if ( $this->baseObject_method === 'details' ) {
            if ( $that->request->is_POST()) {
                $that->load->model('sale/order');
                $order_id = $that->request->get['order_id'];
                $order_products = $that->model_sale_order->getOrderProducts($order_id);
                foreach ($order_products as $order_prods) {
                    $order_options[] = $that->model_sale_order->getOrderOptions($order_id, $order_prods['order_product_id']);
                }
                $that->session->data['advanced_reports']['order_options'] = $order_options;
            }
        }
    }

    public function onControllerPagesSaleOrder_ProcessData() {
        if ( !$this->_is_enabled() ) {
            return null;
        }
        $that     =& $this->baseObject;
        $order_id = (int) $that->request->get['order_id'];
        if ( $this->baseObject_method === 'update' ) {
            $that->load->model('advanced_reports/sale_order');
            $that->model_advanced_reports_sale_order->editOrderProducts($order_id, $that->request->post);
        }
    }

    public function onControllerPagesSaleOrder_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $order_id = (int)$that->request->get['order_id'];
        if ($this->baseObject_method === 'recalc') {
            $that->load->model('advanced_reports/sale_order');
            $that->load->model('advanced_reports/tax');
            $order_option_data = $that->session->data['advanced_reports']['order_options'];
            $that->model_advanced_reports_sale_order->editOrderOption($order_id, $order_option_data);
            unset($that->session->data['advanced_reports']['order_options']);
            $that->load->model('advanced_reports/sale_order');
            $that->load->model('advanced_reports/tax');
            $product = $this->processProduct($that);
            foreach ($product as $prod) {
                $that->model_advanced_reports_sale_order->updateOrderProductTax($order_id, $prod['product_id'], $prod['tax']);
            }
            $that->model_advanced_reports_tax->updateTax($order_id);
        } elseif ($this->baseObject_method === 'details') {
            if ($that->request->is_POST() && $this->_validateForm()) {
                $that->load->model('advanced_reports/sale_order');
                $that->load->model('advanced_reports/tax');
                $order_option_data = $that->session->data['advanced_reports']['order_options'];
                $that->model_advanced_reports_sale_order->editOrderOption($order_id, $order_option_data);
                unset($that->session->data['advanced_reports']['order_options']);
            }
        }
    }

    private function _validateForm() {
        $that =& $this->baseObject;
        if ( ! $that->user->canModify( 'sale/order' ) ) {
            $this->error['warning'] = $that->language->get( 'error_permission' );
        }

        $that->extensions->hk_ValidateData( $that );
        if ( ! $this->error ) {
            return true;
        } else {
            return false;
        }
    }

    public function onControllerPagesCheckoutConfirm_UpdateData() {
        if ( !$this->_is_enabled() ) {
            return null;
        }
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'main' ) {
            if (isset($that->session->data['order_id'])) {
                $order_id = $that->session->data['order_id'];
                $that->load->model('advanced_reports/order');
                $data['products']=$this->processProduct($that);
                $that->model_advanced_reports_order->updateOrder($data,$order_id);
            }
        }
    }

    public function onControllerPagesCheckoutGuestStep3_UpdateData() {
        if ( !$this->_is_enabled() ) {
            return null;
        }
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'main' ) {
            $order_id = $that->session->data['order_id'];
            $that->load->model('advanced_reports/order');
            $data['products']=$this->processProduct($that);
            $that->model_advanced_reports_order->updateOrder($data,$order_id);
        }
    }

    public function beforeModelCheckoutOrder_confirm() {
        if ( !$this->_is_enabled() ) {
            return null;
        }
        $that  =& $this->baseObject;
        $that->load->model('advanced_reports/order');
        $order_id = $that->session->data['order_id'];
        $tax = $that->model_advanced_reports_order->getTaxesDesc($that->session->data['country_id'], $that->session->data['zone_id'] , $order_id);
        $total_tax = sizeof((array)$tax);
        if ($that->customer->isTaxExempt()) {
            $that->model_advanced_reports_order->saveTax($order_id, $tax, '0', '1');
        } else {
            if ($total_tax > 1) {
                foreach ($tax as $k => $v) {
                    if ($k == '0') {
                        $that->model_advanced_reports_order->saveTax($order_id, $v, '0', '0');
                    } else {
                        $that->model_advanced_reports_order->saveTax($order_id, $v, '1', '0');
                    }
                }
            } else {
                $that->model_advanced_reports_order->saveTax($order_id, $tax[0], '0', '0');
            }
        }
    }

    public function onAOrder_ProcessData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'build_order_data') {
            $product_data = $this->processProduct($that);
            $that->data['products'] = $product_data;
        }
    }

    public function afterModelCheckoutOrder_create($data,$set_order_id) {
        if ( !$this->_is_enabled() ) {
            return null;
        }
        $that  =& $this->baseObject;
        $that->load->model('advanced_reports/order');
        $order_id = $that->session->data['order_id'];
        $that->model_advanced_reports_order->updateOrder($data,$order_id);
    }

    private function processProduct($that) {
        $that->load->model('advanced_reports/verify');
        $cart_key = $that->session->data['cart_key'];
        if ($that->config->get('fast_checkout_status')) {
            $indata = $that->session->data['fc'];
        } else {
            $indata = $that->session->data;
        }
        $total_data = [];
        $cost = 0.00;

        $that->load->model('checkout/extension','storefront');
        $results = $that->model_checkout_extension->getExtensions('total');

        $total = 0;
        $taxes = $that->cart->getTaxes();

        foreach ($results as $key => $value) {
            $sort_order[$key] = $that->config->get($value['key'] . '_sort_order');
        }

        array_multisort($sort_order, SORT_ASC, $results);
        foreach ($results as $result) {
            $that->load->model('total/' . $result['key'],'storefront');
            $that->{'model_total_' . $result['key']}->getTotal($total_data, $total, $taxes, $indata);
        }

        $products = $that->cart->getProducts();

        $promotion = new APromotion();
        $coupon = $promotion->getCouponData($indata['coupon']);
        $coupon_product = $coupon['product'];
        $last_coupon_product_keys = [];
        $coupon_product_total = sizeof((array)$coupon_product);
        if ($coupon_product) {
            $last_coupon_product['product_id'] = end($coupon_product);
            foreach ($products as $prod) {
                if ((int)$prod['product_id']===(int)$last_coupon_product['product_id']) {
                    $last_coupon_product_keys[] = $prod['key'];
                    $coupon_product_total +=1;
                }
            }
        }

        $sort_order = [];
        $final_discount = $final_tax = 0;

        foreach ($total_data as $key => $value) {
            $sort_order[$key] = $value['sort_order'];
            if ($value['total_type'] === 'discount') {
                $final_discount = $value['value'];
            } elseif ($value['total_type'] === 'tax') {
                $final_tax = $value['value'];
            }
        }

        $product_data = [];
        $last_product = end($products);
        $last_product_id = $last_product['product_id'];
        $last_product_key = $last_product['key'];
        $ttl_discount = $ttl_tax = 0;
        $last_coupon_key = '';
        if ($last_coupon_product_keys) {
            $last_coupon_key = end($last_coupon_product_keys);
        }
        foreach ($that->cart->getProducts() as $key => $product) {
            $that->load->model('advanced_reports/coupon','storefront');
            $discounts = $that->model_advanced_reports_coupon->getDiscount($product['product_id'],$key,$product['total'], $final_discount, $indata);
            if (empty($coupon_product)) {
                if ($key !== $last_product_key) {
                    if (isset($discounts[$key])) {
                        $dsc = $discounts[$key]['discount'];
                    } else {
                        $dsc = $discounts['discount'];
                    }
                    $discount = $this->rounding($dsc);
                    if ($discount < 0) {
                        $ttl_discount += $discount;
                        $taxes = round($that->tax->calcTotalTaxAmount($product['total'] + $discount, $product['tax_class_id']), 4);
                    } else {
                        $ttl_discount -= $discount;
                        $taxes = round($that->tax->calcTotalTaxAmount($product['total'] - $discount, $product['tax_class_id']), 4);
                    }
                    $tax = $this->rounding($taxes);
                    $ttl_tax += $tax;
                } elseif ($key === $last_product_key) {
                    if ($final_discount < 0) {
                        $discount = $final_discount - $ttl_discount;
                    } else {
                        $discount = $final_discount + $ttl_discount;
                    }
                    $tax = $this->rounding(round($final_tax - $ttl_tax, 4));
                }
            } else {
                if ($coupon_product_total == 1 && in_array($product['product_id'], $coupon_product)) {
                    $discount = $this->rounding($final_discount);
                    $tax = $this->rounding($final_tax);
                } elseif ($coupon_product_total > 1 || ($coupon_product_total == 1 && $last_coupon_key)) {
                    $discount = $discounts[$key]['discount'];
                    $taxes = round($that->tax->calcTotalTaxAmount($product['total'] - $discount, $product['tax_class_id']), 4);
                    $tax = $this->rounding($taxes);
                  } else {
                    $discount = 0;
                    $tax = 0;
                }
            }

            $certain_product_coupon = $discounts[$key]['product_coupon'];
            if (!empty($certain_product_coupon)) {
                if (in_array($product['product_id'], $certain_product_coupon)) {
                    $product_coupon = '1';
                } else {
                    $product_coupon = '0';
                }
            } else {
                $product_coupon = '0';
            }
            $option_data = [];
            foreach ($product['option'] as $option) {
                $option_data[] = [
                    'product_option_value_id' => $option['product_option_value_id'],
                    'name' => $option['name'],
                    'value' => $option['value'],
                    'prefix' => $option['prefix'],
                    'price' => $option['price'],
                    'cost' => $option['cost']
                ];
                $cost += $option['cost'];
            }
            if ($discounts['free_shipping'] == '1') {
                $shipping_cost = $discounts['shipping'];
            } else {
                $shipping_cost = '0';
            }
            $product_data[] = [
                'key' => $product['key'],
                'product_id' => $product['product_id'],
                'name' => $product['name'],
                'model' => $product['model'],
                'sku' => $product['sku'],
                'option' => $product['option'],
                'download' => $product['download'],
                'quantity' => $product['quantity'],
                'price' => $product['price'],
                'cost' => $product['cost'],
                'discount' => $discount,
                'free_shipping_discount' => $shipping_cost,
                'product_coupon' => $product_coupon,
                'certain_product' => $discounts[$key]['certain_product'],
                'total' => $product['total'],
                'tax' => $tax,
                'stock' => $product['stock'],
                'sku' => $product['sku']
            ];
            $cost += ($cost * $product['quantity']);
        }
        return $product_data;
    }

    private function dispatch( $dispatch_rt, $args = [ '' ] ) {
        return new ADispatcher( $dispatch_rt, $args );
    }

    /**
     * Rounding Rates Function
     * @param $rate
     * @return string
     */
    private function rounding($rate) {
        $Rates = explode(".", $rate);
        $rates_len = strlen($Rates[1]);
        if ($rates_len === 4) {
            $splitRates = str_split($Rates[1], 2);
            $temp_rates = (int)$splitRates[1];
            if ($temp_rates <= 25) {
                $tmp_amount = $Rates[0] . '.' . $splitRates[0];
            } elseif ($temp_rates > 25 && $temp_rates <= 75) {
                $tmp_amount = $Rates[0] . '.' . $splitRates[0] . '5';
            } elseif ($temp_rates > 75) {
                $tmp_amount = $Rates[0] . '.' . (string)((int)$splitRates[0] + 1);
            }
            $amt = explode(".", $tmp_amount);
            $amt_len = strlen($amt[1]);
            if ($amt_len === 3) {
                $splitAmt = str_split($amt[1], 1);
                $temp_amt = (int)$splitAmt[2];
                $temp_amt2 = (int)$splitAmt[1] . $splitAmt[2];
                if ($temp_rates <= 2 || $temp_amt2 <= 25) {
                    $rates = $amt[0] . '.' . $splitAmt[0] . $splitAmt[1];
                } elseif (($temp_amt > 2 && $temp_amt <= 7) || ($temp_amt2 > 25 && $temp_amt2 <= 75)) {
                    $rates = $amt[0] . '.' . $splitAmt[0] . '5';
                } elseif ($temp_amt > 7) {
                    $rates = $amt[0] . '.' . (string)((int)($splitAmt[0] . $splitAmt[1]) + 1);
                }
            } else {
                $rates = $tmp_amount;
            }
        } elseif ($rates_len === 3) {
            $splitRates = str_split($Rates[1], 1);
            $temp_rates = (int)$splitRates[2];
            if ($temp_rates <= 2) {
                $rates = $Rates[0] . '.' . $splitRates[0] . $splitRates[1];
            } elseif ($temp_rates > 2 && $temp_rates <= 7) {
                $rates = $Rates[0] . '.' . $splitRates[0] . '5';
            } elseif ($temp_rates > 7) {
                $rates = $Rates[0] . '.' . (string)((int)($splitRates[0] . $splitRates[1]) + 1);
            }
        } else {
            $rates = $rate;
        }
        return $rates;
    }

    public function onControllerCommonHead_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (IS_ADMIN) {
                $latestVersion = $this->getVersion();
                if ($latestVersion) {
                    $that->load->language('advanced_reports/advanced_reports');
                    $that->load->model('extension/advanced_reports_updater');
                    $total = $that->model_extension_advanced_reports_updater->getTotalMsgIds();
                    if ($total > '0') {
                        $msg_ids = $that->model_extension_advanced_reports_updater->getMsgIdsByCartVersions();
                        foreach ($msg_ids as $msg_id) {
                            $that->messages->deleteMessage($msg_id['msg_id']);
                            $that->model_extension_advanced_reports_updater->deleteMsgID($msg_id['msg_id']);
                        }
                    }
                    $msg_title = str_replace('[new_version]', $latestVersion, $that->language->get('text_new_advanced_reports_version_title'));
                    $msg = str_replace('[version_number]', str_replace('.', '-', $latestVersion), $that->language->get('text_new_advanced_reports_version_description'));
                    $that->messages->saveNotice($msg_title, $msg);
                    $msg_info = $that->messages->getLikeMessage($msg_title);
                    $that->model_extension_advanced_reports_updater->saveMessageId($msg_info['msg_id'], $latestVersion);
                }
            }
        }
    }

    private function getVersion() {
        $that =& $this->baseObject;
        $latestVersion = '';
        $license_key = $that->config->get('advanced_reports_license_code');
        if ($license_key) {
            $valid = false;
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('advanced_reports_license_info') . "'");
            if ($exist->num_rows === 1) {
                $that->load->model('extension/advanced_reports_license_info');
                $store_id = $that->model_extension_advanced_reports_license_info->getStoreId();

                $license_key = $that->model_extension_advanced_reports_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_advanced_reports_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);

                if ($validate['status'] === 'valid') {
                    if (stripos($license_key, 'rent-') !== false || stripos($license_key, 'mc-') !== false) {
                        $valid = true;
                    } elseif (stripos($license_key, 'own-') !== false) {
                        $today = date("Y-m-d H:i:s");
                        $support_date = date('Y-m-d H:i:s', strtotime($validate['updates']));
                        if ($today <= $support_date) {
                            $valid = true;
                        }
                    }
                }
            }
            if ($valid) {
                $that->load->language('advanced_reports/advanced_reports');
                $getVersions = advancedReportsUpdaterGetAllVersions();
                $that->load->model('extension/advanced_reports_updater');
                $current_version = $that->model_extension_advanced_reports_updater->getCurrentVersion();
                if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                    $versions = $getVersions['notification_data']['product_versions'];
                    if ($versions) {
                        $latestVersions = [];
                        foreach ($versions as $version) {
                            if (strpos($version['version_number'], VERSION) !== false) {
                                $latestVersions[] = $version['version_number'];
                            }
                        }
                        usort($latestVersions, 'version_compare');
                        $latestVersion = end($latestVersions);
                        if (version_compare($current_version, $latestVersion, '<') === true) {
                            $msg_ids = $that->model_extension_advanced_reports_updater->getMsgIdsByCurrentCartVersion();
                            foreach ($msg_ids as $msg_id) {
                                $that->messages->deleteMessage($msg_id['msg_id']);
                                $that->model_extension_advanced_reports_updater->deleteMsgID($msg_id['msg_id']);
                            }
                            return $latestVersion;
                        }
                    }
                } else {
                    return '';
                }
            } else {
                return '';
            }
        }
    }
}