<?php if ($license_status===true) { ?>
<?php if($export !== "html") { ?>
<style type="text/css">
    @media only screen and (max-width: 800px) {

        /* Force table to not be like tables anymore */
        #tables table,
        #tables thead,
        #tables tbody,
        #tables th,
        #tables td,
        #tables tr {
            display: block;
        }

        /* Hide table headers (but not display: none;, for accessibility) */
        #tables thead tr {
            position: absolute;
            top: -9999px;
            left: -9999px;
        }

        #tables tr { border: 1px solid #ccc; }

        #tables td {
            /* Behave  like a "row" */
            border: none;
            border-bottom: 1px solid #eee;
            position: relative;
            padding-left: 50%;
            white-space: normal;
            text-align:left;
        }

        #tables td:before {
            /* Now like a table header */
            font-weight: bold;
            left: 3px;
            padding-right: 10px;
            position: absolute;
            text-align: left;
            top: 6px;
            white-space: nowrap;
            width: 45%;
        }

        /*
        Label the data
        */
        #tables td:before { content: attr(data-title); }

        #prd {
            width: 100%;
        }

        #select_date_range {
            width: 80%;
        }
    }

    @media only screen and (min-width: 801px) and (max-width: 1366px){
        #tables td:nth-child(1) {
            width: 10%;
            padding-right: 5px;
        }

        #tables td:nth-child(2),#tables td:nth-child(3) {
            width: 6%;
            padding-right: 5px;
        }

        #prd,#select_date_range {
            width: 100%;
        }
    }

    @media only screen and (min-width: 1367px){

        #tables td:nth-child(1){
            width: 10%;
            padding-right: 5px;
        }

        #tables td:nth-child(2),#tables td:nth-child(3) {
            width: 6%;
            padding-right: 5px;
        }

        #prd,#select_date_range {
            width: 100%;
        }
    }
</style>
<?php } else { ?>
<!DOCTYPE html>
<html dir="ltr" lang="en">
<head>
    <meta charset="UTF-8" />
    <link rel="stylesheet" type="text/css" href="<?php echo $base; ?>extensions/sales_state_report/admin/view/default/stylesheet/styles.css"/>
    <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.11.0/jquery.min.js" type="text/javascript"></script>
    <script src="<?php echo $base; ?>extensions/advanced_reports/admin/view/default/javascript/jquery.floatThead.min.js" type="text/javascript"></script>
<body>
<?php } ?>
<?php if($export == "html") { ?>
<div id="header" style="text-align: center;">
    <?php echo $heading_title; ?>
</div>
<hr>
<?php } ?>
<div id="content">
    <div class="box">
        <div class="content">
            <?php if($export != "html") { ?>
            <?php if(!empty($form_store_switch)) { ?>
            <div class="btn-group store_switcher">
                <?php echo $form_store_switch; ?>
            </div>
            <?php } ?>
            <div class="table" id="tables">
                <table>
                    <thead>
                    <tr>
                        <td>
                            <?php echo $text_range; ?>
                        </td>
                        <td>
                            <?php echo $entry_date_start; ?>
                        </td>
                        <td>
                            <?php echo $entry_date_end; ?>
                        </td>
                        <td>
                            <?php echo $entry_order_status; ?>
                        </td>
                        <td>
                            <?php echo $text_export_to; ?>
                        </td>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td data-title="<?php echo $text_range; ?>">
                            <select id="select_date_range" name="range_date" onchange="selectDateRange()">
                                <?php foreach ($range_list as $key => $val) { ?>
                                <?php if(isset($range_date) && $range_date == $key) { ?>
                                <option value="<?php echo $key; ?>" selected="selected"><?php echo $val; ?></option>
                                <?php } else { ?>
                                <option value="<?php echo $key; ?>"><?php echo $val; ?></option>
                                <?php } ?>
                                <?php } ?>
                            </select>
                        </td>
                        <td data-title="<?php echo $entry_date_start; ?>">
                            <input type="text" name="filter_date_start" onchange="setCustomRange()" value="<?php echo $filter_date_start; ?>" id="date-start" size="12" />
                        </td>
                        <td data-title="<?php echo $entry_date_end; ?>">
                            <input type="text" name="filter_date_end" onchange="setCustomRange()" value="<?php echo $filter_date_end; ?>" id="date-end" size="12" />
                        </td>
                        <td data-title="<?php echo $entry_order_status; ?>">
                            <select name="filter_order_status_id" id="ms" multiple="multiple">
                                <?php foreach ($order_statuses as $order_status) { ?>
                                <?php if ($order_status['order_status_id'] == $filter_order_status_id) { ?>
                                <option value="<?php echo $order_status['order_status_id']; ?>" selected="selected"><?php echo $order_status['name']; ?></option>
                                <?php } else { ?>
                                <option value="<?php echo $order_status['order_status_id']; ?>"><?php echo $order_status['name']; ?></option>
                                <?php } ?>
                                <?php } ?>
                            </select>
                            <a onclick="filter();" class="btn btn-primary"><?php echo $button_filter; ?></a>
                            <a onclick="reset();" class="btn btn-primary"><?php echo $button_reset; ?></a>
                        </td>
                        <td data-title="<?php echo $text_export_to; ?>">
                            <select id="select_export_type" name="export_type">
                                <?php foreach ($export_types as $key => $val) { ?>
                                <option value="<?php echo $key; ?>"><?php echo $val; ?></option>
                                <?php } ?>
                            </select>
                            <a onclick="arExport();" class="btn btn-primary"><?php echo $button_export; ?></a>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <?php } ?>
            <?php if ($reports) { ?>
            <div class="table-responsive" style="overflow: auto">
                <table class="list list-reports">
                    <thead>
                    <tr>
                        <td class="left" style="width:10%"><?php echo $column_state; ?></td>
                        <td class="left" style="width:10%"><?php echo $column_number_orders; ?></td>
                        <td class="left" style="width:10%"><?php echo $column_items_ordered; ?></td>
                        <td class="left"><?php echo $column_subtotal; ?></td>
                        <td class="left"><?php echo $column_shipping; ?></td>
                        <td class="left"><?php echo $column_discounts; ?></td>
                        <td class="left"><?php echo $column_tax; ?></td>
                        <td class="left"><?php echo $column_order_total; ?></td>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($reports as $key => $report) { ?>
                    <?php if($report) { ?>
                    <tr>
                        <td class="left"><?php echo isset($report["zone_name"])?$report['zone_name']:"";?></td>
                        <td class="right"><?php echo isset($report["number_orders"])?$report['number_orders']:0;?></td>
                        <td class="right"><?php echo isset($report["items_ordered"])?$report["items_ordered"]:"0";?></td>
                        <td class="right"><?php echo isset($report["subtotal2"])?$report["subtotal2"]:"0.00";?></td>
                        <td class="right"><?php echo isset($report["shipping2"])?$report["shipping2"]:"0.00";?></td>
                        <td class="right"><?php echo isset($report["discount2"])?$report["discount2"]:"0.00";?></td>
                        <td class="right"><?php echo isset($report["tax2"])?$report["tax2"]:"0.00";?></td>
                        <td class="right"><?php echo isset($report["total2"])?$report["total2"]:"0.00";?></td>
                    </tr>
                    <?php } else { ?>
                    <tr class="not_found">
                        <td class="left"><?php echo $key; ?></td>
                        <td colspan="8" style="text-align:center"><?php echo $text_no_found_on_period;?></td>
                    </tr>
                    <?php } ?>
                    <?php } ?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <td class="left">
                            <?php echo $text_report_total; ?>
                        </td>
                        <td class="right"><b><?php echo $sum_orders; ?></b></td>
                        <td class="right"><b><?php echo $sum_items_ordered;?></b></td>
                        <td class="right"><b><?php echo $sum_subtotal_with_currency;?></b></td>
                        <td class="right"><b><?php echo $sum_shipping_with_currency;?></b></td>
                        <td class="right"><b><?php echo $sum_discount_with_currency;?></b></td>
                        <td class="right"><b><?php echo $sum_tax_with_currency;?></b></td>
                        <td class="right"><b><?php echo $sum_total_with_currency;?></b></td>
                    </tr>
                    </tfoot>
                </table>
            </div>
            <div class="pagination"><?php echo $pagination; ?></div>
            <?php } else { ?>
            <?php echo $text_no_results; ?>
            <?php } ?>
        </div>
    </div>
</div>
<?php if($export !== "html") { ?>
<?php
	$today = date("Y-m-d");
	$yesterday = date('Y-m-d', strtotime("-1 days"));
	$last_seven_days = date('Y-m-d', strtotime("-7 days"));

	/*Last week*/
	$start_last_week = strtotime('-2 Sunday');
	$end_last_week = strtotime("+7 days", $start_last_week);
	$last_week_start = date('Y-m-d', $start_last_week);
	$last_week_end = date('Y-m-d', $end_last_week);
	/*Last business week*/
	$start_week = strtotime("last monday midnight");
	$end_week = strtotime("+4 days",$start_week);
	$last_start_business_week = date("Y-m-d",$start_week);
	$last_end_business_week = date("Y-m-d",$end_week);
	/*This Month*/
	$start_month = date("Y-m-d", strtotime(date('m').'/01/'.date('Y').' 00:00:00'));
	/*Last Month*/
	$last_month_start = strtotime('first day of last month');
	$last_month_start = date("Y-m-d", $last_month_start);
	$last_month_end = strtotime('last day of last month');
	$last_month_end = date("Y-m-d", $last_month_end);
    /*Last Year*/
    $last_year_start = strtotime('last year January 1st');
	$last_year_start = date("Y-m-d", $last_year_start);
	$last_year_end = strtotime('last year December 31st');
	$last_year_end = date("Y-m-d", $last_year_end);
	?>
<script type="text/javascript"><!--
    function selectDateRange() {
        var keys = [  'today',
            'yesterday',
            'last_7_days',
            'last_week',
            'last_business_week',
            'this_month',
            'last_month',
            'last_year'
        ];
        var from_dates = ['<?php echo $today;?>',
            '<?php echo $yesterday; ?>',
            '<?php echo $last_seven_days; ?>',
            '<?php echo $last_week_start; ?>',
            '<?php echo $last_start_business_week; ?>',
            '<?php echo $start_month; ?>',
            '<?php echo $last_month_start; ?>',
            '<?php echo $last_year_start; ?>'
        ];
        var to_dates = ['<?php echo $today;?>',
            '<?php echo $yesterday; ?>',
            '<?php echo $today; ?>',
            '<?php echo $last_week_end; ?>',
            '<?php echo $last_end_business_week; ?>',
            '<?php echo $today;?>',
            '<?php echo $last_month_end; ?>',
            '<?php echo $last_year_end; ?>'
        ];
        date_range = $('#select_date_range');
        date_start  = $('#date-start');
        date_end   = $('#date-end');
        value = date_range.val();
        if (value != 'custom')
        {
            var i;
            for (i = 0;i < keys.length; i++)
            {
                if ( keys[i] == value )
                {
                    date_start.val(from_dates[i]);
                    date_end  .val(to_dates[i]);
                }
            }
        }
    }

    function setCustomRange(){
        date_range = $('#select_date_range');
        date_range.val('custom');
    }

    function arExport() {
        url = '<?php echo $export_url;?>';

        var filter_date_start = $('#date-start').val();

        if (filter_date_start) {
            url += '&filter_date_start=' + encodeURIComponent(filter_date_start);
        }

        var filter_date_end = $('#date-end').val();

        if (filter_date_end) {
            url += '&filter_date_end=' + encodeURIComponent(filter_date_end);
        }

        var filter_order_status_id = $("#ms").multipleSelect("getSelects");

        if (filter_order_status_id != "") {
            url += '&filter_order_status_id=' + encodeURIComponent(filter_order_status_id);
        }

        var range_date = $('#select_date_range :selected').val();

        if (range_date) {
            url += '&range_date=' + encodeURIComponent(range_date);
        }

        var export_type = $('#select_export_type :selected').val();

        if (export_type) {
            url += '&export_type=' + encodeURIComponent(export_type);
        }

        location = url;
    }

    function filter() {
        url = '<?php echo $filter_url;?>';

        var filter_date_start = $('#date-start').val();

        if (filter_date_start) {
            url += '&filter_date_start=' + encodeURIComponent(filter_date_start);
        }

        var filter_date_end = $('#date-end').val();

        if (filter_date_end) {
            url += '&filter_date_end=' + encodeURIComponent(filter_date_end);
        }

        var filter_order_status_id = $("#ms").multipleSelect("getSelects");

        if (filter_order_status_id != "") {
            url += '&filter_order_status_id=' + encodeURIComponent(filter_order_status_id);
        }

        var range_date = $('#select_date_range :selected').val();

        if (range_date) {
            url += '&range_date=' + encodeURIComponent(range_date);
        }

        location = url;
    }

    function reset() {
        $('#date-start').val('');
        $('#date-end').val('');
    }

    //--></script>

<script>
    $(function() {
        $('#ms').multipleSelect();
    <?php
        if(isset($filter_order_status_id) && $filter_order_status_id) { ?>
            $("#ms").multipleSelect("setSelects", [<?php echo $filter_order_status_id; ?>]);
        <?php
        }
            ?>
    });
</script>
<script type="text/javascript"><!--
    $(document).ready(function() {
        var $table = $('.list');
        $table.floatThead({
            position: 'absolute'
        });
        $('#date-start').datepicker({dateFormat: 'yy-mm-dd'});

        $('#date-end').datepicker({dateFormat: 'yy-mm-dd'});

        selectDateRange();
    });
    //--></script>
<?php } else { ?>
<?php if($export == "html") { ?>
<script type="text/javascript">
    $(document).ready(function() {
        var $table = $('.list');
        $table.floatThead({
            position: 'absolute'
        });
    });
</script>
<hr>
<div id="footer" style="text-align: center">
    <?php echo 'Period: '.$filter_date_start.' to '.$filter_date_end ; ?>
</div>
<?php } ?>
</body>
</html>
<?php } ?>
<?php } else { ?>
<div id="content">
    <div class="box">
        <div class="content center">
            <?php if(!empty($form_store_switch)) { ?>
            <div class="btn-group store_switcher">
                <?php echo $form_store_switch; ?>
            </div>
            <?php } ?>
            <?php echo $text_unauthorized; ?>
        </div>
    </div>
</div>
<?php } ?>