<?php if ($license_status===true) { ?>
<?php if($export !== "html") { ?>
<style type="text/css">
    .list .low_stock{background: #FFA500!important; color:#FFFFFF!important;}
    .list .available{background: #008000!important; color:#FFFFFF!important;}
    .list .out_stock{background: #FF0000!important; color:#FFFFFF!important;}
    .list tbody tr:hover td.low_stock,.list tbody tr:hover td.available,.list tbody tr:hover td.out_stock{color:#000000!important;}

    @media only screen and (max-width: 360px) {
        #prodName,#filter_category_id,#filter_manufacturer {
            width: 100%;
        }
    }

    @media only screen and (max-width: 800px) {

        /* Force table to not be like tables anymore */
        #tables table,
        #tables thead,
        #tables tbody,
        #tables th,
        #tables td,
        #tables tr {
            display: block;
        }

        /* Hide table headers (but not display: none;, for accessibility) */
        #tables thead tr {
            position: absolute;
            top: -9999px;
            left: -9999px;
        }

        #tables tr { border: 1px solid #ccc; }

        #tables td {
            /* Behave  like a "row" */
            border: none;
            border-bottom: 1px solid #eee;
            position: relative;
            padding-left: 50%;
            white-space: normal;
            text-align:left;
        }

        #tables td:before {
            /* Now like a table header */
            font-weight: bold;
            left: 3px;
            padding-right: 10px;
            position: absolute;
            text-align: left;
            top: 6px;
            white-space: nowrap;
            width: 45%;
        }

        /*
        Label the data
        */
        #tables td:before { content: attr(data-title); }

        #filter_category_id {
            width: 100%;
        }

        #select_date_range {
            width: 80%;
        }
    }

    @media only screen and (min-width: 801px) and (max-width: 1366px){
        #tables td:nth-child(1) {
            width: 15%;
            padding-right: 5px;
        }

        #tables td:nth-child(2) {
            padding-right: 5px;
        }

        #tables td:nth-child(3) {
            padding-right: 5px;
        }

        #tables td:nth-child(4) {
            padding-right: 5px;
        }

        #prd,#select_date_range {
            width: 100%;
        }
    }

    @media only screen and (min-width: 1367px){

        #tables td:nth-child(1){
            width: 11%;
            padding-right: 5px;
        }

        #tables td:nth-child(2) {
            width: 10px;
            padding-right: 5px;
        }

        #tables td:nth-child(3) {
            width: 13px;
            padding-right: 5px;
        }

        #tables td:nth-child(4) {
            padding-right: 5px;
        }

        #prd,#select_date_range {
            width: 100%;
        }
    }

</style>
<?php } else { ?>
<!DOCTYPE html>
<html dir="ltr" lang="en">
<head>
    <meta charset="UTF-8" />
    <link rel="stylesheet" type="text/css" href="<?php echo $base; ?>extensions/advanced_reports/admin/view/default/stylesheet/advancedreports.css"/>
    <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.11.0/jquery.min.js" type="text/javascript"></script>
    <script src="<?php echo $base; ?>extensions/advanced_reports/admin/view/default/javascript/jquery.mousewheel.min.js" type="text/javascript"></script>
    <script src="<?php echo $base; ?>extensions/advanced_reports/admin/view/default/javascript/jquery.floatThead.min.js" type="text/javascript"></script>
    <style type="text/css">
        .list .low_stock{background: #FFA500!important; color:#FFFFFF!important;}
        .list .available{background: #008000!important; color:#FFFFFF!important;}
        .list .out_stock{background: #FF0000!important; color:#FFFFFF!important;}
        .list tbody tr:hover td.low_stock,.list tbody tr:hover td.available,.list tbody tr:hover td.out_stock{color:#000000!important;}
    </style>
<body>
<?php } ?>
<?php if($export === "html") { ?>
<div id="header" style="text-align: center;">
    <?php echo $heading_title; ?>
</div>
<hr>
<?php } ?>
<div id="content">
    <div class="box">
        <div class="content" id="inventory">
            <?php if($export !== "html") { ?>
            <?php if(!empty($form_store_switch)) { ?>
            <div class="btn-group store_switcher">
                <?php echo $form_store_switch; ?>
            </div>
            <?php } ?>
            <div style="padding-left: 5px">
                <div class="table table-responsive" id="tables">
                    <table>
                        <thead>
                        <tr>
                            <td>
                                <?php echo $text_category; ?>
                            </td>
                            <td>
                                <?php echo $text_manufacturer; ?>
                            </td>
                            <td>
                                <?php echo $text_filter_quantity; ?>
                            </td>
                            <td>
                                <?php echo $text_or; ?>
                            </td>
                            <td>
                                <?php echo $text_export_to; ?>
                            </td>
                            <td id="export_images_header" style="display: none">
                                <?php echo $text_export_images; ?>
                            </td>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td data-title="<?php echo $text_category; ?>">
                                <select name="filter_category_id" id="filter_category_id">
                                    <option value=""><?php echo $text_choose_a_category;?></option>
                                    <?php foreach ($categories as $category) { ?>
                                    <?php if(isset($filter_category_id) && $category['category_id'] == $filter_category_id){ ?>
                                    <option value="<?php echo $category['category_id']; ?>" selected="selected"><?php echo $category['name']; ?></option>
                                    <?php } else { ?>
                                    <option value="<?php echo $category['category_id']; ?>"><?php echo $category['name']; ?></option>
                                    <?php } ?>
                                    <?php if (isset($category['children']) && $category['children']) { ?>
                                    <?php foreach ($category['children'] as $child) { ?>
                                    <?php if(isset($filter_category_id) && $category['category_id'] == $filter_category_id){ ?>
                                    <option value="<?php echo $child['category_id']; ?>" selected="selected"> - <?php echo $child['name']; ?></option>
                                    <?php } else { ?>
                                    <option value="<?php echo $child['category_id']; ?>"> - <?php echo $child['name']; ?></option>
                                    <?php } ?>
                                    <?php } ?>
                                    <?php } ?>
                                    <?php } ?>
                                </select>
                            </td>
                            <td data-title="<?php echo $text_manufacturer; ?>">
                                <select id="filter_manufacturer" name="filter_manufacturer">
                                    <option value=""><?php echo $text_choose_a_manufacturer;?></option>
                                    <?php foreach ($manufacturers as $item) { ?>
                                    <?php if(isset($filter_manufacturer) && $item['manufacturer_id'] == $filter_manufacturer){ ?>
                                    <option value="<?php echo $item['manufacturer_id']; ?>" selected="selected"><?php echo $item['name']; ?></option>
                                    <?php }else{ ?>
                                    <option value="<?php echo $item['manufacturer_id']; ?>"><?php echo $item['name']; ?></option>
                                    <?php } ?>
                                    <?php } ?>
                                </select>
                            </td>
                            <td data-title="<?php echo $text_filter_quantity; ?>">
                                <input type="text" id="filter_quantity" name="filter_quantity" size="10" value="<?php echo isset($filter_quantity)?$filter_quantity:'';?>"/>
                            </td>
                            <td data-title="<?php echo $text_or; ?>">
                                <input type="text" id="prodName" name="product_name" placeholder="<?php echo $text_filter_product;?>" autocomplete="off" value="<?php echo isset($product_name)?$product_name:"";?>" size="30"/>
                                <input type="hidden" id="prodID" name="product_id" value="<?php echo isset($product_id)?$product_id:"";?>"/>
                                <a onclick="filter();" class="btn btn-primary"><?php echo $button_filter; ?></a>
                            </td>
                            <td data-title="<?php echo $text_export_to; ?>">
                                <select id="select_export_type" name="export_type">
                                    <?php foreach ($export_types as $key => $val) { ?>
                                    <option value="<?php echo $key; ?>"><?php echo $val; ?></option>
                                    <?php } ?>
                                </select>
                            </td>
                            <td id="export_images" data-title="<?php echo $text_export_images; ?>" style="display: none">
                                <select id="select_export_image" name="export_image">
                                    <option value="1"><?php echo $text_yes; ?></option>
                                    <option value="0"><?php echo $text_no; ?></option>
                                </select>
                            </td>
                            <td>
                                <a onclick="arExport();" class="btn btn-primary"><?php echo $button_export; ?></a>
                            </td>
                        </tr>
                        <tr></tr>
                        </tbody>
                    </table>
                    <div class="row" id="columns">
                        <div class="col-md-12"> <?php echo $text_select_columns;?>
                            <form id="show_columns" action="">
                                <input class="form-group" type="checkbox" id="show_product_name_column" name="show_product_name_column" value="<?php echo $show_product_name_column;?>"
                                <?php echo $show_product_name_column_checked;?>> <?php echo $show_product_name;?>
                                <input class="form-group" type="checkbox" id="show_model_column" name="show_model_column" value="<?php echo $show_model_column;?>"
                                <?php echo $show_model_column_checked;?>> <?php echo $show_model;?>
                                <input class="form-group" type="checkbox" id="show_sku_column" name="show_sku_column" value="<?php echo $show_sku_column;?>"
                                <?php echo $show_sku_column_checked;?>> <?php echo $show_sku;?>
                                <input class="form-group" type="checkbox" id="show_stock_status_column" name="show_stock_status_column" value="<?php echo $show_stock_status_column;?>"
                                <?php echo $show_stock_status_column_checked;?>> <?php echo $show_stock_status;?>
                                <input class="form-group" type="checkbox" id="show_product_qty_column" name="show_product_qty_column" value="<?php echo $show_product_qty_column;?>"
                                <?php echo $show_product_qty_column_checked;?>> <?php echo $show_qty;?>
                                <input class="form-group" type="checkbox" id="show_free_shipping_column" name="show_free_shipping_column" value="<?php echo $show_free_shipping_column;?>"
                                <?php echo $show_free_shipping_column_checked;?>> <?php echo $show_free_shipping;?>
                                <input class="form-group" type="checkbox" id="show_individual_shipping_column" name="show_individual_shipping_column" value="<?php echo $show_individual_shipping_column;?>"
                                <?php echo $show_individual_shipping_column_checked;?>> <?php echo $show_individual_shipping;?>
                                <input class="form-group" type="checkbox" id="show_downloadable_column" name="show_downloadable_column" value="<?php echo $show_downloadable_column;?>"
                                <?php echo $show_downloadable_column_checked;?>> <?php echo $show_downloadable;?>
                                <input class="form-group" type="checkbox" id="show_fixed_shipping_column" name="show_fixed_shipping_column" value="<?php echo $show_fixed_shipping_column;?>"
                                <?php echo $show_fixed_shipping_column_checked;?>> <?php echo $show_fixed_shipping;?>
                                <input class="form-group" type="checkbox" id="show_weight_column" name="show_weight_column" value="<?php echo $show_weight_column;?>"
                                <?php echo $show_weight_column_checked;?>> <?php echo $show_weight;?>
                                <input class="form-group" type="checkbox" id="show_weight_class_column" name="show_weight_class_column" value="<?php echo $show_weight_class_column;?>"
                                <?php echo $show_weight_class_column_checked;?>> <?php echo $show_weight_class;?>
                                <input class="form-group" type="checkbox" id="show_length_column" name="show_length_column" value="<?php echo $show_length_column;?>"
                                <?php echo $show_length_column_checked;?>> <?php echo $show_length;?>
                                <input class="form-group" type="checkbox" id="show_width_column" name="show_width_column" value="<?php echo $show_width_column;?>"
                                <?php echo $show_width_column_checked;?>> <?php echo $show_width;?>
                                <input class="form-group" type="checkbox" id="show_height_column" name="show_height_column" value="<?php echo $show_height_column;?>"
                                <?php echo $show_height_column_checked;?>> <?php echo $show_height;?>
                                <input class="form-group" type="checkbox" id="show_length_class_column" name="show_length_class_column" value="<?php echo $show_length_class_column;?>"
                                <?php echo $show_length_class_column_checked;?>> <?php echo $show_length_class;?>
                                <input class="form-group" type="checkbox" id="show_product_cost_column" name="show_product_cost_column" value="<?php echo $show_product_cost_column;?>"
                                <?php echo $show_product_cost_column_checked;?>> <?php echo $show_cost;?>
                                <input class="form-group" type="checkbox" id="show_product_price_column" name="show_product_price_column" value="<?php echo $show_product_price_column;?>"
                                <?php echo $show_product_price_column_checked;?>> <?php echo $show_price;?>
                                <input class="form-group" type="checkbox" id="show_product_value_column" name="show_product_value_column" value="<?php echo $show_product_value_column;?>"
                                <?php echo $show_product_value_column_checked;?>> <?php echo $show_value;?>
                                <input class="form-group" type="checkbox" id="show_total_cost_column" name="show_total_cost_column" value="<?php echo $show_total_cost_column;?>"
                                <?php echo $show_total_cost_column_checked;?>> <?php echo $show_total_cost;?>
                                <input class="form-group" type="checkbox" id="show_purchased_qty_column" name="show_purchased_qty_column" value="<?php echo $show_purchased_qty_column;?>"
                                <?php echo $show_purchased_qty_column_checked;?>> <?php echo $show_purchased_qty;?>
                                <input class="form-group" type="checkbox" id="show_purchased_value_column" name="show_purchased_value_column" value="<?php echo $show_purchased_value_column;?>"
                                <?php echo $show_purchased_value_column_checked;?>> <?php echo $show_purchased_value;?>
                            </form>
                        </div>
                        <div class="col-md-12">
                            <button class="btn btn-primary" id="show_all"><?php echo $button_show_all_column;?></button>
                            <button class="btn btn-primary" id="save_settings"><i class="fa fa-save"></i> <?php echo $button_save_settings;?></button>
                            <button class="btn btn-primary" id="toggl_options"><?php echo $button_toggle_options;?></button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="summary_top">
                <ul>
                    <li class="no-border-right"><p class="text"><?php echo $column_qty_inventory; ?></p><p class="number"><?php echo $sum_qty; ?></p></li>
                    <li class="no-border-right"><p class="text"><?php echo $column_qty_purchases; ?></p><p class="number"><?php echo $sum_purchases_qty; ?></p></li>
                    <li class="no-border-right"><p class="text"><?php echo $column_product_revenue; ?></p><p class="number"><?php echo $sum_total_purchases_with_currency;?></p></li>
                </ul>
            </div>
            <br><br><br><br>
            <?php } ?>
            <?php if ($reports) { ?>
            <div class="table-responsive" style="overflow: auto" id="mw">
                <table class="list list-reports">
                    <thead>
                    <tr>
                        <th class="left" id="column-image"><?php echo $column_image; ?></th>
                        <th class="left" id="column-name" style="width:30%<?php echo $show_product_name_column_header_style;?>"><?php echo $column_product_name; ?></th>
                        <th class="left" id="column-model" <?php echo $show_model_column_style;?>><?php echo $column_product_model; ?></td>
                        <th class="left" id="column-sku" <?php echo $show_sku_column_style;?>> <?php echo $column_product_sku; ?></td>
                        <th class="left" id="column-stock-status" <?php echo $show_stock_status_column_style; ?>><?php echo $column_stock_status; ?></td>
                        <th class="left" id="column-product-qty" <?php echo $show_product_qty_column_style; ?>><?php echo $column_qty_inventory; ?></td>
                        <th class="left" id="column-free-shipping" <?php echo $show_free_shipping_column_style;?>><?php echo $column_free_shipping; ?></td>
                        <th class="left" id="column-individual-shipping" <?php echo $show_individual_shipping_column_style;?>><?php echo $column_shipping_individually; ?></td>
                        <th class="left" id="column-downloadable" <?php echo $show_downloadable_column_style;?>><?php echo $column_downloadable; ?></td>
                        <th class="left" id="column-fixed-shipping" <?php echo $show_fixed_shipping_column_style;?>><?php echo $column_fixed_shipping; ?></td>
                        <th class="left" id="column-weight" <?php echo $show_weight_column_style;?>><?php echo $column_weight; ?></td>
                        <th class="left" id="column-weight-class" <?php echo $show_weight_class_column_style;?>><?php echo $column_weight_class; ?></td>
                        <th class="left" id="column-length" <?php echo $show_length_column_style;?>><?php echo $column_length; ?></td>
                        <th class="left" id="column-width" <?php echo $show_width_column_style;?>><?php echo $column_width; ?></td>
                        <th class="left" id="column-height" <?php echo $show_height_column_style;?>><?php echo $column_height; ?></td>
                        <th class="left" id="column-length-class" <?php echo $show_length_class_column_style;?>><?php echo $column_length_class; ?></td>
                        <th class="left" id="column-product-cost" <?php echo $show_product_cost_column_style;?>><?php echo $column_cost; ?></td>
                        <th class="left" id="column-price" <?php echo $show_product_price_column_style;?>><?php echo $column_price; ?></td>
                        <th class="left" id="column-product-value" <?php echo $show_product_value_column_style;?>><?php echo $column_value; ?></td>
                        <th class="left" id="column-total-cost" <?php echo $show_total_cost_column_style;?>><?php echo $column_total_cost; ?></td>
                        <th class="left" id="column-purchased-qty" <?php echo $show_purchased_qty_column_style;?>><?php echo $column_qty_purchases; ?></td>
                        <th class="left" id="column-purchased-value" <?php echo $show_purchased_value_column_style;?>><?php echo $column_purchases_value; ?></td>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($reports as $key => $report) { ?>
                    <?php
                                $quantity = isset($report["quantity"])?$report['quantity']:0;
                                $style_color = "";
                                $number_lowstock = isset($number_lowstock)?(int)$number_lowstock:10;
                                if((int)$quantity == 0) {
                                    $style_color = "color:#FF0000";
                                } else if((int)$quantity > 0 && (int)$quantity < $number_lowstock) {
                    $style_color = "color:#FFA500;";
                    }
                    ?>
                    <tr>
                        <td class="center" id="image">
                            <?php if(isset($report['options']) && $report['options']) {
                               $img_style = 'padding: 1px; border: 1px solid #DDDDDD;margin-top:10px;';
                             } else {
                               $img_style = 'padding: 1px; border: 1px solid #DDDDDD;margin-top:5px;margin-bottom:5px;';
                             } ?>
                            <img src="<?php echo $report['image']; ?>" alt="<?php echo $report['name']; ?>" style="<?php echo $img_style;?>" />
                            <?php if(isset($report['options']) && $report['options']) { ?>
                            <span id="toggle-<?php echo $report['product_id'] ?>" title="<?php echo $text_expand_options; ?>" class="toggle-icons icon-plus <?php if($export != "html") { ?>collapsed<?php } ?>" onclick="toggleOptions(<?php echo $report['product_id']; ?>)">+</span>
                            <?php } ?>
                        </td>
                        <?php if ($export==='pdf' || $export==='html') { ?>
                        <?php } ?>
                        <?php if ($export==='pdf' || $export==='html') { ?>
                        <td class="left" id="name" <?php echo $show_product_name_column_style;?>><?php echo $report['name']; ?></td>
                        <?php } else { ?>
                        <td class="left" id="name" <?php echo $show_product_name_column_style;?>><a href="<?php echo $report['link']; ?>" target="_BLANK"><?php echo $report['name']; ?></a></td>
                        <?php } ?>
                        <td class="left" id="model" <?php echo $show_model_column_style;?>><?php echo $report['model']; ?></td>
                        <td class="left" id="sku" <?php echo $show_sku_column_style;?>><?php echo $report['sku']; ?></td>
                        <td class="left <?php echo $report['stock_class'];?>" id="stock-status" <?php echo $show_stock_status_column_style;?>><?php echo $report['stock_status']; ?></td>
                        <td class="right" style="<?php echo $style_color.$show_product_qty_column_header_style; ?>" id="product-qty"><?php echo $quantity;?></td>
                        <td class="left" id="free-shipping" <?php echo $show_free_shipping_column_style;?>><?php echo $report['free']; ?></td>
                        <td class="left" id="individual-shipping" <?php echo $show_individual_shipping_column_style;?>><?php echo $report['individual']; ?></td>
                        <td class="left" id="downloadable" <?php echo $show_downloadable_column_style;?>><?php echo $report['downloadable']; ?></td>
                        <td class="left" id="fixed-shipping" <?php echo $show_fixed_shipping_column_style;?>><?php echo $report['shipping_price2']; ?></td>
                        <td class="left" id="weight" <?php echo $show_weight_column_style;?>><?php echo $report['weight']; ?></td>
                        <td class="left" id="weight-class" <?php echo $show_weight_class_column_style;?>><?php echo $report['weightC']; ?></td>
                        <td class="left" id="length" <?php echo $show_length_column_style;?>><?php echo $report['length']; ?></td>
                        <td class="left" id="width" <?php echo $show_width_column_style;?>><?php echo $report['width']; ?></td>
                        <td class="left" id="height" <?php echo $show_height_column_style;?>><?php echo $report['height']; ?></td>
                        <td class="left" id="length-class" <?php echo $show_length_class_column_style;?>><?php echo $report['lengthC']; ?></td>
                        <td class="right" id="product-cost" <?php echo $show_product_cost_column_style;?>><?php echo isset($report["cost2"])?$report['cost2']:"0.00";?></td>
                        <td class="right" id="price" <?php echo $show_product_price_column_style;?>><?php echo isset($report["price2"])?$report['price2']:"0.00";?></td>
                        <td class="right" id="product-value" <?php echo $show_product_value_column_style;?>><?php echo isset($report["product_value2"])?$report["product_value2"]:"0.00";?></td>
                        <td class="right" id="total-cost" <?php echo $show_total_cost_column_style;?>><?php echo isset($report["total_cost2"])?$report["total_cost2"]:"0.00";?></td>
                        <td class="right" id="purchased-qty" <?php echo $show_purchased_qty_column_style;?>><?php echo isset($report["purchases_quantity"])?$report["purchases_quantity"]:0;?></td>
                        <td class="right" id="purchased-value" <?php echo $show_purchased_value_column_style;?>><?php echo isset($report["purchases_value2"])?$report["purchases_value2"]:"0.00";?></td>
                    </tr>
                    <?php
                                if(isset($report['options']) && $report['options']) {
                                    foreach($report['options'] as $option) {
                                        $style_color = "";
                                        if(isset($option['product_option_value']) && $option['product_option_value']) {
                                            $option_values = isset($option['option_values'])?$option['option_values']:array();
                                            foreach($option['product_option_value'] as $option_value) {
                                                if($option_value['quantity'] < $number_lowstock && $option_value['quantity'] > 0) {
                    $option_value['stock_status'] = $text_low_stock;
                    $option_value['stock_class'] = "low_stock";
                    $style_color = "color:#FFA500;";
                    } else if($option_value['quantity'] <= 0 ) {
                    $option_value['stock_status'] = $text_out_stock;
                    $option_value['stock_class'] = "out_stock";
                    $style_color = "color:#FF0000;";
                    } else {
                    $option_value['stock_status'] = $text_available_stock;
                    $option_value['stock_class'] = "available";
                    $style_color = "color:#000000;";
                    }
                    ?>
                    <tr class="product-options-<?php echo $report['product_id']; ?> toggle-options" <?php if($export != "html") { ?>style="display:none"<?php } ?>>
                    <td class="center" id="option-image">|___</td>
                    <td class="left" id="option-name" <?php echo $show_product_name_column_style;?>><?php echo $option['type']." - ".$option['name']." - <strong>".$option_value["name"]."</strong>"; ?></td>
                    <td class="left" id="option-model" <?php echo $show_model_column_style;?>></td><!-- Model-->
                    <td class="left" id="option-sku" <?php echo $show_sku_column_style;?>></td><!-- sku-->
                    <td class="left <?php echo $option_value['stock_class'];?>" id="option-stock-status" <?php echo $show_stock_status_column_style; ?>><?php echo $option_value['stock_status']; ?></td>
                    <td class="right" id="option-product-qty" style="<?php echo $style_color.$show_product_qty_column_header_style ?>"><?php echo $option_value['quantity'];?></td>
                    <td id="option-free-shipping" <?php echo $show_free_shipping_column_style;?>></td>
                    <td id="option-individual-shipping" <?php echo $show_individual_shipping_column_style;?>></td>
                    <td id="option-downloadable" <?php echo $show_downloadable_column_style;?>></td>
                    <td id="option-fixed-shipping" <?php echo $show_fixed_shipping_column_style;?>></td>
                    <td id="option-weight" <?php echo $show_weight_column_style;?>><?php echo $option_value['weight'];?></td>
                    <td id="option-weight-class" <?php echo $show_weight_class_column_style;?>><?php echo $option_value['weight_type'];?></td>
                    <td id="option-length" <?php echo $show_length_column_style;?>></td>
                    <td id="option-width" <?php echo $show_width_column_style;?>></td>
                    <td id="option-height" <?php echo $show_height_column_style;?>></td>
                    <td id="option-length-class" <?php echo $show_length_class_column_style;?>></td>
                    <td class="right" id="option-product-cost" <?php echo $show_product_cost_column_style;?>><?php echo $option_value['cost2'];?></td>
                    <?php if ($option_value['price_prefix']==='%') { ?>
                    <td class="right" id="option-price" <?php echo $show_product_price_column_style;?>><?php echo $option_value['percent']." ".$option_value['price_prefix']." ".(isset($option_value["price2"])?$option_value['price2']:"0.00");?></td><!-- price2-->
                    <?php } else { ?>
                    <td class="right" id="option-price" <?php echo $show_product_price_column_style;?>><?php echo $option_value['price_prefix']." ".(isset($option_value["price2"])?$option_value['price2']:"0.00");?></td><!-- price2-->
                    <?php } ?>
                    <td class="right" id="option-product-value" <?php echo $show_product_value_column_style;?>><?php echo $option_value['value2'];?></td>
                    <td class="right" id="option-total-cost" <?php echo $show_total_cost_column_style;?>><?php echo $option_value['total_cost2'];?></td>
                    <td id="option-purchased-qty" <?php echo $show_purchased_qty_column_style;?>></td>
                    <td id="option-purchased-value" <?php echo $show_purchased_value_column_style;?>></td>
                    </tr>
                    <?php
                                            }
                                        }
                                    }
                                }
                                ?>
                    <?php } ?>
                    </tbody>
                    <tfoot>
                    <tr id="sum">
                        <td style="border-right: unset" id="sum-image"><?php echo $text_report_total;?></td>
                        <td style="border-right: unset<?php echo $show_product_name_column_header_style;?>" id="sum-product-name"></td>
                        <td style="border-right: unset<?php echo $show_model_column_header_style;?>" id="sum-model"></td>
                        <td style="border-right: unset<?php echo $show_sku_column_header_style;?>" id="sum-sku"></td>
                        <td id="sum-stock-status" <?php echo $show_stock_status_column_style; ?>></td>
                        <td class="right" id="sum-product-qty" <?php echo $show_product_qty_column_style;?>><b><?php echo $sum_qty; ?></b></td>
                        <td class="right" id="sum-free-shipping" <?php echo $show_free_shipping_column_style;?>></td>
                        <td class="right" id="sum-individual-shipping" <?php echo $show_individual_shipping_column_style;?>></td>
                        <td class="right" id="sum-downloadable" <?php echo $show_downloadable_column_style;?>></td>
                        <td class="right" id="sum-fixed-shipping" <?php echo $show_fixed_shipping_column_style;?>></td>
                        <td class="right" id="sum-weight" <?php echo $show_weight_column_style;?>></td>
                        <td class="right" id="sum-weight-class" <?php echo $show_weight_class_column_style;?>></td>
                        <td class="right" id="sum-length" <?php echo $show_length_column_style;?>></td>
                        <td class="right" id="sum-width" <?php echo $show_width_column_style;?>></td>
                        <td class="right" id="sum-height" <?php echo $show_height_column_style;?>></td>
                        <td class="right" id="sum-length-class" <?php echo $show_length_class_column_style;?>></td>
                        <td class="right" id="sum-product-cost" <?php echo $show_product_cost_column_style;?>></td>
                        <td class="right" id="sum-price" <?php echo $show_product_price_column_style;?>></td>
                        <td class="right" id="sum-product-value" <?php echo $show_product_value_column_style;?>><b><?php echo $sum_total_value_with_currency; ?></b></td>
                        <td class="right" id="sum-total-cost" <?php echo $show_total_cost_column_style;?>><b><?php echo $sum_total_total_cost_with_currency; ?></b></td>
                        <td class="right" id="sum-purchased-qty" <?php echo $show_purchased_qty_column_style;?>><b><?php echo $sum_purchases_qty; ?></b></td>
                        <td class="right" id="sum-purchased-value" <?php echo $show_purchased_value_column_style;?>><b><?php echo $sum_total_purchases_with_currency; ?></b></td>
                    </tr>
                    </tfoot>
                </table>
            </div>
            <?php if($export != "html") { ?>
            <div class="pagination"><?php echo $pagination; ?></div>
            <?php } ?>
            <?php } else { ?>

            <?php echo $text_no_results; ?>

            <?php } ?>

        </div>
    </div>
</div>
<script type="text/javascript">
    function toggleOptions(product_id) {
        if($(".product-options-"+product_id).length > 0) {
            $(".product-options-"+product_id).toggle();
            $("#toggle-"+product_id).toggleClass("collapsed");
        }
    }

    var expand = false;

    function toggleAll() {
        expand = !expand;
        $("[id^='toggle']").each(function(e){
            var id = $(this).context.id.split('-');
            if (expand===true || $(this).css('display') == 'none') {
                $(".product-options-"+id[1]).show();
                $(this).removeClass("collapsed");
            } else {
                $(".product-options-"+id[1]).hide();
                $(this).addClass("collapsed");
            }
        });
    }
</script>
<?php if($export !== "html") { ?>
<script type="text/javascript">
    function arExport() {
        url = '<?php echo $export_url;?>';

        var filter_category_id = $('#filter_category_id :selected').val();

        if (filter_category_id) {
            url += '&filter_category_id=' + encodeURIComponent(filter_category_id);
        }

        var filter_manufacturer = $('#filter_manufacturer :selected').val();

        if (filter_manufacturer) {
            url += '&filter_manufacturer=' + encodeURIComponent(filter_manufacturer);
        }

        var filter_quantity = $('#filter_quantity').val();

        if (filter_quantity) {
            url += '&filter_quantity=' + encodeURIComponent(filter_quantity);
        }

        var product_name =  $('#prodName').val();

        if (product_name) {
            url += '&product_name=' + encodeURIComponent(product_name);
        }

        var product_id =  $('#prodID').val();

        if (product_id) {
            if(product_name == "") {
                product_id = 0;
            }
            url += '&product_id=' + encodeURIComponent(product_id);
        }

        var export_type = $('#select_export_type :selected').val();

        if (export_type) {
            url += '&export_type=' + encodeURIComponent(export_type);
        }

        var export_image = $('#select_export_image :selected').val();

        if (export_image) {
            url += '&export_image=' + encodeURIComponent(export_image);
        }

        var data = {
            show_product_name_column: $('#show_product_name_column').val(),
            show_model_column: $('#show_model_column').val(),
            show_sku_column: $('#show_sku_column').val(),
            show_stock_status_column: $('#show_stock_status_column').val(),
            show_product_qty_column: $('#show_product_qty_column').val(),
            show_free_shipping_column: $('#show_free_shipping_column').val(),
            show_individual_shipping_column: $('#show_individual_shipping_column').val(),
            show_downloadable_column: $('#show_downloadable_column').val(),
            show_fixed_shipping_column: $('#show_fixed_shipping_column').val(),
            show_weight_column: $('#show_weight_column').val(),
            show_weight_class_column: $('#show_weight_class_column').val(),
            show_length_column: $('#show_length_column').val(),
            show_width_column: $('#show_width_column').val(),
            show_height_column: $('#show_height_column').val(),
            show_length_class_column: $('#show_length_class_column').val(),
            show_product_cost_column: $('#show_product_cost_column').val(),
            show_product_price_column: $('#show_product_price_column').val(),
            show_product_value_column: $('#show_product_value_column').val(),
            show_total_cost_column: $('#show_total_cost_column').val(),
            show_purchased_qty_column: $('#show_purchased_qty_column').val(),
            show_purchased_value_column : $('#show_purchased_value_column').val()
        };

        url+= '&columns='+ encodeURIComponent(JSON.stringify(data));
        location = url;
    }

    function filter() {
        url = '<?php echo $filter_url;?>';

        var filter_category_id = $('#filter_category_id :selected').val();

        if (filter_category_id) {
            url += '&filter_category_id=' + encodeURIComponent(filter_category_id);
        }

        var filter_manufacturer = $('#filter_manufacturer :selected').val();

        if (filter_manufacturer) {
            url += '&filter_manufacturer=' + encodeURIComponent(filter_manufacturer);
        }

        var filter_quantity = $('#filter_quantity').val();

        if (filter_quantity) {
            url += '&filter_quantity=' + encodeURIComponent(filter_quantity);
        }

        var product_name = $('#prodName').val();

        if (product_name) {
            url += '&product_name=' + encodeURIComponent(product_name);
        }

        var product_id = $('#prodID').val();

        if (product_id) {
            if(product_name == "") {
                product_id = 0;
            }
            url += '&product_id=' + encodeURIComponent(product_id);
        }

    <?php if(isset($page) && $page ) { ?>
            url += '&page=<?php echo $page; ?>';
        <?php } ?>

    <?php if(isset($limit) && $limit ) { ?>
            url += '&limit=<?php echo $limit; ?>';
            <?php } ?>

        location = url;
    }

</script>
<script type="text/javascript">
    function initAutocomplete(){

        $('#prodName').typeahead({
            ajax: {
                url:'<?php echo $autocomplete; ?>',
                triggerLength: 1,
                method: "post",
                dataType: "JSON",
                preDispatch: function (query) {
                    return {
                        search: {filter_name:$('#prodName').val()}
                    }
                },
                preProcess: function (data) {
                    if (data.success === false) {
                        return false;
                    } else{
                        return data;
                    }
                }
            },
            alignWidth:false,
            onSelect: function(item){
                $('#prodID').val(item.value);
            }
        });
    }

    initAutocomplete();
    </script>
<script type="text/javascript">
    $(document).ready(function() {
        var $table = $('.list');
        $table.floatThead({
            position: 'absolute'
        });
        $('#mw').mousewheel(function(e, delta) {
            this.scrollLeft -= (delta * 40);
            e.preventDefault();
        });

        $('#select_export_type').change(function(e){
           if (this.value==='xls' || this.value==='xlsx') {
                $('#export_images_header').show();
               $('#export_images').show();
           } else {
               $('#export_images_header').hide();
               $('#export_images').hide();
           }
        });

        $('#toggl_options').click(function(e){
            e.preventDefault();
            toggleAll();
        });

        $('#show_all').click(function(e){
            showAll();
        });
        $('#save_settings').click(function (e){
            e.preventDefault();
            var data = {
                show_product_name_column: $('#show_product_name_column').val(),
                show_model_column: $('#show_model_column').val(),
                show_sku_column: $('#show_sku_column').val(),
                show_stock_status_column: $('#show_stock_status_column').val(),
                show_product_qty_column: $('#show_product_qty_column').val(),
                show_free_shipping_column: $('#show_free_shipping_column').val(),
                show_individual_shipping_column: $('#show_individual_shipping_column').val(),
                show_downloadable_column: $('#show_downloadable_column').val(),
                show_fixed_shipping_column: $('#show_fixed_shipping_column').val(),
                show_weight_column: $('#show_weight_column').val(),
                show_weight_class_column: $('#show_weight_class_column').val(),
                show_length_column: $('#show_length_column').val(),
                show_width_column: $('#show_width_column').val(),
                show_height_column: $('#show_height_column').val(),
                show_length_class_column: $('#show_length_class_column').val(),
                show_product_cost_column: $('#show_product_cost_column').val(),
                show_product_price_column: $('#show_product_price_column').val(),
                show_product_value_column: $('#show_product_value_column').val(),
                show_total_cost_column: $('#show_total_cost_column').val(),
                show_purchased_qty_column: $('#show_purchased_qty_column').val(),
                show_purchased_value_column : $('#show_purchased_value_column').val()
            };
           $.ajax({
             url: '<?php echo $save_settings_url;?>',
             type: 'post',
             data: data ,
             dataType: 'json',
             cache: false,
             success: function(json) {
                 info_alert(json.text_save_settings_success, false);
             }
           });
        });

        showColumn();
    });

    function showColumn() {
        $('#show_product_name_column').click(function (e) {
            var show_product_name_column = this.checked ? '1' : '0';
            $("#show_product_name_column").val(show_product_name_column);
            $("[id$='name']").toggle();
        });

        $('#show_model_column').click(function (e) {
            var show_model_column = this.checked ? '1' : '0';
            $("#show_model_column").val(show_model_column);
            $("[id$='model']").toggle();
        });

        $('#show_sku_column').click(function (e) {
            var show_sku_column = this.checked ? '1' : '0';
            $("#show_sku_column").val(show_sku_column);
            $("[id$='sku']").toggle();
        });

        $('#show_stock_status_column').click(function (e) {
            var show_stock_status_column = this.checked ? '1' : '0';
            $("#show_stock_status_column").val(show_stock_status_column);
            $("[id$='stock-status']").toggle();
        });

        $('#show_product_qty_column').click(function (e) {
            var show_product_qty_column = this.checked ? '1' : '0';
            $("#show_product_qty_column").val(show_product_qty_column);
            $("[id$='product-qty']").toggle();
        });

        $('#show_free_shipping_column').click(function (e) {
            var show_free_shipping_column = this.checked ? '1' : '0';
            $("#show_free_shipping_column").val(show_free_shipping_column);
            $("[id$='free-shipping']").toggle();
        });

        $('#show_individual_shipping_column').click(function (e) {
            var show_individual_shipping_column = this.checked ? '1' : '0';
            $("#show_individual_shipping_column").val(show_individual_shipping_column);
            $("[id$='individual-shipping']").toggle();
        });

        $('#show_downloadable_column').click(function (e) {
            var show_downloadable_column = this.checked ? '1' : '0';
            $("#show_downloadable_column").val(show_downloadable_column);
            $("[id$='downloadable']").toggle();
        });

        $('#show_fixed_shipping_column').click(function (e) {
            var show_fixed_shipping_column = this.checked ? '1' : '0';
             $("#show_fixed_shipping_column").val(show_fixed_shipping_column);
            $("[id$='fixed-shipping']").toggle();
        });

        $('#show_weight_column').click(function (e) {
            var show_weight_column = this.checked ? '1' : '0';
             $("#show_weight_column").val(show_weight_column);
            $("[id$='weight']").toggle();
        });

        $('#show_weight_class_column').click(function (e) {
            var show_weight_class_column = this.checked ? '1' : '0';
             $("#show_weight_class_column").val(show_weight_class_column);
            $("[id$='weight-class']").toggle();
        });

        $('#show_length_column').click(function (e) {
            var show_length_column = this.checked ? '1' : '0';
             $("#show_length_column").val(show_length_column);
            $("[id$='length']").toggle();
        });

        $('#show_width_column').click(function (e) {
            var show_width_column = this.checked ? '1' : '0';
            $("#show_width_column").val(show_width_column);
            $("[id$='width']").toggle();
        });

        $('#show_height_column').click(function (e) {
            var show_height_column = this.checked ? '1' : '0';
             $("#show_height_column").val(show_height_column);
            $("[id$='height']").toggle();
        });

        $('#show_length_class_column').click(function (e) {
            var show_length_class_column = this.checked ? '1' : '0';
             $("#show_length_class_column").val(show_length_class_column);
            $("[id$='length-class']").toggle();
        });

        $('#show_product_cost_column').click(function (e) {
            var show_product_cost_column = this.checked ? '1' : '0';
             $("#show_product_cost_column").val(show_product_cost_column);
            $("[id$='product-cost']").toggle();
        });

        $('#show_product_price_column').click(function (e) {
            var show_product_price_column = this.checked ? '1' : '0';
             $("#show_product_price_column").val(show_product_price_column);
            $("[id$='price']").toggle();
        });

        $('#show_product_value_column').click(function (e) {
            var show_product_value_column = this.checked ? '1' : '0';
             $("#show_product_value_column").val(show_product_value_column);
            $("[id$='product-value']").toggle();
        });

        $('#show_total_cost_column').click(function (e) {
            var show_total_cost_column = this.checked ? '1' : '0';
             $("#show_total_cost_column").val(show_total_cost_column);
            $("[id$='total-cost']").toggle();
        });

        $('#show_purchased_qty_column').click(function (e) {
            var show_purchased_qty_column = this.checked ? '1' : '0';
            $("#show_purchased_qty_column").val(show_purchased_qty_column);
            $("[id$='purchased-qty']").toggle();
        });

        $('#show_purchased_value_column').click(function (e) {
            var show_purchased_value_column = this.checked ? '1' : '0';
             $("#show_purchased_value_column").val(show_purchased_value_column);
            $("[id$='purchased-value']").toggle();
        });
    }

    function showAll() {
        $("[id^='show_']").attr('checked',true);

        if ($("[id$='name']").css('display') == 'none') {
            $('#show_product_name_column').val('1');
           $("[id$='name']").show();
        }

        if ($("[id$='model']").css('display') == 'none') {
            $('#show_model_column').val('1');
            $("[id$='model']").show();
        }

        if ($("[id$='sku']").css('display') == 'none') {
            $('#show_sku_column').val('1');
            $("[id$='sku']").show();
        }

        if ($("[id$='stock-status']").css('display') == 'none') {
            $('#show_stock_status_column').val('1');
            $("[id$='stock-status']").show();
        }

        if ($("[id$='product-qty']").css('display') == 'none') {
            $('#show_product_qty_column').val('1');
            $("[id$='product-qty']").show();
        }

        if ($("[id$='free-shipping']").css('display') == 'none') {
            $('#show_free_shipping_column').val('1');
            $("[id$='free-shipping']").show();
        }

        if ($("[id$='individual-shipping']").css('display') == 'none') {
            $('#show_individual_shipping_column').val('1');
            $("[id$='individual-shipping']").show();
        }

        if ($("[id$='downloadable']").css('display') == 'none') {
            $('#show_downloadable_column').val('1');
            $("[id$='downloadable']").show();
        }

        if ($("[id$='fixed-shipping']").css('display') == 'none') {
            $('#show_fixed_shipping_column').val('1');
            $("[id$='fixed-shipping']").show();
        }

        if ($("[id$='weight']").css('display') == 'none') {
            $('#show_weight_column').val('1');
            $("[id$='weight']").show();
        }

        if ($("[id$='weight-class']").css('display') == 'none') {
            $('#show_weight_class_column').val('1');
            $("[id$='weight-class']").show();
        }

        if ($("[id$='length']").css('display') == 'none') {
            $('#show_length_column').val('1');
            $("[id$='length']").show();
        }

        if ($("[id$='width']").css('display') == 'none') {
            $('#show_width_column').val('1');
            $("[id$='width']").show();
        }

        if ($("[id$='height']").css('display') == 'none') {
            $('#show_height_column_column').val('1');
            $("[id$='height']").show();
        }

        if ($("[id$='length-class']").css('display') == 'none') {
            $('#show_length_class_column_column').val('1');
            $("[id$='length-class']").show();
        }

        if ($("[id$='product-cost']").css('display') == 'none') {
            $('#show_product_cost_column').val('1');
            $("[id$='product-cost']").show();
        }

        if ($("[id$='price']").css('display') == 'none') {
            $('#show_product_price_column').val('1');
            $("[id$='price']").show();
        }

        if ($("[id$='product-value']").css('display') == 'none') {
            $('#show_product_value_column').val('1');
            $("[id$='product-value']").show();
        }

        if ($("[id$='total-cost']").css('display') == 'none') {
            $('#show_total_cost_column').val('1');
            $("[id$='total-cost']").show();
        }

        if ($("[id$='purchased-qty']").css('display') == 'none') {
            $('#show_purchased_qty_column').val('1');
            $("[id$='purchased-qty']").show();
        }

        if ($("[id$='purchased-value']").css('display') == 'none') {
            $('#show_purchased_value_column').val('1');
            $("[id$='purchased-value']").show();
        }
    }
    
    function showTextTotal() {
        $('#sum').find('td:visible:first').html(`<?php echo $text_report_total; ?>`);
    }

    </script>
<?php } else { ?>
<?php if($export == "html") { ?>
<script type="text/javascript">

    $(document).ready(function() {
        var $table = $('.list');
        $table.floatThead({
            position: 'absolute'
        });
        $('#mw').mousewheel(function(e, delta) {
            this.scrollLeft -= (delta * 40);
            e.preventDefault();
        });


    });
    //--></script>
<hr>
<?php } ?>
</html>
<?php } ?>
<?php } else { ?>
<div id="content">
    <div class="box">
        <div class="content center">
            <?php echo $text_unauthorized; ?>
        </div>
    </div>
</div>
<?php } ?>