<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelAdvancedReportsTax extends Model {

    public $data = [];
    private $error = [];
    private $datas = [];

    /**
     * @param $order_id
     * @param $subtotal
     * @param $tax
     */
    public function updateTax($order_id) {

        $taxes = $this->db->query("SELECT * FROM ".$this->db->table("order_totals")." WHERE `type`='tax' AND order_id=".(int)$order_id);
        $tax=$taxes->rows;

        $subttl = $this->db->query("SELECT `value` FROM ".$this->db->table("order_totals")." WHERE `type`='subtotal' AND order_id=".(int)$order_id);
        $subtotal = $subttl->row['value'];

        if (is_array($tax)) {
            $total_tax = sizeof($tax);
        }
        /*Get not taxable sales*/
        $query_not_tax = $this->db->query("SELECT SUM(IFNULL((op.price * op.quantity), 0)) as `non_taxable_sales` FROM ".$this->db->table("order_products")." op
						LEFT JOIN ".$this->db->table("orders")." o ON o.order_id = op.order_id
					 WHERE  TRIM(op.order_id) = '" . $order_id . "' AND op.tax=0");

        $non_taxable_sales = $query_not_tax->row['non_taxable_sales'];

        /*Get not taxable sales*/
        $query_taxable = $this->db->query("SELECT SUM(IFNULL((op.price * op.quantity), 0)) as `taxable_sales` FROM ".$this->db->table("order_products")." op
						LEFT JOIN ".$this->db->table("orders")." o ON o.order_id = op.order_id
					 WHERE TRIM(op.order_id) = '" . $order_id . "' AND op.tax!=0");

        $taxable_sales = $query_taxable->row['taxable_sales'];
        if ($total_tax > 1) {
            foreach ($tax as $k => $v) {
                if ($k == '0') {
                    $this->db->query("UPDATE " . $this->db->table("adv_reports_tax") . "
								SET date_added = NOW(),
									total = '" . $subtotal . "',
									non_taxable_sales = '" . $non_taxable_sales . "',
									taxable_sales = '" . $taxable_sales . "',
									tax_charged = '" . $v['value'] . "' WHERE order_id='" . $order_id . "' AND description='" . str_replace(':', '', $v['title']) . "' AND total!=''");

                } else {
                    $this->db->query("UPDATE " . $this->db->table("adv_reports_tax") . "
								SET date_added = NOW(),
								total = '',
									non_taxable_sales = '',
									taxable_sales = '',
									tax_charged = '" . $v['value'] . "' WHERE order_id='" . $order_id . "' AND description='" . str_replace(':', '', $v['title']) . "'");
                }
            }
        } else {
            $this->db->query("UPDATE " . $this->db->table("adv_reports_tax") . "
								SET date_added = NOW(),
									total = '" . $subtotal . "',
									non_taxable_sales = '" . $non_taxable_sales . "',
									taxable_sales = '" . $taxable_sales . "',
									tax_charged = '" . $tax[0]['value'] . "' WHERE order_id='" . $order_id . "' AND description='" . str_replace(':','',$tax[0]['title']) . "'");
        }
    }

    public function deleteTax($order_id){
        $this->db->query("DELETE FROM " .$this->db->table("adv_reports_tax") . " WHERE order_id='".$order_id."'");
    }

    /**
     * @param array $data
     * @return mixed
     */
    public function getTaxReport($data = []) {
        $where = "";
        $base_where = "";
        $report_period = isset($data['report_period']) ? $data['report_period'] : 'day';

        $report_period = isset($data['report_period']) ? $data['report_period'] : 'day';
        if ($report_period == 'day') {
            $select_datefield = 'DATE(date_added) AS datefield';
        }

        if (!empty($data['filter_date_start'])) {
            $where = " WHERE DATE(date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $where .= " AND DATE(date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        if ($data['filter_states'] != 'all') {
            $where .= " AND location='" . $data['filter_states'] . "' OR zone='" . $data['filter_states'] . "'";
        }

        $q = "SELECT " . $select_datefield . ",order_id,total,non_taxable_sales,tax_exempt,taxable_sales,tax_charged,
                 tax_rate,location,zone,description FROM " . $this->db->table("adv_reports_tax");
        $q .= $where;

        $q .= " ORDER BY datefield,order_id ";

        $fetch = $this->db->query($q);
        $query = $fetch->rows;

        return $query;
    }

    /**
     * @param array $data
     * @return int
     */
    public function getTotalSales($data = []) {
        $sql1 = "SELECT COUNT(o.order_id) AS `total` FROM ".$this->db->table("orders")." o ";

        if ($data['filter_order_status_id'] != '') {
            $sql1 .= " WHERE o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql1 .= " WHERE o.order_status_id >= '0'";
        }

        $sql1 .= " AND o.store_id = '0'";


        if (!empty($data['filter_date_start'])) {
            $sql1 .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql1 .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $query = $this->db->query($sql1);

        return isset($query->row['total']) ? $query->row['total'] : 0;
    }

    /**
     * @return array
     */
    public function getTaxZones() {
        //$zones = [];
        $zone = "(SELECT DISTINCT location as location FROM ".$this->db->table("adv_reports_tax").") UNION (SELECT DISTINCT zone as location FROM ".$this->db->table("adv_reports_tax").") ";
        $fetch = $this->db->query($zone);
        $results = $fetch->rows;
        foreach ($results as $k => $v) {
            if ($v['location'] != '') {
                $location[] = $v['location'];
            }
        }
        return $location;
    }
}